/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import org.jfree.chart.ui.Drawable;
import org.jfree.chart.util.Args;

public class ExportUtils {
    public static boolean isJFreeSVGAvailable() {
        Class<?> svgClass = null;
        try {
            svgClass = Class.forName("org.jfree.svg.SVGGraphics2D");
        }
        catch (ClassNotFoundException e) {
            try {
                svgClass = Class.forName("org.jfree.graphics2d.svg.SVGGraphics2D");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return svgClass != null;
    }

    public static boolean isOrsonPDFAvailable() {
        Class<?> pdfDocumentClass = null;
        try {
            pdfDocumentClass = Class.forName("com.orsonpdf.PDFDocument");
        }
        catch (ClassNotFoundException e) {
            try {
                pdfDocumentClass = Class.forName("org.jfree.pdf.PDFDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return pdfDocumentClass != null;
    }

    public static void writeAsSVG(Drawable drawable, int w, int h2, File file) {
        if (!ExportUtils.isJFreeSVGAvailable()) {
            throw new IllegalStateException("JFreeSVG is not present on the classpath.");
        }
        Args.nullNotPermitted(drawable, "drawable");
        Args.nullNotPermitted(file, "file");
        try {
            Class<?> svgUtilsClass;
            Class<?> svg2Class;
            try {
                svg2Class = Class.forName("org.jfree.graphics2d.svg.SVGGraphics2D");
            }
            catch (ClassNotFoundException ex) {
                svg2Class = Class.forName("org.jfree.svg.SVGGraphics2D");
            }
            Constructor<?> c1 = svg2Class.getConstructor(Integer.TYPE, Integer.TYPE);
            Graphics2D svg2 = (Graphics2D)c1.newInstance(w, h2);
            Rectangle2D.Double drawArea = new Rectangle2D.Double(0.0, 0.0, w, h2);
            drawable.draw(svg2, drawArea);
            try {
                svgUtilsClass = Class.forName("org.jfree.graphics2d.svg.SVGUtils");
            }
            catch (ClassNotFoundException ex) {
                svgUtilsClass = Class.forName("org.jfree.svg.SVGUtils");
            }
            Method m1 = svg2Class.getMethod("getSVGElement", null);
            String element = (String)m1.invoke((Object)svg2, (Object[])null);
            Method m22 = svgUtilsClass.getMethod("writeToSVG", File.class, String.class);
            m22.invoke(svgUtilsClass, file, element);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final void writeAsPDF(Drawable drawable, int w, int h2, File file) {
        if (!ExportUtils.isOrsonPDFAvailable()) {
            throw new IllegalStateException("Neither OrsonPDF nor JFreePDF is present on the classpath.");
        }
        Args.nullNotPermitted(drawable, "drawable");
        Args.nullNotPermitted(file, "file");
        try {
            Class<?> pdfDocClass;
            try {
                pdfDocClass = Class.forName("com.orsonpdf.PDFDocument");
            }
            catch (ClassNotFoundException e) {
                pdfDocClass = Class.forName("org.jfree.pdf.PDFDocument");
            }
            Object pdfDoc = pdfDocClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method m3 = pdfDocClass.getMethod("createPage", Rectangle2D.class);
            Rectangle rect = new Rectangle(w, h2);
            Object page = m3.invoke(pdfDoc, rect);
            Method m22 = page.getClass().getMethod("getGraphics2D", new Class[0]);
            Graphics2D g2 = (Graphics2D)m22.invoke(page, new Object[0]);
            Rectangle2D.Double drawArea = new Rectangle2D.Double(0.0, 0.0, w, h2);
            drawable.draw(g2, drawArea);
            Method m32 = pdfDocClass.getMethod("writeToFile", File.class);
            m32.invoke(pdfDoc, file);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void writeAsPNG(Drawable drawable, int w, int h2, File file) throws FileNotFoundException, IOException {
        BufferedImage image = new BufferedImage(w, h2, 2);
        Graphics2D g2 = image.createGraphics();
        drawable.draw(g2, new Rectangle(w, h2));
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            ImageIO.write((RenderedImage)image, "png", out);
        }
    }

    public static void writeAsJPEG(Drawable drawable, int w, int h2, File file) throws FileNotFoundException, IOException {
        BufferedImage image = new BufferedImage(w, h2, 1);
        Graphics2D g2 = image.createGraphics();
        drawable.draw(g2, new Rectangle(w, h2));
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            ImageIO.write((RenderedImage)image, "jpg", out);
        }
    }
}

