/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.Version;
import org.opensearch.common.Nullable;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.MetadataFieldMapper;
import org.opensearch.index.mapper.RootObjectMapper;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.similarity.SimilarityService;
import org.opensearch.indices.mapper.MapperRegistry;
import org.opensearch.script.ScriptService;

public class DocumentMapperParser {
    final MapperService mapperService;
    private final NamedXContentRegistry xContentRegistry;
    private final SimilarityService similarityService;
    private final Supplier<QueryShardContext> queryShardContextSupplier;
    private final RootObjectMapper.TypeParser rootObjectTypeParser = new RootObjectMapper.TypeParser();
    private final Version indexVersionCreated;
    private final Map<String, Mapper.TypeParser> typeParsers;
    private final Map<String, MetadataFieldMapper.TypeParser> rootTypeParsers;
    private final ScriptService scriptService;

    public DocumentMapperParser(IndexSettings indexSettings, MapperService mapperService, NamedXContentRegistry xContentRegistry, SimilarityService similarityService, MapperRegistry mapperRegistry, Supplier<QueryShardContext> queryShardContextSupplier, ScriptService scriptService) {
        this.mapperService = mapperService;
        this.xContentRegistry = xContentRegistry;
        this.similarityService = similarityService;
        this.queryShardContextSupplier = queryShardContextSupplier;
        this.scriptService = scriptService;
        this.typeParsers = mapperRegistry.getMapperParsers();
        this.indexVersionCreated = indexSettings.getIndexVersionCreated();
        this.rootTypeParsers = mapperRegistry.getMetadataMapperParsers(this.indexVersionCreated);
    }

    public Mapper.TypeParser.ParserContext parserContext() {
        return new Mapper.TypeParser.ParserContext(this.similarityService::getSimilarity, this.mapperService, this.typeParsers::get, this.indexVersionCreated, this.queryShardContextSupplier, null, this.scriptService);
    }

    public Mapper.TypeParser.ParserContext parserContext(DateFormatter dateFormatter) {
        return new Mapper.TypeParser.ParserContext(this.similarityService::getSimilarity, this.mapperService, this.typeParsers::get, this.indexVersionCreated, this.queryShardContextSupplier, dateFormatter, this.scriptService);
    }

    public DocumentMapper parse(@Nullable String type, CompressedXContent source) throws MapperParsingException {
        Map<String, Object> mapping = null;
        if (source != null) {
            Map root = (Map)XContentHelper.convertToMap(source.compressedReference(), true, MediaTypeRegistry.JSON).v2();
            Tuple<String, Map<String, Object>> t = this.extractMapping(type, root);
            type = (String)t.v1();
            mapping = (Map)t.v2();
        }
        if (mapping == null) {
            mapping = new HashMap<String, Object>();
        }
        return this.parse(type, mapping);
    }

    private DocumentMapper parse(String type, Map<String, Object> mapping) throws MapperParsingException {
        if (type == null) {
            throw new MapperParsingException("Failed to derive type");
        }
        Mapper.TypeParser.ParserContext parserContext = this.parserContext();
        DocumentMapper.Builder docBuilder = new DocumentMapper.Builder((RootObjectMapper.Builder)this.rootObjectTypeParser.parse(type, mapping, parserContext), this.mapperService);
        Iterator<Map.Entry<String, Object>> iterator = mapping.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String fieldName = entry.getKey();
            Object fieldNode = entry.getValue();
            MetadataFieldMapper.TypeParser typeParser = this.rootTypeParsers.get(fieldName);
            if (typeParser == null) continue;
            iterator.remove();
            if (!(fieldNode instanceof Map)) {
                throw new IllegalArgumentException("[_parent] must be an object containing [type]");
            }
            Map fieldNodeMap = (Map)fieldNode;
            docBuilder.put((MetadataFieldMapper.Builder)typeParser.parse(fieldName, fieldNodeMap, parserContext));
            fieldNodeMap.remove("type");
            DocumentMapperParser.checkNoRemainingFields(fieldName, fieldNodeMap, parserContext.indexVersionCreated());
        }
        Map meta = (Map)mapping.remove("_meta");
        if (meta != null) {
            docBuilder.meta(Collections.unmodifiableMap(new HashMap(meta)));
        }
        DocumentMapperParser.checkNoRemainingFields(mapping, parserContext.indexVersionCreated(), "Root mapping definition has unsupported parameters: ");
        return docBuilder.build(this.mapperService);
    }

    public static void checkNoRemainingFields(String fieldName, Map<?, ?> fieldNodeMap, Version indexVersionCreated) {
        DocumentMapperParser.checkNoRemainingFields(fieldNodeMap, indexVersionCreated, "Mapping definition for [" + fieldName + "] has unsupported parameters: ");
    }

    public static void checkNoRemainingFields(Map<?, ?> fieldNodeMap, Version indexVersionCreated, String message) {
        if (!fieldNodeMap.isEmpty()) {
            throw new MapperParsingException(message + DocumentMapperParser.getRemainingFields(fieldNodeMap));
        }
    }

    private static String getRemainingFields(Map<?, ?> map) {
        StringBuilder remainingFields = new StringBuilder();
        for (Object key : map.keySet()) {
            remainingFields.append(" [").append(key).append(" : ").append(map.get(key)).append("]");
        }
        return remainingFields.toString();
    }

    private Tuple<String, Map<String, Object>> extractMapping(String type, String source) throws MapperParsingException {
        Map root;
        try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, source);){
            root = parser.mapOrdered();
        }
        catch (Exception e) {
            throw new MapperParsingException("failed to parse mapping definition", e);
        }
        return this.extractMapping(type, root);
    }

    private Tuple<String, Map<String, Object>> extractMapping(String type, Map<String, Object> root) throws MapperParsingException {
        if (root.size() == 0) {
            if (type != null) {
                return new Tuple((Object)type, root);
            }
            throw new MapperParsingException("malformed mapping, no type name found");
        }
        String rootName = root.keySet().iterator().next();
        Tuple mapping = type == null || type.equals(rootName) || this.mapperService.resolveDocumentType(type).equals(rootName) ? new Tuple((Object)rootName, (Object)((Map)root.get(rootName))) : new Tuple((Object)type, root);
        return mapping;
    }

    NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }
}

