"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _configSchema = require("@osd/config-schema");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function _default(services, router) {
  const {
    monitorService
  } = services;
  router.get({
    path: '/api/alerting/monitors',
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        state: _configSchema.schema.string(),
        monitorIds: _configSchema.schema.maybe(_configSchema.schema.any())
      })
    }
  }, monitorService.getMonitors);
  router.post({
    path: '/api/alerting/monitors/_search',
    validate: {
      body: _configSchema.schema.any()
    }
  }, monitorService.searchMonitors);
  router.post({
    path: '/api/alerting/monitors',
    validate: {
      body: _configSchema.schema.any()
    }
  }, monitorService.createMonitor);
  router.post({
    path: '/api/alerting/workflows',
    validate: {
      body: _configSchema.schema.any()
    }
  }, monitorService.createWorkflow);
  router.post({
    path: '/api/alerting/monitors/_execute',
    validate: {
      query: _configSchema.schema.object({
        dryrun: _configSchema.schema.maybe(_configSchema.schema.string())
      }),
      body: _configSchema.schema.any()
    }
  }, monitorService.executeMonitor);
  router.get({
    path: '/api/alerting/workflows/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, monitorService.getWorkflow);
  router.get({
    path: '/api/alerting/monitors/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, monitorService.getMonitor);
  router.put({
    path: '/api/alerting/monitors/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ifSeqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        ifPrimaryTerm: _configSchema.schema.maybe(_configSchema.schema.number())
      }),
      body: _configSchema.schema.any()
    }
  }, monitorService.updateMonitor);
  router.put({
    path: '/api/alerting/workflows/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ifSeqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        ifPrimaryTerm: _configSchema.schema.maybe(_configSchema.schema.number())
      }),
      body: _configSchema.schema.any()
    }
  }, monitorService.updateMonitor);
  router.delete({
    path: '/api/alerting/monitors/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        version: _configSchema.schema.number()
      })
    }
  }, monitorService.deleteMonitor);
  router.delete({
    path: '/api/alerting/workflows/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        version: _configSchema.schema.number()
      })
    }
  }, monitorService.deleteWorkflow);
  router.post({
    path: '/api/alerting/monitors/{id}/_acknowledge/alerts',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, monitorService.acknowledgeAlerts);
  router.post({
    path: '/api/alerting/workflows/{id}/_acknowledge/alerts',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, monitorService.acknowledgeChainedAlerts);
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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