/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceStateChange;
import software.amazon.awssdk.services.ec2.model.InstanceStateChangeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopInstancesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, StopInstancesResponse> {
    private static final SdkField<List<InstanceStateChange>> STOPPING_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StoppingInstances").getter(StopInstancesResponse.getter(StopInstancesResponse::stoppingInstances)).setter(StopInstancesResponse.setter(Builder::stoppingInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesSet").unmarshallLocationName("instancesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceStateChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STOPPING_INSTANCES_FIELD));
    private final List<InstanceStateChange> stoppingInstances;

    private StopInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.stoppingInstances = builder.stoppingInstances;
    }

    public final boolean hasStoppingInstances() {
        return this.stoppingInstances != null && !(this.stoppingInstances instanceof SdkAutoConstructList);
    }

    public final List<InstanceStateChange> stoppingInstances() {
        return this.stoppingInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStoppingInstances() ? this.stoppingInstances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInstancesResponse)) {
            return false;
        }
        StopInstancesResponse other = (StopInstancesResponse)((Object)obj);
        return this.hasStoppingInstances() == other.hasStoppingInstances() && Objects.equals(this.stoppingInstances(), other.stoppingInstances());
    }

    public final String toString() {
        return ToString.builder((String)"StopInstancesResponse").add("StoppingInstances", this.hasStoppingInstances() ? this.stoppingInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StoppingInstances": {
                return Optional.ofNullable(clazz.cast(this.stoppingInstances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopInstancesResponse, T> g) {
        return obj -> g.apply((StopInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<InstanceStateChange> stoppingInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StopInstancesResponse model) {
            super(model);
            this.stoppingInstances(model.stoppingInstances);
        }

        public final List<InstanceStateChange.Builder> getStoppingInstances() {
            List<InstanceStateChange.Builder> result = InstanceStateChangeListCopier.copyToBuilder(this.stoppingInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStoppingInstances(Collection<InstanceStateChange.BuilderImpl> stoppingInstances) {
            this.stoppingInstances = InstanceStateChangeListCopier.copyFromBuilder(stoppingInstances);
        }

        @Override
        public final Builder stoppingInstances(Collection<InstanceStateChange> stoppingInstances) {
            this.stoppingInstances = InstanceStateChangeListCopier.copy(stoppingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stoppingInstances(InstanceStateChange ... stoppingInstances) {
            this.stoppingInstances(Arrays.asList(stoppingInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stoppingInstances(Consumer<InstanceStateChange.Builder> ... stoppingInstances) {
            this.stoppingInstances(Stream.of(stoppingInstances).map(c -> (InstanceStateChange)((InstanceStateChange.Builder)InstanceStateChange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public StopInstancesResponse build() {
            return new StopInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopInstancesResponse> {
        public Builder stoppingInstances(Collection<InstanceStateChange> var1);

        public Builder stoppingInstances(InstanceStateChange ... var1);

        public Builder stoppingInstances(Consumer<InstanceStateChange.Builder> ... var1);
    }
}

