/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoreSuccessItem;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresResponse;

public class DescribeFastSnapshotRestoresIterable
implements SdkIterable<DescribeFastSnapshotRestoresResponse> {
    private final Ec2Client client;
    private final DescribeFastSnapshotRestoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFastSnapshotRestoresIterable(Ec2Client client, DescribeFastSnapshotRestoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeFastSnapshotRestoresResponseFetcher();
    }

    public Iterator<DescribeFastSnapshotRestoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DescribeFastSnapshotRestoreSuccessItem> fastSnapshotRestores() {
        Function<DescribeFastSnapshotRestoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.fastSnapshotRestores() != null) {
                return response.fastSnapshotRestores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeFastSnapshotRestoresResponseFetcher
    implements SyncPageFetcher<DescribeFastSnapshotRestoresResponse> {
        private DescribeFastSnapshotRestoresResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFastSnapshotRestoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeFastSnapshotRestoresResponse nextPage(DescribeFastSnapshotRestoresResponse previousPage) {
            if (previousPage == null) {
                return DescribeFastSnapshotRestoresIterable.this.client.describeFastSnapshotRestores(DescribeFastSnapshotRestoresIterable.this.firstRequest);
            }
            return DescribeFastSnapshotRestoresIterable.this.client.describeFastSnapshotRestores((DescribeFastSnapshotRestoresRequest)((Object)DescribeFastSnapshotRestoresIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

