/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.Requests;

@ToolAnnotation(value="VisualizationTool")
public class VisualizationsTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(VisualizationsTool.class);
    public static final String NAME = "FindVisualizations";
    public static final String TYPE = "VisualizationTool";
    public static final String VERSION = "v1.0";
    public static final String SAVED_OBJECT_TYPE = "visualization";
    private static final int DEFAULT_SIZE = 3;
    private static final String DEFAULT_DESCRIPTION = "Use this tool to find user created visualizations. This tool takes the visualization name as input and returns matching visualizations";
    private String description = "Use this tool to find user created visualizations. This tool takes the visualization name as input and returns matching visualizations";
    private String name = "FindVisualizations";
    private Map<String, Object> attributes;
    private String type = "VisualizationTool";
    private final String version = "v1.0";
    private final Client client;
    private final String index;
    private final int size;

    public VisualizationsTool(Client client, String index, int size) {
        this.client = client;
        this.index = index;
        this.size = size;
    }

    public <T> void run(Map<String, String> parameters, final ActionListener<T> listener) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"type", (String)SAVED_OBJECT_TYPE));
        boolQueryBuilder.must().add(QueryBuilders.matchQuery((String)"visualization.title", (Object)parameters.get("input")));
        SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().query((QueryBuilder)boolQueryBuilder);
        searchSourceBuilder.from(0).size(this.size);
        SearchRequest searchRequest = Requests.searchRequest((String[])new String[]{this.index}).source(searchSourceBuilder);
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                SearchHits hits = searchResponse.getHits();
                StringBuilder visBuilder = new StringBuilder();
                visBuilder.append("Title,Id\n");
                if (hits.getTotalHits().value() > 0L) {
                    Arrays.stream(hits.getHits()).forEach(h -> {
                        String id = VisualizationsTool.this.trimIdPrefix(h.getId());
                        Map visMap = (Map)h.getSourceAsMap().get(VisualizationsTool.SAVED_OBJECT_TYPE);
                        String title = (String)visMap.get("title");
                        visBuilder.append(String.format(Locale.ROOT, "%s,%s\n", title, id));
                    });
                    listener.onResponse((Object)visBuilder.toString());
                } else {
                    listener.onResponse((Object)"No Visualization found");
                }
            }

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException || ExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                    listener.onResponse((Object)"No Visualization found");
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    String trimIdPrefix(String id) {
        if ((id = Optional.ofNullable(id).orElse("")).startsWith(SAVED_OBJECT_TYPE)) {
            String prefix = String.format(Locale.ROOT, "%s:", SAVED_OBJECT_TYPE);
            return id.substring(prefix.length());
        }
        return id;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters.containsKey("input") && !Strings.isNullOrEmpty((String)parameters.get("input"));
    }

    @Generated
    public static VisualizationsToolBuilder builder() {
        return new VisualizationsToolBuilder();
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getIndex() {
        return this.index;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public static class VisualizationsToolBuilder {
        @Generated
        private Client client;
        @Generated
        private String index;
        @Generated
        private int size;

        @Generated
        VisualizationsToolBuilder() {
        }

        @Generated
        public VisualizationsToolBuilder client(Client client) {
            this.client = client;
            return this;
        }

        @Generated
        public VisualizationsToolBuilder index(String index) {
            this.index = index;
            return this;
        }

        @Generated
        public VisualizationsToolBuilder size(int size) {
            this.size = size;
            return this;
        }

        @Generated
        public VisualizationsTool build() {
            return new VisualizationsTool(this.client, this.index, this.size);
        }

        @Generated
        public String toString() {
            return "VisualizationsTool.VisualizationsToolBuilder(client=" + String.valueOf(this.client) + ", index=" + this.index + ", size=" + this.size + ")";
        }
    }

    public static class Factory
    implements Tool.Factory<VisualizationsTool> {
        private Client client;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<VisualizationsTool> clazz = VisualizationsTool.class;
            synchronized (VisualizationsTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public VisualizationsTool create(Map<String, Object> params) {
            int size;
            String index = params.get("index") == null ? ".kibana" : (String)params.get("index");
            String sizeStr = params.get("size") == null ? "3" : (String)params.get("size");
            try {
                size = Integer.parseInt(sizeStr);
            }
            catch (NumberFormatException ignored) {
                size = 3;
            }
            return VisualizationsTool.builder().client(this.client).index(index).size(size).build();
        }

        public String getDefaultDescription() {
            return VisualizationsTool.DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return VisualizationsTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

