/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.hyperparameter.param;

import ai.djl.training.hyperparameter.param.Hyperparameter;
import ai.djl.util.RandomUtils;

public class HpFloat
extends Hyperparameter<Float> {
    private float lower;
    private float upper;
    private boolean log;

    public HpFloat(String name, float lower, float upper, boolean log) {
        super(name);
        this.log = log;
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public Float random() {
        if (this.log) {
            float logLower = (float)Math.log(this.lower);
            float logUpper = (float)Math.log(this.upper);
            return Float.valueOf((float)Math.exp(RandomUtils.nextFloat(logLower, logUpper)));
        }
        return Float.valueOf(RandomUtils.nextFloat(this.lower, this.upper));
    }

    public String toString() {
        return "HPReal{lower=" + this.lower + ", upper=" + this.upper + ", log=" + this.log + ", name='" + this.name + '\'' + '}';
    }
}

