/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.reportsscheduler.metrics.Metrics;
import org.opensearch.reportsscheduler.settings.PluginSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0016\u0010\u0011\u001a\u0004\u0018\u00010\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\b\u0010\f\u001a\u0004\u0018\u00010\rJ&\u0010\u0014\u001a\u00020\u00152\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010J\u0012\u0010\u0017\u001a\u00020\u00152\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/reportsscheduler/security/UserAccessManager;", "", "<init>", "()V", "USER_TAG", "", "ROLE_TAG", "BACKEND_ROLE_TAG", "PRIVATE_TENANT", "DEFAULT_TENANT", "validateUser", "", "user", "Lorg/opensearch/commons/authuser/User;", "getUserTenant", "getAllAccessInfo", "", "getUserFromAccess", "access", "getSearchAccessInfo", "doesUserHasAccess", "", "tenant", "isUserPrivateTenant", "opensearch-reports-scheduler"})
@SourceDebugExtension(value={"SMAP\nUserAccessManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserAccessManager.kt\norg/opensearch/reportsscheduler/security/UserAccessManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1863#2,2:136\n1863#2,2:138\n774#2:141\n865#2,2:142\n1557#2:144\n1628#2,3:145\n774#2:148\n865#2,2:149\n1557#2:151\n1628#2,3:152\n1557#2:155\n1628#2,3:156\n1557#2:159\n1628#2,3:160\n1755#2,3:163\n1#3:140\n*S KotlinDebug\n*F\n+ 1 UserAccessManager.kt\norg/opensearch/reportsscheduler/security/UserAccessManager\n*L\n76#1:136,2\n77#1:138,2\n89#1:141\n89#1:142,2\n89#1:144\n89#1:145,3\n90#1:148\n90#1:149,2\n90#1:151\n90#1:152,3\n105#1:155\n105#1:156,3\n125#1:159\n125#1:160,3\n125#1:163,3\n*E\n"})
public final class UserAccessManager {
    @NotNull
    public static final UserAccessManager INSTANCE = new UserAccessManager();
    @NotNull
    private static final String USER_TAG = "User:";
    @NotNull
    private static final String ROLE_TAG = "Role:";
    @NotNull
    private static final String BACKEND_ROLE_TAG = "BERole:";
    @NotNull
    private static final String PRIVATE_TENANT = "__user__";
    @NotNull
    public static final String DEFAULT_TENANT = "";

    private UserAccessManager() {
    }

    public final void validateUser(@Nullable User user) {
        if (this.isUserPrivateTenant(user)) {
            User user2 = user;
            if ((user2 != null ? user2.getName() : null) == null) {
                Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
                throw new OpenSearchStatusException("User name not provided for private tenant access", RestStatus.FORBIDDEN, new Object[0]);
            }
        }
        if (PluginSettings.INSTANCE.isRbacEnabled()) {
            User user3 = user;
            Collection collection = user3 != null ? user3.getBackendRoles() : null;
            if (collection == null || collection.isEmpty()) {
                Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
                throw new OpenSearchStatusException("User doesn't have backend roles configured. Contact administrator.", RestStatus.FORBIDDEN, new Object[0]);
            }
        }
    }

    @NotNull
    public final String getUserTenant(@Nullable User user) {
        String requestedTenant;
        Object object = user;
        if (object == null || (object = (requestedTenant = object.getRequestedTenant())) == null) {
            object = DEFAULT_TENANT;
        }
        return object;
    }

    @NotNull
    public final List<String> getAllAccessInfo(@Nullable User user) {
        String it;
        if (user == null) {
            return CollectionsKt.emptyList();
        }
        List retList = new ArrayList();
        if (user.getName() != null) {
            retList.add(USER_TAG + user.getName());
        }
        List list = user.getRoles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRoles(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            retList.add(ROLE_TAG + it);
        }
        List list2 = user.getBackendRoles();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBackendRoles(...)");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            retList.add(BACKEND_ROLE_TAG + it);
        }
        return retList;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final User getUserFromAccess(@NotNull List<String> access) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        String it;
        void $this$filterTo$iv$iv2;
        String string;
        Object v0;
        block8: {
            Intrinsics.checkNotNullParameter(access, (String)"access");
            if (((Collection)access).isEmpty()) {
                return null;
            }
            Iterable iterable = access;
            for (Object t : iterable) {
                String it2 = (String)t;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it2, (String)USER_TAG, (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block8;
            }
            v0 = null;
        }
        String string2 = v0;
        if (string2 != null) {
            String string3 = string2.substring(5);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = null;
        }
        String name = string;
        Iterable $this$filter$iv = access;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)ROLE_TAG, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string4 = it.substring(5);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            collection.add(string4);
        }
        List backendRoles = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = access;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it3 = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it3, (String)BACKEND_ROLE_TAG, (boolean)false, (int)2, null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it3 = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            String string5 = it3.substring(7);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            collection.add(string5);
        }
        List roles = (List)destination$iv$iv2;
        return new User(name, backendRoles, roles, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getSearchAccessInfo(@Nullable User user) {
        List list;
        if (user == null) {
            return CollectionsKt.emptyList();
        }
        if (this.isUserPrivateTenant(user)) {
            return CollectionsKt.listOf((Object)(USER_TAG + user.getName()));
        }
        if (PluginSettings.INSTANCE.isRbacEnabled()) {
            void $this$mapTo$iv$iv;
            List list2 = user.getBackendRoles();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBackendRoles(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(BACKEND_ROLE_TAG + (String)it);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean doesUserHasAccess(@Nullable User user, @NotNull String tenant, @NotNull List<String> access) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
            Intrinsics.checkNotNullParameter(access, (String)"access");
            if (user == null) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)this.getUserTenant(user), (Object)tenant)) {
                return false;
            }
            if (this.isUserPrivateTenant(user)) {
                return access.contains(USER_TAG + user.getName());
            }
            if (PluginSettings.INSTANCE.isRbacEnabled()) {
                void $this$any$iv;
                void $this$mapTo$iv$iv;
                List list = user.getBackendRoles();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBackendRoles(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(BACKEND_ROLE_TAG + (String)it);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!access.contains(it)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isUserPrivateTenant(User user) {
        return Intrinsics.areEqual((Object)this.getUserTenant(user), (Object)PRIVATE_TENANT);
    }
}

