/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.JakartaJsonValue;
import com.github.wnameless.json.base.JsonCore;
import jakarta.json.Json;
import jakarta.json.JsonReaderFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class JakartaJsonCore
implements JsonCore<JakartaJsonValue> {
    private final JsonReaderFactory factory;

    public JakartaJsonCore() {
        this.factory = null;
    }

    public JakartaJsonCore(JsonReaderFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.factory = factory;
    }

    public JakartaJsonValue parse(String json) {
        if (this.factory != null) {
            return new JakartaJsonValue(this.factory.createReader((Reader)new StringReader(json)).readValue());
        }
        return new JakartaJsonValue(Json.createReader((Reader)new StringReader(json)).readValue());
    }

    public JakartaJsonValue parse(Reader jsonReader) throws IOException {
        if (this.factory != null) {
            return new JakartaJsonValue(this.factory.createReader(jsonReader).readValue());
        }
        return new JakartaJsonValue(Json.createReader((Reader)jsonReader).readValue());
    }
}

