/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.dedication.RBlock;

public class RBlocks {
    private final List<RBlock> all = new ArrayList<RBlock>();

    private RBlocks() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.all.size());
        for (RBlock block : this.all) {
            sb.append(" - ");
            sb.append(block.toString());
        }
        return sb.toString();
    }

    public static RBlocks readFrom(byte[] fileContent, int size) {
        RBlocks result = new RBlocks();
        for (int start = 0; start < fileContent.length; start += size) {
            RBlock block = new RBlock(fileContent, start, size);
            result.all.add(block);
        }
        return result;
    }

    public RBlocks change(BigInteger E, BigInteger N2) {
        RBlocks result = new RBlocks();
        for (RBlock rsa : this.all) {
            result.all.add(rsa.change(E, N2));
        }
        return result;
    }

    public void writeTo(Path out, int size) throws IOException {
        this.writeTo(new FileOutputStream(out.toFile()), size);
    }

    public byte[] toByteArray(int size) throws IOException {
        byte[] result = new byte[size * this.all.size()];
        for (int i = 0; i < this.all.size(); ++i) {
            byte[] tmp = this.all.get(i).getData(size);
            System.arraycopy(tmp, 0, result, i * size, tmp.length);
        }
        return result;
    }

    public void writeTo(OutputStream os, int size) throws IOException {
        for (RBlock rsa : this.all) {
            byte[] tmp = rsa.getData(size);
            os.write(tmp);
        }
        os.close();
    }
}

