<!--
title: Serverless Framework Documentation
layout: Doc
-->

<!-- DOCS-SITE-LINK:START automatically generated  -->

### [Read this on the main serverless docs site](https://www.serverless.com/framework/docs/)

<!-- DOCS-SITE-LINK:END -->

# Serverless Framework Documentation

**Deliver software with radically less overhead.**

This is the guiding principle behind the Serverless Framework, which was developed following the release of AWS Lambda in 2014. The Serverless Framework pioneered serverless architecture on AWS, a transformative approach to building applications on cloud infrastructure that auto-scales, incurs no charges when idle, and typically demands minimal maintenance. Today, it continues to be the leading developer tool for deploying serverless architectures.

Here are the Serverless Framework's highlights:

- **Empowering** - Build more and manage less with serverless architectures.
- **Many Use-Cases** - Choose from tons of efficient serverless use-cases (APIs, Scheduled Tasks, Event Handlers, Streaming Data Pipelines, Web Sockets & more).
- **Automated** - Deploys both code and infrastructure together, resulting in out-of-the-box serverless apps.
- **Easy** - Enjoy simple syntax to safely deploy AWS Lambda functions, event sources and more without being a cloud expert.
- **Multi-Language** - Supports Node.js, Python, Java, Go, C#, Ruby, Swift, Kotlin, PHP, Scala, & F#
- **Full Lifecycle** - Manages the lifecycle of your serverless architecture (build, deploy, update, monitor, troubleshoot).
- **Multi-Domains** - Group domains into Serverless Services for easy management of code, resources & processes, across large projects & teams.
- **Multi-Environments** - Built-in support for multiple stages (e.g. development, staging, production).
- **Guardrails** - Loaded with automation, optimization and best practices.
- **Extensible** - Extend or modify the Framework and its operations via Plugins.
- **Plugin Ecosystem** - Extend or modify the Framework and its operations via Plugins.
- **Welcoming** - A passionate and welcoming community!

Get started via the Serverless Framework CLI using [this guide](https://serverless.com/framework/docs/getting-started/).

Have questions? Join thousands of other users in our [Slack Channel](https://serverless.com/slack).

After that, we recommend you...

- [Study Serverless Framework's core concepts](https://www.serverless.com/framework/docs/providers/aws/guide/intro)
- [Get inspiration from these Serverless Framework templates](https://github.com/serverless/examples)
- [Discover all of the events that can trigger AWS Lambda functions](https://www.serverless.com/framework/docs/providers/aws/guide/events)
- [Bookmark Serverless Framework's `serverless.yml` guide](https://www.serverless.com/framework/docs/providers/aws/guide/serverless.yml)
- [Search the plugins registry to extend Serverless Framework](https://www.serverless.com/plugins)
