/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class TimeBucketCounter {
    private final ConcurrentHashMap<String, AtomicInteger> map = new ConcurrentHashMap();
    private final int numBits;
    private final double ratio;
    volatile boolean isRunning = false;

    public TimeBucketCounter(int n) {
        int n2;
        int n3 = n * 1000;
        int n4 = 0;
        int n5 = n2 = TimeBucketCounter.nextPowerOf2(n3);
        while (n5 > 1) {
            n5 = n2 >> ++n4;
        }
        this.numBits = n4;
        this.ratio = TimeBucketCounter.ratioToPowerOf2(n3);
        int n6 = n3 >= 60000 ? 6 : 3;
        MaintenanceThread maintenanceThread = new MaintenanceThread(n3 / n6);
        ((Thread)maintenanceThread).start();
    }

    public final int increment(String string) {
        AtomicInteger atomicInteger;
        String string2 = this.getCurrentBucketPrefix() + "-" + string;
        AtomicInteger atomicInteger2 = this.map.get(string2);
        if (atomicInteger2 == null && (atomicInteger = this.map.putIfAbsent(string2, atomicInteger2 = new AtomicInteger())) != null) {
            atomicInteger2 = atomicInteger;
        }
        return atomicInteger2.incrementAndGet();
    }

    public final int getCurrentBucketPrefix() {
        return (int)(System.currentTimeMillis() >> this.numBits);
    }

    public int getNumBits() {
        return this.numBits;
    }

    public int getActualDuration() {
        return (int)Math.pow(2.0, this.getNumBits());
    }

    public double getRatio() {
        return this.ratio;
    }

    static double ratioToPowerOf2(int n) {
        double d = TimeBucketCounter.nextPowerOf2(n);
        return (double)Math.round(1000.0 * d / (double)n) / 1000.0;
    }

    static int nextPowerOf2(int n) {
        int n2 = Integer.highestOneBit(n);
        if (n2 == n) {
            return n;
        }
        return n2 << 1;
    }

    public long getMillisUntilNextBucket() {
        long l = System.currentTimeMillis();
        long l2 = l + (long)Math.pow(2.0, this.numBits) >> this.numBits << this.numBits;
        long l3 = l2 - l;
        return l3;
    }

    public void destroy() {
        this.isRunning = false;
    }

    class MaintenanceThread
    extends Thread {
        final long sleeptime;

        MaintenanceThread(long l) {
            super.setDaemon(true);
            this.sleeptime = l;
        }

        @Override
        public void start() {
            TimeBucketCounter.this.isRunning = true;
            super.start();
        }

        @Override
        public void run() {
            while (TimeBucketCounter.this.isRunning) {
                String string = String.valueOf(TimeBucketCounter.this.getCurrentBucketPrefix());
                Set set = TimeBucketCounter.this.map.keySet();
                for (String string2 : set) {
                    if (string2.startsWith(string)) continue;
                    set.remove(string2);
                }
                try {
                    Thread.sleep(this.sleeptime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

