/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import org.apache.catalina.ssi.SSICommand;
import org.apache.catalina.ssi.SSIMediator;

public final class SSIFsize
implements SSICommand {
    static final int ONE_KIBIBYTE = 1024;
    static final int ONE_MEBIBYTE = 0x100000;

    @Override
    public long process(SSIMediator sSIMediator, String string, String[] stringArray, String[] stringArray2, PrintWriter printWriter) {
        long l = 0L;
        String string2 = sSIMediator.getConfigErrMsg();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            String string4 = stringArray2[i];
            String string5 = sSIMediator.substituteVariables(string4);
            try {
                if (string3.equalsIgnoreCase("file") || string3.equalsIgnoreCase("virtual")) {
                    boolean bl = string3.equalsIgnoreCase("virtual");
                    l = sSIMediator.getFileLastModified(string5, bl);
                    long l2 = sSIMediator.getFileSize(string5, bl);
                    String string6 = sSIMediator.getConfigSizeFmt();
                    printWriter.write(this.formatSize(l2, string6));
                    continue;
                }
                sSIMediator.log("#fsize--Invalid attribute: " + string3);
                printWriter.write(string2);
                continue;
            }
            catch (IOException iOException) {
                sSIMediator.log("#fsize--Couldn't get size for file: " + string5, iOException);
                printWriter.write(string2);
            }
        }
        return l;
    }

    public String repeat(char c, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Num chars can't be negative");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public String padLeft(String string, int n) {
        String string2 = string;
        int n2 = n - string.length();
        if (n2 > 0) {
            string2 = this.repeat(' ', n2) + string;
        }
        return string2;
    }

    protected String formatSize(long l, String string) {
        String string2 = "";
        if (string.equalsIgnoreCase("bytes")) {
            DecimalFormat decimalFormat = new DecimalFormat("#,##0");
            string2 = decimalFormat.format(l);
        } else {
            if (l < 0L) {
                string2 = "-";
            } else if (l == 0L) {
                string2 = "0k";
            } else if (l < 1024L) {
                string2 = "1k";
            } else if (l < 0x100000L) {
                string2 = Long.toString((l + 512L) / 1024L);
                string2 = string2 + "k";
            } else if (l < 0x6300000L) {
                DecimalFormat decimalFormat = new DecimalFormat("0.0M");
                string2 = decimalFormat.format((double)l / 1048576.0);
            } else {
                string2 = Long.toString((l + 541696L) / 0x100000L);
                string2 = string2 + "M";
            }
            string2 = this.padLeft(string2, 5);
        }
        return string2;
    }
}

