/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.tipis;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.Heartbeat;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.group.Response;
import org.apache.catalina.tribes.group.RpcCallback;
import org.apache.catalina.tribes.group.RpcChannel;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.tipis.ReplicatedMapEntry;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class AbstractReplicatedMap<K, V>
implements Map<K, V>,
Serializable,
RpcCallback,
ChannelListener,
MembershipListener,
Heartbeat {
    private static final long serialVersionUID = 1L;
    protected static final StringManager sm = StringManager.getManager(AbstractReplicatedMap.class);
    private final Log log = LogFactory.getLog(AbstractReplicatedMap.class);
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected final ConcurrentMap<K, MapEntry<K, V>> innerMap;
    protected transient long rpcTimeout = 5000L;
    protected transient Channel channel;
    protected transient RpcChannel rpcChannel;
    protected transient byte[] mapContextName;
    protected transient boolean stateTransferred = false;
    protected final transient Object stateMutex = new Object();
    protected final transient HashMap<Member, Long> mapMembers = new HashMap();
    protected transient int channelSendOptions = 2;
    protected transient MapOwner mapOwner;
    protected transient ClassLoader[] externalLoaders;
    protected transient int currentNode = 0;
    protected transient long accessTimeout = 5000L;
    protected transient String mapname = "";
    private volatile transient State state = State.NEW;

    protected abstract int getStateMessageType();

    protected abstract int getReplicateMessageType();

    public AbstractReplicatedMap(MapOwner mapOwner, Channel channel, long l, String string, int n, float f, int n2, ClassLoader[] classLoaderArray, boolean bl) {
        this.innerMap = new ConcurrentHashMap<K, MapEntry<K, V>>(n, f, 15);
        this.init(mapOwner, channel, string, l, n2, classLoaderArray, bl);
    }

    protected Member[] wrap(Member member) {
        if (member == null) {
            return new Member[0];
        }
        return new Member[]{member};
    }

    protected void init(MapOwner mapOwner, Channel channel, String string, long l, int n, ClassLoader[] classLoaderArray, boolean bl) {
        long l2;
        block5: {
            l2 = System.currentTimeMillis();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)sm.getString("abstractReplicatedMap.init.start", string));
            }
            this.mapOwner = mapOwner;
            this.externalLoaders = classLoaderArray;
            this.channelSendOptions = n;
            this.channel = channel;
            this.rpcTimeout = l;
            this.mapname = string;
            this.mapContextName = string.getBytes(StandardCharsets.ISO_8859_1);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Created Lazy Map with name:" + string + ", bytes:" + Arrays.toString(this.mapContextName)));
            }
            this.rpcChannel = new RpcChannel(this.mapContextName, channel, this);
            this.channel.addChannelListener(this);
            this.channel.addMembershipListener(this);
            try {
                this.broadcast(8, true);
                this.transferState();
                this.broadcast(6, true);
            }
            catch (ChannelException channelException) {
                this.log.warn((Object)sm.getString("abstractReplicatedMap.unableSend.startMessage"));
                if (!bl) break block5;
                this.breakdown();
                throw new RuntimeException(sm.getString("abstractReplicatedMap.unableStart"), channelException);
            }
        }
        this.state = State.INITIALIZED;
        long l3 = System.currentTimeMillis() - l2;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)sm.getString("abstractReplicatedMap.init.completed", string, Long.toString(l3)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ping(long l) throws ChannelException {
        Response[] responseArray;
        MapMessage mapMessage = new MapMessage(this.mapContextName, 13, false, null, null, null, this.channel.getLocalMember(false), null);
        if (this.channel.getMembers().length > 0) {
            try {
                responseArray = this.rpcChannel.send(this.channel.getMembers(), mapMessage, 3, this.channelSendOptions, (int)this.accessTimeout);
                for (Response response : responseArray) {
                    MapMessage mapMessage2 = (MapMessage)response.getMessage();
                    try {
                        mapMessage2.deserialize(this.getExternalLoaders());
                        Member member = response.getSource();
                        Object object = (State)((Object)mapMessage2.getValue());
                        if (((State)((Object)object)).isAvailable()) {
                            this.memberAlive(member);
                            continue;
                        }
                        if (object == State.STATETRANSFERRED) {
                            HashMap<Member, Long> hashMap = this.mapMembers;
                            synchronized (hashMap) {
                                if (this.log.isInfoEnabled()) {
                                    this.log.info((Object)sm.getString("abstractReplicatedMap.ping.stateTransferredMember", member));
                                }
                                if (this.mapMembers.containsKey(member)) {
                                    this.mapMembers.put(member, System.currentTimeMillis());
                                }
                                continue;
                            }
                        }
                        if (!this.log.isInfoEnabled()) continue;
                        this.log.info((Object)sm.getString("abstractReplicatedMap.mapMember.unavailable", member));
                    }
                    catch (IOException | ClassNotFoundException exception) {
                        this.log.error((Object)sm.getString("abstractReplicatedMap.unable.deserialize.MapMessage"), (Throwable)exception);
                    }
                }
            }
            catch (ChannelException channelException) {
                ChannelException.FaultyMember[] faultyMemberArray;
                for (ChannelException.FaultyMember faultyMember : faultyMemberArray = channelException.getFaultyMembers()) {
                    this.memberDisappeared(faultyMember.getMember());
                }
                throw channelException;
            }
        }
        responseArray = this.mapMembers;
        synchronized (this.mapMembers) {
            Object[] objectArray = this.mapMembers.keySet().toArray(new Member[0]);
            long l2 = System.currentTimeMillis();
            for (Object object : objectArray) {
                long l3 = this.mapMembers.get(object);
                if (l2 - l3 <= l) continue;
                this.log.warn((Object)sm.getString("abstractReplicatedMap.ping.timeout", object, this.mapname));
                this.memberDisappeared((Member)object);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void memberAlive(Member member) {
        this.mapMemberAdded(member);
        HashMap<Member, Long> hashMap = this.mapMembers;
        synchronized (hashMap) {
            this.mapMembers.put(member, System.currentTimeMillis());
        }
    }

    protected void broadcast(int n, boolean bl) throws ChannelException {
        Member[] memberArray = this.channel.getMembers();
        if (memberArray.length == 0) {
            return;
        }
        MapMessage mapMessage = new MapMessage(this.mapContextName, n, false, null, null, null, this.channel.getLocalMember(false), null);
        if (bl) {
            Response[] responseArray = this.rpcChannel.send(memberArray, mapMessage, 1, this.channelSendOptions, this.rpcTimeout);
            if (responseArray.length > 0) {
                for (Response response : responseArray) {
                    this.mapMemberAdded(response.getSource());
                    this.messageReceived(response.getMessage(), response.getSource());
                }
            } else {
                this.log.warn((Object)sm.getString("abstractReplicatedMap.broadcast.noReplies"));
            }
        } else {
            this.channel.send(this.channel.getMembers(), mapMessage, this.channelSendOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakdown() {
        this.state = State.DESTROYED;
        if (this.rpcChannel != null) {
            this.rpcChannel.breakdown();
        }
        if (this.channel != null) {
            try {
                this.broadcast(7, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.channel.removeChannelListener(this);
            this.channel.removeMembershipListener(this);
        }
        this.rpcChannel = null;
        this.channel = null;
        HashMap<Member, Long> hashMap = this.mapMembers;
        synchronized (hashMap) {
            this.mapMembers.clear();
        }
        this.innerMap.clear();
        this.stateTransferred = false;
        this.externalLoaders = null;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mapContextName);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AbstractReplicatedMap)) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        AbstractReplicatedMap abstractReplicatedMap = (AbstractReplicatedMap)object;
        return Arrays.equals(this.mapContextName, abstractReplicatedMap.mapContextName);
    }

    public Member[] getMapMembers(HashMap<Member, Long> hashMap) {
        return hashMap.keySet().toArray(new Member[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Member[] getMapMembers() {
        HashMap<Member, Long> hashMap = this.mapMembers;
        synchronized (hashMap) {
            return this.getMapMembers(this.mapMembers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Member[] getMapMembersExcl(Member[] memberArray) {
        if (memberArray == null) {
            return null;
        }
        HashMap<Member, Long> hashMap = this.mapMembers;
        synchronized (hashMap) {
            HashMap hashMap2 = (HashMap)this.mapMembers.clone();
            for (Member member : memberArray) {
                hashMap2.remove(member);
            }
            return this.getMapMembers(hashMap2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicate(K k, boolean bl) {
        MapEntry mapEntry;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Replicate invoked on key:" + k));
        }
        if ((mapEntry = (MapEntry)this.innerMap.get(k)) == null) {
            return;
        }
        if (!mapEntry.isSerializable()) {
            return;
        }
        if (mapEntry.isPrimary() && mapEntry.getBackupNodes() != null && mapEntry.getBackupNodes().length > 0) {
            boolean bl2;
            ReplicatedMapEntry replicatedMapEntry = null;
            if (mapEntry.getValue() instanceof ReplicatedMapEntry) {
                replicatedMapEntry = (ReplicatedMapEntry)mapEntry.getValue();
            }
            boolean bl3 = replicatedMapEntry != null && replicatedMapEntry.isDirty();
            boolean bl4 = replicatedMapEntry != null && replicatedMapEntry.isAccessReplicate();
            boolean bl5 = bl2 = bl || bl3 || bl4;
            if (!bl2) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Not replicating:" + k + ", no change made"));
                }
                return;
            }
            MapMessage mapMessage = null;
            if (replicatedMapEntry != null && replicatedMapEntry.isDiffable() && (bl3 || bl)) {
                replicatedMapEntry.lock();
                try {
                    mapMessage = new MapMessage(this.mapContextName, this.getReplicateMessageType(), true, (Serializable)mapEntry.getKey(), null, replicatedMapEntry.getDiff(), mapEntry.getPrimary(), mapEntry.getBackupNodes());
                    replicatedMapEntry.resetDiff();
                }
                catch (IOException iOException) {
                    this.log.error((Object)sm.getString("abstractReplicatedMap.unable.diffObject"), (Throwable)iOException);
                }
                finally {
                    replicatedMapEntry.unlock();
                }
            }
            if (mapMessage == null && bl) {
                mapMessage = new MapMessage(this.mapContextName, this.getReplicateMessageType(), false, (Serializable)mapEntry.getKey(), (Serializable)mapEntry.getValue(), null, mapEntry.getPrimary(), mapEntry.getBackupNodes());
            }
            if (mapMessage == null) {
                mapMessage = new MapMessage(this.mapContextName, 11, false, (Serializable)mapEntry.getKey(), null, null, mapEntry.getPrimary(), mapEntry.getBackupNodes());
            }
            try {
                if (this.channel != null && mapEntry.getBackupNodes() != null && mapEntry.getBackupNodes().length > 0) {
                    if (replicatedMapEntry != null) {
                        replicatedMapEntry.setLastTimeReplicated(System.currentTimeMillis());
                    }
                    this.channel.send(mapEntry.getBackupNodes(), mapMessage, this.channelSendOptions);
                }
            }
            catch (ChannelException channelException) {
                this.log.error((Object)sm.getString("abstractReplicatedMap.unable.replicate"), (Throwable)channelException);
            }
        }
    }

    public void replicate(boolean bl) {
        for (Map.Entry entry : this.innerMap.entrySet()) {
            this.replicate(entry.getKey(), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferState() {
        block7: {
            try {
                Member member;
                Member[] memberArray = this.getMapMembers();
                Member member2 = member = memberArray.length > 0 ? memberArray[0] : null;
                if (member == null) break block7;
                MapMessage mapMessage = new MapMessage(this.mapContextName, this.getStateMessageType(), false, null, null, null, null, null);
                Response[] responseArray = this.rpcChannel.send(new Member[]{member}, mapMessage, 1, this.channelSendOptions, this.rpcTimeout);
                if (responseArray.length > 0) {
                    Object object = this.stateMutex;
                    synchronized (object) {
                        mapMessage = (MapMessage)responseArray[0].getMessage();
                        mapMessage.deserialize(this.getExternalLoaders());
                        ArrayList arrayList = (ArrayList)mapMessage.getValue();
                        for (Object e : arrayList) {
                            this.messageReceived((Serializable)e, responseArray[0].getSource());
                        }
                    }
                    this.stateTransferred = true;
                    break block7;
                }
                this.log.warn((Object)sm.getString("abstractReplicatedMap.transferState.noReplies"));
            }
            catch (IOException | ClassNotFoundException | ChannelException exception) {
                this.log.error((Object)sm.getString("abstractReplicatedMap.unable.transferState"), (Throwable)exception);
            }
        }
        this.state = State.STATETRANSFERRED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable replyRequest(Serializable serializable, Member member) {
        if (!(serializable instanceof MapMessage)) {
            return null;
        }
        MapMessage mapMessage = (MapMessage)serializable;
        if (mapMessage.getMsgType() == 8) {
            mapMessage.setPrimary(this.channel.getLocalMember(false));
            return mapMessage;
        }
        if (mapMessage.getMsgType() == 6) {
            mapMessage.setPrimary(this.channel.getLocalMember(false));
            this.mapMemberAdded(member);
            return mapMessage;
        }
        if (mapMessage.getMsgType() == 2) {
            MapEntry mapEntry = (MapEntry)this.innerMap.get(mapMessage.getKey());
            if (mapEntry == null || !mapEntry.isSerializable()) {
                return null;
            }
            mapMessage.setValue((Serializable)mapEntry.getValue());
            return mapMessage;
        }
        if (mapMessage.getMsgType() == 5 || mapMessage.getMsgType() == 10) {
            Object object = this.stateMutex;
            synchronized (object) {
                ArrayList<MapMessage> arrayList = new ArrayList<MapMessage>();
                for (Map.Entry entry : this.innerMap.entrySet()) {
                    MapEntry mapEntry = (MapEntry)this.innerMap.get(entry.getKey());
                    if (mapEntry == null || !mapEntry.isSerializable()) continue;
                    boolean bl = mapMessage.getMsgType() == 10;
                    MapMessage mapMessage2 = new MapMessage(this.mapContextName, bl ? 9 : 3, false, (Serializable)mapEntry.getKey(), bl ? (Serializable)mapEntry.getValue() : null, null, mapEntry.getPrimary(), mapEntry.getBackupNodes());
                    arrayList.add(mapMessage2);
                }
                mapMessage.setValue(arrayList);
                return mapMessage;
            }
        }
        if (mapMessage.getMsgType() == 13) {
            mapMessage.setValue((Serializable)((Object)this.state));
            mapMessage.setPrimary(this.channel.getLocalMember(false));
            return mapMessage;
        }
        return null;
    }

    @Override
    public void leftOver(Serializable serializable, Member member) {
        if (!(serializable instanceof MapMessage)) {
            return;
        }
        MapMessage mapMessage = (MapMessage)serializable;
        try {
            mapMessage.deserialize(this.getExternalLoaders());
            if (mapMessage.getMsgType() == 6) {
                this.mapMemberAdded(mapMessage.getPrimary());
            } else if (mapMessage.getMsgType() == 8) {
                this.memberAlive(mapMessage.getPrimary());
            } else if (mapMessage.getMsgType() == 13) {
                State state;
                Member member2 = mapMessage.getPrimary();
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)sm.getString("abstractReplicatedMap.leftOver.pingMsg", member2));
                }
                if ((state = (State)((Object)mapMessage.getValue())).isAvailable()) {
                    this.memberAlive(member2);
                }
            } else if (this.log.isInfoEnabled()) {
                this.log.info((Object)sm.getString("abstractReplicatedMap.leftOver.ignored", mapMessage.getTypeDesc()));
            }
        }
        catch (IOException | ClassNotFoundException exception) {
            this.log.error((Object)sm.getString("abstractReplicatedMap.unable.deserialize.MapMessage"), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(Serializable serializable, Member member) {
        Object object;
        MapEntry mapEntry;
        if (!(serializable instanceof MapMessage)) {
            return;
        }
        MapMessage mapMessage = (MapMessage)serializable;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Map[" + this.mapname + "] received message:" + mapMessage));
        }
        try {
            mapMessage.deserialize(this.getExternalLoaders());
        }
        catch (IOException | ClassNotFoundException exception) {
            this.log.error((Object)sm.getString("abstractReplicatedMap.unable.deserialize.MapMessage"), (Throwable)exception);
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Map message received from:" + member.getName() + " msg:" + mapMessage));
        }
        if (mapMessage.getMsgType() == 6) {
            this.mapMemberAdded(mapMessage.getPrimary());
        }
        if (mapMessage.getMsgType() == 7) {
            this.memberDisappeared(mapMessage.getPrimary());
        }
        if (mapMessage.getMsgType() == 3) {
            mapEntry = (MapEntry)this.innerMap.get(mapMessage.getKey());
            if (mapEntry == null && (object = this.innerMap.putIfAbsent((mapEntry = new MapEntry(mapMessage.getKey(), mapMessage.getValue())).getKey(), mapEntry)) != null) {
                mapEntry = object;
            }
            mapEntry.setProxy(true);
            mapEntry.setBackup(false);
            mapEntry.setCopy(false);
            mapEntry.setBackupNodes(mapMessage.getBackupNodes());
            mapEntry.setPrimary(mapMessage.getPrimary());
        }
        if (mapMessage.getMsgType() == 4) {
            this.innerMap.remove(mapMessage.getKey());
        }
        if (mapMessage.getMsgType() == 1 || mapMessage.getMsgType() == 9) {
            mapEntry = (MapEntry)this.innerMap.get(mapMessage.getKey());
            if (mapEntry == null) {
                mapEntry = new MapEntry(mapMessage.getKey(), mapMessage.getValue());
                mapEntry.setBackup(mapMessage.getMsgType() == 1);
                mapEntry.setProxy(false);
                mapEntry.setCopy(mapMessage.getMsgType() == 9);
                mapEntry.setBackupNodes(mapMessage.getBackupNodes());
                mapEntry.setPrimary(mapMessage.getPrimary());
                if (mapMessage.getValue() instanceof ReplicatedMapEntry) {
                    ((ReplicatedMapEntry)mapMessage.getValue()).setOwner(this.getMapOwner());
                }
            } else {
                mapEntry.setBackup(mapMessage.getMsgType() == 1);
                mapEntry.setProxy(false);
                mapEntry.setCopy(mapMessage.getMsgType() == 9);
                mapEntry.setBackupNodes(mapMessage.getBackupNodes());
                mapEntry.setPrimary(mapMessage.getPrimary());
                if (mapEntry.getValue() instanceof ReplicatedMapEntry) {
                    object = (ReplicatedMapEntry)mapEntry.getValue();
                    if (mapMessage.isDiff()) {
                        object.lock();
                        try {
                            object.applyDiff(mapMessage.getDiffValue(), 0, mapMessage.getDiffValue().length);
                        }
                        catch (Exception exception) {
                            this.log.error((Object)sm.getString("abstractReplicatedMap.unableApply.diff", mapEntry.getKey()), (Throwable)exception);
                        }
                        finally {
                            object.unlock();
                        }
                    } else if (mapMessage.getValue() != null) {
                        if (mapMessage.getValue() instanceof ReplicatedMapEntry) {
                            ReplicatedMapEntry replicatedMapEntry = (ReplicatedMapEntry)mapMessage.getValue();
                            replicatedMapEntry.setOwner(this.getMapOwner());
                            mapEntry.setValue((Serializable)replicatedMapEntry);
                        } else {
                            mapEntry.setValue((Serializable)mapMessage.getValue());
                        }
                    } else {
                        ((ReplicatedMapEntry)mapEntry.getValue()).setOwner(this.getMapOwner());
                    }
                } else if (mapMessage.getValue() instanceof ReplicatedMapEntry) {
                    object = (ReplicatedMapEntry)mapMessage.getValue();
                    object.setOwner(this.getMapOwner());
                    mapEntry.setValue((Serializable)object);
                } else if (mapMessage.getValue() != null) {
                    mapEntry.setValue((Serializable)mapMessage.getValue());
                }
            }
            this.innerMap.put(mapEntry.getKey(), mapEntry);
        }
        if (mapMessage.getMsgType() == 11 && (mapEntry = (MapEntry)this.innerMap.get(mapMessage.getKey())) != null) {
            mapEntry.setBackupNodes(mapMessage.getBackupNodes());
            mapEntry.setPrimary(mapMessage.getPrimary());
            if (mapEntry.getValue() instanceof ReplicatedMapEntry) {
                ((ReplicatedMapEntry)mapEntry.getValue()).accessEntry();
            }
        }
        if (mapMessage.getMsgType() == 12 && (mapEntry = (MapEntry)this.innerMap.get(mapMessage.getKey())) != null) {
            mapEntry.setBackupNodes(mapMessage.getBackupNodes());
            mapEntry.setPrimary(mapMessage.getPrimary());
            if (mapEntry.getValue() instanceof ReplicatedMapEntry) {
                ((ReplicatedMapEntry)mapEntry.getValue()).accessEntry();
            }
        }
    }

    @Override
    public boolean accept(Serializable serializable, Member member) {
        boolean bl = false;
        if (serializable instanceof MapMessage) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Map[" + this.mapname + "] accepting...." + serializable));
            }
            bl = Arrays.equals(this.mapContextName, ((MapMessage)serializable).getMapId());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Msg[" + this.mapname + "] accepted[" + bl + "]...." + serializable));
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapMemberAdded(Member member) {
        if (member.equals(this.getChannel().getLocalMember(false))) {
            return;
        }
        boolean bl = false;
        Member member2 = this.getChannel().getMember(member);
        if (member2 == null) {
            this.log.warn((Object)sm.getString("abstractReplicatedMap.mapMemberAdded.nullMember", member));
            return;
        }
        Object object = this.mapMembers;
        synchronized (object) {
            if (!this.mapMembers.containsKey(member2)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)sm.getString("abstractReplicatedMap.mapMemberAdded.added", member2));
                }
                this.mapMembers.put(member2, System.currentTimeMillis());
                bl = true;
            }
        }
        if (bl) {
            object = this.stateMutex;
            synchronized (object) {
                for (Map.Entry entry : this.innerMap.entrySet()) {
                    MapEntry mapEntry = (MapEntry)this.innerMap.get(entry.getKey());
                    if (mapEntry == null || !mapEntry.isPrimary() || mapEntry.getBackupNodes() != null && mapEntry.getBackupNodes().length != 0) continue;
                    try {
                        Member[] memberArray = this.publishEntryInfo(mapEntry.getKey(), mapEntry.getValue());
                        mapEntry.setBackupNodes(memberArray);
                        mapEntry.setPrimary(this.channel.getLocalMember(false));
                    }
                    catch (ChannelException channelException) {
                        this.log.error((Object)sm.getString("abstractReplicatedMap.unableSelect.backup"), (Throwable)channelException);
                    }
                }
            }
        }
    }

    public boolean inSet(Member member, Member[] memberArray) {
        if (memberArray == null) {
            return false;
        }
        boolean bl = false;
        for (Member member2 : memberArray) {
            if (!member.equals(member2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Member[] excludeFromSet(Member[] memberArray, Member[] memberArray2) {
        ArrayList<Member> arrayList = new ArrayList<Member>();
        for (Member member : memberArray2) {
            boolean bl = true;
            for (Member member2 : memberArray) {
                if (!member2.equals(member)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(member);
        }
        return arrayList.toArray(new Member[0]);
    }

    @Override
    public void memberAdded(Member member) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberDisappeared(Member member) {
        HashMap<Member, Long> hashMap = this.mapMembers;
        synchronized (hashMap) {
            boolean bl;
            boolean bl2 = bl = this.mapMembers.remove(member) != null;
            if (!bl) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("replicatedMap.member.disappeared.unknown", member));
                }
                return;
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)sm.getString("replicatedMap.member.disappeared", member));
        }
        long l = System.currentTimeMillis();
        Iterator iterator = this.innerMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Member[] memberArray;
            Map.Entry entry = iterator.next();
            MapEntry mapEntry = (MapEntry)this.innerMap.get(entry.getKey());
            if (mapEntry == null) continue;
            if (mapEntry.isPrimary() && this.inSet(member, mapEntry.getBackupNodes())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("abstractReplicatedMap.newBackup"));
                }
                try {
                    memberArray = this.publishEntryInfo(mapEntry.getKey(), mapEntry.getValue());
                    mapEntry.setBackupNodes(memberArray);
                    mapEntry.setPrimary(this.channel.getLocalMember(false));
                }
                catch (ChannelException channelException) {
                    this.log.error((Object)sm.getString("abstractReplicatedMap.unable.relocate", mapEntry.getKey()), (Throwable)channelException);
                }
            } else if (member.equals(mapEntry.getPrimary())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("abstractReplicatedMap.primaryDisappeared"));
                }
                mapEntry.setPrimary(null);
            }
            if (mapEntry.isProxy() && mapEntry.getPrimary() == null && mapEntry.getBackupNodes() != null && mapEntry.getBackupNodes().length == 1 && mapEntry.getBackupNodes()[0].equals(member)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("abstractReplicatedMap.removeOrphan"));
                }
                iterator.remove();
                continue;
            }
            if (mapEntry.getPrimary() != null || !mapEntry.isBackup() || mapEntry.getBackupNodes() == null || mapEntry.getBackupNodes().length != 1 || !mapEntry.getBackupNodes()[0].equals(this.channel.getLocalMember(false))) continue;
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("abstractReplicatedMap.newPrimary"));
                }
                mapEntry.setPrimary(this.channel.getLocalMember(false));
                mapEntry.setBackup(false);
                mapEntry.setProxy(false);
                mapEntry.setCopy(false);
                memberArray = this.publishEntryInfo(mapEntry.getKey(), mapEntry.getValue());
                mapEntry.setBackupNodes(memberArray);
                if (this.mapOwner == null) continue;
                this.mapOwner.objectMadePrimary(mapEntry.getKey(), mapEntry.getValue());
            }
            catch (ChannelException channelException) {
                this.log.error((Object)sm.getString("abstractReplicatedMap.unable.relocate", mapEntry.getKey()), (Throwable)channelException);
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)sm.getString("abstractReplicatedMap.relocate.complete", Long.toString(l2)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextBackupIndex() {
        HashMap<Member, Long> hashMap = this.mapMembers;
        synchronized (hashMap) {
            int n;
            int n2 = this.mapMembers.size();
            if (this.mapMembers.isEmpty()) {
                return -1;
            }
            if ((n = this.currentNode++) >= n2) {
                n = 0;
                this.currentNode = 1;
            }
            return n;
        }
    }

    public Member getNextBackupNode() {
        Member[] memberArray = this.getMapMembers();
        int n = this.getNextBackupIndex();
        if (memberArray.length == 0 || n == -1) {
            return null;
        }
        if (n >= memberArray.length) {
            n = 0;
        }
        return memberArray[n];
    }

    protected abstract Member[] publishEntryInfo(Object var1, Object var2) throws ChannelException;

    @Override
    public void heartbeat() {
        try {
            if (this.state.isAvailable()) {
                this.ping(this.accessTimeout);
            }
        }
        catch (Exception exception) {
            this.log.error((Object)sm.getString("abstractReplicatedMap.heartbeat.failed"), (Throwable)exception);
        }
    }

    @Override
    public V remove(Object object) {
        return this.remove(object, true);
    }

    public V remove(Object object, boolean bl) {
        MapEntry mapEntry = (MapEntry)this.innerMap.remove(object);
        try {
            if (this.getMapMembers().length > 0 && bl) {
                MapMessage mapMessage = new MapMessage(this.getMapContextName(), 4, false, (Serializable)object, null, null, null, null);
                this.getChannel().send(this.getMapMembers(), mapMessage, this.getChannelSendOptions());
            }
        }
        catch (ChannelException channelException) {
            this.log.error((Object)sm.getString("abstractReplicatedMap.unable.remove"), (Throwable)channelException);
        }
        return mapEntry != null ? (V)mapEntry.getValue() : null;
    }

    public MapEntry<K, V> getInternal(Object object) {
        return (MapEntry)this.innerMap.get(object);
    }

    @Override
    public V get(Object object) {
        MapEntry mapEntry = (MapEntry)this.innerMap.get(object);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Requesting id:" + object + " entry:" + mapEntry));
        }
        if (mapEntry == null) {
            return null;
        }
        if (!mapEntry.isPrimary()) {
            try {
                Member[] memberArray = null;
                if (mapEntry.isBackup()) {
                    memberArray = this.publishEntryInfo(object, mapEntry.getValue());
                } else if (mapEntry.isProxy()) {
                    MapMessage mapMessage = new MapMessage(this.getMapContextName(), 2, false, (Serializable)object, null, null, null, null);
                    Response[] responseArray = this.getRpcChannel().send(mapEntry.getBackupNodes(), mapMessage, 1, this.getChannelSendOptions(), this.getRpcTimeout());
                    if (responseArray == null || responseArray.length == 0 || responseArray[0].getMessage() == null) {
                        this.log.warn((Object)sm.getString("abstractReplicatedMap.unable.retrieve", object));
                        return null;
                    }
                    mapMessage = (MapMessage)responseArray[0].getMessage();
                    mapMessage.deserialize(this.getExternalLoaders());
                    memberArray = mapEntry.getBackupNodes();
                    if (mapMessage.getValue() != null) {
                        mapEntry.setValue(mapMessage.getValue());
                    }
                    mapMessage = new MapMessage(this.getMapContextName(), 12, false, (Serializable)mapEntry.getKey(), null, null, this.channel.getLocalMember(false), memberArray);
                    if (memberArray != null && memberArray.length > 0) {
                        this.getChannel().send(memberArray, mapMessage, this.getChannelSendOptions());
                    }
                    mapMessage = new MapMessage(this.getMapContextName(), 3, false, (Serializable)object, null, null, this.channel.getLocalMember(false), memberArray);
                    Member[] memberArray2 = this.getMapMembersExcl(memberArray);
                    if (memberArray2 != null && memberArray2.length > 0) {
                        this.getChannel().send(memberArray2, mapMessage, this.getChannelSendOptions());
                    }
                    if (mapEntry.getValue() instanceof ReplicatedMapEntry) {
                        ReplicatedMapEntry replicatedMapEntry = (ReplicatedMapEntry)mapEntry.getValue();
                        replicatedMapEntry.setOwner(this.getMapOwner());
                    }
                } else if (mapEntry.isCopy() && (memberArray = this.getMapMembers()).length > 0) {
                    MapMessage mapMessage = new MapMessage(this.getMapContextName(), 12, false, (Serializable)object, null, null, this.channel.getLocalMember(false), memberArray);
                    this.getChannel().send(memberArray, mapMessage, this.getChannelSendOptions());
                }
                mapEntry.setPrimary(this.channel.getLocalMember(false));
                mapEntry.setBackupNodes(memberArray);
                mapEntry.setBackup(false);
                mapEntry.setProxy(false);
                mapEntry.setCopy(false);
                if (this.getMapOwner() != null) {
                    this.getMapOwner().objectMadePrimary(object, mapEntry.getValue());
                }
            }
            catch (IOException | ClassNotFoundException | RuntimeException | ChannelException exception) {
                this.log.error((Object)sm.getString("abstractReplicatedMap.unable.get"), (Throwable)exception);
                return null;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Requesting id:" + object + " result:" + mapEntry.getValue()));
        }
        return mapEntry.getValue();
    }

    protected void printMap(String string) {
        block4: {
            try {
                System.out.println("\nDEBUG MAP:" + string);
                System.out.println("Map[" + new String(this.mapContextName, StandardCharsets.ISO_8859_1) + ", Map Size:" + this.innerMap.size());
                Member[] memberArray = this.getMapMembers();
                for (int i = 0; i < memberArray.length; ++i) {
                    System.out.println("Mbr[" + (i + 1) + "=" + memberArray[i].getName());
                }
                Iterator iterator = this.innerMap.entrySet().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    System.out.println(++n + ". " + this.innerMap.get(entry.getKey()));
                }
                System.out.println("EndMap]\n\n");
            }
            catch (Exception exception) {
                if (!this.log.isTraceEnabled()) break block4;
                this.log.trace((Object)"Error printing map", (Throwable)exception);
            }
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return this.innerMap.containsKey(object);
    }

    @Override
    public V put(K k, V v) {
        return this.put(k, v, true);
    }

    public V put(K k, V v, boolean bl) {
        MapEntry<K, V> mapEntry = new MapEntry<K, V>(k, v);
        mapEntry.setBackup(false);
        mapEntry.setProxy(false);
        mapEntry.setCopy(false);
        mapEntry.setPrimary(this.channel.getLocalMember(false));
        V v2 = null;
        if (this.containsKey(k)) {
            v2 = this.remove(k);
        }
        try {
            if (bl) {
                Member[] memberArray = this.publishEntryInfo(k, v);
                mapEntry.setBackupNodes(memberArray);
            }
        }
        catch (ChannelException channelException) {
            this.log.error((Object)sm.getString("abstractReplicatedMap.unable.put"), (Throwable)channelException);
        }
        this.innerMap.put(k, mapEntry);
        return v2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry;
            Map.Entry<K, V> entry2 = entry = iterator.next();
            this.put(entry2.getKey(), entry2.getValue());
        }
    }

    @Override
    public void clear() {
        this.clear(true);
    }

    public void clear(boolean bl) {
        if (bl) {
            for (K k : this.keySet()) {
                this.remove(k);
            }
        } else {
            this.innerMap.clear();
        }
    }

    @Override
    public boolean containsValue(Object object) {
        Objects.requireNonNull(object);
        for (Map.Entry entry : this.innerMap.entrySet()) {
            MapEntry mapEntry = (MapEntry)this.innerMap.get(entry.getKey());
            if (mapEntry == null || !mapEntry.isActive() || !object.equals(mapEntry.getValue())) continue;
            return true;
        }
        return false;
    }

    public Set<Map.Entry<K, MapEntry<K, V>>> entrySetFull() {
        return this.innerMap.entrySet();
    }

    public Set<K> keySetFull() {
        return this.innerMap.keySet();
    }

    public int sizeFull() {
        return this.innerMap.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<MapEntry> linkedHashSet = new LinkedHashSet<MapEntry>(this.innerMap.size());
        for (Map.Entry entry : this.innerMap.entrySet()) {
            MapEntry mapEntry = (MapEntry)this.innerMap.get(entry.getKey());
            if (mapEntry == null || !mapEntry.isActive()) continue;
            linkedHashSet.add(mapEntry);
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    @Override
    public Set<K> keySet() {
        LinkedHashSet linkedHashSet = new LinkedHashSet(this.innerMap.size());
        for (Map.Entry entry : this.innerMap.entrySet()) {
            Object k = entry.getKey();
            MapEntry mapEntry = (MapEntry)this.innerMap.get(k);
            if (mapEntry == null || !mapEntry.isActive()) continue;
            linkedHashSet.add(k);
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    @Override
    public int size() {
        int n = 0;
        for (Map.Entry entry : this.innerMap.entrySet()) {
            MapEntry mapEntry;
            if (entry == null || (mapEntry = (MapEntry)this.innerMap.get(entry.getKey())) == null || !mapEntry.isActive() || mapEntry.getValue() == null) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Collection<V> values() {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : this.innerMap.entrySet()) {
            MapEntry mapEntry = (MapEntry)this.innerMap.get(entry.getKey());
            if (mapEntry == null || !mapEntry.isActive() || mapEntry.getValue() == null) continue;
            arrayList.add(mapEntry.getValue());
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public byte[] getMapContextName() {
        return this.mapContextName;
    }

    public RpcChannel getRpcChannel() {
        return this.rpcChannel;
    }

    public long getRpcTimeout() {
        return this.rpcTimeout;
    }

    public Object getStateMutex() {
        return this.stateMutex;
    }

    public boolean isStateTransferred() {
        return this.stateTransferred;
    }

    public MapOwner getMapOwner() {
        return this.mapOwner;
    }

    public ClassLoader[] getExternalLoaders() {
        return this.externalLoaders;
    }

    public int getChannelSendOptions() {
        return this.channelSendOptions;
    }

    public long getAccessTimeout() {
        return this.accessTimeout;
    }

    public void setMapOwner(MapOwner mapOwner) {
        this.mapOwner = mapOwner;
    }

    public void setExternalLoaders(ClassLoader[] classLoaderArray) {
        this.externalLoaders = classLoaderArray;
    }

    public void setChannelSendOptions(int n) {
        this.channelSendOptions = n;
    }

    public void setAccessTimeout(long l) {
        this.accessTimeout = l;
    }

    private static enum State {
        NEW(false),
        STATETRANSFERRED(false),
        INITIALIZED(true),
        DESTROYED(false);

        private final boolean available;

        private State(boolean bl) {
            this.available = bl;
        }

        public boolean isAvailable() {
            return this.available;
        }
    }

    public static interface MapOwner {
        public void objectMadePrimary(Object var1, Object var2);
    }

    public static class MapMessage
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        public static final int MSG_BACKUP = 1;
        public static final int MSG_RETRIEVE_BACKUP = 2;
        public static final int MSG_PROXY = 3;
        public static final int MSG_REMOVE = 4;
        public static final int MSG_STATE = 5;
        public static final int MSG_START = 6;
        public static final int MSG_STOP = 7;
        public static final int MSG_INIT = 8;
        public static final int MSG_COPY = 9;
        public static final int MSG_STATE_COPY = 10;
        public static final int MSG_ACCESS = 11;
        public static final int MSG_NOTIFY_MAPMEMBER = 12;
        public static final int MSG_PING = 13;
        private final byte[] mapId;
        private final int msgtype;
        private final boolean diff;
        private transient Serializable key;
        private transient Serializable value;
        private byte[] valuedata;
        private byte[] keydata;
        private final byte[] diffvalue;
        private final Member[] nodes;
        private Member primary;

        public String toString() {
            return "MapMessage[context=" + new String(this.mapId) + "; type=" + this.getTypeDesc() + "; key=" + this.key + "; value=" + this.value + ']';
        }

        public String getTypeDesc() {
            switch (this.msgtype) {
                case 1: {
                    return "MSG_BACKUP";
                }
                case 2: {
                    return "MSG_RETRIEVE_BACKUP";
                }
                case 3: {
                    return "MSG_PROXY";
                }
                case 4: {
                    return "MSG_REMOVE";
                }
                case 5: {
                    return "MSG_STATE";
                }
                case 6: {
                    return "MSG_START";
                }
                case 7: {
                    return "MSG_STOP";
                }
                case 8: {
                    return "MSG_INIT";
                }
                case 10: {
                    return "MSG_STATE_COPY";
                }
                case 9: {
                    return "MSG_COPY";
                }
                case 11: {
                    return "MSG_ACCESS";
                }
                case 12: {
                    return "MSG_NOTIFY_MAPMEMBER";
                }
                case 13: {
                    return "MSG_PING";
                }
            }
            return "UNKNOWN";
        }

        public MapMessage(byte[] byArray, int n, boolean bl, Serializable serializable, Serializable serializable2, byte[] byArray2, Member member, Member[] memberArray) {
            this.mapId = byArray;
            this.msgtype = n;
            this.diff = bl;
            this.key = serializable;
            this.value = serializable2;
            this.diffvalue = byArray2;
            this.nodes = memberArray;
            this.primary = member;
            this.setValue(serializable2);
            this.setKey(serializable);
        }

        public void deserialize(ClassLoader[] classLoaderArray) throws IOException, ClassNotFoundException {
            this.key(classLoaderArray);
            this.value(classLoaderArray);
        }

        public int getMsgType() {
            return this.msgtype;
        }

        public boolean isDiff() {
            return this.diff;
        }

        public Serializable getKey() {
            try {
                return this.key(null);
            }
            catch (Exception exception) {
                throw new RuntimeException(sm.getString("mapMessage.deserialize.error.key"), exception);
            }
        }

        public Serializable key(ClassLoader[] classLoaderArray) throws IOException, ClassNotFoundException {
            if (this.key != null) {
                return this.key;
            }
            if (this.keydata == null || this.keydata.length == 0) {
                return null;
            }
            this.key = XByteBuffer.deserialize(this.keydata, 0, this.keydata.length, classLoaderArray);
            this.keydata = null;
            return this.key;
        }

        public byte[] getKeyData() {
            return this.keydata;
        }

        public Serializable getValue() {
            try {
                return this.value(null);
            }
            catch (Exception exception) {
                throw new RuntimeException(sm.getString("mapMessage.deserialize.error.value"), exception);
            }
        }

        public Serializable value(ClassLoader[] classLoaderArray) throws IOException, ClassNotFoundException {
            if (this.value != null) {
                return this.value;
            }
            if (this.valuedata == null || this.valuedata.length == 0) {
                return null;
            }
            this.value = XByteBuffer.deserialize(this.valuedata, 0, this.valuedata.length, classLoaderArray);
            this.valuedata = null;
            return this.value;
        }

        public byte[] getValueData() {
            return this.valuedata;
        }

        public byte[] getDiffValue() {
            return this.diffvalue;
        }

        public Member[] getBackupNodes() {
            return this.nodes;
        }

        public Member getPrimary() {
            return this.primary;
        }

        private void setPrimary(Member member) {
            this.primary = member;
        }

        public byte[] getMapId() {
            return this.mapId;
        }

        public void setValue(Serializable serializable) {
            try {
                if (serializable != null) {
                    this.valuedata = XByteBuffer.serialize(serializable);
                }
                this.value = serializable;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public void setKey(Serializable serializable) {
            try {
                if (serializable != null) {
                    this.keydata = XByteBuffer.serialize(serializable);
                }
                this.key = serializable;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public MapMessage clone() {
            try {
                return (MapMessage)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
        }
    }

    public static class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private boolean backup;
        private boolean proxy;
        private boolean copy;
        private Member[] backupNodes;
        private Member primary;
        private K key;
        private V value;

        public MapEntry(K k, V v) {
            this.setKey(k);
            this.setValue(v);
        }

        public boolean isKeySerializable() {
            return this.key == null || this.key instanceof Serializable;
        }

        public boolean isValueSerializable() {
            return this.value == null || this.value instanceof Serializable;
        }

        public boolean isSerializable() {
            return this.isKeySerializable() && this.isValueSerializable();
        }

        public boolean isBackup() {
            return this.backup;
        }

        public void setBackup(boolean bl) {
            this.backup = bl;
        }

        public boolean isProxy() {
            return this.proxy;
        }

        public boolean isPrimary() {
            return !this.proxy && !this.backup && !this.copy;
        }

        public boolean isActive() {
            return !this.proxy;
        }

        public void setProxy(boolean bl) {
            this.proxy = bl;
        }

        public boolean isCopy() {
            return this.copy;
        }

        public void setCopy(boolean bl) {
            this.copy = bl;
        }

        public boolean isDiffable() {
            return this.value instanceof ReplicatedMapEntry && ((ReplicatedMapEntry)this.value).isDiffable();
        }

        public void setBackupNodes(Member[] memberArray) {
            this.backupNodes = memberArray;
        }

        public Member[] getBackupNodes() {
            return this.backupNodes;
        }

        public void setPrimary(Member member) {
            this.primary = member;
        }

        public Member getPrimary() {
            return this.primary;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public K setKey(K k) {
            K k2 = this.key;
            this.key = k;
            return k2;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return this.key.equals(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void apply(byte[] byArray, int n, int n2, boolean bl) throws IOException, ClassNotFoundException {
            if (this.isDiffable() && bl) {
                ReplicatedMapEntry replicatedMapEntry = (ReplicatedMapEntry)this.value;
                replicatedMapEntry.lock();
                try {
                    replicatedMapEntry.applyDiff(byArray, n, n2);
                }
                finally {
                    replicatedMapEntry.unlock();
                }
            } else if (n2 == 0) {
                this.value = null;
                this.proxy = true;
            } else {
                this.value = XByteBuffer.deserialize(byArray, n, n2);
            }
        }

        public String toString() {
            return "MapEntry[key:" + this.getKey() + "; value:" + this.getValue() + "; primary:" + this.isPrimary() + "; backup:" + this.isBackup() + "; proxy:" + this.isProxy() + ";]";
        }
    }
}

