/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.global;

import org.graalvm.visualvm.lib.jfluid.global.TransactionalSupport;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.InternalStatsResponse;

public class ProfilingSessionStatus {
    public static final int N_TIMER_CONSTANTS = 5;
    public static final int CODE_REGION_CLASS_IDX = 0;
    public InternalStatsResponse savedInternalStats;
    public String fullTargetJDKVersionString;
    public String instrClassLoaderName;
    public String javaCommand;
    public String jvmArguments;
    public String targetJDKVersionString;
    public String targetMachineOSName;
    public boolean canInstrumentConstructor;
    public double[] methodEntryExitCallTime = new double[5];
    public double[] methodEntryExitInnerTime = new double[5];
    public double[] methodEntryExitOuterTime = new double[5];
    public long[] timerCountsInSecond = new long[2];
    public boolean absoluteTimerOn;
    public boolean remoteProfiling = false;
    public boolean runningInAttachedMode;
    public boolean startProfilingPointsActive;
    public volatile boolean targetAppRunning;
    public boolean threadCPUTimerOn;
    public int currentInstrType;
    public int instrEndLine;
    public int instrScheme;
    public int instrStartLine;
    public long dumpAbsTimeStamp;
    public long maxHeapSize;
    public long startupTimeInCounts;
    public long startupTimeMillis;
    private TransactionalSupport transaction = new TransactionalSupport();
    private int[] allocatedInstancesCount;
    private int[] classLoaderIds;
    private String[] classNames;
    private String[] instrMethodClasses;
    private boolean[] instrMethodInvoked;
    private String[] instrMethodNames;
    private String[] instrMethodSignatures;
    private int nInstrClasses;
    private int nInstrMethods;

    public int[] getAllocatedInstancesCount() {
        this.beginTrans(false);
        try {
            int[] nArray = this.allocatedInstancesCount;
            return nArray;
        }
        finally {
            this.endTrans();
        }
    }

    public int[] getClassLoaderIds() {
        this.beginTrans(false);
        try {
            int[] nArray = this.classLoaderIds;
            return nArray;
        }
        finally {
            this.endTrans();
        }
    }

    public String[] getClassNames() {
        this.beginTrans(false);
        try {
            String[] stringArray = this.classNames;
            return stringArray;
        }
        finally {
            this.endTrans();
        }
    }

    public String[] getInstrMethodClasses() {
        this.beginTrans(false);
        try {
            String[] stringArray = this.instrMethodClasses;
            return stringArray;
        }
        finally {
            this.endTrans();
        }
    }

    public boolean[] getInstrMethodInvoked() {
        this.beginTrans(false);
        try {
            boolean[] blArray = this.instrMethodInvoked;
            return blArray;
        }
        finally {
            this.endTrans();
        }
    }

    public void setInstrMethodNames(String[] value) {
        this.beginTrans(true);
        try {
            this.instrMethodNames = value;
        }
        finally {
            this.endTrans();
        }
    }

    public String[] getInstrMethodNames() {
        this.beginTrans(false);
        try {
            String[] stringArray = this.instrMethodNames;
            return stringArray;
        }
        finally {
            this.endTrans();
        }
    }

    public void setInstrMethodSignatures(String[] value) {
        this.beginTrans(true);
        try {
            this.instrMethodSignatures = value;
        }
        finally {
            this.endTrans();
        }
    }

    public String[] getInstrMethodSignatures() {
        this.beginTrans(false);
        try {
            String[] stringArray = this.instrMethodSignatures;
            return stringArray;
        }
        finally {
            this.endTrans();
        }
    }

    public int getNInstrClasses() {
        this.beginTrans(false);
        try {
            int n = this.nInstrClasses;
            return n;
        }
        finally {
            this.endTrans();
        }
    }

    public int getNInstrMethods() {
        this.beginTrans(false);
        try {
            int n = this.nInstrMethods;
            return n;
        }
        finally {
            this.endTrans();
        }
    }

    public int getStartingMethodId() {
        this.beginTrans(false);
        try {
            if (this.nInstrMethods > 0) {
                int n = this.nInstrMethods;
                return n;
            }
            int n = 1;
            return n;
        }
        finally {
            this.endTrans();
        }
    }

    public void setTimerTypes(boolean absolute, boolean threadCPU) {
        this.absoluteTimerOn = absolute;
        this.threadCPUTimerOn = threadCPU;
    }

    public void beginTrans(boolean mutable) {
        this.transaction.beginTrans(mutable);
    }

    public boolean collectingTwoTimeStamps() {
        return this.absoluteTimerOn && this.threadCPUTimerOn;
    }

    public void endTrans() {
        this.transaction.endTrans();
    }

    public void resetInstrClassAndMethodInfo() {
        this.beginTrans(true);
        try {
            this.nInstrMethods = 0;
            this.instrMethodSignatures = null;
            this.instrMethodNames = null;
            this.instrMethodClasses = null;
            this.instrMethodInvoked = null;
            this.nInstrClasses = 0;
            this.allocatedInstancesCount = null;
            this.classNames = new String[0];
        }
        finally {
            this.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllocatedInstancesCountInfoInClient(String addedClassName) {
        this.beginTrans(true);
        try {
            if (this.nInstrClasses == 0 || this.nInstrClasses == this.classNames.length) {
                boolean firstTime = this.nInstrClasses == 0;
                int newSize = firstTime ? 50 : this.nInstrClasses * 3 / 2;
                int[] newAllocInstCount = new int[newSize];
                String[] newClassNames = new String[newSize];
                if (!firstTime) {
                    System.arraycopy(this.allocatedInstancesCount, 0, newAllocInstCount, 0, this.nInstrClasses);
                    System.arraycopy(this.classNames, 0, newClassNames, 0, this.nInstrClasses);
                }
                this.allocatedInstancesCount = newAllocInstCount;
                this.classNames = newClassNames;
            }
            this.classNames[this.nInstrClasses++] = addedClassName;
        }
        finally {
            this.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllocatedInstancesCountInfoInServer(int nTotalClasses) {
        this.beginTrans(true);
        try {
            boolean firstTime = this.nInstrClasses == 0;
            int oldSize = firstTime ? 0 : this.allocatedInstancesCount.length;
            int newLen = nTotalClasses;
            if (oldSize < newLen) {
                int newSize = newLen * 2;
                int[] newAllocInstCount = new int[newSize];
                if (!firstTime) {
                    System.arraycopy(this.allocatedInstancesCount, 0, newAllocInstCount, 0, this.nInstrClasses);
                }
                this.allocatedInstancesCount = newAllocInstCount;
            }
            this.nInstrClasses = nTotalClasses;
        }
        finally {
            this.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInstrMethodsInfo(int nClasses, int nMethods, String[] classes, int[] loaderIds, int[] nMethodsInClass, String[] methodNames, String[] methodSignatures, boolean[] isMethodLeaf) {
        if (nClasses == 0) {
            return;
        }
        this.beginTrans(true);
        try {
            boolean firstTime;
            boolean bl = firstTime = this.nInstrMethods == 0;
            int oldSize = firstTime ? 0 : (classes != null ? this.instrMethodNames.length : this.instrMethodInvoked.length);
            int emptyCell = firstTime ? 1 : 0;
            int nAddedMethods = nMethods + emptyCell;
            int newLen = this.nInstrMethods + nMethods + emptyCell;
            if (oldSize < newLen) {
                int newSize = newLen * 2;
                if (classes != null) {
                    String[] newClasses = new String[newSize];
                    int[] newLoaderIds = new int[newSize];
                    String[] newMethods = new String[newSize];
                    String[] newSignatures = new String[newSize];
                    if (!firstTime) {
                        System.arraycopy(this.instrMethodClasses, 0, newClasses, 0, this.nInstrMethods);
                        System.arraycopy(this.classLoaderIds, 0, newLoaderIds, 0, this.nInstrMethods);
                        System.arraycopy(this.instrMethodNames, 0, newMethods, 0, this.nInstrMethods);
                        System.arraycopy(this.instrMethodSignatures, 0, newSignatures, 0, this.nInstrMethods);
                    }
                    this.instrMethodClasses = newClasses;
                    this.classLoaderIds = newLoaderIds;
                    this.instrMethodNames = newMethods;
                    this.instrMethodSignatures = newSignatures;
                } else {
                    boolean[] newMethodInvoked = new boolean[newSize];
                    if (!firstTime) {
                        System.arraycopy(this.instrMethodInvoked, 0, newMethodInvoked, 0, this.nInstrMethods);
                    }
                    this.instrMethodInvoked = newMethodInvoked;
                }
            }
            if (classes != null) {
                if (firstTime) {
                    this.instrMethodClasses[0] = "Thread";
                    this.classLoaderIds[0] = 0;
                    this.instrMethodNames[0] = "";
                    this.instrMethodSignatures[0] = "";
                }
                int idx = this.nInstrMethods + emptyCell;
                for (int i = 0; i < nClasses; ++i) {
                    for (int j = 0; j < nMethodsInClass[i]; ++j) {
                        this.instrMethodClasses[idx] = classes[i];
                        this.classLoaderIds[idx] = loaderIds[i];
                        ++idx;
                    }
                }
                System.arraycopy(methodNames, 0, this.instrMethodNames, this.nInstrMethods + emptyCell, nMethods);
                System.arraycopy(methodSignatures, 0, this.instrMethodSignatures, this.nInstrMethods + emptyCell, nMethods);
            } else {
                if (isMethodLeaf != null) {
                    System.arraycopy(isMethodLeaf, 0, this.instrMethodInvoked, this.nInstrMethods + emptyCell, nMethods);
                }
                if (this.instrScheme == 2) {
                    for (int i = this.nInstrMethods; i < this.nInstrMethods + nAddedMethods; ++i) {
                        this.instrMethodInvoked[i] = true;
                    }
                }
            }
            this.nInstrMethods += nAddedMethods;
        }
        finally {
            this.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInstrMethodsInfo(String className, int loaderId, String methodName, String methodSignature) {
        this.beginTrans(true);
        try {
            boolean firstTime = this.nInstrMethods == 0;
            int oldSize = firstTime ? 0 : this.instrMethodNames.length;
            int newLen = this.nInstrMethods + 1;
            int emptyCell = firstTime ? 1 : 0;
            int nAddedMethods = 1 + emptyCell;
            if (oldSize < newLen) {
                int newSize = newLen * 2;
                String[] newClasses = new String[newSize];
                int[] newLoaderIds = new int[newSize];
                String[] newMethods = new String[newSize];
                String[] newSignatures = new String[newSize];
                if (!firstTime) {
                    System.arraycopy(this.instrMethodClasses, 0, newClasses, 0, this.nInstrMethods);
                    System.arraycopy(this.classLoaderIds, 0, newLoaderIds, 0, this.nInstrMethods);
                    System.arraycopy(this.instrMethodNames, 0, newMethods, 0, this.nInstrMethods);
                    System.arraycopy(this.instrMethodSignatures, 0, newSignatures, 0, this.nInstrMethods);
                }
                this.instrMethodClasses = newClasses;
                this.classLoaderIds = newLoaderIds;
                this.instrMethodNames = newMethods;
                this.instrMethodSignatures = newSignatures;
            }
            if (firstTime) {
                this.instrMethodClasses[0] = "Thread";
                this.classLoaderIds[0] = 0;
                this.instrMethodNames[0] = "";
                this.instrMethodSignatures[0] = "";
            }
            int idx = this.nInstrMethods + emptyCell;
            this.instrMethodClasses[idx] = className;
            this.classLoaderIds[idx] = loaderId;
            this.instrMethodNames[idx] = methodName;
            this.instrMethodSignatures[idx] = methodSignature;
            this.nInstrMethods += nAddedMethods;
        }
        finally {
            this.endTrans();
        }
    }
}

