/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.correlate;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.cmd.CorrelateMediaCmd;
import tim.prune.cmd.MediaLinkType;
import tim.prune.cmd.PointAndMedia;
import tim.prune.correlate.Correlator;
import tim.prune.correlate.MediaPreviewTableModel;
import tim.prune.correlate.MediaPreviewTableRow;
import tim.prune.correlate.PointMediaPair;
import tim.prune.data.DataPoint;
import tim.prune.data.MediaList;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.TimeDifference;
import tim.prune.function.PointUtils;

public class PhotoCorrelator
extends Correlator {
    public PhotoCorrelator(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.correlatephotos";
    }

    @Override
    protected String getMediaTypeKey() {
        return "photo";
    }

    @Override
    protected MediaList<?> getMediaList() {
        return this._app.getTrackInfo().getPhotoList();
    }

    @Override
    protected void createPreview(TimeDifference timeDifference, boolean bl) {
        TimeDifference timeDifference2 = this.parseTimeLimit();
        double d = this.parseDistanceLimit();
        MediaPreviewTableModel mediaPreviewTableModel = new MediaPreviewTableModel("dialog.correlate.select.photoname", this.getTimezone());
        MediaList<Photo> mediaList = this._app.getTrackInfo().getPhotoList();
        int n = mediaList.getCount();
        int n2 = 0;
        while (n2 < n) {
            Photo photo = mediaList.get(n2);
            PointMediaPair pointMediaPair = this.getPointPairForMedia(this._app.getTrackInfo().getTrack(), photo, timeDifference);
            MediaPreviewTableRow mediaPreviewTableRow = new MediaPreviewTableRow(pointMediaPair);
            boolean bl2 = pointMediaPair.isValid();
            if (photo.getCurrentStatus() != MediaObject.Status.NOT_CONNECTED) {
                bl2 = false;
            }
            if (timeDifference2 != null && bl2) {
                long l = pointMediaPair.getMinSeconds();
                boolean bl3 = bl2 = l <= timeDifference2.getTotalSeconds();
            }
            if (d > 0.0 && bl2) {
                double d2;
                double d3 = DataPoint.calculateRadiansBetween(pointMediaPair.getPointBefore(), pointMediaPair.getPointAfter());
                double d4 = pointMediaPair.getFraction();
                if (d4 > 0.5) {
                    d4 = 1.0 - d4;
                }
                boolean bl4 = bl2 = (d2 = d3 * d4) < d;
            }
            if (pointMediaPair.getSecondsBefore() == 0L && pointMediaPair.getPointBefore().isDuplicate(photo.getDataPoint())) {
                bl2 = false;
            }
            mediaPreviewTableRow.setCorrelateFlag(bl2);
            mediaPreviewTableModel.addRow(mediaPreviewTableRow);
            ++n2;
        }
        this._previewTable.setModel(mediaPreviewTableModel);
        mediaPreviewTableModel.setDistanceUnits(this.getSelectedDistanceUnits());
        this._previewTable.setAutoResizeMode(4);
        int[] nArray = new int[]{150, 160, 100, 100, 50};
        int n3 = 0;
        while (n3 < mediaPreviewTableModel.getColumnCount()) {
            this._previewTable.getColumnModel().getColumn(n3).setPreferredWidth(nArray[n3]);
            ++n3;
        }
        this._okButton.setEnabled(mediaPreviewTableModel.hasAnySelected());
        if (bl && !mediaPreviewTableModel.hasAnySelected()) {
            JOptionPane.showMessageDialog(this._dialog, I18nManager.getText("dialog.correlate.alloutsiderange"), this.getName(), 0);
        }
    }

    @Override
    protected void finishCorrelation() {
        PointMediaPair[] pointMediaPairArray = this.getPointPairs();
        if (pointMediaPairArray == null || pointMediaPairArray.length <= 0) {
            return;
        }
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        ArrayList<PointAndMedia> arrayList2 = new ArrayList<PointAndMedia>();
        PhotoCorrelator.fillListsForCommand(pointMediaPairArray, arrayList, arrayList2);
        CorrelateMediaCmd correlateMediaCmd = new CorrelateMediaCmd(MediaLinkType.LINK_PHOTOS, arrayList, arrayList2);
        correlateMediaCmd.setDescription(this.makeUndoText(arrayList2.size()));
        correlateMediaCmd.setConfirmText(this.makeConfirmText(arrayList2.size()));
        this._app.execute(correlateMediaCmd);
    }

    static void fillListsForCommand(PointMediaPair[] pointMediaPairArray, List<DataPoint> list, List<PointAndMedia> list2) {
        PointMediaPair[] pointMediaPairArray2 = pointMediaPairArray;
        int n = pointMediaPairArray.length;
        int n2 = 0;
        while (n2 < n) {
            PointMediaPair pointMediaPair = pointMediaPairArray2[n2];
            if (pointMediaPair != null && pointMediaPair.isValid()) {
                DataPoint dataPoint;
                Photo photo = (Photo)pointMediaPair.getMedia();
                if (pointMediaPair.getMinSeconds() == 0L) {
                    dataPoint = pointMediaPair.getPointBefore();
                    Photo photo2 = dataPoint.getPhoto();
                    if (photo2 == null && !PhotoCorrelator.pointAlreadyBeingConnected(dataPoint, list2)) {
                        list2.add(new PointAndMedia(dataPoint, photo, null));
                    } else if (photo2 == null || !photo2.equals(pointMediaPair.getMedia())) {
                        DataPoint dataPoint2 = pointMediaPair.getPointBefore().clonePoint();
                        list.add(dataPoint2);
                        list2.add(new PointAndMedia(dataPoint2, photo, null));
                    }
                } else {
                    dataPoint = PointUtils.interpolate(pointMediaPair.getPointBefore(), pointMediaPair.getPointAfter(), pointMediaPair.getFraction());
                    dataPoint.setSegmentStart(true);
                    list.add(dataPoint);
                    list2.add(new PointAndMedia(dataPoint, photo, null));
                }
            }
            ++n2;
        }
    }
}

