/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.logger;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.logger.LoggingControllerDelegate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;

class Log4jCoreController
implements LoggingControllerDelegate {
    private final LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);

    @Override
    public Map<String, String> loggers() {
        String rootLoggerLevel = this.logContext.getRootLogger().getLevel().toString();
        HashMap<String, String> result = new HashMap<String, String>();
        for (LoggerConfig logger : this.logContext.getConfiguration().getLoggers().values()) {
            if (logger.getName().equals("")) continue;
            result.put(logger.getName(), logger.getLevel().toString());
        }
        for (LoggerConfig logger : this.logContext.getLoggers()) {
            if (logger.getName().equals("")) continue;
            result.put(logger.getName(), logger.getLevel().toString());
        }
        result.put("root", rootLoggerLevel);
        return result;
    }

    @Override
    public boolean logLevel(String loggerName, String logLevel) {
        if (Utils.isBlank((String)loggerName) || Utils.isBlank((String)logLevel)) {
            return false;
        }
        Level level = Level.toLevel((String)logLevel.toUpperCase(Locale.ROOT));
        if (loggerName.equals("root")) {
            Configurator.setLevel((String)"", (Level)level);
            return true;
        }
        if (this.loggerExists(loggerName) && level != null) {
            Configurator.setLevel((String)loggerName, (Level)level);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetLogLevel(String loggerName) {
        Level nullLevel = null;
        if (loggerName.equals("root")) {
            Configurator.setLevel((String)"", nullLevel);
            return true;
        }
        if (this.loggerExists(loggerName)) {
            Configurator.setLevel((String)loggerName, nullLevel);
            return true;
        }
        return false;
    }
}

