/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractKomihash;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hasher64;
import com.dynatrace.hash4j.internal.ByteArrayUtil;
import com.dynatrace.hash4j.internal.UnsignedMultiplyUtil;

class Komihash4_3
extends AbstractKomihash {
    private static final Hasher64 DEFAULT_HASHER_INSTANCE = Komihash4_3.create(0L);

    static Hasher64 create() {
        return DEFAULT_HASHER_INSTANCE;
    }

    static Hasher64 create(long useSeed) {
        return new Komihash4_3(useSeed);
    }

    private Komihash4_3(long seed) {
        super(seed);
    }

    @Override
    public HashStream64 hashStream() {
        return new HashStreamImpl();
    }

    @Override
    public long hashBytesToLong(byte[] input, int off, int len) {
        long tmp4;
        long tmp3;
        long tmp2;
        long tmp1;
        boolean nonZeroLength;
        long see1 = this.seed1;
        long see2 = this.seed2;
        long see3 = this.seed3;
        long see4 = this.seed4;
        long see5 = this.seed5;
        long see6 = this.seed6;
        long see7 = this.seed7;
        long see8 = this.seed8;
        boolean bl = nonZeroLength = len > 0;
        if (len > 63) {
            do {
                tmp1 = see1 ^ ByteArrayUtil.getLong(input, off);
                tmp2 = see5 ^ ByteArrayUtil.getLong(input, off + 8);
                tmp3 = see2 ^ ByteArrayUtil.getLong(input, off + 16);
                tmp4 = see6 ^ ByteArrayUtil.getLong(input, off + 24);
                long tmp5 = see3 ^ ByteArrayUtil.getLong(input, off + 32);
                long tmp6 = see7 ^ ByteArrayUtil.getLong(input, off + 40);
                long tmp7 = see4 ^ ByteArrayUtil.getLong(input, off + 48);
                long tmp8 = see8 ^ ByteArrayUtil.getLong(input, off + 56);
                see1 = tmp1 * tmp2;
                see2 = tmp3 * tmp4;
                see3 = tmp5 * tmp6;
                see4 = tmp7 * tmp8;
                see2 ^= (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2));
                see3 ^= (see6 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp3, tmp4));
                see4 ^= (see7 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp5, tmp6));
                see1 ^= (see8 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp7, tmp8));
                off += 64;
            } while ((len -= 64) > 63);
            see5 ^= see6 ^ see7 ^ see8;
            see1 ^= see2 ^ see3 ^ see4;
        }
        if (len > 31) {
            tmp1 = see1 ^ ByteArrayUtil.getLong(input, off);
            tmp2 = see5 ^ ByteArrayUtil.getLong(input, off + 8);
            see1 = tmp1 * tmp2;
            tmp3 = (see1 ^= (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2))) ^ ByteArrayUtil.getLong(input, off + 16);
            tmp4 = see5 ^ ByteArrayUtil.getLong(input, off + 24);
            see1 = tmp3 * tmp4;
            see1 ^= (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp3, tmp4));
            off += 32;
            len -= 32;
        }
        if (len > 15) {
            tmp1 = see1 ^ ByteArrayUtil.getLong(input, off);
            tmp2 = see5 ^ ByteArrayUtil.getLong(input, off + 8);
            see1 = tmp1 * tmp2;
            see1 ^= (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2));
            off += 16;
            len -= 16;
        }
        long r2h = see5;
        long r2l = see1;
        int ml8 = len << 3;
        if (len > 7) {
            r2l ^= ByteArrayUtil.getLong(input, off);
            long y = ByteArrayUtil.getLong(input, off + len - 8);
            long fb = y >>> 1 >>> ~ml8;
            r2h ^= (fb |= 1L << ml8 << (int)(y >>> 63));
        } else if (len > 3) {
            long fb = (long)ByteArrayUtil.getInt(input, off) & 0xFFFFFFFFL;
            long y = ByteArrayUtil.getInt(input, off + len - 4);
            fb |= y << 32 >>> -ml8;
            r2l ^= (fb |= 1L << ml8 << (int)(y >>> 63));
        } else if (len > 0) {
            long fb = (long)input[off] & 0xFFL;
            if (len > 1) {
                fb |= ((long)input[off + 1] & 0xFFL) << 8;
            }
            if (len > 2) {
                fb |= ((long)input[off + 2] & 0xFFL) << 16;
            }
            fb |= 1L << ml8 << (int)(fb >>> ml8 - 1);
            r2l ^= fb;
        } else if (nonZeroLength) {
            r2l ^= input[off - 1] < 0 ? 2L : 1L;
        }
        return Komihash4_3.finish(r2h, r2l, see5);
    }

    @Override
    public long hashCharsToLong(CharSequence input) {
        long r1h;
        long r1l;
        long tmp2;
        long tmp1;
        boolean nonZeroLength;
        int off = 0;
        int len = input.length();
        long see1 = this.seed1;
        long see2 = this.seed2;
        long see3 = this.seed3;
        long see4 = this.seed4;
        long see5 = this.seed5;
        long see6 = this.seed6;
        long see7 = this.seed7;
        long see8 = this.seed8;
        boolean bl = nonZeroLength = len > 0;
        if (len > 31) {
            do {
                tmp1 = see1 ^ ByteArrayUtil.getLong(input, off);
                tmp2 = see5 ^ ByteArrayUtil.getLong(input, off + 4);
                long tmp3 = see2 ^ ByteArrayUtil.getLong(input, off + 8);
                long tmp4 = see6 ^ ByteArrayUtil.getLong(input, off + 12);
                long tmp5 = see3 ^ ByteArrayUtil.getLong(input, off + 16);
                long tmp6 = see7 ^ ByteArrayUtil.getLong(input, off + 20);
                long tmp7 = see4 ^ ByteArrayUtil.getLong(input, off + 24);
                long tmp8 = see8 ^ ByteArrayUtil.getLong(input, off + 28);
                long r1l2 = tmp1 * tmp2;
                long r1h2 = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2);
                long r2l = tmp3 * tmp4;
                long r2h = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp3, tmp4);
                long r3l = tmp5 * tmp6;
                long r3h = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp5, tmp6);
                long r4l = tmp7 * tmp8;
                long r4h = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp7, tmp8);
                off += 32;
                see2 = (see5 += r1h2) ^ r2l;
                see3 = (see6 += r2h) ^ r3l;
                see4 = (see7 += r3h) ^ r4l;
                see1 = (see8 += r4h) ^ r1l2;
            } while ((len -= 32) > 31);
            see5 ^= see6 ^ see7 ^ see8;
            see1 ^= see2 ^ see3 ^ see4;
        }
        if (len > 15) {
            tmp1 = see1 ^ ByteArrayUtil.getLong(input, off);
            tmp2 = see5 ^ ByteArrayUtil.getLong(input, off + 4);
            r1l = tmp1 * tmp2;
            r1h = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2);
            see1 = (see5 += r1h) ^ r1l;
            long tmp3 = see1 ^ ByteArrayUtil.getLong(input, off + 8);
            long tmp4 = see5 ^ ByteArrayUtil.getLong(input, off + 12);
            r1l = tmp3 * tmp4;
            r1h = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp3, tmp4);
            see1 = (see5 += r1h) ^ r1l;
            off += 16;
            len -= 16;
        }
        if (len > 7) {
            tmp1 = see1 ^ ByteArrayUtil.getLong(input, off);
            tmp2 = see5 ^ ByteArrayUtil.getLong(input, off + 4);
            r1l = tmp1 * tmp2;
            r1h = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2);
            see1 = (see5 += r1h) ^ r1l;
            off += 8;
            len -= 8;
        }
        long r2h = see5;
        long r2l = see1;
        int ml8 = len << 4;
        if (len > 3) {
            r2l ^= ByteArrayUtil.getLong(input, off);
            long y = ByteArrayUtil.getLong(input, off + len - 4);
            long fb = y >>> 1 >>> ~ml8;
            r2h ^= (fb |= 1L << ml8 << (int)(y >>> 63));
        } else if (len > 1) {
            long fb = (long)ByteArrayUtil.getInt(input, off) & 0xFFFFFFFFL;
            long y = ByteArrayUtil.getInt(input, off + len - 2);
            fb |= y << 32 >>> -ml8;
            r2l ^= (fb |= 1L << ml8 << (int)(y >>> 63));
        } else if (len > 0) {
            long fb = input.charAt(off);
            fb |= 65536L << (int)(fb >>> 15);
            r2l ^= fb;
        } else if (nonZeroLength) {
            r2l ^= 1L << (input.charAt(off - 1) >>> 15);
        }
        return Komihash4_3.finish(r2h, r2l, see5);
    }

    @Override
    public long hashLongLongToLong(long v1, long v2) {
        long tmp1 = this.seed1 ^ v1;
        long tmp2 = this.seed5 ^ v2;
        long see5 = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2) + this.seed5;
        return Komihash4_3.finish(see5, tmp1 * tmp2 ^ (see5 ^ 1L << (int)(v2 >>> 63)), see5);
    }

    @Override
    public long hashLongLongLongToLong(long v1, long v2, long v3) {
        long tmp1 = this.seed1 ^ v1;
        long tmp2 = this.seed5 ^ v2;
        long see5 = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2) + this.seed5;
        return Komihash4_3.finish(see5 ^ 1L << (int)(v3 >>> 63), tmp1 * tmp2 ^ (see5 ^ v3), see5);
    }

    private long finish12Bytes(long a, long b) {
        long r2l = this.seed1 ^ a;
        long r2h = this.seed5 ^ b;
        return Komihash4_3.finish(r2h, r2l, this.seed5);
    }

    @Override
    public long hashLongIntToLong(long v1, int v2) {
        return this.finish12Bytes(v1, (long)v2 & 0xFFFFFFFFL ^ 0x100000000L << (v2 >>> 31));
    }

    @Override
    public long hashIntIntIntToLong(int v1, int v2, int v3) {
        return this.finish12Bytes((long)v1 & 0xFFFFFFFFL ^ (long)v2 << 32, (long)v3 & 0xFFFFFFFFL ^ 0x100000000L << (v3 >>> 31));
    }

    @Override
    public long hashIntLongToLong(int v1, long v2) {
        return this.finish12Bytes((long)v1 & 0xFFFFFFFFL ^ v2 << 32, v2 >>> 32 ^ 0x100000000L << (int)(v2 >>> 63));
    }

    private class HashStreamImpl
    extends AbstractKomihash.HashStreamImpl {
        private HashStreamImpl() {
        }

        @Override
        protected void processBuffer(long b0, long b1, long b2, long b3, long b4, long b5, long b6, long b7) {
            b0 ^= this.see1;
            b1 ^= this.see5;
            b2 ^= this.see2;
            b3 ^= this.see6;
            b4 ^= this.see3;
            b5 ^= this.see7;
            b6 ^= this.see4;
            b7 ^= this.see8;
            long r1l = b0 * b1;
            long r1h = UnsignedMultiplyUtil.unsignedMultiplyHigh(b0, b1);
            long r2l = b2 * b3;
            long r2h = UnsignedMultiplyUtil.unsignedMultiplyHigh(b2, b3);
            long r3l = b4 * b5;
            long r3h = UnsignedMultiplyUtil.unsignedMultiplyHigh(b4, b5);
            long r4l = b6 * b7;
            long r4h = UnsignedMultiplyUtil.unsignedMultiplyHigh(b6, b7);
            this.see5 += r1h;
            this.see6 += r2h;
            this.see7 += r3h;
            this.see8 += r4h;
            this.see2 = this.see5 ^ r2l;
            this.see3 = this.see6 ^ r3l;
            this.see4 = this.see7 ^ r4l;
            this.see1 = this.see8 ^ r1l;
        }

        @Override
        protected long finalizeGetAsLong(long se1, long se5, int off, int len) {
            long r2h = se5;
            long r2l = se1;
            long y = 1L << (len << 3);
            long fb = y << (this.buffer[off + len - 1 & 0x3F] < 0 ? 1 : 0);
            if (len > 7) {
                r2h ^= (fb |= ByteArrayUtil.getLong(this.buffer, off + 8) & y - 1L);
                r2l ^= ByteArrayUtil.getLong(this.buffer, off);
            } else if (this.byteCount > 0L) {
                r2l ^= (fb |= ByteArrayUtil.getLong(this.buffer, off) & y - 1L);
            }
            return AbstractKomihash.finish(r2h, r2l, se5);
        }

        @Override
        public HashStream64 copy() {
            HashStreamImpl hashStream = new HashStreamImpl();
            this.copyTo(hashStream);
            return hashStream;
        }
    }
}

