/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.ConversionException;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class SqlAstProcessingStateImpl
implements SqlAstProcessingState,
SqlExpressionResolver,
BaseSqmToSqlAstConverter.SqmAliasedNodeCollector {
    private final SqlAstProcessingState parentState;
    private final SqlAstCreationState creationState;
    private final SqlExpressionResolver expressionResolver;
    private final Supplier<Clause> currentClauseAccess;
    private final Map<SqlExpressionResolver.ColumnReferenceKey, Expression> expressionMap = new HashMap<SqlExpressionResolver.ColumnReferenceKey, Expression>();

    public SqlAstProcessingStateImpl(SqlAstProcessingState parentState, SqlAstCreationState creationState, Supplier<Clause> currentClauseAccess) {
        this.parentState = parentState;
        this.creationState = creationState;
        this.expressionResolver = this;
        this.currentClauseAccess = currentClauseAccess;
    }

    public SqlAstProcessingStateImpl(SqlAstProcessingState parentState, SqlAstCreationState creationState, Function<SqlExpressionResolver, SqlExpressionResolver> expressionResolverDecorator, Supplier<Clause> currentClauseAccess) {
        this.parentState = parentState;
        this.creationState = creationState;
        this.expressionResolver = expressionResolverDecorator.apply(this);
        this.currentClauseAccess = currentClauseAccess;
    }

    @Override
    public SqlAstProcessingState getParentState() {
        return this.parentState;
    }

    @Override
    public SqlExpressionResolver getSqlExpressionResolver() {
        return this.expressionResolver;
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this.creationState;
    }

    @Override
    public Expression resolveSqlExpression(SqlExpressionResolver.ColumnReferenceKey key, Function<SqlAstProcessingState, Expression> creator) {
        Expression expression;
        Expression existing = this.expressionMap.get(key);
        if (existing != null) {
            expression = existing;
        } else {
            expression = creator.apply(this);
            this.expressionMap.put(key, expression);
        }
        return expression;
    }

    @Override
    public SqlSelection resolveSqlSelection(Expression expression, JavaType<?> javaType, FetchParent fetchParent, TypeConfiguration typeConfiguration) {
        throw new ConversionException("Unexpected call to resolve SqlSelection outside of QuerySpec processing");
    }

    @Override
    public void next() {
        boolean i = true;
    }

    @Override
    public List<SqlSelection> getSelections(int position) {
        throw new UnsupportedOperationException();
    }
}

