/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.BiLinkedHashMultiMap;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.NodePromotionStrategy;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;

public class NodePromotion
implements ILayoutProcessor<LGraph> {
    private static final Comparator<LNode> MODEL_ORDER_NODE_COMPARATOR_DESC = new Comparator<LNode>(){

        @Override
        public int compare(LNode o1, LNode o2) {
            if (o1.hasProperty(InternalProperties.MODEL_ORDER) && o2.hasProperty(InternalProperties.MODEL_ORDER)) {
                return o2.getProperty(InternalProperties.MODEL_ORDER) - o1.getProperty(InternalProperties.MODEL_ORDER);
            }
            return 0;
        }
    };
    private static final Comparator<LNode> MODEL_ORDER_NODE_COMPARATOR_ASC = new Comparator<LNode>(){

        @Override
        public int compare(LNode o1, LNode o2) {
            if (o1.hasProperty(InternalProperties.MODEL_ORDER) && o2.hasProperty(InternalProperties.MODEL_ORDER)) {
                return o1.getProperty(InternalProperties.MODEL_ORDER) - o2.getProperty(InternalProperties.MODEL_ORDER);
            }
            return 0;
        }
    };
    private LGraph masterGraph;
    private List<LNode> nodesWithIncomingEdges;
    private List<LNode> nodes;
    private List<Integer> currentWidth;
    private List<Double> currentWidthPixel;
    private int[] layers;
    private int[][] degreeDiff;
    private int maxWidth;
    private double maxWidthPixel;
    private int dummyNodeCount;
    private int maxHeight;
    private double nodeSizeAffix;
    private double dummySize;
    private NodePromotionStrategy promotionStrategy;
    private BiLinkedHashMultiMap<Integer, LNode> biLayerMap = new BiLinkedHashMultiMap();

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Node promotion heuristic", 1.0f);
        this.masterGraph = layeredGraph;
        this.promotionStrategy = layeredGraph.getProperty(LayeredOptions.LAYERING_NODE_PROMOTION_STRATEGY);
        if (this.promotionStrategy != NodePromotionStrategy.MODEL_ORDER_LEFT_TO_RIGHT && this.promotionStrategy != NodePromotionStrategy.MODEL_ORDER_RIGHT_TO_LEFT) {
            this.precalculateAndSetInformation();
        } else {
            this.precalculateAndSetInformationModelOrder();
        }
        int promoteUntil = this.masterGraph.getProperty(LayeredOptions.LAYERING_NODE_PROMOTION_MAX_ITERATIONS);
        Function funFunction = pair -> true;
        switch (this.promotionStrategy) {
            case NIKOLOV: {
                this.promotionMagic(funFunction);
                break;
            }
            case NIKOLOV_PIXEL: {
                this.promotionMagic(funFunction);
                break;
            }
            case NIKOLOV_IMPROVED: {
                this.promotionStrategy = NodePromotionStrategy.NO_BOUNDARY;
                this.promotionMagic(funFunction);
                int newMaxWidth = 0;
                for (Integer martha : this.currentWidth) {
                    newMaxWidth = Math.max(newMaxWidth, martha);
                }
                if (newMaxWidth <= this.maxWidth) break;
                this.promotionStrategy = NodePromotionStrategy.NIKOLOV;
                this.promotionMagic(funFunction);
                break;
            }
            case NIKOLOV_IMPROVED_PIXEL: {
                this.promotionStrategy = NodePromotionStrategy.NO_BOUNDARY;
                this.promotionMagic(funFunction);
                double newMaxWidthPixel = 0.0;
                for (Double donna : this.currentWidthPixel) {
                    newMaxWidthPixel = Math.max(newMaxWidthPixel, donna);
                }
                if (!(newMaxWidthPixel > this.maxWidthPixel)) break;
                this.promotionStrategy = NodePromotionStrategy.NIKOLOV_PIXEL;
                this.promotionMagic(funFunction);
                break;
            }
            case NODECOUNT_PERCENTAGE: {
                int promoteUntilN = (int)Math.ceil((double)(this.layers.length * promoteUntil) / 100.0);
                this.promotionMagic(pair -> (Integer)pair.getSecond() < promoteUntilN);
                break;
            }
            case DUMMYNODE_PERCENTAGE: {
                int promoteUntilD = (int)Math.ceil((double)(this.dummyNodeCount * promoteUntil) / 100.0);
                this.promotionMagic(pair -> (Integer)pair.getFirst() < promoteUntilD);
                break;
            }
            case MODEL_ORDER_LEFT_TO_RIGHT: {
                this.modelOrderNodePromotion(true);
                break;
            }
            case MODEL_ORDER_RIGHT_TO_LEFT: {
                this.modelOrderNodePromotion(false);
                break;
            }
            default: {
                this.promotionMagic(funFunction);
            }
        }
        if (this.promotionStrategy != NodePromotionStrategy.MODEL_ORDER_LEFT_TO_RIGHT && this.promotionStrategy != NodePromotionStrategy.MODEL_ORDER_RIGHT_TO_LEFT) {
            this.setNewLayering(layeredGraph);
        } else {
            this.setNewLayeringModelOrder(layeredGraph);
        }
        progressMonitor.done();
    }

    private void precalculateAndSetInformation() {
        this.nodeSizeAffix = this.masterGraph.getProperty(LayeredOptions.SPACING_NODE_NODE);
        this.dummySize = this.masterGraph.getProperty(LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
        this.maxHeight = this.masterGraph.getLayers().size();
        int layerID = this.maxHeight - 1;
        int nodeID = 0;
        this.maxWidth = 0;
        this.maxWidthPixel = 0.0;
        this.currentWidth = Lists.newArrayList(new Integer[this.maxHeight]);
        this.currentWidthPixel = Lists.newArrayList(new Double[this.maxHeight]);
        for (Layer layer : this.masterGraph.getLayers()) {
            layer.id = layerID;
            for (LNode node : layer.getNodes()) {
                node.id = nodeID++;
            }
            --layerID;
        }
        this.layers = new int[nodeID];
        this.degreeDiff = new int[nodeID][3];
        this.nodes = Lists.newArrayList();
        this.nodesWithIncomingEdges = Lists.newArrayList();
        int dummyBaggage = 0;
        this.dummyNodeCount = 0;
        for (Layer layer : this.masterGraph) {
            layerID = layer.id;
            int incoming = 0;
            int outcoming = 0;
            int layerSize = layer.getNodes().size();
            double layerSizePixel = 0.0;
            for (LNode node : layer.getNodes()) {
                nodeID = node.id;
                this.layers[nodeID] = node.getLayer().id;
                layerSizePixel += node.getSize().y + this.nodeSizeAffix;
                int inDegree = Iterables.size(node.getIncomingEdges());
                int outDegree = Iterables.size(node.getOutgoingEdges());
                this.degreeDiff[nodeID][0] = outDegree - inDegree;
                this.degreeDiff[nodeID][1] = inDegree;
                this.degreeDiff[nodeID][2] = outDegree;
                incoming += inDegree;
                outcoming += outDegree;
                if (inDegree > 0) {
                    this.nodesWithIncomingEdges.add(node);
                }
                this.nodes.add(node);
            }
            int nodesNdummies = layerSize + (dummyBaggage -= incoming);
            this.currentWidth.set(layerID, nodesNdummies);
            this.currentWidthPixel.set(layerID, layerSizePixel += (double)dummyBaggage * this.dummySize);
            this.maxWidth = Math.max(this.maxWidth, nodesNdummies);
            this.maxWidthPixel = Math.max(this.maxWidthPixel, layerSizePixel);
            this.dummyNodeCount += dummyBaggage;
            dummyBaggage += outcoming;
        }
    }

    public void precalculateAndSetInformationModelOrder() {
        this.biLayerMap = new BiLinkedHashMultiMap();
        int nodeId = 0;
        int layerId = 0;
        for (Layer layer : this.masterGraph.getLayers()) {
            layer.id = layerId;
            for (LNode node : layer.getNodes()) {
                node.id = nodeId++;
            }
            ++layerId;
        }
        boolean leftToRight = this.promotionStrategy == NodePromotionStrategy.MODEL_ORDER_LEFT_TO_RIGHT;
        Comparator<LNode> modelOrderComparator = leftToRight ? MODEL_ORDER_NODE_COMPARATOR_DESC : MODEL_ORDER_NODE_COMPARATOR_ASC;
        for (Layer layer : this.masterGraph) {
            layer.getNodes().sort(modelOrderComparator);
            this.biLayerMap.putAll(layer.id, layer.getNodes());
        }
    }

    private void modelOrderNodePromotion(boolean leftToRight) {
        boolean somethingChanged = false;
        do {
            somethingChanged = false;
            int currentLayerId = leftToRight ? this.biLayerMap.keySet().size() - 2 : 1;
            while (!(leftToRight ? currentLayerId < 0 : currentLayerId >= this.biLayerMap.keySet().size())) {
                LinkedList<LNode> currentLayer = this.biLayerMap.getValues(currentLayerId);
                int nodeIndex = 0;
                while (nodeIndex < currentLayer.size()) {
                    LNode node = currentLayer.get(nodeIndex);
                    if (!(!node.hasProperty(InternalProperties.MODEL_ORDER) || this.biLayerMap.isMaximalKey(currentLayerId) && this.promotionStrategy == NodePromotionStrategy.MODEL_ORDER_LEFT_TO_RIGHT || this.biLayerMap.isMinimalKey(currentLayerId) && this.promotionStrategy == NodePromotionStrategy.MODEL_ORDER_RIGHT_TO_LEFT)) {
                        boolean shallBePromoted = true;
                        int otherNodeIndex = 0;
                        while (otherNodeIndex < currentLayer.size()) {
                            LNode otherNode = currentLayer.get(otherNodeIndex);
                            if (otherNode.hasProperty(InternalProperties.MODEL_ORDER) && (leftToRight && node.getProperty(InternalProperties.MODEL_ORDER) < otherNode.getProperty(InternalProperties.MODEL_ORDER) || !leftToRight && node.getProperty(InternalProperties.MODEL_ORDER) > otherNode.getProperty(InternalProperties.MODEL_ORDER))) {
                                shallBePromoted = false;
                            }
                            ++otherNodeIndex;
                        }
                        if (shallBePromoted) {
                            int nextLayerId = leftToRight ? currentLayerId + 1 : currentLayerId - 1;
                            LinkedList<LNode> nextLayer = this.biLayerMap.getValues(nextLayerId);
                            boolean modelOrderAllowsPromotion = false;
                            boolean promoteThroughDummyLayer = true;
                            boolean containsLabels = false;
                            for (LNode nextLayerNode : nextLayer) {
                                if (nextLayerNode.hasProperty(InternalProperties.MODEL_ORDER)) {
                                    if (nextLayerNode.id == node.id) continue;
                                    modelOrderAllowsPromotion |= leftToRight ? nextLayerNode.getProperty(InternalProperties.MODEL_ORDER) < node.getProperty(InternalProperties.MODEL_ORDER) : nextLayerNode.getProperty(InternalProperties.MODEL_ORDER) > node.getProperty(InternalProperties.MODEL_ORDER);
                                    promoteThroughDummyLayer = false;
                                    continue;
                                }
                                if (modelOrderAllowsPromotion || !promoteThroughDummyLayer || nextLayerNode.getType() != LNode.NodeType.LABEL) continue;
                                containsLabels = true;
                                LNode nodeConnectedToNextLayer = leftToRight ? nextLayerNode.getIncomingEdges().iterator().next().getSource().getNode() : nextLayerNode.getOutgoingEdges().iterator().next().getTarget().getNode();
                                if (!nodeConnectedToNextLayer.equals(node)) continue;
                                LNode connectedNode = leftToRight ? nextLayerNode.getOutgoingEdges().iterator().next().getTarget().getNode() : nextLayerNode.getIncomingEdges().iterator().next().getSource().getNode();
                                if ((leftToRight ? this.biLayerMap.getKey(connectedNode) - this.biLayerMap.getKey(nodeConnectedToNextLayer) : this.biLayerMap.getKey(nodeConnectedToNextLayer) - this.biLayerMap.getKey(connectedNode)) > 2) continue;
                                promoteThroughDummyLayer = false;
                            }
                            if (containsLabels && promoteThroughDummyLayer) {
                                LNode connectedNode = leftToRight ? node.getOutgoingEdges().iterator().next().getTarget().getNode() : node.getIncomingEdges().iterator().next().getSource().getNode();
                                if ((leftToRight ? this.biLayerMap.getKey(connectedNode) - this.biLayerMap.getKey(node) : this.biLayerMap.getKey(node) - this.biLayerMap.getKey(connectedNode)) <= 2 && connectedNode.getType() == LNode.NodeType.NORMAL) {
                                    promoteThroughDummyLayer = false;
                                }
                            }
                            if (modelOrderAllowsPromotion || promoteThroughDummyLayer) {
                                LinkedHashSet<LNode> nodesToPromote = this.promoteNodeByModelOrder(node, leftToRight);
                                while (!nodesToPromote.isEmpty()) {
                                    LNode nodeToPromote = (LNode)nodesToPromote.iterator().next();
                                    nodesToPromote.remove(nodeToPromote);
                                    nodesToPromote.addAll(this.promoteNodeByModelOrder(nodeToPromote, leftToRight));
                                }
                                --nodeIndex;
                                somethingChanged = true;
                            }
                        }
                    }
                    ++nodeIndex;
                }
                currentLayerId += leftToRight ? -1 : 1;
            }
        } while (somethingChanged);
    }

    private LinkedHashSet<LNode> promoteNodeByModelOrder(LNode node, boolean leftToRight) {
        int oldLayerId = this.biLayerMap.getKey(node);
        if (leftToRight) {
            this.biLayerMap.put(oldLayerId + 1, node);
        } else {
            this.biLayerMap.put(oldLayerId - 1, node);
        }
        LinkedHashSet<LNode> nodesToPromote = new LinkedHashSet<LNode>();
        for (LEdge edge : leftToRight ? node.getOutgoingEdges() : node.getIncomingEdges()) {
            LNode nextNode = leftToRight ? edge.getTarget().getNode() : edge.getSource().getNode();
            if (this.biLayerMap.getKey(nextNode) != this.biLayerMap.getKey(node)) continue;
            nodesToPromote.add(nextNode);
        }
        return nodesToPromote;
    }

    private void promotionMagic(Function<Pair<Integer, Integer>, Boolean> funky) {
        int promotions;
        boolean promotionFlag;
        int iterationCounter = 0;
        int reducedDummies = 0;
        int[] layeringBackup = Arrays.copyOf(this.layers, this.layers.length);
        int dummyBackup = this.dummyNodeCount;
        int heightBackup = this.maxHeight;
        List<Integer> currentWidthBackup = this.currentWidth;
        List<Double> currentWidthPixelBackup = this.currentWidthPixel;
        do {
            promotions = 0;
            for (LNode node : this.nodesWithIncomingEdges) {
                Pair<Integer, Boolean> promotionPair = this.promoteNode(node);
                boolean apply = true;
                if (this.promotionStrategy == NodePromotionStrategy.NIKOLOV || this.promotionStrategy == NodePromotionStrategy.NIKOLOV_PIXEL) {
                    apply = promotionPair.getSecond();
                }
                if (promotionPair.getFirst() < 0 && apply) {
                    ++promotions;
                    layeringBackup = Arrays.copyOf(this.layers, this.layers.length);
                    this.dummyNodeCount += promotionPair.getFirst().intValue();
                    reducedDummies += dummyBackup - this.dummyNodeCount;
                    dummyBackup = this.dummyNodeCount + promotionPair.getFirst();
                    heightBackup = this.maxHeight;
                    currentWidthBackup = Lists.newArrayList(this.currentWidth);
                    currentWidthPixelBackup = Lists.newArrayList(this.currentWidthPixel);
                    continue;
                }
                this.layers = Arrays.copyOf(layeringBackup, layeringBackup.length);
                this.dummyNodeCount = dummyBackup;
                this.currentWidth = Lists.newArrayList(currentWidthBackup);
                this.currentWidthPixel = Lists.newArrayList(currentWidthPixelBackup);
                this.maxHeight = heightBackup;
            }
        } while (promotionFlag = promotions != 0 && funky.apply(Pair.of(reducedDummies, ++iterationCounter)) != false);
    }

    private Pair<Integer, Boolean> promoteNode(LNode node) {
        boolean maxWidthNotExceeded = true;
        int dummydiff = 0;
        int nodeLayerPos = this.layers[node.id];
        double nodeSize = node.getSize().y + this.nodeSizeAffix;
        int dummiesBuilt = this.degreeDiff[node.id][2];
        this.currentWidth.set(nodeLayerPos, this.currentWidth.get(nodeLayerPos) - 1 + dummiesBuilt);
        this.currentWidthPixel.set(nodeLayerPos, this.currentWidthPixel.get(nodeLayerPos) - nodeSize + (double)dummiesBuilt * this.dummySize);
        if (++nodeLayerPos >= this.maxHeight) {
            ++this.maxHeight;
            this.currentWidth.add(1);
            this.currentWidthPixel.add(nodeSize);
        } else {
            int dummiesReduced = this.degreeDiff[node.id][1];
            this.currentWidth.set(nodeLayerPos, this.currentWidth.get(nodeLayerPos) + 1 - dummiesReduced);
            this.currentWidthPixel.set(nodeLayerPos, this.currentWidthPixel.get(nodeLayerPos) + nodeSize - (double)dummiesReduced * this.dummySize);
        }
        if (this.promotionStrategy == NodePromotionStrategy.NIKOLOV && (this.currentWidth.get(nodeLayerPos) > this.maxWidth || this.currentWidth.get(nodeLayerPos - 1) > this.maxWidth) || this.promotionStrategy == NodePromotionStrategy.NIKOLOV_PIXEL && (this.currentWidthPixel.get(nodeLayerPos) > this.maxWidthPixel || this.currentWidthPixel.get(nodeLayerPos - 1) > this.maxWidthPixel)) {
            maxWidthNotExceeded = false;
        }
        for (LEdge edge : node.getIncomingEdges()) {
            LNode masterNode = edge.getSource().getNode();
            if (this.layers[masterNode.id] != nodeLayerPos) continue;
            Pair<Integer, Boolean> promotion = this.promoteNode(masterNode);
            dummydiff += promotion.getFirst().intValue();
            boolean bl = maxWidthNotExceeded = maxWidthNotExceeded && promotion.getSecond() != false;
        }
        this.layers[node.id] = nodeLayerPos;
        return new Pair<Integer, Boolean>(dummydiff += this.degreeDiff[node.id][0], maxWidthNotExceeded);
    }

    private void setNewLayering(LGraph layeredGraph) {
        ArrayList<Object> layList = Lists.newArrayList();
        int i = 0;
        while (i <= this.maxHeight) {
            Layer laLaLayer = new Layer(layeredGraph);
            laLaLayer.id = this.maxHeight - i;
            layList.add(laLaLayer);
            ++i;
        }
        for (LNode node : this.nodes) {
            node.setLayer((Layer)layList.get(this.maxHeight - this.layers[node.id]));
        }
        Iterator layerIt = layList.iterator();
        while (layerIt.hasNext()) {
            Layer possiblyEvilLayer = (Layer)layerIt.next();
            if (!possiblyEvilLayer.getNodes().isEmpty()) continue;
            layerIt.remove();
        }
        layeredGraph.getLayers().clear();
        layeredGraph.getLayers().addAll(layList);
    }

    private void setNewLayeringModelOrder(LGraph layeredGraph) {
        ArrayList<Layer> layerList = Lists.newArrayList();
        layeredGraph.getLayers().clear();
        List keySet = this.biLayerMap.keySet().stream().sorted().collect(Collectors.toList());
        for (Integer layerIndex : keySet) {
            LinkedList<LNode> layerNodes = this.biLayerMap.getValues(layerIndex);
            if (layerNodes.isEmpty()) continue;
            Layer newLayer = new Layer(layeredGraph);
            layerList.add(newLayer);
            newLayer.id = layerIndex;
            for (LNode node : layerNodes) {
                node.setLayer(newLayer);
            }
        }
        layeredGraph.getLayers().addAll(layerList);
    }
}

