/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.OWLWorkspace;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.util.OWLEntityDeleter;
import org.protege.editor.owl.ui.list.OWLObjectList;
import org.protege.editor.owl.ui.view.ChangeListenerMediator;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.util.OWLEntityCollector;

public class OWLIndividualListComponent
extends JPanel {
    private OWLEditorKit owlEditorKit;
    private OWLObjectList list;
    private OWLOntologyChangeListener listener;
    private ChangeListenerMediator changeListenerMediator;
    private Set<OWLIndividual> individualsInList;
    private OWLModelManagerListener modelManagerListener;

    public OWLIndividualListComponent(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        this.initialiseIndividualsView();
    }

    public OWLObjectList getList() {
        return this.list;
    }

    private OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    private OWLWorkspace getOWLWorkspace() {
        return this.getOWLEditorKit().getWorkspace();
    }

    private OWLModelManager getOWLModelManager() {
        return this.getOWLEditorKit().getModelManager();
    }

    public void initialiseIndividualsView() {
        this.list = new OWLObjectList(this.getOWLEditorKit());
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.list));
        this.listener = changes -> this.processChanges(changes);
        this.getOWLModelManager().addOntologyChangeListener(this.listener);
        this.changeListenerMediator = new ChangeListenerMediator();
        this.individualsInList = new TreeSet<OWLObject>(this.getOWLModelManager().getOWLObjectComparator());
        this.modelManagerListener = event -> {
            if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED) || event.isType(EventType.ONTOLOGY_RELOADED)) {
                this.refill();
            }
        };
        this.getOWLModelManager().addListener(this.modelManagerListener);
        this.refill();
    }

    private void refill() {
        this.individualsInList.clear();
        for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
            this.individualsInList.addAll(ont.getIndividualsInSignature());
        }
        this.reset();
    }

    public void setSelectedIndividual(OWLIndividual individual) {
        this.list.setSelectedValue(individual, true);
    }

    private void reset() {
        this.list.setListData(this.individualsInList.toArray());
        OWLNamedIndividual entity = this.getSelectedIndividual();
        if (entity instanceof OWLIndividual) {
            this.list.setSelectedValue(entity, true);
        }
    }

    protected OWLIndividual updateView(OWLIndividual selelectedIndividual) {
        this.list.setSelectedValue(selelectedIndividual, true);
        return selelectedIndividual;
    }

    public void disposeView() {
        this.getOWLModelManager().removeOntologyChangeListener(this.listener);
        this.getOWLModelManager().removeListener(this.modelManagerListener);
    }

    public OWLNamedIndividual getSelectedIndividual() {
        return (OWLNamedIndividual)this.list.getSelectedValue();
    }

    public Set<OWLNamedIndividual> getSelectedIndividuals() {
        HashSet<OWLNamedIndividual> inds = new HashSet<OWLNamedIndividual>();
        for (Object obj : this.list.getSelectedValues()) {
            inds.add((OWLNamedIndividual)obj);
        }
        return inds;
    }

    private void processChanges(List<? extends OWLOntologyChange> changes) {
        HashSet possiblyAddedEntities = new HashSet();
        HashSet possiblyRemovedEntities = new HashSet();
        OWLEntityCollector addedCollector = new OWLEntityCollector(possiblyAddedEntities);
        OWLEntityCollector removedCollector = new OWLEntityCollector(possiblyRemovedEntities);
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange()) continue;
            OWLAxiomChange axChg = (OWLAxiomChange)oWLOntologyChange;
            if (axChg instanceof AddAxiom) {
                axChg.getAxiom().accept((OWLObjectVisitorEx)addedCollector);
                continue;
            }
            axChg.getAxiom().accept((OWLObjectVisitorEx)removedCollector);
        }
        boolean mod = false;
        for (OWLEntity ent : possiblyAddedEntities) {
            if (!(ent instanceof OWLIndividual) || !this.individualsInList.add((OWLIndividual)ent)) continue;
            mod = true;
        }
        for (OWLEntity ent : possiblyRemovedEntities) {
            if (!(ent instanceof OWLNamedIndividual) || !this.individualsInList.remove(ent)) continue;
            mod = true;
        }
        if (mod) {
            this.reset();
        }
    }

    private void addIndividual() {
        OWLEntityCreationSet<OWLNamedIndividual> set = this.getOWLWorkspace().createOWLIndividual();
        if (set == null) {
            return;
        }
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        changes.addAll(set.getOntologyChanges());
        this.getOWLModelManager().applyChanges(changes);
        OWLNamedIndividual ind = set.getOWLEntity();
        if (ind != null) {
            this.getOWLWorkspace().getOWLSelectionModel().setSelectedEntity((OWLEntity)ind);
        }
    }

    public List<OWLIndividual> find(String match) {
        return new ArrayList<OWLNamedIndividual>(this.getOWLModelManager().getOWLEntityFinder().getMatchingOWLIndividuals(match));
    }

    public void show(OWLIndividual owlEntity) {
        this.list.setSelectedValue(owlEntity, true);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListenerMediator.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListenerMediator.removeChangeListener(listener);
    }

    public void handleDelete() {
        OWLEntityDeleter.deleteEntities(this.getSelectedIndividuals(), this.getOWLModelManager());
    }

    public boolean canDelete() {
        return !this.getSelectedIndividuals().isEmpty();
    }

    public boolean canCreateNew() {
        return true;
    }

    public void createNewObject() {
        this.addIndividual();
    }
}

