/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.texplate;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.islandoftex.texplate.exceptions.InvalidTemplateException;
import org.islandoftex.texplate.model.Configuration;
import org.islandoftex.texplate.model.Template;
import org.islandoftex.texplate.util.MergingUtils;
import org.islandoftex.texplate.util.MessageUtils;
import org.islandoftex.texplate.util.PathUtils;
import org.islandoftex.texplate.util.ValidatorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(name="texplate", usageHelpWidth=70)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J#\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0015\u001a\u0002H\u00142\u0006\u0010\u0016\u001a\u0002H\u0014H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/islandoftex/texplate/TemplateProcessing;", "Ljava/util/concurrent/Callable;", "", "<init>", "()V", "output", "Ljava/nio/file/Path;", "template", "", "map", "", "configuration", "call", "()Ljava/lang/Integer;", "ensureMap", "", "getSize", "bytes", "", "ensure", "T", "first", "second", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "has", "", "obj", "", "texplate"})
public final class TemplateProcessing
implements Callable<Integer> {
    @CommandLine.Option(names={"-o", "--output"}, required=true, description={"The output file in which the chosen template will be effectively written. Make sure the directory has the correct permissions for writing the output file."}, type={Path.class})
    @Nullable
    private final Path output;
    @CommandLine.Option(names={"-t", "--template"}, description={"The name of the template. The tool will search both user and system locations and set the template model accordingly, based on your specs."})
    @Nullable
    private String template;
    @CommandLine.Option(names={"-m", "--map"}, description={"The contextual map that provides the data to be merged in the template. This parameter can be used multiple times. You can specify a map entry with the key=value syntax (mind the entry separator)."}, arity="1..*")
    @Nullable
    private Map<String, String> map;
    @CommandLine.Option(names={"-c", "--config"}, description={"The configuration file in which the tool can read template data, for automation purposes. Make sure to follow the correct specification when writing a configuration file."}, type={Path.class})
    @Nullable
    private final Path configuration;

    @Override
    @NotNull
    public Integer call() throws Exception {
        int exit = 0;
        boolean halt = false;
        Map<String, Object> cmap = new LinkedHashMap();
        this.ensureMap();
        if (this.has(this.configuration)) {
            MessageUtils.line("Checking configuration");
            try {
                Path path = this.configuration;
                Intrinsics.checkNotNull(path);
                Configuration config = Configuration.Companion.fromPath(path);
                MessageUtils.status(true);
                if (this.has(config.getTemplate())) {
                    this.template = this.ensure(this.template, config.getTemplate());
                }
                if (this.has(config.getMap())) {
                    cmap = config.getMap();
                }
                MessageUtils.line("Adjusting variables from file");
                MessageUtils.status(true);
                System.out.println();
            }
            catch (InvalidTemplateException e) {
                MessageUtils.status(false);
                MessageUtils.error(e);
                exit = -1;
                halt = true;
            }
        } else {
            MessageUtils.line("Configuration file mode disabled");
            MessageUtils.status(true);
            MessageUtils.line("Entering full command line mode");
            if (!this.has(this.template)) {
                MessageUtils.status(false);
                MessageUtils.error(new Exception("The template was not set in the command line through the -t/--template option. If not explicitly specified in a configuration file, this option becomes mandatory, so make sure to define it  either in the command line or in a proper configuration file."));
                exit = -1;
                halt = true;
            } else {
                MessageUtils.status(true);
                System.out.println();
            }
        }
        if (!halt) {
            System.out.println((Object)"Please, wait...");
            System.out.println();
            MessageUtils.line("Obtaining reference");
            try {
                String string = this.template;
                Intrinsics.checkNotNull(string);
                Path file = PathUtils.getTemplatePath(string);
                MessageUtils.status(true);
                MessageUtils.line("Composing template");
                Template template = Template.Companion.fromPath(file);
                MessageUtils.status(true);
                MessageUtils.line("Validating data");
                Map<String, String> map = this.map;
                Intrinsics.checkNotNull(map);
                Map<String, String> validatedData = ValidatorUtils.validate(template, map);
                MessageUtils.status(true);
                MessageUtils.line("Merging template and data");
                Path path = this.output;
                Intrinsics.checkNotNull(path);
                long merged = MergingUtils.mergeTemplate(template, validatedData, path, cmap);
                MessageUtils.status(true);
                System.out.println();
                System.out.println((Object)"Done! Enjoy your template!");
                System.out.println((Object)("Written: " + this.getSize(merged)));
            }
            catch (InvalidTemplateException e) {
                MessageUtils.status(false);
                MessageUtils.error(e);
                exit = -1;
            }
        }
        return exit;
    }

    private final void ensureMap() {
        if (!this.has(this.map)) {
            this.map = new LinkedHashMap();
        }
    }

    private final String getSize(long bytes) {
        String string;
        if (bytes < 1024L) {
            string = bytes + " B";
        } else {
            int exponent = (int)(Math.log(bytes) / Math.log(1024.0));
            String string2 = "%.1f %cB";
            Object[] objectArray = new Object[]{(double)bytes / Math.pow(1024.0, exponent), Character.valueOf("KMGTPE".charAt(exponent - 1))};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        }
        return string;
    }

    private final <T> T ensure(T first, T second) {
        return !this.has(first) ? second : first;
    }

    private final boolean has(Object obj) {
        return obj != null;
    }
}

