/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.html.CommonDefsImplJvmKt;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserUtil;", "", "()V", "Companion", "markdown"})
public final class SequentialParserUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u001a\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fR\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fR\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserUtil$Companion;", "", "()V", "filterBlockquotes", "", "Lkotlin/ranges/IntRange;", "tokensCache", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "textRange", "isPunctuation", "", "info", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "lookup", "", "isWhitespace", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isWhitespace(@NotNull TokensCache.Iterator info, int lookup) {
            Intrinsics.checkNotNullParameter(info, "info");
            return CommonDefsImplJvmKt.isWhitespace(info.charLookup(lookup));
        }

        public final boolean isPunctuation(@NotNull TokensCache.Iterator info, int lookup) {
            Intrinsics.checkNotNullParameter(info, "info");
            return CommonDefsImplJvmKt.isPunctuation(info.charLookup(lookup));
        }

        @NotNull
        public final List<IntRange> filterBlockquotes(@NotNull TokensCache tokensCache, @NotNull IntRange textRange) {
            Intrinsics.checkNotNullParameter(tokensCache, "tokensCache");
            Intrinsics.checkNotNullParameter(textRange, "textRange");
            ArrayList<IntRange> result2 = new ArrayList<IntRange>();
            int lastStart = textRange.getFirst();
            int R = textRange.getLast();
            int i = lastStart;
            int n = R - 1;
            if (i <= n) {
                while (true) {
                    if (Intrinsics.areEqual(new TokensCache.Iterator(tokensCache, i).getType(), MarkdownTokenTypes.BLOCK_QUOTE)) {
                        if (lastStart < i) {
                            result2.add(new IntRange(lastStart, i - 1));
                        }
                        lastStart = i + 1;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            if (lastStart < R) {
                result2.add(new IntRange(lastStart, R));
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

