/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.icon.button;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;

public class BorderIcon
implements Icon {
    private Icon icon;
    private Color color;
    private Insets insets;

    public BorderIcon(Icon icon, int borderSize) {
        this(icon, null, new Insets(borderSize, borderSize, borderSize, borderSize));
    }

    public BorderIcon(Icon icon, Color color, Insets insets) {
        this.icon = icon;
        this.color = color;
        this.insets = insets;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.color != null) {
            Color oldColor = g.getColor();
            g.setColor(this.color);
            g.fillRect(x, y, this.getIconWidth(), this.insets.top);
            g.fillRect(x, y + this.getIconHeight() - this.insets.bottom, this.getIconWidth(), this.insets.bottom);
            g.fillRect(x, y + this.insets.top, this.insets.left, this.getIconHeight() - this.insets.top - this.insets.bottom);
            g.fillRect(x + this.getIconWidth() - this.insets.right, y + this.insets.top, this.insets.right, this.getIconHeight() - this.insets.top - this.insets.bottom);
            g.setColor(oldColor);
        }
        this.icon.paintIcon(c, g, x + this.insets.left, y + this.insets.top);
    }

    @Override
    public int getIconWidth() {
        return this.insets.left + this.insets.right + this.icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.insets.top + this.insets.bottom + this.icon.getIconHeight();
    }
}

