/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.freeplane.api.HorizontalTextAlignment;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.TagIcon;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.html.CssRuleBuilder;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.IconBuilder;
import org.freeplane.features.icon.IconClickedEvent;
import org.freeplane.features.icon.IconConditionController;
import org.freeplane.features.icon.IconMouseListener;
import org.freeplane.features.icon.IconRegistry;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.PriorityConditionController;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagBuilder;
import org.freeplane.features.icon.TagCategories;
import org.freeplane.features.icon.TagReference;
import org.freeplane.features.icon.Tags;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.CombinedPropertyChain;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.StyleNode;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.TagLocation;

public class IconController
implements IExtension {
    private static final Quantity<LengthUnit> DEFAULT_ICON_SIZE = new Quantity(12.0, (Enum)LengthUnit.pt);
    private static final int TAG_TOOLTIP = 5;
    private final CombinedPropertyChain<Collection<NamedIcon>, NodeModel> iconHandlers;
    private UIIcon tagsIcon;
    private final Collection<IStateIconProvider> stateIconProviders;
    private final List<IconMouseListener> iconMouseListeners;
    private final ModeController modeController;

    public static IconController getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return IconController.getController(modeController);
    }

    public static IconController getController(ModeController modeController) {
        return modeController.getExtension(IconController.class);
    }

    public static void installConditionControllers() {
        ConditionFactory conditionFactory = FilterController.getCurrentFilterController().getConditionFactory();
        conditionFactory.addConditionController(10, new IconConditionController());
        conditionFactory.addConditionController(50, new PriorityConditionController());
    }

    public void install(ModeController modeController) {
        modeController.addExtension(IconController.class, this);
        this.registerStateIconProvider();
        this.registerTooltipProvider();
    }

    private void registerStateIconProvider() {
        this.addStateIconProvider(new IStateIconProvider(){

            @Override
            public UIIcon getStateIcon(NodeModel node) {
                boolean showIcon;
                if (IconController.this.getTags(node).isEmpty()) {
                    return null;
                }
                MapStyle mapStyle = IconController.this.modeController.getExtension(MapStyle.class);
                TagLocation tagLocation = mapStyle.tagLocation(node.getMap());
                boolean bl = showIcon = tagLocation == TagLocation.NEVER || !MapView.showsTagsOnMinimizedNodes() && IconController.this.modeController.getExtension(TextController.class).isMinimized(node);
                if (showIcon) {
                    if (IconController.this.tagsIcon == null) {
                        IconController.this.tagsIcon = IconStoreFactory.ICON_STORE.getUIIcon("tags.svg");
                    }
                    return IconController.this.tagsIcon;
                }
                return null;
            }

            @Override
            public boolean mustIncludeInIconRegistry() {
                return true;
            }
        });
    }

    private void registerTooltipProvider() {
        this.modeController.addToolTipProvider(5, new ITooltipProvider(){

            @Override
            public String getTooltip(ModeController modeController, NodeModel node, Component view, ITooltipProvider.TooltipTrigger tooltipTrigger) {
                boolean showTooltip;
                List<Tag> tags = IconController.this.getTags(node);
                if (tags.isEmpty()) {
                    return null;
                }
                MapStyle mapStyle = modeController.getExtension(MapStyle.class);
                TagLocation tagLocation = mapStyle.tagLocation(node.getMap());
                boolean bl = showTooltip = tooltipTrigger == ITooltipProvider.TooltipTrigger.LINK || tagLocation == TagLocation.NEVER || !MapView.showsTagsOnMinimizedNodes() && modeController.getExtension(TextController.class).isMinimized(node, view);
                if (!showTooltip) {
                    return null;
                }
                Font font = IconController.this.getTagFont(node);
                StringBuilder tooltip = new StringBuilder();
                tooltip.append("<html><body><p style=\"");
                tooltip.append(new CssRuleBuilder().withHTMLFont(font));
                tooltip.append(" \">");
                tooltip.append(tags.stream().map(Tag::getContent).map(HtmlUtils::toXMLEscapedText).collect(Collectors.joining("] [", "[", "]")));
                tooltip.append("</p></body></html>");
                return tooltip.toString();
            }
        });
    }

    public void addIconMouseListener(IconMouseListener iconMouseListener) {
        this.iconMouseListeners.add(iconMouseListener);
    }

    public boolean addStateIconProvider(IStateIconProvider o) {
        return this.stateIconProviders.add(o);
    }

    public boolean removeStateIconProvider(IStateIconProvider o) {
        return this.stateIconProviders.remove(o);
    }

    public IconController(final ModeController modeController) {
        this.modeController = modeController;
        this.stateIconProviders = new LinkedList<IStateIconProvider>();
        this.iconHandlers = new CombinedPropertyChain(false);
        MapController mapController = modeController.getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        IconBuilder textBuilder = new IconBuilder(this, IconStoreFactory.ICON_STORE);
        textBuilder.registerBy(readManager, writeManager);
        TagBuilder tagBuilder = new TagBuilder();
        tagBuilder.registerBy(readManager, writeManager);
        this.addIconGetter(IPropertyHandler.STYLE, new IPropertyHandler<Collection<NamedIcon>, NodeModel>(){

            @Override
            public Collection<NamedIcon> getProperty(NodeModel node, LogicalStyleController.StyleOption option, Collection<NamedIcon> currentValue) {
                MapStyleModel model = MapStyleModel.getExtension(node.getMap());
                Collection<IStyle> styleKeys = LogicalStyleController.getController(modeController).getStyles(node, option);
                for (IStyle styleKey : styleKeys) {
                    NodeModel styleNode = model.getStyleNode(styleKey);
                    if (styleNode == null || node == styleNode && !(styleKey instanceof StyleNode)) continue;
                    List<NamedIcon> styleIcons = styleNode.getIcons();
                    currentValue.addAll(styleIcons);
                }
                return currentValue;
            }
        });
        this.iconMouseListeners = new LinkedList<IconMouseListener>();
    }

    public IPropertyHandler<Collection<NamedIcon>, NodeModel> addIconGetter(Integer key, IPropertyHandler<Collection<NamedIcon>, NodeModel> getter) {
        return this.iconHandlers.addGetter(key, getter);
    }

    public IPropertyHandler<Collection<NamedIcon>, NodeModel> removeIconGetter(Integer key, IPropertyHandler<Collection<NamedIcon>, NodeModel> getter) {
        return this.iconHandlers.addGetter(key, getter);
    }

    public Collection<NamedIcon> getIcons(NodeModel node, LogicalStyleController.StyleOption option) {
        Collection icons = this.iconHandlers.getProperty(node, option, new LinkedList());
        return icons;
    }

    public final Collection<UIIcon> getStateIcons(NodeModel node) {
        LinkedList<UIIcon> icons = new LinkedList<UIIcon>();
        for (IStateIconProvider provider : this.stateIconProviders) {
            UIIcon stateIcon = provider.getStateIcon(node);
            if (stateIcon == null) continue;
            icons.add(stateIcon);
            if (!provider.mustIncludeInIconRegistry()) continue;
            IconRegistry iconRegistry = node.getMap().getIconRegistry();
            iconRegistry.addIcon(stateIcon);
        }
        return icons;
    }

    public boolean onIconClicked(NodeModel node, NamedIcon icon) {
        boolean processed = false;
        for (IconMouseListener listener : this.iconMouseListeners) {
            IconClickedEvent event;
            if (!listener.onIconClicked(event = new IconClickedEvent(icon, node))) continue;
            processed = true;
        }
        return processed;
    }

    private Quantity<LengthUnit> getStyleIconSize(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            Quantity<LengthUnit> iconSize;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (iconSize = styleNode.getSharedData().getIcons().getIconSize()) == null) continue;
            return iconSize;
        }
        return DEFAULT_ICON_SIZE;
    }

    public Quantity<LengthUnit> getIconSize(NodeModel node, LogicalStyleController.StyleOption option) {
        MapModel map = node.getMap();
        ModeController modeController = Controller.getCurrentModeController();
        LogicalStyleController styleController = LogicalStyleController.getController(modeController);
        Collection<IStyle> styles = styleController.getStyles(node, option);
        Quantity<LengthUnit> size = this.getStyleIconSize(map, styles);
        return size;
    }

    public Map<String, AFreeplaneAction> getAllIconActions() {
        return Collections.emptyMap();
    }

    public List<TagIcon> getTagIcons(NodeModel node) {
        MapStyle mapStyle = this.modeController.getExtension(MapStyle.class);
        boolean showCategories = mapStyle.showsTagCategories(node.getMap());
        return this.getTagIcons(node, showCategories);
    }

    public List<TagIcon> getTagIcons(NodeModel node, boolean showCategories) {
        Font font = this.getTagFont(node);
        Color tagBackgroundColor = this.getTagBackgroundColor(node);
        Color tagTextColor = this.getTagTextColor(node);
        TagCategories tagCategories = node.getMap().getIconRegistry().getTagCategories();
        String tagCategorySeparator = tagCategories.getTagCategorySeparator();
        return this.getTags(node).stream().map(tag -> this.tagIcon((Tag)tag, font, tagTextColor, tagBackgroundColor, showCategories, tagCategorySeparator)).collect(Collectors.toList());
    }

    private TagIcon tagIcon(Tag tag, Font font, Color tagTextColor, Color tagBackgroundColor, boolean showCategories, String tagCategorySeparator) {
        if (showCategories) {
            return new TagIcon(tag, font, tagTextColor, tagBackgroundColor);
        }
        Tag tagWithoutCategories = tag.withoutCategories(tagCategorySeparator);
        tagWithoutCategories.setAlternativeTag(tag);
        TagIcon tagIcon = new TagIcon(tagWithoutCategories, font, tagTextColor, tagBackgroundColor);
        return tagIcon;
    }

    public Font getTagFont(NodeModel node) {
        MapStyleModel model = MapStyleModel.getExtension(node.getMap());
        NodeModel tagStyleNode = model.getStyleNodeSafe(MapStyleModel.TAG_STYLE);
        NodeStyleController style = this.modeController.getExtension(NodeStyleController.class);
        Font nodeFont = style.getFont(tagStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        Font font = nodeFont.deriveFont(UITools.FONT_SCALE_FACTOR * nodeFont.getSize2D());
        return font;
    }

    public Color getTagBackgroundColor(NodeModel node) {
        MapStyleModel model = MapStyleModel.getExtension(node.getMap());
        NodeModel tagStyleNode = model.getStyleNodeSafe(MapStyleModel.TAG_STYLE);
        return NodeStyleModel.getBackgroundColor(tagStyleNode);
    }

    public Color getTagTextColor(NodeModel node) {
        MapStyleModel model = MapStyleModel.getExtension(node.getMap());
        NodeModel tagStyleNode = model.getStyleNodeSafe(MapStyleModel.TAG_STYLE);
        return NodeStyleModel.getColor(tagStyleNode);
    }

    public HorizontalTextAlignment getTagComponentAlignment(NodeModel node) {
        MapStyleModel model = MapStyleModel.getExtension(node.getMap());
        NodeModel tagStyleNode = model.getStyleNodeSafe(MapStyleModel.TAG_STYLE);
        NodeStyleController style = this.modeController.getExtension(NodeStyleController.class);
        return style.getHorizontalTextAlignment(tagStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
    }

    public List<TagReference> getTagReferences(NodeModel node) {
        return Tags.getTagReferences(node);
    }

    public List<Tag> getTags(NodeModel node) {
        Tags tags = node.getExtension(Tags.class);
        return tags == null ? Collections.emptyList() : tags.getTags();
    }

    public List<Tag> getTagsWithExtendedCategories(NodeModel node) {
        return this.extendCategories(this.getTags(node), node.getMap().getIconRegistry().getTagCategories());
    }

    public List<Tag> extendCategories(List<Tag> tags, TagCategories tagCategories) {
        return Collections.emptyList();
    }
}

