/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Transforms the image so that any pixel that is not a regional minima
is set to the maximum value for the pixel type. Pixels that are
regional minima retain their value.


Regional minima are flat zones surrounded by pixels of higher value. A
completely flat image will be marked as a regional minima by this
filter.

This code was contributed in the Insight Journal paper: "Finding
regional extrema - methods and performance" by Beare R., Lehmann G. https://doi.org/10.54294/hva3gz


Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.

See:
 ValuedRegionalMaximaImageFilter , ValuedRegionalExtremaImageFilter ,

 HMinimaImageFilter

 itk::simple::ValuedRegionalMinima for the procedural interface

 itk::ValuedRegionalMinimaImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkValuedRegionalMinimaImageFilter.h
*/
public class ValuedRegionalMinimaImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ValuedRegionalMinimaImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ValuedRegionalMinimaImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ValuedRegionalMinimaImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ValuedRegionalMinimaImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ValuedRegionalMinimaImageFilter::~ValuedRegionalMinimaImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ValuedRegionalMinimaImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ValuedRegionalMinimaImageFilter::ValuedRegionalMinimaImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ValuedRegionalMinimaImageFilter() {
    this(SimpleITKJNI.new_ValuedRegionalMinimaImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ValuedRegionalMinimaImageFilter::SetFullyConnected(bool FullyConnected)
*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.ValuedRegionalMinimaImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::ValuedRegionalMinimaImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.ValuedRegionalMinimaImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ValuedRegionalMinimaImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.ValuedRegionalMinimaImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::ValuedRegionalMinimaImageFilter::GetFullyConnected() const
*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.ValuedRegionalMinimaImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
bool itk::simple::ValuedRegionalMinimaImageFilter::GetFlat() const

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  boolean getFlat() {
    return SimpleITKJNI.ValuedRegionalMinimaImageFilter_getFlat(swigCPtr, this);
  }

  /**
std::string itk::simple::ValuedRegionalMinimaImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ValuedRegionalMinimaImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ValuedRegionalMinimaImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ValuedRegionalMinimaImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ValuedRegionalMinimaImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ValuedRegionalMinimaImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
