/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Pixel-wise addition of two images.


This class is templated over the types of the two input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.

The pixel type of the input 1 image must have a valid definition of
the operator+ with a pixel type of the image 2. This condition is
required because internally this filter will perform the operation


Additionally the type resulting from the sum, will be cast to the
pixel type of the output image.

The total operation over one pixel will be

For example, this filter could be used directly for adding images
whose pixels are vectors of the same dimension, and to store the
resulting vector in an output image of vector pixels.

The images to be added are set using the methods:

Additionally, this filter can be used to add a constant to every pixel
of an image by using


WARNING:
No numeric overflow checking is performed in this filter.

See:
 itk::simple::Add for the procedural interface

 itk::AddImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkAddImageFilter.h
*/
public class AddImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected AddImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.AddImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(AddImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(AddImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::AddImageFilter::~AddImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_AddImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::AddImageFilter::AddImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  AddImageFilter() {
    this(SimpleITKJNI.new_AddImageFilter(), true);
  }

  /**
std::string itk::simple::AddImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.AddImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::AddImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.AddImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::AddImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.AddImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::AddImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, double constant) {
    return new Image(SimpleITKJNI.AddImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::AddImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(double constant, Image image2) {
    return new Image(SimpleITKJNI.AddImageFilter_execute__SWIG_2(swigCPtr, this, constant, Image.getCPtr(image2), image2), true);
  }

}
