/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.ValidatorVisitor;
import org.openstreetmap.josm.data.validation.util.MultipleNameVisitor;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class TestError
implements Comparable<TestError> {
    private static boolean switchOver = Instant.now().isAfter(Instant.ofEpochMilli(1704067200L));
    private boolean ignored;
    private final Severity severity;
    private final String message;
    private final String description;
    private final String descriptionEn;
    private final Collection<? extends OsmPrimitive> primitives;
    private final Collection<?> highlighted;
    private final Test tester;
    private final int code;
    private final int uniqueCode;
    private boolean selected;
    private boolean incompletePrimitives;
    private final Supplier<Command> fixingCommand;

    static void setUpdateErrorCodes(boolean updateErrorCodes) {
        switchOver = updateErrorCodes;
    }

    public static Builder builder(Test tester, Severity severity, int code) {
        return new Builder(tester, severity, code);
    }

    TestError(Builder builder) {
        this.tester = builder.tester;
        this.severity = builder.severity;
        this.message = builder.message;
        this.description = builder.description;
        this.descriptionEn = builder.descriptionEn;
        this.primitives = builder.primitives;
        this.highlighted = builder.highlighted;
        this.code = builder.code;
        this.uniqueCode = builder.uniqueCode;
        this.fixingCommand = builder.fixingCommand;
        this.incompletePrimitives = builder.incompletePrimitives;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<? extends OsmPrimitive> getPrimitives() {
        return Collections.unmodifiableCollection(this.primitives);
    }

    public final <T extends OsmPrimitive> Stream<T> primitives(Class<T> type) {
        return this.primitives.stream().filter(type::isInstance).map(type::cast);
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getIgnoreState() {
        return this.getIgnoreState(false);
    }

    private String getIgnoreState(boolean useOriginal) {
        TreeSet<CallSite> strings = new TreeSet<CallSite>();
        for (OsmPrimitive osmPrimitive : this.primitives) {
            if (osmPrimitive.isNew()) {
                return null;
            }
            String type = "u";
            if (osmPrimitive instanceof Way) {
                type = "w";
            } else if (osmPrimitive instanceof Relation) {
                type = "r";
            } else if (osmPrimitive instanceof Node) {
                type = "n";
            }
            strings.add((CallSite)((Object)(type + "_" + osmPrimitive.getId())));
        }
        return strings.stream().map(o -> ":" + o).collect(Collectors.joining("", this.getIgnoreSubGroup(useOriginal), ""));
    }

    public boolean updateIgnored() {
        this.setIgnored(this.calcIgnored());
        return this.isIgnored();
    }

    private boolean calcIgnored() {
        if (OsmValidator.hasIgnoredError(this.getIgnoreGroup(true))) {
            TestError.updateIgnoreList(this.getIgnoreGroup(true), this.getIgnoreGroup(false));
            return true;
        }
        if (OsmValidator.hasIgnoredError(this.getIgnoreSubGroup(true))) {
            TestError.updateIgnoreList(this.getIgnoreSubGroup(true), this.getIgnoreSubGroup(false));
            return true;
        }
        String oldState = this.getIgnoreState(true);
        String state = this.getIgnoreState(false);
        if (oldState != null && OsmValidator.hasIgnoredError(oldState)) {
            TestError.updateIgnoreList(oldState, state);
            return true;
        }
        if (OsmValidator.hasIgnoredError(this.getIgnoreGroup())) {
            return true;
        }
        if (OsmValidator.hasIgnoredError(this.getIgnoreSubGroup())) {
            return true;
        }
        return state != null && OsmValidator.hasIgnoredError(state);
    }

    private static void updateIgnoreList(String oldKey, String newKey) {
        SortedMap<String, String> errors;
        if (switchOver && (errors = OsmValidator.getIgnoredErrors()).containsKey(oldKey)) {
            String value = (String)errors.remove(oldKey);
            errors.put(newKey, value);
        }
    }

    public String getIgnoreSubGroup() {
        return this.getIgnoreSubGroup(false);
    }

    private String getIgnoreSubGroup(boolean useOriginal) {
        if (this.code == 3000) {
            return "3000_" + (this.description == null ? this.message : this.description);
        }
        Object ignorestring = this.getIgnoreGroup(useOriginal);
        if (this.descriptionEn != null) {
            ignorestring = (String)ignorestring + "_" + this.descriptionEn;
        }
        return ignorestring;
    }

    public String getIgnoreGroup() {
        return this.getIgnoreGroup(false);
    }

    private String getIgnoreGroup(boolean useOriginal) {
        if (this.code == 3000) {
            return "3000_" + this.getMessage();
        }
        if (useOriginal) {
            return Integer.toString(this.code);
        }
        return this.uniqueCode + "_" + this.code;
    }

    public void setIgnored(boolean state) {
        this.ignored = state;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public Test getTester() {
        return this.tester;
    }

    public int getCode() {
        return this.code;
    }

    public int getUniqueCode() {
        return this.uniqueCode;
    }

    public boolean isFixable() {
        return (this.fixingCommand != null || this.tester != null && this.tester.isFixable(this)) && OsmUtils.isOsmCollectionEditable(this.primitives);
    }

    public Command getFix() {
        Command fix;
        Command command = fix = this.fixingCommand != null ? this.fixingCommand.get() : null;
        if (fix != null) {
            return fix;
        }
        if (this.tester == null || !this.tester.isFixable(this) || this.primitives.isEmpty()) {
            return null;
        }
        return this.tester.fixError(this);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void visitHighlighted(ValidatorVisitor v) {
        for (Object o : this.highlighted) {
            if (o instanceof OsmPrimitive) {
                v.visit((OsmPrimitive)o);
                continue;
            }
            if (o instanceof WaySegment) {
                v.visit((WaySegment)o);
                continue;
            }
            if (o instanceof List) {
                v.visit((List)o);
                continue;
            }
            if (!(o instanceof Area)) continue;
            for (List<Node> l : TestError.getHiliteNodesForArea((Area)o)) {
                v.visit(l);
            }
        }
    }

    private static List<List<Node>> getHiliteNodesForArea(Area area) {
        ArrayList<List<Node>> hilite = new ArrayList<List<Node>>();
        PathIterator pit = area.getPathIterator(null);
        double[] res = new double[6];
        ArrayList<Node> nodes = new ArrayList<Node>();
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            Node n = new Node(new EastNorth(res[0], res[1]));
            switch (type) {
                case 0: {
                    if (!nodes.isEmpty()) {
                        hilite.add(nodes);
                    }
                    nodes = new ArrayList();
                    nodes.add(n);
                    break;
                }
                case 1: {
                    nodes.add(n);
                    break;
                }
                case 4: {
                    if (nodes.isEmpty()) break;
                    nodes.add((Node)nodes.get(0));
                    hilite.add(nodes);
                    nodes = new ArrayList();
                    break;
                }
            }
            pit.next();
        }
        if (nodes.size() > 1) {
            hilite.add(nodes);
        }
        return hilite;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Collection<?> getHighlighted() {
        return Collections.unmodifiableCollection(this.highlighted);
    }

    @Override
    public int compareTo(TestError o) {
        if (this.equals(o)) {
            return 0;
        }
        return AlphanumComparator.getInstance().compare(this.getNameVisitor().toString(), o.getNameVisitor().toString());
    }

    public MultipleNameVisitor getNameVisitor() {
        MultipleNameVisitor v = new MultipleNameVisitor();
        v.visit(this.getPrimitives());
        return v;
    }

    public boolean isSimilar(TestError other) {
        return this.getUniqueCode() == other.getUniqueCode() && this.getCode() == other.getCode() && this.getMessage().equals(other.getMessage()) && this.getPrimitives().size() == other.getPrimitives().size() && this.getPrimitives().containsAll(other.getPrimitives()) && TestError.highlightedIsEqual(this.getHighlighted(), other.getHighlighted());
    }

    private static boolean highlightedIsEqual(Collection<?> highlighted, Collection<?> highlighted2) {
        if (highlighted.size() == highlighted2.size()) {
            if (!highlighted.isEmpty()) {
                Object h1 = highlighted.iterator().next();
                Object h2 = highlighted2.iterator().next();
                if (h1 instanceof Area && h2 instanceof Area) {
                    return ((Area)h1).equals((Area)h2);
                }
                return highlighted.containsAll(highlighted2);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "TestError [tester=" + String.valueOf(this.tester) + ", unique code=" + this.uniqueCode + ", code=" + this.code + ", message=" + this.message + "]";
    }

    public boolean isConcerned(Set<? extends OsmPrimitive> given) {
        if (this.incompletePrimitives) {
            return true;
        }
        for (OsmPrimitive osmPrimitive : this.getPrimitives()) {
            if (!given.contains(osmPrimitive)) continue;
            return true;
        }
        return false;
    }

    public static final class Builder {
        private final Test tester;
        private final Severity severity;
        private final int code;
        private final int uniqueCode;
        private String message;
        private String description;
        private String descriptionEn;
        private Collection<? extends OsmPrimitive> primitives;
        private Collection<?> highlighted;
        private Supplier<Command> fixingCommand;
        private boolean incompletePrimitives;

        Builder(Test tester, Severity severity, int code) {
            this.tester = tester;
            this.severity = severity;
            this.code = code;
            this.uniqueCode = this.tester != null ? this.tester.getClass().getName().hashCode() : code;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder messageWithManuallyTranslatedDescription(String message, String description, String descriptionEn) {
            this.message = message;
            this.description = description;
            this.descriptionEn = descriptionEn;
            return this;
        }

        public Builder message(String message, String marktrDescription, Object ... args) {
            this.message = message;
            this.description = I18n.tr(marktrDescription, args);
            this.descriptionEn = new MessageFormat(marktrDescription, Locale.ENGLISH).format(args);
            return this;
        }

        public Builder primitives(OsmPrimitive ... primitives) {
            return this.primitives(Arrays.asList(primitives));
        }

        public Builder primitives(Collection<? extends OsmPrimitive> primitives) {
            CheckParameterUtil.ensureThat(this.primitives == null, "primitives already set");
            CheckParameterUtil.ensureParameterNotNull(primitives, "primitives");
            this.primitives = primitives;
            if (this.highlighted == null) {
                this.highlighted = primitives;
            }
            return this;
        }

        public Builder highlight(OsmPrimitive ... highlighted) {
            return this.highlight(Arrays.asList(highlighted));
        }

        public Builder highlight(Collection<? extends OsmPrimitive> highlighted) {
            CheckParameterUtil.ensureParameterNotNull(highlighted, "highlighted");
            this.highlighted = highlighted;
            return this;
        }

        public Builder highlightWaySegments(Collection<WaySegment> highlighted) {
            CheckParameterUtil.ensureParameterNotNull(highlighted, "highlighted");
            this.highlighted = highlighted;
            return this;
        }

        public Builder highlightNodePairs(Collection<List<Node>> highlighted) {
            CheckParameterUtil.ensureParameterNotNull(highlighted, "highlighted");
            this.highlighted = highlighted;
            return this;
        }

        public Builder highlight(Area highlighted) {
            CheckParameterUtil.ensureParameterNotNull(highlighted, "highlighted");
            this.highlighted = Collections.singleton(highlighted);
            return this;
        }

        public Builder imcompletePrimitives() {
            this.incompletePrimitives = true;
            return this;
        }

        public Builder fix(Supplier<Command> fixingCommand) {
            CheckParameterUtil.ensureThat(this.fixingCommand == null, "fixingCommand already set");
            this.fixingCommand = fixingCommand;
            return this;
        }

        public TestError build() {
            CheckParameterUtil.ensureParameterNotNull(this.message, "message not set");
            CheckParameterUtil.ensureParameterNotNull(this.primitives, "primitives not set");
            if (this.highlighted == null) {
                this.highlighted = Collections.emptySet();
            }
            return new TestError(this);
        }
    }
}

