/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

class EventPerformanceMonitor {
    private static final DecimalFormat MILLISECOND_DECIMAL_FORMAT = new DecimalFormat("#0.00");
    private final Logger log;
    private long periodNs;
    private long alwaysLogThresholdNs;
    private String slowestEventName;
    private long slowestEventDurationNs;
    private long totalEventDurationNs;
    private int numEvents;

    private EventPerformanceMonitor(LogContext logContext, long periodNs, long alwaysLogThresholdNs) {
        this.log = logContext.logger(EventPerformanceMonitor.class);
        this.periodNs = periodNs;
        this.alwaysLogThresholdNs = alwaysLogThresholdNs;
        this.reset();
    }

    long periodNs() {
        return this.periodNs;
    }

    Map.Entry<String, Long> slowestEvent() {
        return new AbstractMap.SimpleImmutableEntry<String, Long>(this.slowestEventName, this.slowestEventDurationNs);
    }

    void reset() {
        this.slowestEventName = null;
        this.slowestEventDurationNs = 0L;
        this.totalEventDurationNs = 0L;
        this.numEvents = 0;
    }

    void observeEvent(String name, long durationNs) {
        String message = this.doObserveEvent(name, durationNs);
        if (message != null) {
            this.log.error("{}", (Object)message);
        }
    }

    String doObserveEvent(String name, long durationNs) {
        if (this.slowestEventName == null || this.slowestEventDurationNs < durationNs) {
            this.slowestEventName = name;
            this.slowestEventDurationNs = durationNs;
        }
        this.totalEventDurationNs += durationNs;
        ++this.numEvents;
        if (durationNs < this.alwaysLogThresholdNs) {
            return null;
        }
        return "Exceptionally slow controller event " + name + " took " + TimeUnit.NANOSECONDS.toMillis(durationNs) + " ms.";
    }

    void generatePeriodicPerformanceMessage() {
        String message = this.periodicPerformanceMessage();
        this.log.info("{}", (Object)message);
        this.reset();
    }

    String periodicPerformanceMessage() {
        StringBuilder bld = new StringBuilder();
        bld.append("In the last ");
        bld.append(TimeUnit.NANOSECONDS.toMillis(this.periodNs));
        bld.append(" ms period, ");
        if (this.numEvents == 0) {
            bld.append("there were no controller events completed.");
        } else {
            bld.append(this.numEvents).append(" controller events were completed, which took an average of ");
            bld.append(EventPerformanceMonitor.formatNsAsDecimalMs(this.totalEventDurationNs / (long)this.numEvents));
            bld.append(" ms each. The slowest event was ").append(this.slowestEventName);
            bld.append(", which took ");
            bld.append(EventPerformanceMonitor.formatNsAsDecimalMs(this.slowestEventDurationNs));
            bld.append(" ms.");
        }
        return bld.toString();
    }

    static String formatNsAsDecimalMs(long durationNs) {
        double number = TimeUnit.NANOSECONDS.toMicros(durationNs);
        return MILLISECOND_DECIMAL_FORMAT.format(number /= 1000.0);
    }

    static class Builder {
        LogContext logContext = null;
        long periodNs = TimeUnit.SECONDS.toNanos(60L);
        long alwaysLogThresholdNs = TimeUnit.SECONDS.toNanos(2L);

        Builder() {
        }

        Builder setLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        Builder setPeriodNs(long periodNs) {
            this.periodNs = periodNs;
            return this;
        }

        Builder setAlwaysLogThresholdNs(long alwaysLogThresholdNs) {
            this.alwaysLogThresholdNs = alwaysLogThresholdNs;
            return this;
        }

        EventPerformanceMonitor build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            return new EventPerformanceMonitor(this.logContext, this.periodNs, this.alwaysLogThresholdNs);
        }
    }
}

