/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.spi;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.InvalidAttributeValueException;
import oracle.xdb.RealInputStream;
import oracle.xdb.XMLType;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBElement;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.dom.XDBNodeList;
import oracle.xdb.event.XDBInvalidOperationException;
import oracle.xdb.spi.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XDBResource
extends XDBDocument
implements Resource {
    private static String RES_OWNERID = "OwnerID";
    private static String RES_CHARSET = "CharacterSet";
    private static String RES_CREATEDATE = "CreationDate";
    private static String RES_MODDATE = "ModificationDate";
    private static String RES_AUTHOR = "Author";
    private static String RES_DISPLAYNAME = "DisplayName";
    private static String RES_COMMENT = "Comment";
    private static String RES_LANGUAGE = "Language";
    private static String RES_CONTENTTYPE = "ContentType";
    private static String RES_VERSIONID = "VersionId";
    private static String RES_FLAGS = "Flags";
    private static String RES_SCHEMA_ELEMENT = "SchemaElement";
    private static String RES_LAST_MOD = "LastModifier";
    private static String RES_CREATOR = "Creator";
    private static String RES_OWNER = "Owner";
    private static String RES_ACL = "acl";
    private static String RES_REF_COUNT = "RefCount";
    private static String RES_METADATA = "SBResExtra";
    private static final int NO_ERROR = 0;
    private static final int NOT_CONTAINER_ERROR = 1;
    private static final int NOT_FOUND_ERROR = 2;
    private static final int NOT_DONE = 3;
    private static final int INVALID_HANDLE = 4;
    private static final int ENTRY_EXISTS_ERROR = 5;
    private static final int OTHER_ERROR = 6;
    private static final int INV_RESHDL_OR_PATH_ERR = 31001;
    private static final int NOT_CONT_ERR = 31002;
    private static final int ENTRY_EXISTS_ERR = 31003;
    private static final int DBBLKSIZE_TOO_SMALL_ERR = 31004;
    private static final int PATHNAME_TOO_LONG_ERR = 31005;
    private static final int PATH_SEGMENT_TOO_LONG_ERR = 31006;
    private static final int DEL_NONEMPTY_CONT_ERR = 31007;
    private static final int XDB_SPI_UNBIND_CONTEXT_ERR = 1;
    private static final int XDB_SPI_ENUM_EMPTY_ERR = 3;
    protected Element m_resElem;
    protected String m_path;
    private static int RES_FLAGS_CONTAINER = 8;
    private static int CONTENT_XML = 1;
    private static int CONTENT_BINARY = 2;

    public static native long getServerEnv();

    public static native long getServerCtx();

    public static native void freeServerCtx(long var0);

    private native String getACLNative(long var1);

    private native long setACLNative(long var1, String var3, boolean var4);

    private native boolean hasACLChangedNative(long var1);

    private native void saveNative(long var1);

    private native int getSizeNative(long var1);

    private native long getContentKprb(long var1, int var3);

    private native long getContentThick(long var1, long var3, String var5, int var6);

    private native void setContentXmlKprb(long var1, long var3, int var5);

    private native void setContentXmlThick(long var1, long var3, String var5, long var6, int var8);

    private native boolean hasContentChangedNative(long var1);

    private native boolean checkNoModifyNative(long var1, String var3);

    private native boolean hasPropChangedNative(long var1, long var3);

    private native boolean hasChangedNative(long var1, String var3, String var4);

    @Override
    public long getOwnerId() {
        long l;
        String s = this.getProperty(RES_OWNERID);
        try {
            l = Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            l = 0L;
        }
        return l;
    }

    @Override
    public void setOwnerId(long ownerid) throws InvalidAttributeValueException {
        this.setProperty(RES_OWNERID, String.valueOf(ownerid));
    }

    @Override
    public String getCharacterSet() {
        return this.getProperty(RES_CHARSET);
    }

    @Override
    public void setCharacterSet(String charSet) throws InvalidAttributeValueException {
        this.setProperty(RES_CHARSET, charSet);
    }

    @Override
    public String getSchemaElement() {
        return this.getProperty(RES_SCHEMA_ELEMENT);
    }

    @Override
    public void setSchemaElement(String schema) throws InvalidAttributeValueException {
        this.setProperty(RES_SCHEMA_ELEMENT, schema);
    }

    @Override
    public String getCreator() {
        return this.getProperty(RES_CREATOR);
    }

    @Override
    public void setCreator(String creator) throws InvalidAttributeValueException {
        this.setProperty(RES_CREATOR, creator);
    }

    public String getRefCount() {
        return this.getProperty(RES_REF_COUNT);
    }

    @Override
    public String getOwner() {
        return this.getProperty(RES_OWNER);
    }

    @Override
    public void setOwner(String owner) throws InvalidAttributeValueException {
        this.setProperty(RES_OWNER, owner);
    }

    @Override
    public Timestamp getCreationDate() {
        String credat = this.getProperty(RES_CREATEDATE);
        return Timestamp.valueOf(credat.replace('T', ' '));
    }

    @Override
    public void setCreationDate(Timestamp credate) throws InvalidAttributeValueException {
        this.setProperty(RES_CREATEDATE, credate.toString().replace(' ', 'T'));
    }

    @Override
    public Timestamp getModificationDate() {
        String moddat = this.getProperty(RES_MODDATE);
        return Timestamp.valueOf(moddat.replace('T', ' '));
    }

    @Override
    public void setModificationDate(Timestamp moddate) throws InvalidAttributeValueException {
        this.setProperty(RES_MODDATE, moddate.toString().replace(' ', 'T'));
    }

    @Override
    public String getLastModifier() {
        return this.getProperty(RES_LAST_MOD);
    }

    @Override
    public void setLastModifier(String modifier) throws InvalidAttributeValueException {
        this.setProperty(RES_LAST_MOD, modifier);
    }

    @Override
    public String getAuthor() {
        return this.getProperty(RES_AUTHOR);
    }

    @Override
    public void setAuthor(String authname) throws InvalidAttributeValueException {
        this.setProperty(RES_AUTHOR, authname);
    }

    @Override
    public String getDisplayName() {
        return this.getProperty(RES_DISPLAYNAME);
    }

    @Override
    public void setDisplayName(String dname) throws InvalidAttributeValueException {
        this.setProperty(RES_DISPLAYNAME, dname);
    }

    @Override
    public String getComment() {
        return this.getProperty(RES_COMMENT);
    }

    @Override
    public void setComment(String davcom) throws InvalidAttributeValueException {
        this.setProperty(RES_COMMENT, davcom);
    }

    @Override
    public String getLanguage() {
        return this.getProperty(RES_LANGUAGE);
    }

    @Override
    public void setLanguage(String lang) throws InvalidAttributeValueException {
        this.setProperty(RES_LANGUAGE, lang);
    }

    @Override
    public String getContentType() {
        return this.getProperty(RES_CONTENTTYPE);
    }

    @Override
    public void setContentType(String conttype) throws InvalidAttributeValueException {
        this.setProperty(RES_CONTENTTYPE, conttype);
    }

    @Override
    public int getVersionId() {
        int i;
        String s = this.getProperty(RES_VERSIONID);
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            i = 0;
        }
        return i;
    }

    @Override
    public void setVersionId(int versionId) throws InvalidAttributeValueException, XDBInvalidOperationException {
        throw new XDBInvalidOperationException("It is not allowed to change the version id of a resource.");
    }

    @Override
    public Document getContentXML() {
        long cstate = 0L;
        try {
            int conntype = XMLType.getConnType(this.m_conn);
            switch (conntype) {
                case 1: 
                case 2: {
                    cstate = this.getContentKprb(((XDBElement)this.m_resElem).toCState(), CONTENT_XML);
                    if (cstate != 0L) break;
                    return null;
                }
                case 0: {
                    return null;
                }
            }
        }
        catch (SQLException e) {
            return null;
        }
        return new XDBDocument(this.m_conn, cstate);
    }

    @Override
    public InputStream getContentBinary() {
        long strm_c_state = 0L;
        try {
            int conntype = XMLType.getConnType(this.m_conn);
            switch (conntype) {
                case 1: 
                case 2: {
                    strm_c_state = this.getContentKprb(((XDBElement)this.m_resElem).toCState(), CONTENT_BINARY);
                    if (strm_c_state != 0L) break;
                    return null;
                }
                case 0: {
                    return null;
                }
            }
            return new RealInputStream(this.m_conn, strm_c_state, 2);
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public void setContent(Object xmlobj) throws InvalidAttributeValueException, OperationNotSupportedException {
        XMLType xmlt = null;
        try {
            int conntype = XMLType.getConnType(this.m_conn);
            switch (conntype) {
                case 1: 
                case 2: {
                    if (!(xmlobj instanceof XMLType)) {
                        throw new OperationNotSupportedException("It is not allowed to set a non-XMLType content.");
                    }
                    xmlt = (XMLType)((Object)xmlobj);
                    this.setContentXmlKprb(((XDBElement)this.m_resElem).toCState(), xmlt.toCState(), CONTENT_XML);
                    break;
                }
                case 0: {
                    return;
                }
            }
        }
        catch (SQLException e) {
            return;
        }
    }

    @Override
    public String getACL() {
        if (this.m_resElem instanceof XDBElement) {
            return this.getACLNative(((XDBElement)this.m_resElem).toCState());
        }
        return null;
    }

    @Override
    public void setACL(String aclpath) throws InvalidAttributeValueException {
        if (!(this.m_resElem instanceof XDBElement)) {
            throw new InvalidAttributeValueException();
        }
        this.setACLNative(((XDBElement)this.m_resElem).toCState(), aclpath, true);
    }

    public void save() {
        if (this.m_resElem instanceof XDBElement) {
            this.saveNative(((XDBElement)this.m_resElem).toCState());
        }
    }

    @Override
    public int getSize() {
        if (this.m_resElem instanceof XDBElement) {
            return this.getSizeNative(((XDBElement)this.m_resElem).toCState());
        }
        return 0;
    }

    @Override
    public boolean isFolder() {
        long flags;
        try {
            flags = Long.parseLong(this.getProperty(RES_FLAGS));
        }
        catch (NumberFormatException e) {
            flags = 0L;
        }
        return (flags & (long)RES_FLAGS_CONTAINER) == (long)RES_FLAGS_CONTAINER;
    }

    public XMLType getCustomMetadata(String namespace, String name) {
        return null;
    }

    public void setCustomMetadata(String namespace, String name, XMLType newData) {
    }

    public boolean hasACLChanged() {
        if (this.m_resElem instanceof XDBElement) {
            return this.hasACLChangedNative(((XDBElement)this.m_resElem).toCState());
        }
        return false;
    }

    public boolean hasAuthorChanged() {
        return this.hasPropertyChanged(RES_AUTHOR);
    }

    public boolean hasCharacterSetChanged() {
        return this.hasPropertyChanged(RES_CHARSET);
    }

    public boolean hasCommentChanged() {
        return this.hasPropertyChanged(RES_COMMENT);
    }

    public boolean hasContentChanged() {
        if (this.m_resElem instanceof XDBElement) {
            return this.hasContentChangedNative(((XDBElement)this.m_resElem).toCState());
        }
        return false;
    }

    public boolean hasContentTypeChanged() {
        return this.hasPropertyChanged(RES_CONTENTTYPE);
    }

    public boolean hasCreationDateChanged() {
        return this.hasPropertyChanged(RES_CREATEDATE);
    }

    public boolean hasCreatorChanged() {
        return this.hasPropertyChanged(RES_CREATOR);
    }

    public boolean hasCustomMetadataChanged() {
        return this.hasPropertyChanged(RES_METADATA);
    }

    public boolean hasDisplayNameChanged() {
        return this.hasPropertyChanged(RES_DISPLAYNAME);
    }

    public boolean hasLanguageChanged() {
        return this.hasPropertyChanged(RES_LANGUAGE);
    }

    public boolean hasLastModifierChanged() {
        return this.hasPropertyChanged(RES_LAST_MOD);
    }

    public boolean hasModificationDateChanged() {
        return this.hasPropertyChanged(RES_MODDATE);
    }

    public boolean hasOwnerChanged() {
        return this.hasPropertyChanged(RES_OWNER);
    }

    public boolean hasRefCountChanged() {
        return this.hasPropertyChanged(RES_REF_COUNT);
    }

    public boolean hasVersionIdChanged() {
        return this.hasPropertyChanged(RES_VERSIONID);
    }

    public boolean hasChanged(String xpath, String namespace) {
        return this.hasChangedNative(((XDBElement)this.m_resElem).toCState(), xpath, namespace);
    }

    private boolean hasPropertyChanged(String propname) {
        XDBNodeList nl = ((XDBElement)this.m_resElem).getChildrenByTagName(propname);
        if (nl == null) {
            return false;
        }
        Node n = nl.item(0);
        if (n == null) {
            return false;
        }
        if ((n = n.getFirstChild()) == null) {
            return false;
        }
        return this.hasPropChangedNative(((XDBElement)this.m_resElem).toCState(), ((XDBNode)n).toCState());
    }

    private String getProperty(String propname) {
        XDBNodeList nl = ((XDBElement)this.m_resElem).getChildrenByTagName(propname);
        if (nl == null) {
            return null;
        }
        Node n = nl.item(0);
        if (n == null) {
            return null;
        }
        if ((n = n.getFirstChild()) == null) {
            return null;
        }
        return n.getNodeValue();
    }

    private void setProperty(String propname, String value) {
        Node n;
        if (!this.checkNoModifyNative(((XDBElement)this.m_resElem).toCState(), propname)) {
            return;
        }
        XDBNodeList nl = ((XDBElement)this.m_resElem).getChildrenByTagName(propname);
        if (nl != null && (n = nl.item(0)) != null) {
            if ((n = n.getFirstChild()) != null) {
                n.setNodeValue(value);
                return;
            }
            try {
                Text tnode = this.createTextNode(value);
                n.appendChild(tnode);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            Element e = this.createElementNS("http://xmlns.oracle.com/xdb/XDBResource.xsd", propname);
            Text tnode = this.createTextNode(value);
            e.appendChild(tnode);
            this.m_resElem.appendChild(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XDBResource(Connection conn, String abspath, long xobd) {
        super(conn, xobd);
        this.m_resElem = this.getDocumentElement();
        this.m_path = abspath;
    }

    XDBResource(XMLType resxmlt, Connection conn, String abspath) {
        super(resxmlt, conn, 0L);
        this.m_path = abspath;
    }
}

