"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderBars = void 0;
var canvas_1 = require("../../../../renderers/canvas");
var utils_1 = require("../../rendering/utils");
var rect_1 = require("./primitives/rect");
var bar_1 = require("./styles/bar");
var panel_transform_1 = require("./utils/panel_transform");
function renderBars(ctx, imgCanvas, barGeometries, sharedStyle, clippings, renderingArea, highlightedLegendItem, rotation) {
    canvas_1.withContext(ctx, function (ctx) {
        var barRenderer = renderPerPanelBars(ctx, imgCanvas, clippings, sharedStyle, renderingArea, highlightedLegendItem, rotation);
        barGeometries.forEach(barRenderer);
    });
}
exports.renderBars = renderBars;
function renderPerPanelBars(ctx, imgCanvas, clippings, sharedStyle, renderingArea, highlightedLegendItem, rotation) {
    if (rotation === void 0) { rotation = 0; }
    return function (_a) {
        var panel = _a.panel, bars = _a.value;
        if (bars.length === 0) {
            return;
        }
        panel_transform_1.withPanelTransform(ctx, panel, rotation, renderingArea, function (ctx) {
            bars.forEach(function (barGeometry) {
                var x = barGeometry.x, y = barGeometry.y, width = barGeometry.width, height = barGeometry.height, color = barGeometry.color, seriesStyle = barGeometry.seriesStyle, seriesIdentifier = barGeometry.seriesIdentifier;
                var geometryStateStyle = utils_1.getGeometryStateStyle(seriesIdentifier, sharedStyle, highlightedLegendItem);
                var _a = bar_1.buildBarStyles(ctx, imgCanvas, color, seriesStyle.rect, seriesStyle.rectBorder, geometryStateStyle), fill = _a.fill, stroke = _a.stroke;
                var rect = { x: x, y: y, width: width, height: height };
                canvas_1.withContext(ctx, function (ctx) {
                    rect_1.renderRect(ctx, rect, fill, stroke);
                });
            });
        }, { area: clippings, shouldClip: true });
    };
}
//# sourceMappingURL=bars.js.map