/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.IpSource;
import software.amazon.awssdk.services.ec2.model.Ipv6AddressAttribute;
import software.amazon.awssdk.services.ec2.model.SubnetCidrBlockState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubnetIpv6CidrBlockAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubnetIpv6CidrBlockAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(SubnetIpv6CidrBlockAssociation.getter(SubnetIpv6CidrBlockAssociation::associationId)).setter(SubnetIpv6CidrBlockAssociation.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").unmarshallLocationName("associationId").build()}).build();
    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6CidrBlock").getter(SubnetIpv6CidrBlockAssociation.getter(SubnetIpv6CidrBlockAssociation::ipv6CidrBlock)).setter(SubnetIpv6CidrBlockAssociation.setter(Builder::ipv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock").unmarshallLocationName("ipv6CidrBlock").build()}).build();
    private static final SdkField<SubnetCidrBlockState> IPV6_CIDR_BLOCK_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ipv6CidrBlockState").getter(SubnetIpv6CidrBlockAssociation.getter(SubnetIpv6CidrBlockAssociation::ipv6CidrBlockState)).setter(SubnetIpv6CidrBlockAssociation.setter(Builder::ipv6CidrBlockState)).constructor(SubnetCidrBlockState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockState").unmarshallLocationName("ipv6CidrBlockState").build()}).build();
    private static final SdkField<String> IPV6_ADDRESS_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6AddressAttribute").getter(SubnetIpv6CidrBlockAssociation.getter(SubnetIpv6CidrBlockAssociation::ipv6AddressAttributeAsString)).setter(SubnetIpv6CidrBlockAssociation.setter(Builder::ipv6AddressAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressAttribute").unmarshallLocationName("ipv6AddressAttribute").build()}).build();
    private static final SdkField<String> IP_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpSource").getter(SubnetIpv6CidrBlockAssociation.getter(SubnetIpv6CidrBlockAssociation::ipSourceAsString)).setter(SubnetIpv6CidrBlockAssociation.setter(Builder::ipSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpSource").unmarshallLocationName("ipSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, IPV6_CIDR_BLOCK_FIELD, IPV6_CIDR_BLOCK_STATE_FIELD, IPV6_ADDRESS_ATTRIBUTE_FIELD, IP_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubnetIpv6CidrBlockAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String ipv6CidrBlock;
    private final SubnetCidrBlockState ipv6CidrBlockState;
    private final String ipv6AddressAttribute;
    private final String ipSource;

    private SubnetIpv6CidrBlockAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.ipv6CidrBlockState = builder.ipv6CidrBlockState;
        this.ipv6AddressAttribute = builder.ipv6AddressAttribute;
        this.ipSource = builder.ipSource;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public final SubnetCidrBlockState ipv6CidrBlockState() {
        return this.ipv6CidrBlockState;
    }

    public final Ipv6AddressAttribute ipv6AddressAttribute() {
        return Ipv6AddressAttribute.fromValue(this.ipv6AddressAttribute);
    }

    public final String ipv6AddressAttributeAsString() {
        return this.ipv6AddressAttribute;
    }

    public final IpSource ipSource() {
        return IpSource.fromValue(this.ipSource);
    }

    public final String ipSourceAsString() {
        return this.ipSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlockState());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6AddressAttributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSourceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetIpv6CidrBlockAssociation)) {
            return false;
        }
        SubnetIpv6CidrBlockAssociation other = (SubnetIpv6CidrBlockAssociation)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.ipv6CidrBlock(), other.ipv6CidrBlock()) && Objects.equals(this.ipv6CidrBlockState(), other.ipv6CidrBlockState()) && Objects.equals(this.ipv6AddressAttributeAsString(), other.ipv6AddressAttributeAsString()) && Objects.equals(this.ipSourceAsString(), other.ipSourceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SubnetIpv6CidrBlockAssociation").add("AssociationId", (Object)this.associationId()).add("Ipv6CidrBlock", (Object)this.ipv6CidrBlock()).add("Ipv6CidrBlockState", (Object)this.ipv6CidrBlockState()).add("Ipv6AddressAttribute", (Object)this.ipv6AddressAttributeAsString()).add("IpSource", (Object)this.ipSourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "Ipv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlock()));
            }
            case "Ipv6CidrBlockState": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlockState()));
            }
            case "Ipv6AddressAttribute": {
                return Optional.ofNullable(clazz.cast(this.ipv6AddressAttributeAsString()));
            }
            case "IpSource": {
                return Optional.ofNullable(clazz.cast(this.ipSourceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("Ipv6CidrBlock", IPV6_CIDR_BLOCK_FIELD);
        map.put("Ipv6CidrBlockState", IPV6_CIDR_BLOCK_STATE_FIELD);
        map.put("Ipv6AddressAttribute", IPV6_ADDRESS_ATTRIBUTE_FIELD);
        map.put("IpSource", IP_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubnetIpv6CidrBlockAssociation, T> g) {
        return obj -> g.apply((SubnetIpv6CidrBlockAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String ipv6CidrBlock;
        private SubnetCidrBlockState ipv6CidrBlockState;
        private String ipv6AddressAttribute;
        private String ipSource;

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetIpv6CidrBlockAssociation model) {
            this.associationId(model.associationId);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.ipv6CidrBlockState(model.ipv6CidrBlockState);
            this.ipv6AddressAttribute(model.ipv6AddressAttribute);
            this.ipSource(model.ipSource);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final SubnetCidrBlockState.Builder getIpv6CidrBlockState() {
            return this.ipv6CidrBlockState != null ? this.ipv6CidrBlockState.toBuilder() : null;
        }

        public final void setIpv6CidrBlockState(SubnetCidrBlockState.BuilderImpl ipv6CidrBlockState) {
            this.ipv6CidrBlockState = ipv6CidrBlockState != null ? ipv6CidrBlockState.build() : null;
        }

        @Override
        public final Builder ipv6CidrBlockState(SubnetCidrBlockState ipv6CidrBlockState) {
            this.ipv6CidrBlockState = ipv6CidrBlockState;
            return this;
        }

        public final String getIpv6AddressAttribute() {
            return this.ipv6AddressAttribute;
        }

        public final void setIpv6AddressAttribute(String ipv6AddressAttribute) {
            this.ipv6AddressAttribute = ipv6AddressAttribute;
        }

        @Override
        public final Builder ipv6AddressAttribute(String ipv6AddressAttribute) {
            this.ipv6AddressAttribute = ipv6AddressAttribute;
            return this;
        }

        @Override
        public final Builder ipv6AddressAttribute(Ipv6AddressAttribute ipv6AddressAttribute) {
            this.ipv6AddressAttribute(ipv6AddressAttribute == null ? null : ipv6AddressAttribute.toString());
            return this;
        }

        public final String getIpSource() {
            return this.ipSource;
        }

        public final void setIpSource(String ipSource) {
            this.ipSource = ipSource;
        }

        @Override
        public final Builder ipSource(String ipSource) {
            this.ipSource = ipSource;
            return this;
        }

        @Override
        public final Builder ipSource(IpSource ipSource) {
            this.ipSource(ipSource == null ? null : ipSource.toString());
            return this;
        }

        public SubnetIpv6CidrBlockAssociation build() {
            return new SubnetIpv6CidrBlockAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubnetIpv6CidrBlockAssociation> {
        public Builder associationId(String var1);

        public Builder ipv6CidrBlock(String var1);

        public Builder ipv6CidrBlockState(SubnetCidrBlockState var1);

        default public Builder ipv6CidrBlockState(Consumer<SubnetCidrBlockState.Builder> ipv6CidrBlockState) {
            return this.ipv6CidrBlockState((SubnetCidrBlockState)((SubnetCidrBlockState.Builder)SubnetCidrBlockState.builder().applyMutation(ipv6CidrBlockState)).build());
        }

        public Builder ipv6AddressAttribute(String var1);

        public Builder ipv6AddressAttribute(Ipv6AddressAttribute var1);

        public Builder ipSource(String var1);

        public Builder ipSource(IpSource var1);
    }
}

