/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ProcessCpuStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ProcessCpuStats> {
    private final double percent;
    @Nullable
    private final Time total;
    private final long totalInMillis;
    public static final JsonpDeserializer<ProcessCpuStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ProcessCpuStats::setupProcessCpuStatsDeserializer);

    private ProcessCpuStats(Builder builder) {
        this.percent = ApiTypeHelper.requireNonNull(builder.percent, this, "percent");
        this.total = builder.total;
        this.totalInMillis = ApiTypeHelper.requireNonNull(builder.totalInMillis, this, "totalInMillis");
    }

    public static ProcessCpuStats of(Function<Builder, ObjectBuilder<ProcessCpuStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double percent() {
        return this.percent;
    }

    @Nullable
    public final Time total() {
        return this.total;
    }

    public final long totalInMillis() {
        return this.totalInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("percent");
        generator.write(this.percent);
        if (this.total != null) {
            generator.writeKey("total");
            this.total.serialize(generator, mapper);
        }
        generator.writeKey("total_in_millis");
        generator.write(this.totalInMillis);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupProcessCpuStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::percent, JsonpDeserializer.doubleDeserializer(), "percent");
        op.add(Builder::total, Time._DESERIALIZER, "total");
        op.add(Builder::totalInMillis, JsonpDeserializer.longDeserializer(), "total_in_millis");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Double.hashCode(this.percent);
        result = 31 * result + Objects.hashCode(this.total);
        result = 31 * result + Long.hashCode(this.totalInMillis);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessCpuStats other = (ProcessCpuStats)o;
        return this.percent == other.percent && Objects.equals(this.total, other.total) && this.totalInMillis == other.totalInMillis;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ProcessCpuStats> {
        private Double percent;
        @Nullable
        private Time total;
        private Long totalInMillis;

        public Builder() {
        }

        private Builder(ProcessCpuStats o) {
            this.percent = o.percent;
            this.total = o.total;
            this.totalInMillis = o.totalInMillis;
        }

        private Builder(Builder o) {
            this.percent = o.percent;
            this.total = o.total;
            this.totalInMillis = o.totalInMillis;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder percent(double value) {
            this.percent = value;
            return this;
        }

        @Nonnull
        public final Builder total(@Nullable Time value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public final Builder total(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.total(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder totalInMillis(long value) {
            this.totalInMillis = value;
            return this;
        }

        @Override
        @Nonnull
        public ProcessCpuStats build() {
            this._checkSingleUse();
            return new ProcessCpuStats(this);
        }
    }
}

