/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wsaddressing.messaging.impl;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.AbstractHeaderGeneratingMessageHandler;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.wsaddressing.MessageID;
import org.opensaml.soap.wsaddressing.messaging.WSAddressingContext;
import org.slf4j.Logger;

public class AddMessageIDHandler
extends AbstractHeaderGeneratingMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddMessageIDHandler.class);
    @Nullable
    private IdentifierGenerationStrategy identifierGenerationStrategy;

    @Nullable
    public IdentifierGenerationStrategy getIdentifierGenerationStrategy() {
        return this.identifierGenerationStrategy;
    }

    public void setIdentifierGenerationStrategy(@Nullable IdentifierGenerationStrategy strategy) {
        this.checkSetterPreconditions();
        this.identifierGenerationStrategy = strategy;
    }

    @Override
    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        String id = this.getMessageID(messageContext);
        this.log.debug("Issuing WS-Addressing MessageID: {}", (Object)id);
        MessageID messageID = (MessageID)XMLObjectSupport.buildXMLObject(MessageID.ELEMENT_NAME);
        messageID.setURI(id);
        this.decorateGeneratedHeader(messageContext, messageID);
        SOAPMessagingSupport.addHeaderBlock(messageContext, messageID);
    }

    @Nonnull
    protected String getMessageID(MessageContext messageContext) {
        String id;
        WSAddressingContext addressing = messageContext.getSubcontext(WSAddressingContext.class);
        String string = id = addressing != null ? addressing.getMessageIDURI() : null;
        if (id != null) {
            return id;
        }
        if (this.identifierGenerationStrategy != null) {
            return this.identifierGenerationStrategy.generateIdentifier(false);
        }
        return "urn:uuid:" + UUID.randomUUID().toString();
    }
}

