# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "lab custom-image create",
    is_preview=True,
)
class Create(AAZCommand):
    """Create an existing custom image. This operation can take a while to complete.

    :example: Create a custom image in the lab from a running Windows virtual machine without applying sysprep.
        az lab custom-image create --lab-name {LabName} -g {ResourceGroup} --name {VMName} --os-type Windows --os-state NonSysprepped --source-vm-id "/subscriptions/{SubID}/resourcegroups/{ResourceGroup}/providers/microsoft.devtestlab/labs/{LabName}/virtualmachines/{VMName}"
    """

    _aaz_info = {
        "version": "2018-09-15",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.devtestlab/labs/{}/customimages/{}", "2018-09-15"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.lab_name = AAZStrArg(
            options=["--lab-name"],
            help="The name of the lab.",
            required=True,
        )
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The name of the custom image.",
            required=True,
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.author = AAZStrArg(
            options=["--author"],
            help="The author of the custom image.",
        )
        _args_schema.description = AAZStrArg(
            options=["--description"],
            help="The description of the custom image.",
        )

        # define Arg Group "CustomImage"

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.vm = AAZObjectArg(
            options=["--vm"],
            arg_group="Properties",
            help="The virtual machine from which the image is to be created.",
        )

        vm = cls._args_schema.vm
        vm.linux_os_info = AAZObjectArg(
            options=["linux-os-info"],
            help="The Linux OS information of the VM.",
        )
        vm.source_vm_id = AAZStrArg(
            options=["source-vm-id"],
            help="The source vm identifier.",
        )
        vm.windows_os_info = AAZObjectArg(
            options=["windows-os-info"],
            help="The Windows OS information of the VM.",
        )

        linux_os_info = cls._args_schema.vm.linux_os_info
        linux_os_info.linux_os_state = AAZStrArg(
            options=["linux-os-state"],
            help="The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied).",
            enum={"DeprovisionApplied": "DeprovisionApplied", "DeprovisionRequested": "DeprovisionRequested", "NonDeprovisioned": "NonDeprovisioned"},
        )

        windows_os_info = cls._args_schema.vm.windows_os_info
        windows_os_info.windows_os_state = AAZStrArg(
            options=["windows-os-state"],
            help="The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied).",
            enum={"NonSysprepped": "NonSysprepped", "SysprepApplied": "SysprepApplied", "SysprepRequested": "SysprepRequested"},
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        yield self.CustomImagesCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class CustomImagesCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/customimages/{name}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "labName", self.ctx.args.lab_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "name", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2018-09-15",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("properties", AAZObjectType, ".", typ_kwargs={"flags": {"required": True, "client_flatten": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("author", AAZStrType, ".author")
                properties.set_prop("description", AAZStrType, ".description")
                properties.set_prop("vm", AAZObjectType, ".vm")

            vm = _builder.get(".properties.vm")
            if vm is not None:
                vm.set_prop("linuxOsInfo", AAZObjectType, ".linux_os_info")
                vm.set_prop("sourceVmId", AAZStrType, ".source_vm_id")
                vm.set_prop("windowsOsInfo", AAZObjectType, ".windows_os_info")

            linux_os_info = _builder.get(".properties.vm.linuxOsInfo")
            if linux_os_info is not None:
                linux_os_info.set_prop("linuxOsState", AAZStrType, ".linux_os_state")

            windows_os_info = _builder.get(".properties.vm.windowsOsInfo")
            if windows_os_info is not None:
                windows_os_info.set_prop("windowsOsState", AAZStrType, ".windows_os_state")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()

            _schema_on_200_201 = cls._schema_on_200_201
            _schema_on_200_201.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.location = AAZStrType()
            _schema_on_200_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.properties = AAZObjectType(
                flags={"required": True, "client_flatten": True},
            )
            _schema_on_200_201.tags = AAZDictType()
            _schema_on_200_201.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties
            properties.author = AAZStrType()
            properties.creation_date = AAZStrType(
                serialized_name="creationDate",
                flags={"read_only": True},
            )
            properties.custom_image_plan = AAZObjectType(
                serialized_name="customImagePlan",
            )
            properties.data_disk_storage_info = AAZListType(
                serialized_name="dataDiskStorageInfo",
            )
            properties.description = AAZStrType()
            properties.is_plan_authorized = AAZBoolType(
                serialized_name="isPlanAuthorized",
            )
            properties.managed_image_id = AAZStrType(
                serialized_name="managedImageId",
            )
            properties.managed_snapshot_id = AAZStrType(
                serialized_name="managedSnapshotId",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.unique_identifier = AAZStrType(
                serialized_name="uniqueIdentifier",
                flags={"read_only": True},
            )
            properties.vhd = AAZObjectType()
            properties.vm = AAZObjectType()

            custom_image_plan = cls._schema_on_200_201.properties.custom_image_plan
            custom_image_plan.id = AAZStrType()
            custom_image_plan.offer = AAZStrType()
            custom_image_plan.publisher = AAZStrType()

            data_disk_storage_info = cls._schema_on_200_201.properties.data_disk_storage_info
            data_disk_storage_info.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.data_disk_storage_info.Element
            _element.lun = AAZStrType()
            _element.storage_type = AAZStrType(
                serialized_name="storageType",
            )

            vhd = cls._schema_on_200_201.properties.vhd
            vhd.image_name = AAZStrType(
                serialized_name="imageName",
            )
            vhd.os_type = AAZStrType(
                serialized_name="osType",
                flags={"required": True},
            )
            vhd.sys_prep = AAZBoolType(
                serialized_name="sysPrep",
            )

            vm = cls._schema_on_200_201.properties.vm
            vm.linux_os_info = AAZObjectType(
                serialized_name="linuxOsInfo",
            )
            vm.source_vm_id = AAZStrType(
                serialized_name="sourceVmId",
            )
            vm.windows_os_info = AAZObjectType(
                serialized_name="windowsOsInfo",
            )

            linux_os_info = cls._schema_on_200_201.properties.vm.linux_os_info
            linux_os_info.linux_os_state = AAZStrType(
                serialized_name="linuxOsState",
            )

            windows_os_info = cls._schema_on_200_201.properties.vm.windows_os_info
            windows_os_info.windows_os_state = AAZStrType(
                serialized_name="windowsOsState",
            )

            tags = cls._schema_on_200_201.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200_201


class _CreateHelper:
    """Helper class for Create"""


__all__ = ["Create"]
