import { bindSourceFile } from "../binder.js";
import { checkSourceFile } from "../checker.js";
import { Parser } from "../index.js";
import { executeCommand, getAvailableCommands, getCodeActions } from "./codeAction.js";
import { getColorRepresentations, getDocumentColors } from "./colorProvider.js";
import { getCompletions } from "./completion.js";
import { hover } from "./hover.js";
import { findDefinition, findReferences } from "./reference.js";
import { renameSymbol } from "./rename.js";
import { validateDocument } from "./validation.js";
function parseDocument(doc) {
    const parser = new Parser();
    const content = typeof doc === "string" ? doc : doc.getText();
    const sourceFile = parser.parse(content);
    bindSourceFile(sourceFile);
    checkSourceFile(sourceFile);
    return sourceFile;
}
export function createService() {
    return {
        parseDocument,
        validateDocument,
        hover,
        findReferences,
        findDefinition,
        renameSymbol,
        getCompletions,
        getDocumentColors,
        getColorRepresentations,
        getCodeActions,
        executeCommand,
        getAvailableCommands,
    };
}
//# sourceMappingURL=service.js.map