/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.MapTransform;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.panel.FreeColImageBorder;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.PropertyList;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public final class InfoPanel
extends FreeColPanel
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(InfoPanel.class.getName());
    private static final int TEXT_WIDTH = 150;
    private static final int SLACK = 5;
    private static final int PRODUCTION = 4;
    public static final Dimension PREFERRED_SIZE = new Dimension(250, 138);
    private final ImageLibrary lib;
    private Font font;
    private Image skin;
    private final MouseAdapter mouseAdapter;
    private InfoPanelMode mode = InfoPanelMode.NONE;
    private MapTransform mapTransform = null;
    private Tile tile = null;
    private Unit unit = null;
    private boolean useSkin;

    public InfoPanel(FreeColClient freeColClient) {
        this(freeColClient, true);
    }

    public InfoPanel(FreeColClient freeColClient, boolean useSkin) {
        super(freeColClient, null, null);
        this.lib = freeColClient.getGUI().getFixedImageLibrary();
        this.useSkin = useSkin;
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Tile tile = InfoPanel.this.getTile();
                if (tile != null) {
                    InfoPanel.this.getGUI().setFocus(tile);
                }
            }
        };
    }

    public void updateLayoutIfNeeded(boolean newUseSkin) {
        BufferedImage newSkin;
        Font newFont = this.lib.getScaledFont("normal-plain-tiny", null);
        BufferedImage bufferedImage = newSkin = newUseSkin ? this.lib.getScaledImage("image.skin.InfoPanel") : null;
        if (this.useSkin == newUseSkin && newFont == this.font && newSkin == this.skin) {
            return;
        }
        this.font = newFont;
        this.skin = newSkin;
        this.useSkin = newUseSkin;
        if (this.skin != null) {
            this.setBorder(null);
            this.setSize(this.skin.getWidth(null), this.skin.getHeight(null));
            this.setOpaque(false);
        } else if (!this.useSkin) {
            this.setSize(this.lib.scale(PREFERRED_SIZE));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setOpaque(true);
        } else {
            this.setSize(this.lib.scale(PREFERRED_SIZE));
            this.setBorder(FreeColImageBorder.panelWithoutShadowBorder);
            this.setOpaque(true);
        }
    }

    private MigPanel newPanel(LayoutManager layout) {
        MigPanel panel = new MigPanel(layout);
        panel.setSize(new Dimension((int)((double)this.getWidth() * 0.8), (int)((double)this.getHeight() * 0.6)));
        return panel;
    }

    private void setPanel(MigPanel panel) {
        panel.addMouseListener(this.mouseAdapter);
        if (this.skin != null) {
            panel.setOpaque(false);
            PropertyList pl = ResourceManager.getPropertyList("image.skin.InfoPanel.properties");
            panel.setLocation(this.lib.scaleInt(pl.getInt("panel.x")), this.lib.scaleInt(pl.getInt("panel.y")));
            panel.setSize(this.lib.scaleInt(pl.getInt("panel.width")), this.lib.scaleInt(pl.getInt("panel.height")));
        } else {
            int y = (this.getHeight() - panel.getHeight()) / 2;
            int x = (this.getWidth() - panel.getWidth()) / 2;
            panel.setSize(this.lib.scale(PREFERRED_SIZE));
            panel.setLocation(0, 0);
        }
        this.removeAll();
        this.add(panel);
        this.revalidate();
        this.repaint();
    }

    private Tile getTile() {
        switch (this.mode) {
            case TILE: {
                return this.tile;
            }
            case UNIT: {
                return this.unit == null ? null : this.unit.getTile();
            }
        }
        return null;
    }

    private InfoPanelMode changeMode(InfoPanelMode newMode) {
        InfoPanelMode oldMode = this.mode;
        if (oldMode != newMode) {
            switch (oldMode) {
                case MAP: {
                    this.mapTransform = null;
                    break;
                }
                case TILE: {
                    this.tile = null;
                    break;
                }
                case UNIT: {
                    this.unit.removePropertyChangeListener(this);
                    GoodsContainer gc = this.unit.getGoodsContainer();
                    if (gc != null) {
                        gc.removePropertyChangeListener(this);
                    }
                    this.unit = null;
                    break;
                }
            }
            this.mode = newMode;
        }
        return oldMode;
    }

    private void fillEndPanel() {
        MigPanel panel = this.newPanel(new MigLayout("wrap 1, center", "[center]", ""));
        String labelString = Messages.message("infoPanel.endTurn");
        int width = (int)(0.3 * (double)this.getWidth());
        panel.add(new JLabel(""));
        for (String s : StringUtils.splitText(labelString, " /", this.getFontMetrics(this.font), width)) {
            JLabel label = new JLabel(s);
            label.setFont(this.font);
            panel.add(label);
        }
        JButton button = new JButton(this.getFreeColClient().getActionManager().getFreeColAction("endTurnAction"));
        button.setFont(this.font);
        panel.add(button);
        this.setPanel(panel);
    }

    private MapTransform fillMapPanel(MapTransform mapTransform) {
        JPanel p;
        MigPanel panel = this.newPanel(new BorderLayout());
        JPanel jPanel = p = mapTransform == null ? null : mapTransform.getDescriptionPanel();
        if (p != null) {
            p.setOpaque(false);
            Dimension d = p.getPreferredSize();
            p.setBounds(0, (this.getHeight() - d.height) / 2, this.getWidth(), d.height);
            panel.add((Component)p, "Center");
        }
        this.setPanel(panel);
        return mapTransform;
    }

    private Tile fillTilePanel(Tile tile) {
        MigPanel panel = this.newPanel(new MigLayout("fill, wrap 5, gap 1 1", "", ""));
        if (tile != null) {
            BufferedImage image = this.getGUI().createTileImageWithBeachBorderAndItems(tile);
            if (tile.isExplored()) {
                JLabel label;
                int width = panel.getWidth() - 5;
                String text = Messages.message(tile.getLabel());
                for (String s : StringUtils.splitText(text, " /", this.getFontMetrics(this.font), width)) {
                    label = new JLabel(s);
                    label.setFont(this.font);
                    panel.add((Component)label, "span, align center");
                }
                panel.add((Component)new JLabel(new ImageIcon(image)), "spany");
                Player owner = tile.getOwner();
                if (owner == null) {
                    panel.add((Component)new JLabel(), "span 4");
                } else {
                    StringTemplate t = owner.getNationLabel();
                    label = Utility.localizedLabel(t);
                    label.setFont(this.font);
                    panel.add((Component)label, "span 4");
                }
                JLabel defenceLabel = Utility.localizedLabel(StringTemplate.template("infoPanel.defenseBonus").addAmount("%bonus%", tile.getDefenceBonusPercentage()));
                defenceLabel.setFont(this.font);
                panel.add((Component)defenceLabel, "span 4");
                JLabel moveLabel = Utility.localizedLabel(StringTemplate.template("infoPanel.movementCost").addAmount("%cost%", tile.getType().getBasicMoveCost() / 3));
                moveLabel.setFont(this.font);
                this.add((Component)moveLabel, "span 4");
                List<AbstractGoods> produce = CollectionUtils.sort(tile.getType().getPossibleProduction(true), AbstractGoods.descendingAmountComparator);
                if (produce.isEmpty()) {
                    panel.add((Component)new JLabel(), "span 4");
                } else {
                    for (AbstractGoods ag : produce) {
                        GoodsType type = ag.getType();
                        int n = tile.getPotentialProduction(type, null);
                        JLabel label2 = new JLabel(String.valueOf(n), new ImageIcon(this.lib.getSmallGoodsTypeImage(type)), 4);
                        label2.setToolTipText(Messages.getName(type));
                        label2.setFont(this.font);
                        panel.add(label2);
                    }
                }
            } else {
                panel.add((Component)Utility.localizedLabel("unexplored"), "span, align center");
                panel.add((Component)new JLabel(new ImageIcon(image)), "spany");
            }
        }
        this.setPanel(panel);
        return tile;
    }

    private static void addLabels(JPanel panel, List<JLabel> labels, int max) {
        int n;
        while ((n = Math.min(max, labels.size())) > 0) {
            if (n == 1) {
                panel.add(labels.get(0));
                break;
            }
            panel.add((Component)labels.remove(0), "split " + n);
            for (int i = 1; i < n; ++i) {
                panel.add(labels.remove(0));
            }
        }
    }

    private Unit fillUnitPanel(Unit unit) {
        JLabel textLabel;
        ImageIcon ii = new ImageIcon(this.lib.getScaledUnitImage(unit));
        int width = ii.getIconWidth();
        MigPanel panel = this.newPanel(new MigLayout("wrap 2, fill, gap 0 0", "[" + width + "][fill]", ""));
        panel.add((Component)new JLabel(ii), "spany, center");
        Object text = unit.getDescription(Unit.UnitLabelType.FULL);
        for (String s : StringUtils.splitText((String)text, " /", this.getFontMetrics(this.font), panel.getWidth() - width)) {
            textLabel = new JLabel(s);
            textLabel.setFont(this.font);
            panel.add(textLabel);
        }
        text = unit.isInEurope() ? Messages.getName(unit.getOwner().getEurope()) : Messages.message("infoPanel.moves") + " " + unit.getMovesAsString();
        textLabel = new JLabel((String)text);
        textLabel.setFont(this.font);
        panel.add(textLabel);
        if (unit.isCarrier()) {
            JLabel label;
            ImageIcon icon;
            ArrayList<JLabel> labels = new ArrayList<JLabel>();
            for (Unit carriedUnit : unit.getUnitList()) {
                icon = new ImageIcon(this.lib.getSmallerUnitImage(carriedUnit));
                label = new JLabel(icon);
                text = carriedUnit.getDescription(Unit.UnitLabelType.NATIONAL);
                label.setFont(this.font);
                label.setToolTipText((String)text);
                labels.add(label);
            }
            InfoPanel.addLabels(panel, labels, 6);
            labels.clear();
            for (Goods goods : unit.getGoodsList()) {
                int amount = goods.getAmount();
                GoodsType gt = goods.getType();
                icon = new ImageIcon(this.lib.getSmallerGoodsTypeImage(gt));
                label = new JLabel(String.valueOf(amount), icon, 0);
                text = Messages.message(goods.getLabel(true));
                label.setFont(this.font);
                label.setToolTipText((String)text);
                labels.add(label);
            }
            InfoPanel.addLabels(panel, labels, 3);
        }
        panel.add((Component)new JLabel(""), "growy");
        this.setPanel(panel);
        return unit;
    }

    public void update() {
        if (this.getFreeColClient().isMapEditor()) {
            this.changeMode(InfoPanelMode.NONE);
            this.removeAll();
            this.revalidate();
            this.repaint();
        } else {
            boolean updated = false;
            InfoPanelMode oldMode = this.changeMode(InfoPanelMode.END);
            if (oldMode != InfoPanelMode.END) {
                this.fillEndPanel();
                updated = true;
            }
            logger.info("InfoPanel " + (updated ? "updated " : "maintained ") + oldMode + " -> " + this.mode);
        }
    }

    public void update(MapTransform mapTransform) {
        boolean updated = false;
        InfoPanelMode oldMode = this.changeMode(InfoPanelMode.MAP);
        if (oldMode != InfoPanelMode.MAP || mapTransform != this.mapTransform) {
            this.mapTransform = this.fillMapPanel(mapTransform);
            updated = true;
        }
        logger.info("InfoPanel " + (updated ? "updated " : "maintained ") + oldMode + " -> " + this.mode + " with " + mapTransform);
    }

    public void update(Tile tile) {
        boolean updated = false;
        InfoPanelMode oldMode = this.changeMode(InfoPanelMode.TILE);
        if (oldMode != InfoPanelMode.TILE || tile != this.tile) {
            this.tile = this.fillTilePanel(tile);
            updated = true;
        }
        logger.info("InfoPanel " + (updated ? "updated " : "maintained ") + oldMode + " -> " + this.mode + " with tile " + tile);
    }

    public void update(Unit unit) {
        if (unit == null) {
            this.update();
            return;
        }
        boolean updated = false;
        InfoPanelMode oldMode = this.changeMode(InfoPanelMode.UNIT);
        if (unit != this.unit) {
            GoodsContainer gc;
            if (this.unit != null) {
                this.unit.removePropertyChangeListener(this);
                gc = this.unit.getGoodsContainer();
                if (gc != null) {
                    gc.removePropertyChangeListener(this);
                }
            }
            unit.addPropertyChangeListener(this);
            gc = unit.getGoodsContainer();
            if (gc != null) {
                gc.addPropertyChangeListener(this);
            }
        }
        this.unit = this.fillUnitPanel(unit);
        updated = true;
        logger.info("InfoPanel " + (updated ? "updated " : "maintained ") + oldMode + " -> " + this.mode + " with unit " + unit);
    }

    public void refresh() {
        switch (this.mode) {
            case END: {
                this.fillEndPanel();
                break;
            }
            case MAP: {
                this.fillMapPanel(this.mapTransform);
                break;
            }
            case TILE: {
                this.fillTilePanel(this.tile);
                break;
            }
            case UNIT: {
                this.fillUnitPanel(this.unit);
                break;
            }
        }
    }

    @Override
    public SwingGUI.PopupPosition getFramePopupPosition() {
        return SwingGUI.PopupPosition.LOWER_RIGHT;
    }

    @Override
    public String getFrameTitle() {
        return Messages.message("infoPanel.title");
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.skin != null) {
            graphics.drawImage(this.skin, 0, 0, null);
        }
        super.paintComponent(graphics);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.refresh();
    }

    private static enum InfoPanelMode {
        NONE,
        END,
        MAP,
        TILE,
        UNIT;

    }
}

