/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow;

import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.ScalableSurface;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import com.jogamp.nativewindow.UpstreamSurfaceHookMutableSize;
import jogamp.nativewindow.ProxySurfaceImpl;
import jogamp.nativewindow.SurfaceScaleUtils;

public class WrappedSurface
extends ProxySurfaceImpl
implements ScalableSurface {
    private final float[] hasPixelScale = new float[]{1.0f, 1.0f};
    private long surfaceHandle;

    public WrappedSurface(AbstractGraphicsConfiguration abstractGraphicsConfiguration, long l, int n, int n2, boolean bl) {
        super(abstractGraphicsConfiguration, new UpstreamSurfaceHookMutableSize(n, n2), bl);
        this.surfaceHandle = l;
    }

    public WrappedSurface(AbstractGraphicsConfiguration abstractGraphicsConfiguration, long l, UpstreamSurfaceHook upstreamSurfaceHook, boolean bl) {
        super(abstractGraphicsConfiguration, upstreamSurfaceHook, bl);
        this.surfaceHandle = l;
    }

    @Override
    protected void invalidateImpl() {
        this.surfaceHandle = 0L;
        this.hasPixelScale[0] = 1.0f;
        this.hasPixelScale[1] = 1.0f;
    }

    @Override
    public final long getSurfaceHandle() {
        return this.surfaceHandle;
    }

    @Override
    public final void setSurfaceHandle(long l) {
        this.surfaceHandle = l;
    }

    @Override
    protected final int lockSurfaceImpl() {
        return 3;
    }

    @Override
    protected final void unlockSurfaceImpl() {
    }

    protected final float getPixelScaleX() {
        return this.hasPixelScale[0];
    }

    protected final float getPixelScaleY() {
        return this.hasPixelScale[1];
    }

    @Override
    public final int[] convertToWindowUnits(int[] nArray) {
        return SurfaceScaleUtils.scaleInv(nArray, nArray, this.hasPixelScale);
    }

    @Override
    public final int[] convertToPixelUnits(int[] nArray) {
        return SurfaceScaleUtils.scale(nArray, nArray, this.hasPixelScale);
    }

    @Override
    public final boolean canSetSurfaceScale() {
        return false;
    }

    @Override
    public final boolean setSurfaceScale(float[] fArray) {
        boolean bl = this.hasPixelScale[0] != fArray[0] || this.hasPixelScale[1] != fArray[1];
        System.arraycopy(fArray, 0, this.hasPixelScale, 0, 2);
        return bl;
    }

    @Override
    public final float[] getRequestedSurfaceScale(float[] fArray) {
        System.arraycopy(this.hasPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public final float[] getCurrentSurfaceScale(float[] fArray) {
        System.arraycopy(this.hasPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public float[] getMinimumSurfaceScale(float[] fArray) {
        System.arraycopy(this.hasPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public final float[] getMaximumSurfaceScale(float[] fArray) {
        System.arraycopy(this.hasPixelScale, 0, fArray, 0, 2);
        return fArray;
    }
}

