/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.origin;

import java.time.Duration;
import org.gradle.internal.hash.HashCode;

public class OriginMetadata {
    private final String buildInvocationId;
    private final HashCode buildCacheKey;
    private final Duration executionTime;

    public OriginMetadata(String buildInvocationId, HashCode buildCacheKey, Duration executionTime) {
        this.buildInvocationId = buildInvocationId;
        this.buildCacheKey = buildCacheKey;
        this.executionTime = executionTime;
    }

    public String getBuildInvocationId() {
        return this.buildInvocationId;
    }

    public HashCode getBuildCacheKey() {
        return this.buildCacheKey;
    }

    public Duration getExecutionTime() {
        return this.executionTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OriginMetadata that = (OriginMetadata)o;
        if (!this.buildInvocationId.equals(that.buildInvocationId)) {
            return false;
        }
        if (!this.buildCacheKey.equals((Object)that.buildCacheKey)) {
            return false;
        }
        return this.executionTime.equals(that.executionTime);
    }

    public int hashCode() {
        int result = this.buildInvocationId.hashCode();
        result = 31 * result + this.buildCacheKey.hashCode();
        result = 31 * result + this.executionTime.hashCode();
        return result;
    }

    public String toString() {
        return "OriginMetadata{buildInvocationId=" + this.buildInvocationId + ", buildCacheKey=" + this.buildCacheKey + ", executionTime=" + this.executionTime + '}';
    }
}

