/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import org.apache.ibatis.ognl.ASTChain;
import org.apache.ibatis.ognl.ASTMethod;
import org.apache.ibatis.ognl.ASTProperty;
import org.apache.ibatis.ognl.ASTSequence;
import org.apache.ibatis.ognl.NumericExpression;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.OgnlParserTreeConstants;
import org.apache.ibatis.ognl.SimpleNode;
import org.apache.ibatis.ognl.enhance.ExpressionCompiler;

public abstract class ExpressionNode
extends SimpleNode {
    private static final long serialVersionUID = 4880029588563407661L;

    public ExpressionNode(int i) {
        super(i);
    }

    public ExpressionNode(OgnlParser p, int i) {
        super(p, i);
    }

    @Override
    public boolean isNodeConstant(OgnlContext context) throws OgnlException {
        return false;
    }

    @Override
    public boolean isConstant(OgnlContext context) throws OgnlException {
        boolean result = this.isNodeConstant(context);
        if (this.children != null && this.children.length > 0) {
            result = true;
            for (int i = 0; result && i < this.children.length; ++i) {
                result = this.children[i] instanceof SimpleNode ? ((SimpleNode)this.children[i]).isConstant(context) : false;
            }
        }
        return result;
    }

    public String getExpressionOperator(int index) {
        throw new RuntimeException("unknown operator for " + OgnlParserTreeConstants.jjtNodeName[this.id]);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(this.parent == null ? "" : "(");
        if (this.children != null && this.children.length > 0) {
            for (int i = 0; i < this.children.length; ++i) {
                if (i > 0) {
                    result.append(" ").append(this.getExpressionOperator(i)).append(" ");
                }
                result.append(this.children[i].toString());
            }
        }
        if (this.parent != null) {
            result.append(")");
        }
        return result.toString();
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        StringBuilder result = new StringBuilder(this.parent == null || NumericExpression.class.isAssignableFrom(this.parent.getClass()) ? "" : "(");
        if (this.children != null && this.children.length > 0) {
            for (int i = 0; i < this.children.length; ++i) {
                if (i > 0) {
                    result.append(" ").append(this.getExpressionOperator(i)).append(" ");
                }
                String value = this.children[i].toGetSourceString(context, target);
                if ((this.children[i] instanceof ASTProperty || this.children[i] instanceof ASTMethod || this.children[i] instanceof ASTSequence || this.children[i] instanceof ASTChain) && value != null && value.trim().length() > 0) {
                    String cast;
                    String pre = null;
                    if (this.children[i] instanceof ASTMethod) {
                        pre = (String)context.get("_currentChain");
                    }
                    if (pre == null) {
                        pre = "";
                    }
                    if ((cast = (String)context.remove("_preCast")) == null) {
                        cast = "";
                    }
                    value = cast + ExpressionCompiler.getRootExpression(this.children[i], context.getRoot(), context) + pre + value;
                }
                result.append(value);
            }
        }
        if (this.parent != null && !NumericExpression.class.isAssignableFrom(this.parent.getClass())) {
            result.append(")");
        }
        return result.toString();
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        StringBuilder result = new StringBuilder(this.parent == null ? "" : "(");
        if (this.children != null && this.children.length > 0) {
            for (int i = 0; i < this.children.length; ++i) {
                if (i > 0) {
                    result.append(" ").append(this.getExpressionOperator(i)).append(" ");
                }
                result.append(this.children[i].toSetSourceString(context, target));
            }
        }
        if (this.parent != null) {
            result.append(")");
        }
        return result.toString();
    }

    @Override
    public boolean isOperation(OgnlContext context) throws OgnlException {
        return true;
    }
}

