/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.PartitionEndpointKey;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.utils.Pair;

@SdkPublicApi
public final class BudgetsServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "budgets";
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("aws-global"), Region.of("aws-cn-global"), Region.of("aws-iso-global"), Region.of("us-iso-east-1"), Region.of("aws-iso-b-global"), Region.of("us-isob-east-1"), Region.of("aws-iso-f-global"), Region.of("us-isof-south-1")));
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", Region.of("aws-global")), new DefaultServicePartitionMetadata("aws-cn", Region.of("aws-cn-global")), new DefaultServicePartitionMetadata("aws-iso", Region.of("aws-iso-global")), new DefaultServicePartitionMetadata("aws-iso-b", Region.of("aws-iso-b-global")), new DefaultServicePartitionMetadata("aws-iso-f", Region.of("aws-iso-f-global"))));
    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap.builder().put((Object)ServiceEndpointKey.builder().region(Region.of("aws-global")).build(), (Object)"us-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("aws-cn-global")).build(), (Object)"cn-northwest-1").put((Object)ServiceEndpointKey.builder().region(Region.of("aws-iso-global")).build(), (Object)"us-iso-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-iso-east-1")).build(), (Object)"us-iso-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("aws-iso-b-global")).build(), (Object)"us-isob-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isob-east-1")).build(), (Object)"us-isob-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("aws-iso-f-global")).build(), (Object)"us-isof-south-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isof-south-1")).build(), (Object)"us-isof-south-1").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap.builder().build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap.builder().put((Object)ServiceEndpointKey.builder().region(Region.of("aws-global")).build(), (Object)"budgets.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("aws-cn-global")).build(), (Object)"budgets.amazonaws.com.cn").put((Object)ServiceEndpointKey.builder().region(Region.of("aws-iso-global")).build(), (Object)"budgets.c2s.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-iso-east-1")).build(), (Object)"budgets.c2s.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("aws-iso-b-global")).build(), (Object)"budgets.global.sc2s.sgov.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isob-east-1")).build(), (Object)"budgets.global.sc2s.sgov.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("aws-iso-f-global")).build(), (Object)"budgets.global.csp.hci.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isof-south-1")).build(), (Object)"budgets.global.csp.hci.ic.gov").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap.builder().build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION), ENDPOINT_PREFIX, key.region().id(), ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}

