/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ServiceConfiguration;
import software.amazon.awssdk.services.ec2.model.ServiceConfigurationSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcEndpointServiceConfigurationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcEndpointServiceConfigurationsResponse> {
    private static final SdkField<List<ServiceConfiguration>> SERVICE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceConfigurations").getter(DescribeVpcEndpointServiceConfigurationsResponse.getter(DescribeVpcEndpointServiceConfigurationsResponse::serviceConfigurations)).setter(DescribeVpcEndpointServiceConfigurationsResponse.setter(Builder::serviceConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceConfigurationSet").unmarshallLocationName("serviceConfigurationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVpcEndpointServiceConfigurationsResponse.getter(DescribeVpcEndpointServiceConfigurationsResponse::nextToken)).setter(DescribeVpcEndpointServiceConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeVpcEndpointServiceConfigurationsResponse.memberNameToFieldInitializer();
    private final List<ServiceConfiguration> serviceConfigurations;
    private final String nextToken;

    private DescribeVpcEndpointServiceConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceConfigurations = builder.serviceConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasServiceConfigurations() {
        return this.serviceConfigurations != null && !(this.serviceConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ServiceConfiguration> serviceConfigurations() {
        return this.serviceConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceConfigurations() ? this.serviceConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointServiceConfigurationsResponse)) {
            return false;
        }
        DescribeVpcEndpointServiceConfigurationsResponse other = (DescribeVpcEndpointServiceConfigurationsResponse)((Object)obj);
        return this.hasServiceConfigurations() == other.hasServiceConfigurations() && Objects.equals(this.serviceConfigurations(), other.serviceConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpcEndpointServiceConfigurationsResponse").add("ServiceConfigurations", this.hasServiceConfigurations() ? this.serviceConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceConfigurations": {
                return Optional.ofNullable(clazz.cast(this.serviceConfigurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceConfigurationSet", SERVICE_CONFIGURATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcEndpointServiceConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeVpcEndpointServiceConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ServiceConfiguration> serviceConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointServiceConfigurationsResponse model) {
            super(model);
            this.serviceConfigurations(model.serviceConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<ServiceConfiguration.Builder> getServiceConfigurations() {
            List<ServiceConfiguration.Builder> result = ServiceConfigurationSetCopier.copyToBuilder(this.serviceConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceConfigurations(Collection<ServiceConfiguration.BuilderImpl> serviceConfigurations) {
            this.serviceConfigurations = ServiceConfigurationSetCopier.copyFromBuilder(serviceConfigurations);
        }

        @Override
        public final Builder serviceConfigurations(Collection<ServiceConfiguration> serviceConfigurations) {
            this.serviceConfigurations = ServiceConfigurationSetCopier.copy(serviceConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceConfigurations(ServiceConfiguration ... serviceConfigurations) {
            this.serviceConfigurations(Arrays.asList(serviceConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceConfigurations(Consumer<ServiceConfiguration.Builder> ... serviceConfigurations) {
            this.serviceConfigurations(Stream.of(serviceConfigurations).map(c -> (ServiceConfiguration)((ServiceConfiguration.Builder)ServiceConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVpcEndpointServiceConfigurationsResponse build() {
            return new DescribeVpcEndpointServiceConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcEndpointServiceConfigurationsResponse> {
        public Builder serviceConfigurations(Collection<ServiceConfiguration> var1);

        public Builder serviceConfigurations(ServiceConfiguration ... var1);

        public Builder serviceConfigurations(Consumer<ServiceConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

