/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.neuralsearch.sparse.SparseSettings;
import org.opensearch.neuralsearch.sparse.mapper.SparseVectorFieldType;

public class SparseFieldUtils {
    public static Set<String> getSparseAnnFields(String index, ClusterService clusterService) {
        if (index == null) {
            return Collections.emptySet();
        }
        IndexMetadata metadata = Optional.ofNullable(clusterService).map(ClusterService::state).map(ClusterState::metadata).map(metadataState -> metadataState.index(index)).orElse(null);
        if (metadata == null || !((Boolean)SparseSettings.IS_SPARSE_INDEX_SETTING.get(metadata.getSettings())).booleanValue()) {
            return Collections.emptySet();
        }
        MappingMetadata mappingMetadata = metadata.mapping();
        if (mappingMetadata == null || mappingMetadata.sourceAsMap() == null) {
            return Collections.emptySet();
        }
        Object properties = mappingMetadata.sourceAsMap().get("properties");
        if (!(properties instanceof Map)) {
            return Collections.emptySet();
        }
        HashSet<String> sparseAnnFields = new HashSet<String>();
        Map fields = (Map)properties;
        for (Map.Entry field : fields.entrySet()) {
            Map fieldMap = (Map)field.getValue();
            Object type = fieldMap.get("type");
            if (!Objects.nonNull(type) || !SparseVectorFieldType.isSparseVectorType(type.toString())) continue;
            sparseAnnFields.add((String)field.getKey());
        }
        return sparseAnnFields;
    }
}

