/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLambda;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.ListScope;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.base.Preconditions;

public class SqlLambdaScope
extends ListScope {
    private final SqlLambda lambdaExpr;
    private final Map<String, RelDataType> parameterTypes;

    public SqlLambdaScope(SqlValidatorScope parent, SqlLambda lambdaExpr) {
        super(parent);
        this.lambdaExpr = lambdaExpr;
        RelDataType any = this.validator.typeFactory.createTypeWithNullability(this.validator.typeFactory.createSqlType(SqlTypeName.ANY), true);
        this.parameterTypes = new HashMap<String, RelDataType>();
        lambdaExpr.getParameters().forEach((Consumer<? super SqlNode>)((Consumer<SqlNode>)param -> this.parameterTypes.put(param.toString(), any)));
    }

    @Override
    public SqlNode getNode() {
        return this.lambdaExpr;
    }

    @Override
    public SqlQualified fullyQualify(SqlIdentifier identifier) {
        boolean found = this.lambdaExpr.getParameters().stream().anyMatch(param -> param.equalsDeep((SqlNode)identifier, Litmus.IGNORE));
        if (found) {
            return SqlQualified.create(this, 1, null, identifier);
        }
        throw this.validator.newValidationError(identifier, Static.RESOURCE.paramNotFoundInLambdaExpression(identifier.toString(), this.lambdaExpr.toString()));
    }

    @Override
    public @Nullable RelDataType resolveColumn(String columnName, SqlNode ctx) {
        Preconditions.checkArgument(this.parameterTypes.containsKey(columnName), "column %s not found", (Object)columnName);
        return this.parameterTypes.get(columnName);
    }

    public Map<String, RelDataType> getParameterTypes() {
        return this.parameterTypes;
    }
}

