/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.pit;

import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.CreatePitAction;
import org.opensearch.action.search.CreatePitRequest;
import org.opensearch.action.search.CreatePitResponse;
import org.opensearch.action.search.DeletePitAction;
import org.opensearch.action.search.DeletePitRequest;
import org.opensearch.action.search.DeletePitResponse;
import org.opensearch.common.action.ActionFuture;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.pit.PointInTimeHandler;
import org.opensearch.transport.client.Client;

public class PointInTimeHandlerImpl
implements PointInTimeHandler {
    private final Client client;
    private String[] indices;
    private String pitId;
    private static final Logger LOG = LogManager.getLogger();

    public PointInTimeHandlerImpl(Client client, String[] indices) {
        this.client = client;
        this.indices = indices;
    }

    public PointInTimeHandlerImpl(Client client, String pitId) {
        this.client = client;
        this.pitId = pitId;
    }

    @Override
    public void create() {
        CreatePitRequest createPitRequest = new CreatePitRequest((TimeValue)LocalClusterState.state().getSettingValue(Settings.Key.SQL_CURSOR_KEEP_ALIVE), Boolean.valueOf(false), this.indices);
        ActionFuture execute2 = this.client.execute((ActionType)CreatePitAction.INSTANCE, (ActionRequest)createPitRequest);
        try {
            CreatePitResponse pitResponse = (CreatePitResponse)execute2.get();
            this.pitId = pitResponse.getId();
            LOG.info("Created Point In Time {} successfully.", (Object)this.pitId);
        }
        catch (OpenSearchSecurityException e) {
            throw e;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Error occurred while creating PIT.", e);
        }
    }

    @Override
    public void delete() {
        DeletePitRequest deletePitRequest = new DeletePitRequest(new String[]{this.pitId});
        ActionFuture execute2 = this.client.execute((ActionType)DeletePitAction.INSTANCE, (ActionRequest)deletePitRequest);
        try {
            DeletePitResponse deletePitResponse = (DeletePitResponse)execute2.get();
            LOG.info("Delete Point In Time {} status: {}", (Object)this.pitId, (Object)deletePitResponse.status().getStatus());
        }
        catch (OpenSearchSecurityException e) {
            throw e;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Error occurred while deleting PIT.", e);
        }
    }

    @Override
    @Generated
    public String getPitId() {
        return this.pitId;
    }

    @Generated
    public void setPitId(String pitId) {
        this.pitId = pitId;
    }
}

