/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Enumerator;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.exception.NonFallbackCalciteException;
import org.opensearch.sql.monitor.ResourceMonitor;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;

public class OpenSearchIndexEnumerator
implements Enumerator<Object> {
    private final OpenSearchClient client;
    private final List<String> fields;
    private final OpenSearchRequest request;
    private final int maxResponseSize;
    private static final long NUMBER_OF_NEXT_CALL_TO_CHECK = 1000L;
    private final ResourceMonitor monitor;
    private Integer queryCount;
    private Iterator<ExprValue> iterator;
    private ExprValue current;

    public OpenSearchIndexEnumerator(OpenSearchClient client, List<String> fields2, int maxResponseSize, OpenSearchRequest request, ResourceMonitor monitor) {
        this.client = client;
        this.fields = fields2;
        this.request = request;
        this.maxResponseSize = maxResponseSize;
        this.monitor = monitor;
        this.queryCount = 0;
        this.current = null;
        if (!this.monitor.isHealthy()) {
            throw new NonFallbackCalciteException("insufficient resources to run the query, quit.");
        }
    }

    private void fetchNextBatch() {
        OpenSearchResponse response = this.client.search(this.request);
        if (!response.isEmpty()) {
            this.iterator = response.iterator();
        } else if (this.iterator == null) {
            this.iterator = Collections.emptyIterator();
        }
    }

    @Override
    public Object current() {
        if (this.fields.size() == 1) {
            return this.resolveForCalcite(this.current, this.fields.getFirst());
        }
        return this.fields.stream().map(field -> this.resolveForCalcite(this.current, (String)field)).toArray();
    }

    private Object resolveForCalcite(ExprValue value, String rawPath) {
        return ExprValueUtils.resolveRefPaths(value, List.of(rawPath.split("\\."))).valueForCalcite();
    }

    @Override
    public boolean moveNext() {
        boolean shouldCheck;
        if (this.queryCount >= this.maxResponseSize) {
            return false;
        }
        boolean bl = shouldCheck = (long)this.queryCount.intValue() % 1000L == 0L;
        if (shouldCheck && !this.monitor.isHealthy()) {
            throw new NonFallbackCalciteException("insufficient resources to load next row, quit.");
        }
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.fetchNextBatch();
        }
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            Integer n = this.queryCount;
            this.queryCount = this.queryCount + 1;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.iterator = Collections.emptyIterator();
        this.queryCount = 0;
    }

    @Override
    public void close() {
        this.reset();
        this.client.cleanup(this.request);
    }
}

