// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from esp32c6-lp.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Espressif

//go:build esp && esp32c6lp

/*
// 32-bit RISC-V MCU
*/
//     Copyright 2023 Espressif Systems (Shanghai) PTE LTD Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
package esp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ESP32-C6-LP"
	CPU          = "RV32IMAC"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Low-power Timer
	IRQ_LP_TIMER = 7

	// Low-power UART (Universal Asynchronous Receiver-Transmitter) Controller
	IRQ_LP_UART = 16

	// Low-power I2C (Inter-Integrated Circuit) Controller
	IRQ_LP_I2C = 17

	// Low-power Watchdog Timer
	IRQ_LP_WDT = 18

	// LP_PERI Peripheral
	IRQ_LP_PERI_TIMEOUT = 19

	// Low-power Access Permission Management Controller
	IRQ_LP_APM_M0 = 20

	// Low-power Access Permission Management Controller
	IRQ_LP_APM_M1 = 21

	// Highest interrupt number on this device.
	IRQ_max = 21
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)
func HandleInterrupt(num int) {
	switch num {
	case IRQ_LP_TIMER:
		callHandlers(IRQ_LP_TIMER)
	case IRQ_LP_UART:
		callHandlers(IRQ_LP_UART)
	case IRQ_LP_I2C:
		callHandlers(IRQ_LP_I2C)
	case IRQ_LP_WDT:
		callHandlers(IRQ_LP_WDT)
	case IRQ_LP_PERI_TIMEOUT:
		callHandlers(IRQ_LP_PERI_TIMEOUT)
	case IRQ_LP_APM_M0:
		callHandlers(IRQ_LP_APM_M0)
	case IRQ_LP_APM_M1:
		callHandlers(IRQ_LP_APM_M1)
	}
}

// Peripherals.
var (
	// Low-power I2C (Inter-Integrated Circuit) Controller
	LP_I2C = (*I2C_Type)(unsafe.Pointer(uintptr(0x600b1800)))

	// LP_PERI Peripheral
	LP_PERI = (*LPPERI_Type)(unsafe.Pointer(uintptr(0x600b2800)))

	// LP_ANA_PERI Peripheral
	LP_ANA_PERI = (*LP_ANA_Type)(unsafe.Pointer(uintptr(0x600b2c00)))

	// LP_AON Peripheral
	LP_AON = (*LP_AON_Type)(unsafe.Pointer(uintptr(0x600b1000)))

	// Low-power Access Permission Management Controller
	LP_APM = (*LP_APM_Type)(unsafe.Pointer(uintptr(0x600b3800)))

	// LP_CLKRST Peripheral
	LP_CLKRST = (*LP_CLKRST_Type)(unsafe.Pointer(uintptr(0x600b0400)))

	// LP_I2C_ANA_MST Peripheral
	LP_I2C_ANA_MST = (*LP_I2C_ANA_MST_Type)(unsafe.Pointer(uintptr(0x600b2400)))

	// Low-power Input/Output Multiplexer
	LP_IO_MUX = (*LP_IO_Type)(unsafe.Pointer(uintptr(0x600b2000)))

	// Low-power Trusted Execution Environment
	LP_TEE = (*LP_TEE_Type)(unsafe.Pointer(uintptr(0x600b3400)))

	// Low-power Timer
	LP_TIMER = (*LP_TIMER_Type)(unsafe.Pointer(uintptr(0x600b0c00)))

	// Low-power UART (Universal Asynchronous Receiver-Transmitter) Controller
	LP_UART = (*LP_UART_Type)(unsafe.Pointer(uintptr(0x600b1400)))

	// Low-power Watchdog Timer
	LP_WDT = (*LP_WDT_Type)(unsafe.Pointer(uintptr(0x600b1c00)))
)

// Low-power I2C (Inter-Integrated Circuit) Controller
type I2C_Type struct {
	SCL_LOW_PERIOD       volatile.Register32 // 0x0
	CTR                  volatile.Register32 // 0x4
	SR                   volatile.Register32 // 0x8
	TO                   volatile.Register32 // 0xC
	_                    [4]byte
	FIFO_ST              volatile.Register32 // 0x14
	FIFO_CONF            volatile.Register32 // 0x18
	DATA                 volatile.Register32 // 0x1C
	INT_RAW              volatile.Register32 // 0x20
	INT_CLR              volatile.Register32 // 0x24
	INT_ENA              volatile.Register32 // 0x28
	INT_STATUS           volatile.Register32 // 0x2C
	SDA_HOLD             volatile.Register32 // 0x30
	SDA_SAMPLE           volatile.Register32 // 0x34
	SCL_HIGH_PERIOD      volatile.Register32 // 0x38
	_                    [4]byte
	SCL_START_HOLD       volatile.Register32 // 0x40
	SCL_RSTART_SETUP     volatile.Register32 // 0x44
	SCL_STOP_HOLD        volatile.Register32 // 0x48
	SCL_STOP_SETUP       volatile.Register32 // 0x4C
	FILTER_CFG           volatile.Register32 // 0x50
	CLK_CONF             volatile.Register32 // 0x54
	COMD0                volatile.Register32 // 0x58
	COMD1                volatile.Register32 // 0x5C
	COMD2                volatile.Register32 // 0x60
	COMD3                volatile.Register32 // 0x64
	COMD4                volatile.Register32 // 0x68
	COMD5                volatile.Register32 // 0x6C
	COMD6                volatile.Register32 // 0x70
	COMD7                volatile.Register32 // 0x74
	SCL_ST_TIME_OUT      volatile.Register32 // 0x78
	SCL_MAIN_ST_TIME_OUT volatile.Register32 // 0x7C
	SCL_SP_CONF          volatile.Register32 // 0x80
	_                    [116]byte
	DATE                 volatile.Register32 // 0xF8
	_                    [4]byte
	TXFIFO_START_ADDR    volatile.Register32 // 0x100
	_                    [124]byte
	RXFIFO_START_ADDR    volatile.Register32 // 0x180
}

// I2C.SCL_LOW_PERIOD: Configures the low level width of the SCL Clock
func (o *I2C_Type) SetSCL_LOW_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_LOW_PERIOD.Reg, volatile.LoadUint32(&o.SCL_LOW_PERIOD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_LOW_PERIOD() uint32 {
	return volatile.LoadUint32(&o.SCL_LOW_PERIOD.Reg) & 0x1ff
}

// I2C.CTR: Transmission setting
func (o *I2C_Type) SetCTR_SDA_FORCE_OUT(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCTR_SDA_FORCE_OUT() uint32 {
	return volatile.LoadUint32(&o.CTR.Reg) & 0x1
}
func (o *I2C_Type) SetCTR_SCL_FORCE_OUT(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCTR_SCL_FORCE_OUT() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCTR_SAMPLE_SCL_LEVEL(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCTR_SAMPLE_SCL_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCTR_RX_FULL_ACK_LEVEL(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCTR_RX_FULL_ACK_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCTR_TRANS_START(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCTR_TRANS_START() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCTR_TX_LSB_FIRST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCTR_TX_LSB_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCTR_RX_LSB_FIRST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCTR_RX_LSB_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCTR_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetCTR_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetCTR_ARBITRATION_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetCTR_ARBITRATION_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetCTR_FSM_RST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCTR_FSM_RST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCTR_CONF_UPGATE(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCTR_CONF_UPGATE() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x800) >> 11
}

// I2C.SR: Describe I2C work status.
func (o *I2C_Type) SetSR_RESP_REC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSR_RESP_REC() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *I2C_Type) SetSR_ARB_LOST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetSR_ARB_LOST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetSR_BUS_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSR_BUS_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSR_RXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1f00)|value<<8)
}
func (o *I2C_Type) GetSR_RXFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1f00) >> 8
}
func (o *I2C_Type) SetSR_TXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7c0000)|value<<18)
}
func (o *I2C_Type) GetSR_TXFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x7c0000) >> 18
}
func (o *I2C_Type) SetSR_SCL_MAIN_STATE_LAST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7000000)|value<<24)
}
func (o *I2C_Type) GetSR_SCL_MAIN_STATE_LAST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x7000000) >> 24
}
func (o *I2C_Type) SetSR_SCL_STATE_LAST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x70000000)|value<<28)
}
func (o *I2C_Type) GetSR_SCL_STATE_LAST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x70000000) >> 28
}

// I2C.TO: Setting time out control for receiving data.
func (o *I2C_Type) SetTO_TIME_OUT_VALUE(value uint32) {
	volatile.StoreUint32(&o.TO.Reg, volatile.LoadUint32(&o.TO.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetTO_TIME_OUT_VALUE() uint32 {
	return volatile.LoadUint32(&o.TO.Reg) & 0x1f
}
func (o *I2C_Type) SetTO_TIME_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.TO.Reg, volatile.LoadUint32(&o.TO.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetTO_TIME_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.TO.Reg) & 0x20) >> 5
}

// I2C.FIFO_ST: FIFO status register.
func (o *I2C_Type) SetFIFO_ST_RXFIFO_RADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0xf)|value)
}
func (o *I2C_Type) GetFIFO_ST_RXFIFO_RADDR() uint32 {
	return volatile.LoadUint32(&o.FIFO_ST.Reg) & 0xf
}
func (o *I2C_Type) SetFIFO_ST_RXFIFO_WADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x1e0)|value<<5)
}
func (o *I2C_Type) GetFIFO_ST_RXFIFO_WADDR() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x1e0) >> 5
}
func (o *I2C_Type) SetFIFO_ST_TXFIFO_RADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x3c00)|value<<10)
}
func (o *I2C_Type) GetFIFO_ST_TXFIFO_RADDR() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x3c00) >> 10
}
func (o *I2C_Type) SetFIFO_ST_TXFIFO_WADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x78000)|value<<15)
}
func (o *I2C_Type) GetFIFO_ST_TXFIFO_WADDR() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x78000) >> 15
}

// I2C.FIFO_CONF: FIFO configuration register.
func (o *I2C_Type) SetFIFO_CONF_RXFIFO_WM_THRHD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0xf)|value)
}
func (o *I2C_Type) GetFIFO_CONF_RXFIFO_WM_THRHD() uint32 {
	return volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0xf
}
func (o *I2C_Type) SetFIFO_CONF_TXFIFO_WM_THRHD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x1e0)|value<<5)
}
func (o *I2C_Type) GetFIFO_CONF_TXFIFO_WM_THRHD() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x1e0) >> 5
}
func (o *I2C_Type) SetFIFO_CONF_NONFIFO_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetFIFO_CONF_NONFIFO_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetFIFO_CONF_RX_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetFIFO_CONF_RX_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetFIFO_CONF_TX_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetFIFO_CONF_TX_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetFIFO_CONF_FIFO_PRT_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetFIFO_CONF_FIFO_PRT_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x4000) >> 14
}

// I2C.DATA: Rx FIFO read data.
func (o *I2C_Type) SetDATA_FIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetDATA_FIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg) & 0xff
}

// I2C.INT_RAW: Raw interrupt status
func (o *I2C_Type) SetINT_RAW_RXFIFO_WM_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_RAW_RXFIFO_WM_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *I2C_Type) SetINT_RAW_TXFIFO_WM_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_RAW_TXFIFO_WM_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_RAW_RXFIFO_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_RAW_RXFIFO_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_RAW_END_DETECT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_RAW_END_DETECT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_RAW_BYTE_TRANS_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_RAW_BYTE_TRANS_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_RAW_ARBITRATION_LOST_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_RAW_ARBITRATION_LOST_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_RAW_MST_TXFIFO_UDF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_RAW_MST_TXFIFO_UDF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_RAW_TRANS_COMPLETE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_RAW_TRANS_COMPLETE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_RAW_TIME_OUT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_RAW_TIME_OUT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_RAW_TRANS_START_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_RAW_TRANS_START_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_RAW_NACK_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_RAW_NACK_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_RAW_TXFIFO_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_RAW_TXFIFO_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_RAW_RXFIFO_UDF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_RAW_RXFIFO_UDF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_RAW_SCL_ST_TO_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_RAW_SCL_ST_TO_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_RAW_SCL_MAIN_ST_TO_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_RAW_SCL_MAIN_ST_TO_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_RAW_DET_START_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_RAW_DET_START_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8000) >> 15
}

// I2C.INT_CLR: Interrupt clear bits
func (o *I2C_Type) SetINT_CLR_RXFIFO_WM_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_CLR_RXFIFO_WM_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *I2C_Type) SetINT_CLR_TXFIFO_WM_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_CLR_TXFIFO_WM_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_CLR_RXFIFO_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_CLR_RXFIFO_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_CLR_END_DETECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_CLR_END_DETECT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_CLR_BYTE_TRANS_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_CLR_BYTE_TRANS_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_CLR_ARBITRATION_LOST_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_CLR_ARBITRATION_LOST_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_CLR_MST_TXFIFO_UDF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_CLR_MST_TXFIFO_UDF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_CLR_TRANS_COMPLETE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_CLR_TRANS_COMPLETE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_CLR_TIME_OUT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_CLR_TIME_OUT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_CLR_TRANS_START_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_CLR_TRANS_START_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_CLR_NACK_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_CLR_NACK_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_CLR_TXFIFO_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_CLR_TXFIFO_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_CLR_RXFIFO_UDF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_CLR_RXFIFO_UDF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_CLR_SCL_ST_TO_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_CLR_SCL_ST_TO_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_CLR_SCL_MAIN_ST_TO_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_CLR_SCL_MAIN_ST_TO_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_CLR_DET_START_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_CLR_DET_START_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8000) >> 15
}

// I2C.INT_ENA: Interrupt enable bits
func (o *I2C_Type) SetINT_ENA_RXFIFO_WM_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_ENA_RXFIFO_WM_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *I2C_Type) SetINT_ENA_TXFIFO_WM_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_ENA_TXFIFO_WM_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_ENA_RXFIFO_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_ENA_RXFIFO_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_ENA_END_DETECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_ENA_END_DETECT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_ENA_BYTE_TRANS_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_ENA_BYTE_TRANS_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_ENA_ARBITRATION_LOST_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_ENA_ARBITRATION_LOST_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_ENA_MST_TXFIFO_UDF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_ENA_MST_TXFIFO_UDF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_ENA_TRANS_COMPLETE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_ENA_TRANS_COMPLETE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_ENA_TIME_OUT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_ENA_TIME_OUT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_ENA_TRANS_START_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_ENA_TRANS_START_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_ENA_NACK_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_ENA_NACK_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_ENA_TXFIFO_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_ENA_TXFIFO_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_ENA_RXFIFO_UDF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_ENA_RXFIFO_UDF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_ENA_SCL_ST_TO_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_ENA_SCL_ST_TO_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_ENA_SCL_MAIN_ST_TO_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_ENA_SCL_MAIN_ST_TO_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_ENA_DET_START_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_ENA_DET_START_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8000) >> 15
}

// I2C.INT_STATUS: Status of captured I2C communication events
func (o *I2C_Type) SetINT_STATUS_RXFIFO_WM_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_STATUS_RXFIFO_WM_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x1
}
func (o *I2C_Type) SetINT_STATUS_TXFIFO_WM_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_STATUS_TXFIFO_WM_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_STATUS_RXFIFO_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_STATUS_RXFIFO_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_STATUS_END_DETECT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_STATUS_END_DETECT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_STATUS_BYTE_TRANS_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_STATUS_BYTE_TRANS_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_STATUS_ARBITRATION_LOST_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_STATUS_ARBITRATION_LOST_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_STATUS_MST_TXFIFO_UDF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_STATUS_MST_TXFIFO_UDF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_STATUS_TRANS_COMPLETE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_STATUS_TRANS_COMPLETE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_STATUS_TIME_OUT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_STATUS_TIME_OUT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_STATUS_TRANS_START_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_STATUS_TRANS_START_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_STATUS_NACK_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_STATUS_NACK_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_STATUS_TXFIFO_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_STATUS_TXFIFO_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_STATUS_RXFIFO_UDF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_STATUS_RXFIFO_UDF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_STATUS_SCL_ST_TO_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_STATUS_SCL_ST_TO_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_STATUS_SCL_MAIN_ST_TO_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_STATUS_SCL_MAIN_ST_TO_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_STATUS_DET_START_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_STATUS_DET_START_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x8000) >> 15
}

// I2C.SDA_HOLD: Configures the hold time after a negative SCL edge.
func (o *I2C_Type) SetSDA_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.SDA_HOLD.Reg, volatile.LoadUint32(&o.SDA_HOLD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSDA_HOLD_TIME() uint32 {
	return volatile.LoadUint32(&o.SDA_HOLD.Reg) & 0x1ff
}

// I2C.SDA_SAMPLE: Configures the sample time after a positive SCL edge.
func (o *I2C_Type) SetSDA_SAMPLE_TIME(value uint32) {
	volatile.StoreUint32(&o.SDA_SAMPLE.Reg, volatile.LoadUint32(&o.SDA_SAMPLE.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSDA_SAMPLE_TIME() uint32 {
	return volatile.LoadUint32(&o.SDA_SAMPLE.Reg) & 0x1ff
}

// I2C.SCL_HIGH_PERIOD: Configures the high level width of SCL
func (o *I2C_Type) SetSCL_HIGH_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_HIGH_PERIOD.Reg, volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_HIGH_PERIOD() uint32 {
	return volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg) & 0x1ff
}
func (o *I2C_Type) SetSCL_HIGH_PERIOD_SCL_WAIT_HIGH_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_HIGH_PERIOD.Reg, volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg)&^(0xfe00)|value<<9)
}
func (o *I2C_Type) GetSCL_HIGH_PERIOD_SCL_WAIT_HIGH_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg) & 0xfe00) >> 9
}

// I2C.SCL_START_HOLD: Configures the delay between the SDA and SCL negative edge for a start condition
func (o *I2C_Type) SetSCL_START_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_START_HOLD.Reg, volatile.LoadUint32(&o.SCL_START_HOLD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_START_HOLD_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_START_HOLD.Reg) & 0x1ff
}

// I2C.SCL_RSTART_SETUP: Configures the delay between the positive edge of SCL and the negative edge of SDA
func (o *I2C_Type) SetSCL_RSTART_SETUP_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_RSTART_SETUP.Reg, volatile.LoadUint32(&o.SCL_RSTART_SETUP.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_RSTART_SETUP_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_RSTART_SETUP.Reg) & 0x1ff
}

// I2C.SCL_STOP_HOLD: Configures the delay after the SCL clock edge for a stop condition
func (o *I2C_Type) SetSCL_STOP_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_STOP_HOLD.Reg, volatile.LoadUint32(&o.SCL_STOP_HOLD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_STOP_HOLD_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_STOP_HOLD.Reg) & 0x1ff
}

// I2C.SCL_STOP_SETUP: Configures the delay between the SDA and SCL positive edge for a stop condition
func (o *I2C_Type) SetSCL_STOP_SETUP_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_STOP_SETUP.Reg, volatile.LoadUint32(&o.SCL_STOP_SETUP.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_STOP_SETUP_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_STOP_SETUP.Reg) & 0x1ff
}

// I2C.FILTER_CFG: SCL and SDA filter configuration register
func (o *I2C_Type) SetFILTER_CFG_SCL_FILTER_THRES(value uint32) {
	volatile.StoreUint32(&o.FILTER_CFG.Reg, volatile.LoadUint32(&o.FILTER_CFG.Reg)&^(0xf)|value)
}
func (o *I2C_Type) GetFILTER_CFG_SCL_FILTER_THRES() uint32 {
	return volatile.LoadUint32(&o.FILTER_CFG.Reg) & 0xf
}
func (o *I2C_Type) SetFILTER_CFG_SDA_FILTER_THRES(value uint32) {
	volatile.StoreUint32(&o.FILTER_CFG.Reg, volatile.LoadUint32(&o.FILTER_CFG.Reg)&^(0xf0)|value<<4)
}
func (o *I2C_Type) GetFILTER_CFG_SDA_FILTER_THRES() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CFG.Reg) & 0xf0) >> 4
}
func (o *I2C_Type) SetFILTER_CFG_SCL_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.FILTER_CFG.Reg, volatile.LoadUint32(&o.FILTER_CFG.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetFILTER_CFG_SCL_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CFG.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetFILTER_CFG_SDA_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.FILTER_CFG.Reg, volatile.LoadUint32(&o.FILTER_CFG.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetFILTER_CFG_SDA_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CFG.Reg) & 0x200) >> 9
}

// I2C.CLK_CONF: I2C CLK configuration register
func (o *I2C_Type) SetCLK_CONF_SCLK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetCLK_CONF_SCLK_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.CLK_CONF.Reg) & 0xff
}
func (o *I2C_Type) SetCLK_CONF_SCLK_DIV_A(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x3f00)|value<<8)
}
func (o *I2C_Type) GetCLK_CONF_SCLK_DIV_A() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x3f00) >> 8
}
func (o *I2C_Type) SetCLK_CONF_SCLK_DIV_B(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0xfc000)|value<<14)
}
func (o *I2C_Type) GetCLK_CONF_SCLK_DIV_B() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0xfc000) >> 14
}
func (o *I2C_Type) SetCLK_CONF_SCLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetCLK_CONF_SCLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetCLK_CONF_SCLK_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetCLK_CONF_SCLK_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x200000) >> 21
}

// I2C.COMD0: I2C command register 0
func (o *I2C_Type) SetCOMD0_COMMAND0(value uint32) {
	volatile.StoreUint32(&o.COMD0.Reg, volatile.LoadUint32(&o.COMD0.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD0_COMMAND0() uint32 {
	return volatile.LoadUint32(&o.COMD0.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD0_COMMAND0_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD0.Reg, volatile.LoadUint32(&o.COMD0.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD0_COMMAND0_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD0.Reg) & 0x80000000) >> 31
}

// I2C.COMD1: I2C command register 1
func (o *I2C_Type) SetCOMD1_COMMAND1(value uint32) {
	volatile.StoreUint32(&o.COMD1.Reg, volatile.LoadUint32(&o.COMD1.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD1_COMMAND1() uint32 {
	return volatile.LoadUint32(&o.COMD1.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD1_COMMAND1_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD1.Reg, volatile.LoadUint32(&o.COMD1.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD1_COMMAND1_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD1.Reg) & 0x80000000) >> 31
}

// I2C.COMD2: I2C command register 2
func (o *I2C_Type) SetCOMD2_COMMAND2(value uint32) {
	volatile.StoreUint32(&o.COMD2.Reg, volatile.LoadUint32(&o.COMD2.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD2_COMMAND2() uint32 {
	return volatile.LoadUint32(&o.COMD2.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD2_COMMAND2_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD2.Reg, volatile.LoadUint32(&o.COMD2.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD2_COMMAND2_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD2.Reg) & 0x80000000) >> 31
}

// I2C.COMD3: I2C command register 3
func (o *I2C_Type) SetCOMD3_COMMAND3(value uint32) {
	volatile.StoreUint32(&o.COMD3.Reg, volatile.LoadUint32(&o.COMD3.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD3_COMMAND3() uint32 {
	return volatile.LoadUint32(&o.COMD3.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD3_COMMAND3_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD3.Reg, volatile.LoadUint32(&o.COMD3.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD3_COMMAND3_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD3.Reg) & 0x80000000) >> 31
}

// I2C.COMD4: I2C command register 4
func (o *I2C_Type) SetCOMD4_COMMAND4(value uint32) {
	volatile.StoreUint32(&o.COMD4.Reg, volatile.LoadUint32(&o.COMD4.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD4_COMMAND4() uint32 {
	return volatile.LoadUint32(&o.COMD4.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD4_COMMAND4_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD4.Reg, volatile.LoadUint32(&o.COMD4.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD4_COMMAND4_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD4.Reg) & 0x80000000) >> 31
}

// I2C.COMD5: I2C command register 5
func (o *I2C_Type) SetCOMD5_COMMAND5(value uint32) {
	volatile.StoreUint32(&o.COMD5.Reg, volatile.LoadUint32(&o.COMD5.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD5_COMMAND5() uint32 {
	return volatile.LoadUint32(&o.COMD5.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD5_COMMAND5_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD5.Reg, volatile.LoadUint32(&o.COMD5.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD5_COMMAND5_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD5.Reg) & 0x80000000) >> 31
}

// I2C.COMD6: I2C command register 6
func (o *I2C_Type) SetCOMD6_COMMAND6(value uint32) {
	volatile.StoreUint32(&o.COMD6.Reg, volatile.LoadUint32(&o.COMD6.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD6_COMMAND6() uint32 {
	return volatile.LoadUint32(&o.COMD6.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD6_COMMAND6_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD6.Reg, volatile.LoadUint32(&o.COMD6.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD6_COMMAND6_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD6.Reg) & 0x80000000) >> 31
}

// I2C.COMD7: I2C command register 7
func (o *I2C_Type) SetCOMD7_COMMAND7(value uint32) {
	volatile.StoreUint32(&o.COMD7.Reg, volatile.LoadUint32(&o.COMD7.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD7_COMMAND7() uint32 {
	return volatile.LoadUint32(&o.COMD7.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD7_COMMAND7_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD7.Reg, volatile.LoadUint32(&o.COMD7.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD7_COMMAND7_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD7.Reg) & 0x80000000) >> 31
}

// I2C.SCL_ST_TIME_OUT: SCL status time out register
func (o *I2C_Type) SetSCL_ST_TIME_OUT_SCL_ST_TO_I2C(value uint32) {
	volatile.StoreUint32(&o.SCL_ST_TIME_OUT.Reg, volatile.LoadUint32(&o.SCL_ST_TIME_OUT.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetSCL_ST_TIME_OUT_SCL_ST_TO_I2C() uint32 {
	return volatile.LoadUint32(&o.SCL_ST_TIME_OUT.Reg) & 0x1f
}

// I2C.SCL_MAIN_ST_TIME_OUT: SCL main status time out register
func (o *I2C_Type) SetSCL_MAIN_ST_TIME_OUT_SCL_MAIN_ST_TO_I2C(value uint32) {
	volatile.StoreUint32(&o.SCL_MAIN_ST_TIME_OUT.Reg, volatile.LoadUint32(&o.SCL_MAIN_ST_TIME_OUT.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetSCL_MAIN_ST_TIME_OUT_SCL_MAIN_ST_TO_I2C() uint32 {
	return volatile.LoadUint32(&o.SCL_MAIN_ST_TIME_OUT.Reg) & 0x1f
}

// I2C.SCL_SP_CONF: Power configuration register
func (o *I2C_Type) SetSCL_SP_CONF_SCL_RST_SLV_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSCL_SP_CONF_SCL_RST_SLV_EN() uint32 {
	return volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x1
}
func (o *I2C_Type) SetSCL_SP_CONF_SCL_RST_SLV_NUM(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x3e)|value<<1)
}
func (o *I2C_Type) GetSCL_SP_CONF_SCL_RST_SLV_NUM() uint32 {
	return (volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x3e) >> 1
}
func (o *I2C_Type) SetSCL_SP_CONF_SCL_PD_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSCL_SP_CONF_SCL_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetSCL_SP_CONF_SDA_PD_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetSCL_SP_CONF_SDA_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x80) >> 7
}

// I2C.DATE: Version register
func (o *I2C_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *I2C_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// I2C.TXFIFO_START_ADDR: I2C TXFIFO base address register
func (o *I2C_Type) SetTXFIFO_START_ADDR(value uint32) {
	volatile.StoreUint32(&o.TXFIFO_START_ADDR.Reg, value)
}
func (o *I2C_Type) GetTXFIFO_START_ADDR() uint32 {
	return volatile.LoadUint32(&o.TXFIFO_START_ADDR.Reg)
}

// I2C.RXFIFO_START_ADDR: I2C RXFIFO base address register
func (o *I2C_Type) SetRXFIFO_START_ADDR(value uint32) {
	volatile.StoreUint32(&o.RXFIFO_START_ADDR.Reg, value)
}
func (o *I2C_Type) GetRXFIFO_START_ADDR() uint32 {
	return volatile.LoadUint32(&o.RXFIFO_START_ADDR.Reg)
}

// LP_PERI Peripheral
type LPPERI_Type struct {
	CLK_EN           volatile.Register32 // 0x0
	RESET_EN         volatile.Register32 // 0x4
	RNG_DATA         volatile.Register32 // 0x8
	CPU              volatile.Register32 // 0xC
	BUS_TIMEOUT      volatile.Register32 // 0x10
	BUS_TIMEOUT_ADDR volatile.Register32 // 0x14
	BUS_TIMEOUT_UID  volatile.Register32 // 0x18
	MEM_CTRL         volatile.Register32 // 0x1C
	INTERRUPT_SOURCE volatile.Register32 // 0x20
	_                [984]byte
	DATE             volatile.Register32 // 0x3FC
}

// LPPERI.CLK_EN: need_des
func (o *LPPERI_Type) SetCLK_EN_LP_TOUCH_CK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN.Reg, volatile.LoadUint32(&o.CLK_EN.Reg)&^(0x800000)|value<<23)
}
func (o *LPPERI_Type) GetCLK_EN_LP_TOUCH_CK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN.Reg) & 0x800000) >> 23
}
func (o *LPPERI_Type) SetCLK_EN_RNG_CK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN.Reg, volatile.LoadUint32(&o.CLK_EN.Reg)&^(0x1000000)|value<<24)
}
func (o *LPPERI_Type) GetCLK_EN_RNG_CK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN.Reg) & 0x1000000) >> 24
}
func (o *LPPERI_Type) SetCLK_EN_OTP_DBG_CK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN.Reg, volatile.LoadUint32(&o.CLK_EN.Reg)&^(0x2000000)|value<<25)
}
func (o *LPPERI_Type) GetCLK_EN_OTP_DBG_CK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN.Reg) & 0x2000000) >> 25
}
func (o *LPPERI_Type) SetCLK_EN_LP_UART_CK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN.Reg, volatile.LoadUint32(&o.CLK_EN.Reg)&^(0x4000000)|value<<26)
}
func (o *LPPERI_Type) GetCLK_EN_LP_UART_CK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN.Reg) & 0x4000000) >> 26
}
func (o *LPPERI_Type) SetCLK_EN_LP_IO_CK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN.Reg, volatile.LoadUint32(&o.CLK_EN.Reg)&^(0x8000000)|value<<27)
}
func (o *LPPERI_Type) GetCLK_EN_LP_IO_CK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN.Reg) & 0x8000000) >> 27
}
func (o *LPPERI_Type) SetCLK_EN_LP_EXT_I2C_CK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN.Reg, volatile.LoadUint32(&o.CLK_EN.Reg)&^(0x10000000)|value<<28)
}
func (o *LPPERI_Type) GetCLK_EN_LP_EXT_I2C_CK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN.Reg) & 0x10000000) >> 28
}
func (o *LPPERI_Type) SetCLK_EN_LP_ANA_I2C_CK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN.Reg, volatile.LoadUint32(&o.CLK_EN.Reg)&^(0x20000000)|value<<29)
}
func (o *LPPERI_Type) GetCLK_EN_LP_ANA_I2C_CK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN.Reg) & 0x20000000) >> 29
}
func (o *LPPERI_Type) SetCLK_EN_EFUSE_CK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN.Reg, volatile.LoadUint32(&o.CLK_EN.Reg)&^(0x40000000)|value<<30)
}
func (o *LPPERI_Type) GetCLK_EN_EFUSE_CK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN.Reg) & 0x40000000) >> 30
}
func (o *LPPERI_Type) SetCLK_EN_LP_CPU_CK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN.Reg, volatile.LoadUint32(&o.CLK_EN.Reg)&^(0x80000000)|value<<31)
}
func (o *LPPERI_Type) GetCLK_EN_LP_CPU_CK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN.Reg) & 0x80000000) >> 31
}

// LPPERI.RESET_EN: need_des
func (o *LPPERI_Type) SetRESET_EN_BUS_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.RESET_EN.Reg, volatile.LoadUint32(&o.RESET_EN.Reg)&^(0x800000)|value<<23)
}
func (o *LPPERI_Type) GetRESET_EN_BUS_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.RESET_EN.Reg) & 0x800000) >> 23
}
func (o *LPPERI_Type) SetRESET_EN_LP_TOUCH_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.RESET_EN.Reg, volatile.LoadUint32(&o.RESET_EN.Reg)&^(0x1000000)|value<<24)
}
func (o *LPPERI_Type) GetRESET_EN_LP_TOUCH_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.RESET_EN.Reg) & 0x1000000) >> 24
}
func (o *LPPERI_Type) SetRESET_EN_OTP_DBG_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.RESET_EN.Reg, volatile.LoadUint32(&o.RESET_EN.Reg)&^(0x2000000)|value<<25)
}
func (o *LPPERI_Type) GetRESET_EN_OTP_DBG_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.RESET_EN.Reg) & 0x2000000) >> 25
}
func (o *LPPERI_Type) SetRESET_EN_LP_UART_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.RESET_EN.Reg, volatile.LoadUint32(&o.RESET_EN.Reg)&^(0x4000000)|value<<26)
}
func (o *LPPERI_Type) GetRESET_EN_LP_UART_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.RESET_EN.Reg) & 0x4000000) >> 26
}
func (o *LPPERI_Type) SetRESET_EN_LP_IO_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.RESET_EN.Reg, volatile.LoadUint32(&o.RESET_EN.Reg)&^(0x8000000)|value<<27)
}
func (o *LPPERI_Type) GetRESET_EN_LP_IO_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.RESET_EN.Reg) & 0x8000000) >> 27
}
func (o *LPPERI_Type) SetRESET_EN_LP_EXT_I2C_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.RESET_EN.Reg, volatile.LoadUint32(&o.RESET_EN.Reg)&^(0x10000000)|value<<28)
}
func (o *LPPERI_Type) GetRESET_EN_LP_EXT_I2C_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.RESET_EN.Reg) & 0x10000000) >> 28
}
func (o *LPPERI_Type) SetRESET_EN_LP_ANA_I2C_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.RESET_EN.Reg, volatile.LoadUint32(&o.RESET_EN.Reg)&^(0x20000000)|value<<29)
}
func (o *LPPERI_Type) GetRESET_EN_LP_ANA_I2C_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.RESET_EN.Reg) & 0x20000000) >> 29
}
func (o *LPPERI_Type) SetRESET_EN_EFUSE_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.RESET_EN.Reg, volatile.LoadUint32(&o.RESET_EN.Reg)&^(0x40000000)|value<<30)
}
func (o *LPPERI_Type) GetRESET_EN_EFUSE_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.RESET_EN.Reg) & 0x40000000) >> 30
}
func (o *LPPERI_Type) SetRESET_EN_LP_CPU_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.RESET_EN.Reg, volatile.LoadUint32(&o.RESET_EN.Reg)&^(0x80000000)|value<<31)
}
func (o *LPPERI_Type) GetRESET_EN_LP_CPU_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.RESET_EN.Reg) & 0x80000000) >> 31
}

// LPPERI.RNG_DATA: need_des
func (o *LPPERI_Type) SetRNG_DATA(value uint32) {
	volatile.StoreUint32(&o.RNG_DATA.Reg, value)
}
func (o *LPPERI_Type) GetRNG_DATA() uint32 {
	return volatile.LoadUint32(&o.RNG_DATA.Reg)
}

// LPPERI.CPU: need_des
func (o *LPPERI_Type) SetCPU_LPCORE_DBGM_UNAVALIABLE(value uint32) {
	volatile.StoreUint32(&o.CPU.Reg, volatile.LoadUint32(&o.CPU.Reg)&^(0x80000000)|value<<31)
}
func (o *LPPERI_Type) GetCPU_LPCORE_DBGM_UNAVALIABLE() uint32 {
	return (volatile.LoadUint32(&o.CPU.Reg) & 0x80000000) >> 31
}

// LPPERI.BUS_TIMEOUT: need_des
func (o *LPPERI_Type) SetBUS_TIMEOUT_LP_PERI_TIMEOUT_THRES(value uint32) {
	volatile.StoreUint32(&o.BUS_TIMEOUT.Reg, volatile.LoadUint32(&o.BUS_TIMEOUT.Reg)&^(0x3fffc000)|value<<14)
}
func (o *LPPERI_Type) GetBUS_TIMEOUT_LP_PERI_TIMEOUT_THRES() uint32 {
	return (volatile.LoadUint32(&o.BUS_TIMEOUT.Reg) & 0x3fffc000) >> 14
}
func (o *LPPERI_Type) SetBUS_TIMEOUT_LP_PERI_TIMEOUT_INT_CLEAR(value uint32) {
	volatile.StoreUint32(&o.BUS_TIMEOUT.Reg, volatile.LoadUint32(&o.BUS_TIMEOUT.Reg)&^(0x40000000)|value<<30)
}
func (o *LPPERI_Type) GetBUS_TIMEOUT_LP_PERI_TIMEOUT_INT_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.BUS_TIMEOUT.Reg) & 0x40000000) >> 30
}
func (o *LPPERI_Type) SetBUS_TIMEOUT_LP_PERI_TIMEOUT_PROTECT_EN(value uint32) {
	volatile.StoreUint32(&o.BUS_TIMEOUT.Reg, volatile.LoadUint32(&o.BUS_TIMEOUT.Reg)&^(0x80000000)|value<<31)
}
func (o *LPPERI_Type) GetBUS_TIMEOUT_LP_PERI_TIMEOUT_PROTECT_EN() uint32 {
	return (volatile.LoadUint32(&o.BUS_TIMEOUT.Reg) & 0x80000000) >> 31
}

// LPPERI.BUS_TIMEOUT_ADDR: need_des
func (o *LPPERI_Type) SetBUS_TIMEOUT_ADDR(value uint32) {
	volatile.StoreUint32(&o.BUS_TIMEOUT_ADDR.Reg, value)
}
func (o *LPPERI_Type) GetBUS_TIMEOUT_ADDR() uint32 {
	return volatile.LoadUint32(&o.BUS_TIMEOUT_ADDR.Reg)
}

// LPPERI.BUS_TIMEOUT_UID: need_des
func (o *LPPERI_Type) SetBUS_TIMEOUT_UID_LP_PERI_TIMEOUT_UID(value uint32) {
	volatile.StoreUint32(&o.BUS_TIMEOUT_UID.Reg, volatile.LoadUint32(&o.BUS_TIMEOUT_UID.Reg)&^(0x7f)|value)
}
func (o *LPPERI_Type) GetBUS_TIMEOUT_UID_LP_PERI_TIMEOUT_UID() uint32 {
	return volatile.LoadUint32(&o.BUS_TIMEOUT_UID.Reg) & 0x7f
}

// LPPERI.MEM_CTRL: need_des
func (o *LPPERI_Type) SetMEM_CTRL_UART_WAKEUP_FLAG_CLR(value uint32) {
	volatile.StoreUint32(&o.MEM_CTRL.Reg, volatile.LoadUint32(&o.MEM_CTRL.Reg)&^(0x1)|value)
}
func (o *LPPERI_Type) GetMEM_CTRL_UART_WAKEUP_FLAG_CLR() uint32 {
	return volatile.LoadUint32(&o.MEM_CTRL.Reg) & 0x1
}
func (o *LPPERI_Type) SetMEM_CTRL_UART_WAKEUP_FLAG(value uint32) {
	volatile.StoreUint32(&o.MEM_CTRL.Reg, volatile.LoadUint32(&o.MEM_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *LPPERI_Type) GetMEM_CTRL_UART_WAKEUP_FLAG() uint32 {
	return (volatile.LoadUint32(&o.MEM_CTRL.Reg) & 0x2) >> 1
}
func (o *LPPERI_Type) SetMEM_CTRL_UART_WAKEUP_EN(value uint32) {
	volatile.StoreUint32(&o.MEM_CTRL.Reg, volatile.LoadUint32(&o.MEM_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *LPPERI_Type) GetMEM_CTRL_UART_WAKEUP_EN() uint32 {
	return (volatile.LoadUint32(&o.MEM_CTRL.Reg) & 0x20000000) >> 29
}
func (o *LPPERI_Type) SetMEM_CTRL_UART_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.MEM_CTRL.Reg, volatile.LoadUint32(&o.MEM_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *LPPERI_Type) GetMEM_CTRL_UART_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.MEM_CTRL.Reg) & 0x40000000) >> 30
}
func (o *LPPERI_Type) SetMEM_CTRL_UART_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.MEM_CTRL.Reg, volatile.LoadUint32(&o.MEM_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *LPPERI_Type) GetMEM_CTRL_UART_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.MEM_CTRL.Reg) & 0x80000000) >> 31
}

// LPPERI.INTERRUPT_SOURCE: need_des
func (o *LPPERI_Type) SetINTERRUPT_SOURCE_LP_INTERRUPT_SOURCE(value uint32) {
	volatile.StoreUint32(&o.INTERRUPT_SOURCE.Reg, volatile.LoadUint32(&o.INTERRUPT_SOURCE.Reg)&^(0x3f)|value)
}
func (o *LPPERI_Type) GetINTERRUPT_SOURCE_LP_INTERRUPT_SOURCE() uint32 {
	return volatile.LoadUint32(&o.INTERRUPT_SOURCE.Reg) & 0x3f
}

// LPPERI.DATE: need_des
func (o *LPPERI_Type) SetDATE_LPPERI_DATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x7fffffff)|value)
}
func (o *LPPERI_Type) GetDATE_LPPERI_DATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x7fffffff
}
func (o *LPPERI_Type) SetDATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x80000000)|value<<31)
}
func (o *LPPERI_Type) GetDATE_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.DATE.Reg) & 0x80000000) >> 31
}

// LP_ANA_PERI Peripheral
type LP_ANA_Type struct {
	BOD_MODE0_CNTL volatile.Register32 // 0x0
	BOD_MODE1_CNTL volatile.Register32 // 0x4
	CK_GLITCH_CNTL volatile.Register32 // 0x8
	FIB_ENABLE     volatile.Register32 // 0xC
	INT_RAW        volatile.Register32 // 0x10
	INT_ST         volatile.Register32 // 0x14
	INT_ENA        volatile.Register32 // 0x18
	INT_CLR        volatile.Register32 // 0x1C
	LP_INT_RAW     volatile.Register32 // 0x20
	LP_INT_ST      volatile.Register32 // 0x24
	LP_INT_ENA     volatile.Register32 // 0x28
	LP_INT_CLR     volatile.Register32 // 0x2C
	_              [972]byte
	DATE           volatile.Register32 // 0x3FC
}

// LP_ANA.BOD_MODE0_CNTL: need_des
func (o *LP_ANA_Type) SetBOD_MODE0_CNTL_BOD_MODE0_CLOSE_FLASH_ENA(value uint32) {
	volatile.StoreUint32(&o.BOD_MODE0_CNTL.Reg, volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg)&^(0x40)|value<<6)
}
func (o *LP_ANA_Type) GetBOD_MODE0_CNTL_BOD_MODE0_CLOSE_FLASH_ENA() uint32 {
	return (volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg) & 0x40) >> 6
}
func (o *LP_ANA_Type) SetBOD_MODE0_CNTL_BOD_MODE0_PD_RF_ENA(value uint32) {
	volatile.StoreUint32(&o.BOD_MODE0_CNTL.Reg, volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg)&^(0x80)|value<<7)
}
func (o *LP_ANA_Type) GetBOD_MODE0_CNTL_BOD_MODE0_PD_RF_ENA() uint32 {
	return (volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg) & 0x80) >> 7
}
func (o *LP_ANA_Type) SetBOD_MODE0_CNTL_BOD_MODE0_INTR_WAIT(value uint32) {
	volatile.StoreUint32(&o.BOD_MODE0_CNTL.Reg, volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg)&^(0x3ff00)|value<<8)
}
func (o *LP_ANA_Type) GetBOD_MODE0_CNTL_BOD_MODE0_INTR_WAIT() uint32 {
	return (volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg) & 0x3ff00) >> 8
}
func (o *LP_ANA_Type) SetBOD_MODE0_CNTL_BOD_MODE0_RESET_WAIT(value uint32) {
	volatile.StoreUint32(&o.BOD_MODE0_CNTL.Reg, volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg)&^(0xffc0000)|value<<18)
}
func (o *LP_ANA_Type) GetBOD_MODE0_CNTL_BOD_MODE0_RESET_WAIT() uint32 {
	return (volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg) & 0xffc0000) >> 18
}
func (o *LP_ANA_Type) SetBOD_MODE0_CNTL_BOD_MODE0_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.BOD_MODE0_CNTL.Reg, volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg)&^(0x10000000)|value<<28)
}
func (o *LP_ANA_Type) GetBOD_MODE0_CNTL_BOD_MODE0_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg) & 0x10000000) >> 28
}
func (o *LP_ANA_Type) SetBOD_MODE0_CNTL_BOD_MODE0_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.BOD_MODE0_CNTL.Reg, volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg)&^(0x20000000)|value<<29)
}
func (o *LP_ANA_Type) GetBOD_MODE0_CNTL_BOD_MODE0_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg) & 0x20000000) >> 29
}
func (o *LP_ANA_Type) SetBOD_MODE0_CNTL_BOD_MODE0_RESET_SEL(value uint32) {
	volatile.StoreUint32(&o.BOD_MODE0_CNTL.Reg, volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_ANA_Type) GetBOD_MODE0_CNTL_BOD_MODE0_RESET_SEL() uint32 {
	return (volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg) & 0x40000000) >> 30
}
func (o *LP_ANA_Type) SetBOD_MODE0_CNTL_BOD_MODE0_RESET_ENA(value uint32) {
	volatile.StoreUint32(&o.BOD_MODE0_CNTL.Reg, volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_ANA_Type) GetBOD_MODE0_CNTL_BOD_MODE0_RESET_ENA() uint32 {
	return (volatile.LoadUint32(&o.BOD_MODE0_CNTL.Reg) & 0x80000000) >> 31
}

// LP_ANA.BOD_MODE1_CNTL: need_des
func (o *LP_ANA_Type) SetBOD_MODE1_CNTL_BOD_MODE1_RESET_ENA(value uint32) {
	volatile.StoreUint32(&o.BOD_MODE1_CNTL.Reg, volatile.LoadUint32(&o.BOD_MODE1_CNTL.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_ANA_Type) GetBOD_MODE1_CNTL_BOD_MODE1_RESET_ENA() uint32 {
	return (volatile.LoadUint32(&o.BOD_MODE1_CNTL.Reg) & 0x80000000) >> 31
}

// LP_ANA.CK_GLITCH_CNTL: need_des
func (o *LP_ANA_Type) SetCK_GLITCH_CNTL_CK_GLITCH_RESET_ENA(value uint32) {
	volatile.StoreUint32(&o.CK_GLITCH_CNTL.Reg, volatile.LoadUint32(&o.CK_GLITCH_CNTL.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_ANA_Type) GetCK_GLITCH_CNTL_CK_GLITCH_RESET_ENA() uint32 {
	return (volatile.LoadUint32(&o.CK_GLITCH_CNTL.Reg) & 0x80000000) >> 31
}

// LP_ANA.FIB_ENABLE: need_des
func (o *LP_ANA_Type) SetFIB_ENABLE(value uint32) {
	volatile.StoreUint32(&o.FIB_ENABLE.Reg, value)
}
func (o *LP_ANA_Type) GetFIB_ENABLE() uint32 {
	return volatile.LoadUint32(&o.FIB_ENABLE.Reg)
}

// LP_ANA.INT_RAW: need_des
func (o *LP_ANA_Type) SetINT_RAW_BOD_MODE0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_ANA_Type) GetINT_RAW_BOD_MODE0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80000000) >> 31
}

// LP_ANA.INT_ST: need_des
func (o *LP_ANA_Type) SetINT_ST_BOD_MODE0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_ANA_Type) GetINT_ST_BOD_MODE0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80000000) >> 31
}

// LP_ANA.INT_ENA: need_des
func (o *LP_ANA_Type) SetINT_ENA_BOD_MODE0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_ANA_Type) GetINT_ENA_BOD_MODE0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80000000) >> 31
}

// LP_ANA.INT_CLR: need_des
func (o *LP_ANA_Type) SetINT_CLR_BOD_MODE0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_ANA_Type) GetINT_CLR_BOD_MODE0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80000000) >> 31
}

// LP_ANA.LP_INT_RAW: need_des
func (o *LP_ANA_Type) SetLP_INT_RAW_BOD_MODE0_LP_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.LP_INT_RAW.Reg, volatile.LoadUint32(&o.LP_INT_RAW.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_ANA_Type) GetLP_INT_RAW_BOD_MODE0_LP_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.LP_INT_RAW.Reg) & 0x80000000) >> 31
}

// LP_ANA.LP_INT_ST: need_des
func (o *LP_ANA_Type) SetLP_INT_ST_BOD_MODE0_LP_INT_ST(value uint32) {
	volatile.StoreUint32(&o.LP_INT_ST.Reg, volatile.LoadUint32(&o.LP_INT_ST.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_ANA_Type) GetLP_INT_ST_BOD_MODE0_LP_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.LP_INT_ST.Reg) & 0x80000000) >> 31
}

// LP_ANA.LP_INT_ENA: need_des
func (o *LP_ANA_Type) SetLP_INT_ENA_BOD_MODE0_LP_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.LP_INT_ENA.Reg, volatile.LoadUint32(&o.LP_INT_ENA.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_ANA_Type) GetLP_INT_ENA_BOD_MODE0_LP_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.LP_INT_ENA.Reg) & 0x80000000) >> 31
}

// LP_ANA.LP_INT_CLR: need_des
func (o *LP_ANA_Type) SetLP_INT_CLR_BOD_MODE0_LP_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.LP_INT_CLR.Reg, volatile.LoadUint32(&o.LP_INT_CLR.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_ANA_Type) GetLP_INT_CLR_BOD_MODE0_LP_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.LP_INT_CLR.Reg) & 0x80000000) >> 31
}

// LP_ANA.DATE: need_des
func (o *LP_ANA_Type) SetDATE_LP_ANA_DATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x7fffffff)|value)
}
func (o *LP_ANA_Type) GetDATE_LP_ANA_DATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x7fffffff
}
func (o *LP_ANA_Type) SetDATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_ANA_Type) GetDATE_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.DATE.Reg) & 0x80000000) >> 31
}

// LP_AON Peripheral
type LP_AON_Type struct {
	STORE0          volatile.Register32 // 0x0
	STORE1          volatile.Register32 // 0x4
	STORE2          volatile.Register32 // 0x8
	STORE3          volatile.Register32 // 0xC
	STORE4          volatile.Register32 // 0x10
	STORE5          volatile.Register32 // 0x14
	STORE6          volatile.Register32 // 0x18
	STORE7          volatile.Register32 // 0x1C
	STORE8          volatile.Register32 // 0x20
	STORE9          volatile.Register32 // 0x24
	GPIO_MUX        volatile.Register32 // 0x28
	GPIO_HOLD0      volatile.Register32 // 0x2C
	GPIO_HOLD1      volatile.Register32 // 0x30
	SYS_CFG         volatile.Register32 // 0x34
	CPUCORE0_CFG    volatile.Register32 // 0x38
	IO_MUX          volatile.Register32 // 0x3C
	EXT_WAKEUP_CNTL volatile.Register32 // 0x40
	USB             volatile.Register32 // 0x44
	LPBUS           volatile.Register32 // 0x48
	SDIO_ACTIVE     volatile.Register32 // 0x4C
	LPCORE          volatile.Register32 // 0x50
	SAR_CCT         volatile.Register32 // 0x54
	_               [932]byte
	DATE            volatile.Register32 // 0x3FC
}

// LP_AON.STORE0: need_des
func (o *LP_AON_Type) SetSTORE0(value uint32) {
	volatile.StoreUint32(&o.STORE0.Reg, value)
}
func (o *LP_AON_Type) GetSTORE0() uint32 {
	return volatile.LoadUint32(&o.STORE0.Reg)
}

// LP_AON.STORE1: need_des
func (o *LP_AON_Type) SetSTORE1(value uint32) {
	volatile.StoreUint32(&o.STORE1.Reg, value)
}
func (o *LP_AON_Type) GetSTORE1() uint32 {
	return volatile.LoadUint32(&o.STORE1.Reg)
}

// LP_AON.STORE2: need_des
func (o *LP_AON_Type) SetSTORE2(value uint32) {
	volatile.StoreUint32(&o.STORE2.Reg, value)
}
func (o *LP_AON_Type) GetSTORE2() uint32 {
	return volatile.LoadUint32(&o.STORE2.Reg)
}

// LP_AON.STORE3: need_des
func (o *LP_AON_Type) SetSTORE3(value uint32) {
	volatile.StoreUint32(&o.STORE3.Reg, value)
}
func (o *LP_AON_Type) GetSTORE3() uint32 {
	return volatile.LoadUint32(&o.STORE3.Reg)
}

// LP_AON.STORE4: need_des
func (o *LP_AON_Type) SetSTORE4(value uint32) {
	volatile.StoreUint32(&o.STORE4.Reg, value)
}
func (o *LP_AON_Type) GetSTORE4() uint32 {
	return volatile.LoadUint32(&o.STORE4.Reg)
}

// LP_AON.STORE5: need_des
func (o *LP_AON_Type) SetSTORE5(value uint32) {
	volatile.StoreUint32(&o.STORE5.Reg, value)
}
func (o *LP_AON_Type) GetSTORE5() uint32 {
	return volatile.LoadUint32(&o.STORE5.Reg)
}

// LP_AON.STORE6: need_des
func (o *LP_AON_Type) SetSTORE6(value uint32) {
	volatile.StoreUint32(&o.STORE6.Reg, value)
}
func (o *LP_AON_Type) GetSTORE6() uint32 {
	return volatile.LoadUint32(&o.STORE6.Reg)
}

// LP_AON.STORE7: need_des
func (o *LP_AON_Type) SetSTORE7(value uint32) {
	volatile.StoreUint32(&o.STORE7.Reg, value)
}
func (o *LP_AON_Type) GetSTORE7() uint32 {
	return volatile.LoadUint32(&o.STORE7.Reg)
}

// LP_AON.STORE8: need_des
func (o *LP_AON_Type) SetSTORE8(value uint32) {
	volatile.StoreUint32(&o.STORE8.Reg, value)
}
func (o *LP_AON_Type) GetSTORE8() uint32 {
	return volatile.LoadUint32(&o.STORE8.Reg)
}

// LP_AON.STORE9: need_des
func (o *LP_AON_Type) SetSTORE9(value uint32) {
	volatile.StoreUint32(&o.STORE9.Reg, value)
}
func (o *LP_AON_Type) GetSTORE9() uint32 {
	return volatile.LoadUint32(&o.STORE9.Reg)
}

// LP_AON.GPIO_MUX: need_des
func (o *LP_AON_Type) SetGPIO_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO_MUX.Reg, volatile.LoadUint32(&o.GPIO_MUX.Reg)&^(0xff)|value)
}
func (o *LP_AON_Type) GetGPIO_MUX_SEL() uint32 {
	return volatile.LoadUint32(&o.GPIO_MUX.Reg) & 0xff
}

// LP_AON.GPIO_HOLD0: need_des
func (o *LP_AON_Type) SetGPIO_HOLD0(value uint32) {
	volatile.StoreUint32(&o.GPIO_HOLD0.Reg, value)
}
func (o *LP_AON_Type) GetGPIO_HOLD0() uint32 {
	return volatile.LoadUint32(&o.GPIO_HOLD0.Reg)
}

// LP_AON.GPIO_HOLD1: need_des
func (o *LP_AON_Type) SetGPIO_HOLD1(value uint32) {
	volatile.StoreUint32(&o.GPIO_HOLD1.Reg, value)
}
func (o *LP_AON_Type) GetGPIO_HOLD1() uint32 {
	return volatile.LoadUint32(&o.GPIO_HOLD1.Reg)
}

// LP_AON.SYS_CFG: need_des
func (o *LP_AON_Type) SetSYS_CFG_FORCE_DOWNLOAD_BOOT(value uint32) {
	volatile.StoreUint32(&o.SYS_CFG.Reg, volatile.LoadUint32(&o.SYS_CFG.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_AON_Type) GetSYS_CFG_FORCE_DOWNLOAD_BOOT() uint32 {
	return (volatile.LoadUint32(&o.SYS_CFG.Reg) & 0x40000000) >> 30
}
func (o *LP_AON_Type) SetSYS_CFG_HPSYS_SW_RESET(value uint32) {
	volatile.StoreUint32(&o.SYS_CFG.Reg, volatile.LoadUint32(&o.SYS_CFG.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_AON_Type) GetSYS_CFG_HPSYS_SW_RESET() uint32 {
	return (volatile.LoadUint32(&o.SYS_CFG.Reg) & 0x80000000) >> 31
}

// LP_AON.CPUCORE0_CFG: need_des
func (o *LP_AON_Type) SetCPUCORE0_CFG_CPU_CORE0_SW_STALL(value uint32) {
	volatile.StoreUint32(&o.CPUCORE0_CFG.Reg, volatile.LoadUint32(&o.CPUCORE0_CFG.Reg)&^(0xff)|value)
}
func (o *LP_AON_Type) GetCPUCORE0_CFG_CPU_CORE0_SW_STALL() uint32 {
	return volatile.LoadUint32(&o.CPUCORE0_CFG.Reg) & 0xff
}
func (o *LP_AON_Type) SetCPUCORE0_CFG_CPU_CORE0_SW_RESET(value uint32) {
	volatile.StoreUint32(&o.CPUCORE0_CFG.Reg, volatile.LoadUint32(&o.CPUCORE0_CFG.Reg)&^(0x10000000)|value<<28)
}
func (o *LP_AON_Type) GetCPUCORE0_CFG_CPU_CORE0_SW_RESET() uint32 {
	return (volatile.LoadUint32(&o.CPUCORE0_CFG.Reg) & 0x10000000) >> 28
}
func (o *LP_AON_Type) SetCPUCORE0_CFG_CPU_CORE0_OCD_HALT_ON_RESET(value uint32) {
	volatile.StoreUint32(&o.CPUCORE0_CFG.Reg, volatile.LoadUint32(&o.CPUCORE0_CFG.Reg)&^(0x20000000)|value<<29)
}
func (o *LP_AON_Type) GetCPUCORE0_CFG_CPU_CORE0_OCD_HALT_ON_RESET() uint32 {
	return (volatile.LoadUint32(&o.CPUCORE0_CFG.Reg) & 0x20000000) >> 29
}
func (o *LP_AON_Type) SetCPUCORE0_CFG_CPU_CORE0_STAT_VECTOR_SEL(value uint32) {
	volatile.StoreUint32(&o.CPUCORE0_CFG.Reg, volatile.LoadUint32(&o.CPUCORE0_CFG.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_AON_Type) GetCPUCORE0_CFG_CPU_CORE0_STAT_VECTOR_SEL() uint32 {
	return (volatile.LoadUint32(&o.CPUCORE0_CFG.Reg) & 0x40000000) >> 30
}
func (o *LP_AON_Type) SetCPUCORE0_CFG_CPU_CORE0_DRESET_MASK(value uint32) {
	volatile.StoreUint32(&o.CPUCORE0_CFG.Reg, volatile.LoadUint32(&o.CPUCORE0_CFG.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_AON_Type) GetCPUCORE0_CFG_CPU_CORE0_DRESET_MASK() uint32 {
	return (volatile.LoadUint32(&o.CPUCORE0_CFG.Reg) & 0x80000000) >> 31
}

// LP_AON.IO_MUX: need_des
func (o *LP_AON_Type) SetIO_MUX_RESET_DISABLE(value uint32) {
	volatile.StoreUint32(&o.IO_MUX.Reg, volatile.LoadUint32(&o.IO_MUX.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_AON_Type) GetIO_MUX_RESET_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.IO_MUX.Reg) & 0x80000000) >> 31
}

// LP_AON.EXT_WAKEUP_CNTL: need_des
func (o *LP_AON_Type) SetEXT_WAKEUP_CNTL_EXT_WAKEUP_STATUS(value uint32) {
	volatile.StoreUint32(&o.EXT_WAKEUP_CNTL.Reg, volatile.LoadUint32(&o.EXT_WAKEUP_CNTL.Reg)&^(0xff)|value)
}
func (o *LP_AON_Type) GetEXT_WAKEUP_CNTL_EXT_WAKEUP_STATUS() uint32 {
	return volatile.LoadUint32(&o.EXT_WAKEUP_CNTL.Reg) & 0xff
}
func (o *LP_AON_Type) SetEXT_WAKEUP_CNTL_EXT_WAKEUP_STATUS_CLR(value uint32) {
	volatile.StoreUint32(&o.EXT_WAKEUP_CNTL.Reg, volatile.LoadUint32(&o.EXT_WAKEUP_CNTL.Reg)&^(0x4000)|value<<14)
}
func (o *LP_AON_Type) GetEXT_WAKEUP_CNTL_EXT_WAKEUP_STATUS_CLR() uint32 {
	return (volatile.LoadUint32(&o.EXT_WAKEUP_CNTL.Reg) & 0x4000) >> 14
}
func (o *LP_AON_Type) SetEXT_WAKEUP_CNTL_EXT_WAKEUP_SEL(value uint32) {
	volatile.StoreUint32(&o.EXT_WAKEUP_CNTL.Reg, volatile.LoadUint32(&o.EXT_WAKEUP_CNTL.Reg)&^(0x7f8000)|value<<15)
}
func (o *LP_AON_Type) GetEXT_WAKEUP_CNTL_EXT_WAKEUP_SEL() uint32 {
	return (volatile.LoadUint32(&o.EXT_WAKEUP_CNTL.Reg) & 0x7f8000) >> 15
}
func (o *LP_AON_Type) SetEXT_WAKEUP_CNTL_EXT_WAKEUP_LV(value uint32) {
	volatile.StoreUint32(&o.EXT_WAKEUP_CNTL.Reg, volatile.LoadUint32(&o.EXT_WAKEUP_CNTL.Reg)&^(0x7f800000)|value<<23)
}
func (o *LP_AON_Type) GetEXT_WAKEUP_CNTL_EXT_WAKEUP_LV() uint32 {
	return (volatile.LoadUint32(&o.EXT_WAKEUP_CNTL.Reg) & 0x7f800000) >> 23
}
func (o *LP_AON_Type) SetEXT_WAKEUP_CNTL_EXT_WAKEUP_FILTER(value uint32) {
	volatile.StoreUint32(&o.EXT_WAKEUP_CNTL.Reg, volatile.LoadUint32(&o.EXT_WAKEUP_CNTL.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_AON_Type) GetEXT_WAKEUP_CNTL_EXT_WAKEUP_FILTER() uint32 {
	return (volatile.LoadUint32(&o.EXT_WAKEUP_CNTL.Reg) & 0x80000000) >> 31
}

// LP_AON.USB: need_des
func (o *LP_AON_Type) SetUSB_RESET_DISABLE(value uint32) {
	volatile.StoreUint32(&o.USB.Reg, volatile.LoadUint32(&o.USB.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_AON_Type) GetUSB_RESET_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.USB.Reg) & 0x80000000) >> 31
}

// LP_AON.LPBUS: need_des
func (o *LP_AON_Type) SetLPBUS_FAST_MEM_WPULSE(value uint32) {
	volatile.StoreUint32(&o.LPBUS.Reg, volatile.LoadUint32(&o.LPBUS.Reg)&^(0x70000)|value<<16)
}
func (o *LP_AON_Type) GetLPBUS_FAST_MEM_WPULSE() uint32 {
	return (volatile.LoadUint32(&o.LPBUS.Reg) & 0x70000) >> 16
}
func (o *LP_AON_Type) SetLPBUS_FAST_MEM_WA(value uint32) {
	volatile.StoreUint32(&o.LPBUS.Reg, volatile.LoadUint32(&o.LPBUS.Reg)&^(0x380000)|value<<19)
}
func (o *LP_AON_Type) GetLPBUS_FAST_MEM_WA() uint32 {
	return (volatile.LoadUint32(&o.LPBUS.Reg) & 0x380000) >> 19
}
func (o *LP_AON_Type) SetLPBUS_FAST_MEM_RA(value uint32) {
	volatile.StoreUint32(&o.LPBUS.Reg, volatile.LoadUint32(&o.LPBUS.Reg)&^(0xc00000)|value<<22)
}
func (o *LP_AON_Type) GetLPBUS_FAST_MEM_RA() uint32 {
	return (volatile.LoadUint32(&o.LPBUS.Reg) & 0xc00000) >> 22
}
func (o *LP_AON_Type) SetLPBUS_FAST_MEM_MUX_FSM_IDLE(value uint32) {
	volatile.StoreUint32(&o.LPBUS.Reg, volatile.LoadUint32(&o.LPBUS.Reg)&^(0x10000000)|value<<28)
}
func (o *LP_AON_Type) GetLPBUS_FAST_MEM_MUX_FSM_IDLE() uint32 {
	return (volatile.LoadUint32(&o.LPBUS.Reg) & 0x10000000) >> 28
}
func (o *LP_AON_Type) SetLPBUS_FAST_MEM_MUX_SEL_STATUS(value uint32) {
	volatile.StoreUint32(&o.LPBUS.Reg, volatile.LoadUint32(&o.LPBUS.Reg)&^(0x20000000)|value<<29)
}
func (o *LP_AON_Type) GetLPBUS_FAST_MEM_MUX_SEL_STATUS() uint32 {
	return (volatile.LoadUint32(&o.LPBUS.Reg) & 0x20000000) >> 29
}
func (o *LP_AON_Type) SetLPBUS_FAST_MEM_MUX_SEL_UPDATE(value uint32) {
	volatile.StoreUint32(&o.LPBUS.Reg, volatile.LoadUint32(&o.LPBUS.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_AON_Type) GetLPBUS_FAST_MEM_MUX_SEL_UPDATE() uint32 {
	return (volatile.LoadUint32(&o.LPBUS.Reg) & 0x40000000) >> 30
}
func (o *LP_AON_Type) SetLPBUS_FAST_MEM_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.LPBUS.Reg, volatile.LoadUint32(&o.LPBUS.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_AON_Type) GetLPBUS_FAST_MEM_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.LPBUS.Reg) & 0x80000000) >> 31
}

// LP_AON.SDIO_ACTIVE: need_des
func (o *LP_AON_Type) SetSDIO_ACTIVE_SDIO_ACT_DNUM(value uint32) {
	volatile.StoreUint32(&o.SDIO_ACTIVE.Reg, volatile.LoadUint32(&o.SDIO_ACTIVE.Reg)&^(0xffc00000)|value<<22)
}
func (o *LP_AON_Type) GetSDIO_ACTIVE_SDIO_ACT_DNUM() uint32 {
	return (volatile.LoadUint32(&o.SDIO_ACTIVE.Reg) & 0xffc00000) >> 22
}

// LP_AON.LPCORE: need_des
func (o *LP_AON_Type) SetLPCORE_ETM_WAKEUP_FLAG_CLR(value uint32) {
	volatile.StoreUint32(&o.LPCORE.Reg, volatile.LoadUint32(&o.LPCORE.Reg)&^(0x1)|value)
}
func (o *LP_AON_Type) GetLPCORE_ETM_WAKEUP_FLAG_CLR() uint32 {
	return volatile.LoadUint32(&o.LPCORE.Reg) & 0x1
}
func (o *LP_AON_Type) SetLPCORE_ETM_WAKEUP_FLAG(value uint32) {
	volatile.StoreUint32(&o.LPCORE.Reg, volatile.LoadUint32(&o.LPCORE.Reg)&^(0x2)|value<<1)
}
func (o *LP_AON_Type) GetLPCORE_ETM_WAKEUP_FLAG() uint32 {
	return (volatile.LoadUint32(&o.LPCORE.Reg) & 0x2) >> 1
}
func (o *LP_AON_Type) SetLPCORE_DISABLE(value uint32) {
	volatile.StoreUint32(&o.LPCORE.Reg, volatile.LoadUint32(&o.LPCORE.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_AON_Type) GetLPCORE_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.LPCORE.Reg) & 0x80000000) >> 31
}

// LP_AON.SAR_CCT: need_des
func (o *LP_AON_Type) SetSAR_CCT_SAR2_PWDET_CCT(value uint32) {
	volatile.StoreUint32(&o.SAR_CCT.Reg, volatile.LoadUint32(&o.SAR_CCT.Reg)&^(0xe0000000)|value<<29)
}
func (o *LP_AON_Type) GetSAR_CCT_SAR2_PWDET_CCT() uint32 {
	return (volatile.LoadUint32(&o.SAR_CCT.Reg) & 0xe0000000) >> 29
}

// LP_AON.DATE: need_des
func (o *LP_AON_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x7fffffff)|value)
}
func (o *LP_AON_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x7fffffff
}
func (o *LP_AON_Type) SetDATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_AON_Type) GetDATE_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.DATE.Reg) & 0x80000000) >> 31
}

// Low-power Access Permission Management Controller
type LP_APM_Type struct {
	REGION_FILTER_EN   volatile.Register32 // 0x0
	REGION0_ADDR_START volatile.Register32 // 0x4
	REGION0_ADDR_END   volatile.Register32 // 0x8
	REGION0_PMS_ATTR   volatile.Register32 // 0xC
	REGION1_ADDR_START volatile.Register32 // 0x10
	REGION1_ADDR_END   volatile.Register32 // 0x14
	REGION1_PMS_ATTR   volatile.Register32 // 0x18
	REGION2_ADDR_START volatile.Register32 // 0x1C
	REGION2_ADDR_END   volatile.Register32 // 0x20
	REGION2_PMS_ATTR   volatile.Register32 // 0x24
	REGION3_ADDR_START volatile.Register32 // 0x28
	REGION3_ADDR_END   volatile.Register32 // 0x2C
	REGION3_PMS_ATTR   volatile.Register32 // 0x30
	_                  [144]byte
	FUNC_CTRL          volatile.Register32 // 0xC4
	M0_STATUS          volatile.Register32 // 0xC8
	M0_STATUS_CLR      volatile.Register32 // 0xCC
	M0_EXCEPTION_INFO0 volatile.Register32 // 0xD0
	M0_EXCEPTION_INFO1 volatile.Register32 // 0xD4
	M1_STATUS          volatile.Register32 // 0xD8
	M1_STATUS_CLR      volatile.Register32 // 0xDC
	M1_EXCEPTION_INFO0 volatile.Register32 // 0xE0
	M1_EXCEPTION_INFO1 volatile.Register32 // 0xE4
	INT_EN             volatile.Register32 // 0xE8
	CLOCK_GATE         volatile.Register32 // 0xEC
	_                  [12]byte
	DATE               volatile.Register32 // 0xFC
}

// LP_APM.REGION_FILTER_EN: Region filter enable register
func (o *LP_APM_Type) SetREGION_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.REGION_FILTER_EN.Reg, volatile.LoadUint32(&o.REGION_FILTER_EN.Reg)&^(0xf)|value)
}
func (o *LP_APM_Type) GetREGION_FILTER_EN() uint32 {
	return volatile.LoadUint32(&o.REGION_FILTER_EN.Reg) & 0xf
}

// LP_APM.REGION0_ADDR_START: Region address register
func (o *LP_APM_Type) SetREGION0_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION0_ADDR_START.Reg, value)
}
func (o *LP_APM_Type) GetREGION0_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION0_ADDR_START.Reg)
}

// LP_APM.REGION0_ADDR_END: Region address register
func (o *LP_APM_Type) SetREGION0_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION0_ADDR_END.Reg, value)
}
func (o *LP_APM_Type) GetREGION0_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION0_ADDR_END.Reg)
}

// LP_APM.REGION0_PMS_ATTR: Region access authority attribute register
func (o *LP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *LP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x1
}
func (o *LP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *LP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *LP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *LP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *LP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *LP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *LP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *LP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *LP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *LP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *LP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *LP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *LP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *LP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *LP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *LP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x400) >> 10
}

// LP_APM.REGION1_ADDR_START: Region address register
func (o *LP_APM_Type) SetREGION1_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION1_ADDR_START.Reg, value)
}
func (o *LP_APM_Type) GetREGION1_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION1_ADDR_START.Reg)
}

// LP_APM.REGION1_ADDR_END: Region address register
func (o *LP_APM_Type) SetREGION1_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION1_ADDR_END.Reg, value)
}
func (o *LP_APM_Type) GetREGION1_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION1_ADDR_END.Reg)
}

// LP_APM.REGION1_PMS_ATTR: Region access authority attribute register
func (o *LP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *LP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x1
}
func (o *LP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *LP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *LP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *LP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *LP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *LP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *LP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *LP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *LP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *LP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *LP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *LP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *LP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *LP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *LP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *LP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x400) >> 10
}

// LP_APM.REGION2_ADDR_START: Region address register
func (o *LP_APM_Type) SetREGION2_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION2_ADDR_START.Reg, value)
}
func (o *LP_APM_Type) GetREGION2_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION2_ADDR_START.Reg)
}

// LP_APM.REGION2_ADDR_END: Region address register
func (o *LP_APM_Type) SetREGION2_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION2_ADDR_END.Reg, value)
}
func (o *LP_APM_Type) GetREGION2_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION2_ADDR_END.Reg)
}

// LP_APM.REGION2_PMS_ATTR: Region access authority attribute register
func (o *LP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *LP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x1
}
func (o *LP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *LP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *LP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *LP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *LP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *LP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *LP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *LP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *LP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *LP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *LP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *LP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *LP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *LP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *LP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *LP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x400) >> 10
}

// LP_APM.REGION3_ADDR_START: Region address register
func (o *LP_APM_Type) SetREGION3_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION3_ADDR_START.Reg, value)
}
func (o *LP_APM_Type) GetREGION3_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION3_ADDR_START.Reg)
}

// LP_APM.REGION3_ADDR_END: Region address register
func (o *LP_APM_Type) SetREGION3_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION3_ADDR_END.Reg, value)
}
func (o *LP_APM_Type) GetREGION3_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION3_ADDR_END.Reg)
}

// LP_APM.REGION3_PMS_ATTR: Region access authority attribute register
func (o *LP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *LP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x1
}
func (o *LP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *LP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *LP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *LP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *LP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *LP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *LP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *LP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *LP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *LP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *LP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *LP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *LP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *LP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *LP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *LP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x400) >> 10
}

// LP_APM.FUNC_CTRL: PMS function control register
func (o *LP_APM_Type) SetFUNC_CTRL_M0_PMS_FUNC_EN(value uint32) {
	volatile.StoreUint32(&o.FUNC_CTRL.Reg, volatile.LoadUint32(&o.FUNC_CTRL.Reg)&^(0x1)|value)
}
func (o *LP_APM_Type) GetFUNC_CTRL_M0_PMS_FUNC_EN() uint32 {
	return volatile.LoadUint32(&o.FUNC_CTRL.Reg) & 0x1
}
func (o *LP_APM_Type) SetFUNC_CTRL_M1_PMS_FUNC_EN(value uint32) {
	volatile.StoreUint32(&o.FUNC_CTRL.Reg, volatile.LoadUint32(&o.FUNC_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *LP_APM_Type) GetFUNC_CTRL_M1_PMS_FUNC_EN() uint32 {
	return (volatile.LoadUint32(&o.FUNC_CTRL.Reg) & 0x2) >> 1
}

// LP_APM.M0_STATUS: M0 status register
func (o *LP_APM_Type) SetM0_STATUS_M0_EXCEPTION_STATUS(value uint32) {
	volatile.StoreUint32(&o.M0_STATUS.Reg, volatile.LoadUint32(&o.M0_STATUS.Reg)&^(0x3)|value)
}
func (o *LP_APM_Type) GetM0_STATUS_M0_EXCEPTION_STATUS() uint32 {
	return volatile.LoadUint32(&o.M0_STATUS.Reg) & 0x3
}

// LP_APM.M0_STATUS_CLR: M0 status clear register
func (o *LP_APM_Type) SetM0_STATUS_CLR_M0_REGION_STATUS_CLR(value uint32) {
	volatile.StoreUint32(&o.M0_STATUS_CLR.Reg, volatile.LoadUint32(&o.M0_STATUS_CLR.Reg)&^(0x1)|value)
}
func (o *LP_APM_Type) GetM0_STATUS_CLR_M0_REGION_STATUS_CLR() uint32 {
	return volatile.LoadUint32(&o.M0_STATUS_CLR.Reg) & 0x1
}

// LP_APM.M0_EXCEPTION_INFO0: M0 exception_info0 register
func (o *LP_APM_Type) SetM0_EXCEPTION_INFO0_M0_EXCEPTION_REGION(value uint32) {
	volatile.StoreUint32(&o.M0_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M0_EXCEPTION_INFO0.Reg)&^(0xf)|value)
}
func (o *LP_APM_Type) GetM0_EXCEPTION_INFO0_M0_EXCEPTION_REGION() uint32 {
	return volatile.LoadUint32(&o.M0_EXCEPTION_INFO0.Reg) & 0xf
}
func (o *LP_APM_Type) SetM0_EXCEPTION_INFO0_M0_EXCEPTION_MODE(value uint32) {
	volatile.StoreUint32(&o.M0_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M0_EXCEPTION_INFO0.Reg)&^(0x30000)|value<<16)
}
func (o *LP_APM_Type) GetM0_EXCEPTION_INFO0_M0_EXCEPTION_MODE() uint32 {
	return (volatile.LoadUint32(&o.M0_EXCEPTION_INFO0.Reg) & 0x30000) >> 16
}
func (o *LP_APM_Type) SetM0_EXCEPTION_INFO0_M0_EXCEPTION_ID(value uint32) {
	volatile.StoreUint32(&o.M0_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M0_EXCEPTION_INFO0.Reg)&^(0x7c0000)|value<<18)
}
func (o *LP_APM_Type) GetM0_EXCEPTION_INFO0_M0_EXCEPTION_ID() uint32 {
	return (volatile.LoadUint32(&o.M0_EXCEPTION_INFO0.Reg) & 0x7c0000) >> 18
}

// LP_APM.M0_EXCEPTION_INFO1: M0 exception_info1 register
func (o *LP_APM_Type) SetM0_EXCEPTION_INFO1(value uint32) {
	volatile.StoreUint32(&o.M0_EXCEPTION_INFO1.Reg, value)
}
func (o *LP_APM_Type) GetM0_EXCEPTION_INFO1() uint32 {
	return volatile.LoadUint32(&o.M0_EXCEPTION_INFO1.Reg)
}

// LP_APM.M1_STATUS: M1 status register
func (o *LP_APM_Type) SetM1_STATUS_M1_EXCEPTION_STATUS(value uint32) {
	volatile.StoreUint32(&o.M1_STATUS.Reg, volatile.LoadUint32(&o.M1_STATUS.Reg)&^(0x3)|value)
}
func (o *LP_APM_Type) GetM1_STATUS_M1_EXCEPTION_STATUS() uint32 {
	return volatile.LoadUint32(&o.M1_STATUS.Reg) & 0x3
}

// LP_APM.M1_STATUS_CLR: M1 status clear register
func (o *LP_APM_Type) SetM1_STATUS_CLR_M1_REGION_STATUS_CLR(value uint32) {
	volatile.StoreUint32(&o.M1_STATUS_CLR.Reg, volatile.LoadUint32(&o.M1_STATUS_CLR.Reg)&^(0x1)|value)
}
func (o *LP_APM_Type) GetM1_STATUS_CLR_M1_REGION_STATUS_CLR() uint32 {
	return volatile.LoadUint32(&o.M1_STATUS_CLR.Reg) & 0x1
}

// LP_APM.M1_EXCEPTION_INFO0: M1 exception_info0 register
func (o *LP_APM_Type) SetM1_EXCEPTION_INFO0_M1_EXCEPTION_REGION(value uint32) {
	volatile.StoreUint32(&o.M1_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M1_EXCEPTION_INFO0.Reg)&^(0xf)|value)
}
func (o *LP_APM_Type) GetM1_EXCEPTION_INFO0_M1_EXCEPTION_REGION() uint32 {
	return volatile.LoadUint32(&o.M1_EXCEPTION_INFO0.Reg) & 0xf
}
func (o *LP_APM_Type) SetM1_EXCEPTION_INFO0_M1_EXCEPTION_MODE(value uint32) {
	volatile.StoreUint32(&o.M1_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M1_EXCEPTION_INFO0.Reg)&^(0x30000)|value<<16)
}
func (o *LP_APM_Type) GetM1_EXCEPTION_INFO0_M1_EXCEPTION_MODE() uint32 {
	return (volatile.LoadUint32(&o.M1_EXCEPTION_INFO0.Reg) & 0x30000) >> 16
}
func (o *LP_APM_Type) SetM1_EXCEPTION_INFO0_M1_EXCEPTION_ID(value uint32) {
	volatile.StoreUint32(&o.M1_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M1_EXCEPTION_INFO0.Reg)&^(0x7c0000)|value<<18)
}
func (o *LP_APM_Type) GetM1_EXCEPTION_INFO0_M1_EXCEPTION_ID() uint32 {
	return (volatile.LoadUint32(&o.M1_EXCEPTION_INFO0.Reg) & 0x7c0000) >> 18
}

// LP_APM.M1_EXCEPTION_INFO1: M1 exception_info1 register
func (o *LP_APM_Type) SetM1_EXCEPTION_INFO1(value uint32) {
	volatile.StoreUint32(&o.M1_EXCEPTION_INFO1.Reg, value)
}
func (o *LP_APM_Type) GetM1_EXCEPTION_INFO1() uint32 {
	return volatile.LoadUint32(&o.M1_EXCEPTION_INFO1.Reg)
}

// LP_APM.INT_EN: APM interrupt enable register
func (o *LP_APM_Type) SetINT_EN_M0_APM_INT_EN(value uint32) {
	volatile.StoreUint32(&o.INT_EN.Reg, volatile.LoadUint32(&o.INT_EN.Reg)&^(0x1)|value)
}
func (o *LP_APM_Type) GetINT_EN_M0_APM_INT_EN() uint32 {
	return volatile.LoadUint32(&o.INT_EN.Reg) & 0x1
}
func (o *LP_APM_Type) SetINT_EN_M1_APM_INT_EN(value uint32) {
	volatile.StoreUint32(&o.INT_EN.Reg, volatile.LoadUint32(&o.INT_EN.Reg)&^(0x2)|value<<1)
}
func (o *LP_APM_Type) GetINT_EN_M1_APM_INT_EN() uint32 {
	return (volatile.LoadUint32(&o.INT_EN.Reg) & 0x2) >> 1
}

// LP_APM.CLOCK_GATE: clock gating register
func (o *LP_APM_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *LP_APM_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// LP_APM.DATE: Version register
func (o *LP_APM_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *LP_APM_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// LP_CLKRST Peripheral
type LP_CLKRST_Type struct {
	LP_CLK_CONF  volatile.Register32 // 0x0
	LP_CLK_PO_EN volatile.Register32 // 0x4
	LP_CLK_EN    volatile.Register32 // 0x8
	LP_RST_EN    volatile.Register32 // 0xC
	RESET_CAUSE  volatile.Register32 // 0x10
	CPU_RESET    volatile.Register32 // 0x14
	FOSC_CNTL    volatile.Register32 // 0x18
	RC32K_CNTL   volatile.Register32 // 0x1C
	CLK_TO_HP    volatile.Register32 // 0x20
	LPMEM_FORCE  volatile.Register32 // 0x24
	LPPERI       volatile.Register32 // 0x28
	XTAL32K      volatile.Register32 // 0x2C
	_            [972]byte
	DATE         volatile.Register32 // 0x3FC
}

// LP_CLKRST.LP_CLK_CONF: need_des
func (o *LP_CLKRST_Type) SetLP_CLK_CONF_SLOW_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.LP_CLK_CONF.Reg, volatile.LoadUint32(&o.LP_CLK_CONF.Reg)&^(0x3)|value)
}
func (o *LP_CLKRST_Type) GetLP_CLK_CONF_SLOW_CLK_SEL() uint32 {
	return volatile.LoadUint32(&o.LP_CLK_CONF.Reg) & 0x3
}
func (o *LP_CLKRST_Type) SetLP_CLK_CONF_FAST_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.LP_CLK_CONF.Reg, volatile.LoadUint32(&o.LP_CLK_CONF.Reg)&^(0x4)|value<<2)
}
func (o *LP_CLKRST_Type) GetLP_CLK_CONF_FAST_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.LP_CLK_CONF.Reg) & 0x4) >> 2
}
func (o *LP_CLKRST_Type) SetLP_CLK_CONF_LP_PERI_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.LP_CLK_CONF.Reg, volatile.LoadUint32(&o.LP_CLK_CONF.Reg)&^(0x7f8)|value<<3)
}
func (o *LP_CLKRST_Type) GetLP_CLK_CONF_LP_PERI_DIV_NUM() uint32 {
	return (volatile.LoadUint32(&o.LP_CLK_CONF.Reg) & 0x7f8) >> 3
}

// LP_CLKRST.LP_CLK_PO_EN: need_des
func (o *LP_CLKRST_Type) SetLP_CLK_PO_EN_AON_SLOW_OEN(value uint32) {
	volatile.StoreUint32(&o.LP_CLK_PO_EN.Reg, volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg)&^(0x1)|value)
}
func (o *LP_CLKRST_Type) GetLP_CLK_PO_EN_AON_SLOW_OEN() uint32 {
	return volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg) & 0x1
}
func (o *LP_CLKRST_Type) SetLP_CLK_PO_EN_AON_FAST_OEN(value uint32) {
	volatile.StoreUint32(&o.LP_CLK_PO_EN.Reg, volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg)&^(0x2)|value<<1)
}
func (o *LP_CLKRST_Type) GetLP_CLK_PO_EN_AON_FAST_OEN() uint32 {
	return (volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg) & 0x2) >> 1
}
func (o *LP_CLKRST_Type) SetLP_CLK_PO_EN_SOSC_OEN(value uint32) {
	volatile.StoreUint32(&o.LP_CLK_PO_EN.Reg, volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg)&^(0x4)|value<<2)
}
func (o *LP_CLKRST_Type) GetLP_CLK_PO_EN_SOSC_OEN() uint32 {
	return (volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg) & 0x4) >> 2
}
func (o *LP_CLKRST_Type) SetLP_CLK_PO_EN_FOSC_OEN(value uint32) {
	volatile.StoreUint32(&o.LP_CLK_PO_EN.Reg, volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg)&^(0x8)|value<<3)
}
func (o *LP_CLKRST_Type) GetLP_CLK_PO_EN_FOSC_OEN() uint32 {
	return (volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg) & 0x8) >> 3
}
func (o *LP_CLKRST_Type) SetLP_CLK_PO_EN_OSC32K_OEN(value uint32) {
	volatile.StoreUint32(&o.LP_CLK_PO_EN.Reg, volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg)&^(0x10)|value<<4)
}
func (o *LP_CLKRST_Type) GetLP_CLK_PO_EN_OSC32K_OEN() uint32 {
	return (volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg) & 0x10) >> 4
}
func (o *LP_CLKRST_Type) SetLP_CLK_PO_EN_XTAL32K_OEN(value uint32) {
	volatile.StoreUint32(&o.LP_CLK_PO_EN.Reg, volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg)&^(0x20)|value<<5)
}
func (o *LP_CLKRST_Type) GetLP_CLK_PO_EN_XTAL32K_OEN() uint32 {
	return (volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg) & 0x20) >> 5
}
func (o *LP_CLKRST_Type) SetLP_CLK_PO_EN_CORE_EFUSE_OEN(value uint32) {
	volatile.StoreUint32(&o.LP_CLK_PO_EN.Reg, volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg)&^(0x40)|value<<6)
}
func (o *LP_CLKRST_Type) GetLP_CLK_PO_EN_CORE_EFUSE_OEN() uint32 {
	return (volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg) & 0x40) >> 6
}
func (o *LP_CLKRST_Type) SetLP_CLK_PO_EN_SLOW_OEN(value uint32) {
	volatile.StoreUint32(&o.LP_CLK_PO_EN.Reg, volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg)&^(0x80)|value<<7)
}
func (o *LP_CLKRST_Type) GetLP_CLK_PO_EN_SLOW_OEN() uint32 {
	return (volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg) & 0x80) >> 7
}
func (o *LP_CLKRST_Type) SetLP_CLK_PO_EN_FAST_OEN(value uint32) {
	volatile.StoreUint32(&o.LP_CLK_PO_EN.Reg, volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg)&^(0x100)|value<<8)
}
func (o *LP_CLKRST_Type) GetLP_CLK_PO_EN_FAST_OEN() uint32 {
	return (volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg) & 0x100) >> 8
}
func (o *LP_CLKRST_Type) SetLP_CLK_PO_EN_RNG_OEN(value uint32) {
	volatile.StoreUint32(&o.LP_CLK_PO_EN.Reg, volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg)&^(0x200)|value<<9)
}
func (o *LP_CLKRST_Type) GetLP_CLK_PO_EN_RNG_OEN() uint32 {
	return (volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg) & 0x200) >> 9
}
func (o *LP_CLKRST_Type) SetLP_CLK_PO_EN_LPBUS_OEN(value uint32) {
	volatile.StoreUint32(&o.LP_CLK_PO_EN.Reg, volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg)&^(0x400)|value<<10)
}
func (o *LP_CLKRST_Type) GetLP_CLK_PO_EN_LPBUS_OEN() uint32 {
	return (volatile.LoadUint32(&o.LP_CLK_PO_EN.Reg) & 0x400) >> 10
}

// LP_CLKRST.LP_CLK_EN: need_des
func (o *LP_CLKRST_Type) SetLP_CLK_EN_FAST_ORI_GATE(value uint32) {
	volatile.StoreUint32(&o.LP_CLK_EN.Reg, volatile.LoadUint32(&o.LP_CLK_EN.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_CLKRST_Type) GetLP_CLK_EN_FAST_ORI_GATE() uint32 {
	return (volatile.LoadUint32(&o.LP_CLK_EN.Reg) & 0x80000000) >> 31
}

// LP_CLKRST.LP_RST_EN: need_des
func (o *LP_CLKRST_Type) SetLP_RST_EN_AON_EFUSE_CORE_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.LP_RST_EN.Reg, volatile.LoadUint32(&o.LP_RST_EN.Reg)&^(0x10000000)|value<<28)
}
func (o *LP_CLKRST_Type) GetLP_RST_EN_AON_EFUSE_CORE_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.LP_RST_EN.Reg) & 0x10000000) >> 28
}
func (o *LP_CLKRST_Type) SetLP_RST_EN_LP_TIMER_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.LP_RST_EN.Reg, volatile.LoadUint32(&o.LP_RST_EN.Reg)&^(0x20000000)|value<<29)
}
func (o *LP_CLKRST_Type) GetLP_RST_EN_LP_TIMER_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.LP_RST_EN.Reg) & 0x20000000) >> 29
}
func (o *LP_CLKRST_Type) SetLP_RST_EN_WDT_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.LP_RST_EN.Reg, volatile.LoadUint32(&o.LP_RST_EN.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_CLKRST_Type) GetLP_RST_EN_WDT_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.LP_RST_EN.Reg) & 0x40000000) >> 30
}
func (o *LP_CLKRST_Type) SetLP_RST_EN_ANA_PERI_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.LP_RST_EN.Reg, volatile.LoadUint32(&o.LP_RST_EN.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_CLKRST_Type) GetLP_RST_EN_ANA_PERI_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.LP_RST_EN.Reg) & 0x80000000) >> 31
}

// LP_CLKRST.RESET_CAUSE: need_des
func (o *LP_CLKRST_Type) SetRESET_CAUSE(value uint32) {
	volatile.StoreUint32(&o.RESET_CAUSE.Reg, volatile.LoadUint32(&o.RESET_CAUSE.Reg)&^(0x1f)|value)
}
func (o *LP_CLKRST_Type) GetRESET_CAUSE() uint32 {
	return volatile.LoadUint32(&o.RESET_CAUSE.Reg) & 0x1f
}
func (o *LP_CLKRST_Type) SetRESET_CAUSE_CORE0_RESET_FLAG(value uint32) {
	volatile.StoreUint32(&o.RESET_CAUSE.Reg, volatile.LoadUint32(&o.RESET_CAUSE.Reg)&^(0x20)|value<<5)
}
func (o *LP_CLKRST_Type) GetRESET_CAUSE_CORE0_RESET_FLAG() uint32 {
	return (volatile.LoadUint32(&o.RESET_CAUSE.Reg) & 0x20) >> 5
}
func (o *LP_CLKRST_Type) SetRESET_CAUSE_CORE0_RESET_CAUSE_CLR(value uint32) {
	volatile.StoreUint32(&o.RESET_CAUSE.Reg, volatile.LoadUint32(&o.RESET_CAUSE.Reg)&^(0x20000000)|value<<29)
}
func (o *LP_CLKRST_Type) GetRESET_CAUSE_CORE0_RESET_CAUSE_CLR() uint32 {
	return (volatile.LoadUint32(&o.RESET_CAUSE.Reg) & 0x20000000) >> 29
}
func (o *LP_CLKRST_Type) SetRESET_CAUSE_CORE0_RESET_FLAG_SET(value uint32) {
	volatile.StoreUint32(&o.RESET_CAUSE.Reg, volatile.LoadUint32(&o.RESET_CAUSE.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_CLKRST_Type) GetRESET_CAUSE_CORE0_RESET_FLAG_SET() uint32 {
	return (volatile.LoadUint32(&o.RESET_CAUSE.Reg) & 0x40000000) >> 30
}
func (o *LP_CLKRST_Type) SetRESET_CAUSE_CORE0_RESET_FLAG_CLR(value uint32) {
	volatile.StoreUint32(&o.RESET_CAUSE.Reg, volatile.LoadUint32(&o.RESET_CAUSE.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_CLKRST_Type) GetRESET_CAUSE_CORE0_RESET_FLAG_CLR() uint32 {
	return (volatile.LoadUint32(&o.RESET_CAUSE.Reg) & 0x80000000) >> 31
}

// LP_CLKRST.CPU_RESET: need_des
func (o *LP_CLKRST_Type) SetCPU_RESET_RTC_WDT_CPU_RESET_LENGTH(value uint32) {
	volatile.StoreUint32(&o.CPU_RESET.Reg, volatile.LoadUint32(&o.CPU_RESET.Reg)&^(0x1c00000)|value<<22)
}
func (o *LP_CLKRST_Type) GetCPU_RESET_RTC_WDT_CPU_RESET_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.CPU_RESET.Reg) & 0x1c00000) >> 22
}
func (o *LP_CLKRST_Type) SetCPU_RESET_RTC_WDT_CPU_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.CPU_RESET.Reg, volatile.LoadUint32(&o.CPU_RESET.Reg)&^(0x2000000)|value<<25)
}
func (o *LP_CLKRST_Type) GetCPU_RESET_RTC_WDT_CPU_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.CPU_RESET.Reg) & 0x2000000) >> 25
}
func (o *LP_CLKRST_Type) SetCPU_RESET_CPU_STALL_WAIT(value uint32) {
	volatile.StoreUint32(&o.CPU_RESET.Reg, volatile.LoadUint32(&o.CPU_RESET.Reg)&^(0x7c000000)|value<<26)
}
func (o *LP_CLKRST_Type) GetCPU_RESET_CPU_STALL_WAIT() uint32 {
	return (volatile.LoadUint32(&o.CPU_RESET.Reg) & 0x7c000000) >> 26
}
func (o *LP_CLKRST_Type) SetCPU_RESET_CPU_STALL_EN(value uint32) {
	volatile.StoreUint32(&o.CPU_RESET.Reg, volatile.LoadUint32(&o.CPU_RESET.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_CLKRST_Type) GetCPU_RESET_CPU_STALL_EN() uint32 {
	return (volatile.LoadUint32(&o.CPU_RESET.Reg) & 0x80000000) >> 31
}

// LP_CLKRST.FOSC_CNTL: need_des
func (o *LP_CLKRST_Type) SetFOSC_CNTL_FOSC_DFREQ(value uint32) {
	volatile.StoreUint32(&o.FOSC_CNTL.Reg, volatile.LoadUint32(&o.FOSC_CNTL.Reg)&^(0xffc00000)|value<<22)
}
func (o *LP_CLKRST_Type) GetFOSC_CNTL_FOSC_DFREQ() uint32 {
	return (volatile.LoadUint32(&o.FOSC_CNTL.Reg) & 0xffc00000) >> 22
}

// LP_CLKRST.RC32K_CNTL: need_des
func (o *LP_CLKRST_Type) SetRC32K_CNTL_RC32K_DFREQ(value uint32) {
	volatile.StoreUint32(&o.RC32K_CNTL.Reg, volatile.LoadUint32(&o.RC32K_CNTL.Reg)&^(0xffc00000)|value<<22)
}
func (o *LP_CLKRST_Type) GetRC32K_CNTL_RC32K_DFREQ() uint32 {
	return (volatile.LoadUint32(&o.RC32K_CNTL.Reg) & 0xffc00000) >> 22
}

// LP_CLKRST.CLK_TO_HP: need_des
func (o *LP_CLKRST_Type) SetCLK_TO_HP_ICG_HP_XTAL32K(value uint32) {
	volatile.StoreUint32(&o.CLK_TO_HP.Reg, volatile.LoadUint32(&o.CLK_TO_HP.Reg)&^(0x10000000)|value<<28)
}
func (o *LP_CLKRST_Type) GetCLK_TO_HP_ICG_HP_XTAL32K() uint32 {
	return (volatile.LoadUint32(&o.CLK_TO_HP.Reg) & 0x10000000) >> 28
}
func (o *LP_CLKRST_Type) SetCLK_TO_HP_ICG_HP_SOSC(value uint32) {
	volatile.StoreUint32(&o.CLK_TO_HP.Reg, volatile.LoadUint32(&o.CLK_TO_HP.Reg)&^(0x20000000)|value<<29)
}
func (o *LP_CLKRST_Type) GetCLK_TO_HP_ICG_HP_SOSC() uint32 {
	return (volatile.LoadUint32(&o.CLK_TO_HP.Reg) & 0x20000000) >> 29
}
func (o *LP_CLKRST_Type) SetCLK_TO_HP_ICG_HP_OSC32K(value uint32) {
	volatile.StoreUint32(&o.CLK_TO_HP.Reg, volatile.LoadUint32(&o.CLK_TO_HP.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_CLKRST_Type) GetCLK_TO_HP_ICG_HP_OSC32K() uint32 {
	return (volatile.LoadUint32(&o.CLK_TO_HP.Reg) & 0x40000000) >> 30
}
func (o *LP_CLKRST_Type) SetCLK_TO_HP_ICG_HP_FOSC(value uint32) {
	volatile.StoreUint32(&o.CLK_TO_HP.Reg, volatile.LoadUint32(&o.CLK_TO_HP.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_CLKRST_Type) GetCLK_TO_HP_ICG_HP_FOSC() uint32 {
	return (volatile.LoadUint32(&o.CLK_TO_HP.Reg) & 0x80000000) >> 31
}

// LP_CLKRST.LPMEM_FORCE: need_des
func (o *LP_CLKRST_Type) SetLPMEM_FORCE_LPMEM_CLK_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.LPMEM_FORCE.Reg, volatile.LoadUint32(&o.LPMEM_FORCE.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_CLKRST_Type) GetLPMEM_FORCE_LPMEM_CLK_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.LPMEM_FORCE.Reg) & 0x80000000) >> 31
}

// LP_CLKRST.LPPERI: need_des
func (o *LP_CLKRST_Type) SetLPPERI_LP_I2C_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.LPPERI.Reg, volatile.LoadUint32(&o.LPPERI.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_CLKRST_Type) GetLPPERI_LP_I2C_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.LPPERI.Reg) & 0x40000000) >> 30
}
func (o *LP_CLKRST_Type) SetLPPERI_LP_UART_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.LPPERI.Reg, volatile.LoadUint32(&o.LPPERI.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_CLKRST_Type) GetLPPERI_LP_UART_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.LPPERI.Reg) & 0x80000000) >> 31
}

// LP_CLKRST.XTAL32K: need_des
func (o *LP_CLKRST_Type) SetXTAL32K_DRES_XTAL32K(value uint32) {
	volatile.StoreUint32(&o.XTAL32K.Reg, volatile.LoadUint32(&o.XTAL32K.Reg)&^(0x1c00000)|value<<22)
}
func (o *LP_CLKRST_Type) GetXTAL32K_DRES_XTAL32K() uint32 {
	return (volatile.LoadUint32(&o.XTAL32K.Reg) & 0x1c00000) >> 22
}
func (o *LP_CLKRST_Type) SetXTAL32K_DGM_XTAL32K(value uint32) {
	volatile.StoreUint32(&o.XTAL32K.Reg, volatile.LoadUint32(&o.XTAL32K.Reg)&^(0xe000000)|value<<25)
}
func (o *LP_CLKRST_Type) GetXTAL32K_DGM_XTAL32K() uint32 {
	return (volatile.LoadUint32(&o.XTAL32K.Reg) & 0xe000000) >> 25
}
func (o *LP_CLKRST_Type) SetXTAL32K_DBUF_XTAL32K(value uint32) {
	volatile.StoreUint32(&o.XTAL32K.Reg, volatile.LoadUint32(&o.XTAL32K.Reg)&^(0x10000000)|value<<28)
}
func (o *LP_CLKRST_Type) GetXTAL32K_DBUF_XTAL32K() uint32 {
	return (volatile.LoadUint32(&o.XTAL32K.Reg) & 0x10000000) >> 28
}
func (o *LP_CLKRST_Type) SetXTAL32K_DAC_XTAL32K(value uint32) {
	volatile.StoreUint32(&o.XTAL32K.Reg, volatile.LoadUint32(&o.XTAL32K.Reg)&^(0xe0000000)|value<<29)
}
func (o *LP_CLKRST_Type) GetXTAL32K_DAC_XTAL32K() uint32 {
	return (volatile.LoadUint32(&o.XTAL32K.Reg) & 0xe0000000) >> 29
}

// LP_CLKRST.DATE: need_des
func (o *LP_CLKRST_Type) SetDATE_CLKRST_DATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x7fffffff)|value)
}
func (o *LP_CLKRST_Type) GetDATE_CLKRST_DATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x7fffffff
}
func (o *LP_CLKRST_Type) SetDATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_CLKRST_Type) GetDATE_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.DATE.Reg) & 0x80000000) >> 31
}

// LP_I2C_ANA_MST Peripheral
type LP_I2C_ANA_MST_Type struct {
	I2C0_CTRL volatile.Register32 // 0x0
	I2C0_CONF volatile.Register32 // 0x4
	I2C0_DATA volatile.Register32 // 0x8
	ANA_CONF1 volatile.Register32 // 0xC
	NOUSE     volatile.Register32 // 0x10
	DEVICE_EN volatile.Register32 // 0x14
	_         [996]byte
	DATE      volatile.Register32 // 0x3FC
}

// LP_I2C_ANA_MST.I2C0_CTRL: need_des
func (o *LP_I2C_ANA_MST_Type) SetI2C0_CTRL_LP_I2C_ANA_MAST_I2C0_CTRL(value uint32) {
	volatile.StoreUint32(&o.I2C0_CTRL.Reg, volatile.LoadUint32(&o.I2C0_CTRL.Reg)&^(0x1ffffff)|value)
}
func (o *LP_I2C_ANA_MST_Type) GetI2C0_CTRL_LP_I2C_ANA_MAST_I2C0_CTRL() uint32 {
	return volatile.LoadUint32(&o.I2C0_CTRL.Reg) & 0x1ffffff
}
func (o *LP_I2C_ANA_MST_Type) SetI2C0_CTRL_LP_I2C_ANA_MAST_I2C0_BUSY(value uint32) {
	volatile.StoreUint32(&o.I2C0_CTRL.Reg, volatile.LoadUint32(&o.I2C0_CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *LP_I2C_ANA_MST_Type) GetI2C0_CTRL_LP_I2C_ANA_MAST_I2C0_BUSY() uint32 {
	return (volatile.LoadUint32(&o.I2C0_CTRL.Reg) & 0x2000000) >> 25
}

// LP_I2C_ANA_MST.I2C0_CONF: need_des
func (o *LP_I2C_ANA_MST_Type) SetI2C0_CONF_LP_I2C_ANA_MAST_I2C0_CONF(value uint32) {
	volatile.StoreUint32(&o.I2C0_CONF.Reg, volatile.LoadUint32(&o.I2C0_CONF.Reg)&^(0xffffff)|value)
}
func (o *LP_I2C_ANA_MST_Type) GetI2C0_CONF_LP_I2C_ANA_MAST_I2C0_CONF() uint32 {
	return volatile.LoadUint32(&o.I2C0_CONF.Reg) & 0xffffff
}
func (o *LP_I2C_ANA_MST_Type) SetI2C0_CONF_LP_I2C_ANA_MAST_I2C0_STATUS(value uint32) {
	volatile.StoreUint32(&o.I2C0_CONF.Reg, volatile.LoadUint32(&o.I2C0_CONF.Reg)&^(0xff000000)|value<<24)
}
func (o *LP_I2C_ANA_MST_Type) GetI2C0_CONF_LP_I2C_ANA_MAST_I2C0_STATUS() uint32 {
	return (volatile.LoadUint32(&o.I2C0_CONF.Reg) & 0xff000000) >> 24
}

// LP_I2C_ANA_MST.I2C0_DATA: need_des
func (o *LP_I2C_ANA_MST_Type) SetI2C0_DATA_LP_I2C_ANA_MAST_I2C0_RDATA(value uint32) {
	volatile.StoreUint32(&o.I2C0_DATA.Reg, volatile.LoadUint32(&o.I2C0_DATA.Reg)&^(0xff)|value)
}
func (o *LP_I2C_ANA_MST_Type) GetI2C0_DATA_LP_I2C_ANA_MAST_I2C0_RDATA() uint32 {
	return volatile.LoadUint32(&o.I2C0_DATA.Reg) & 0xff
}
func (o *LP_I2C_ANA_MST_Type) SetI2C0_DATA_LP_I2C_ANA_MAST_I2C0_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.I2C0_DATA.Reg, volatile.LoadUint32(&o.I2C0_DATA.Reg)&^(0x700)|value<<8)
}
func (o *LP_I2C_ANA_MST_Type) GetI2C0_DATA_LP_I2C_ANA_MAST_I2C0_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.I2C0_DATA.Reg) & 0x700) >> 8
}
func (o *LP_I2C_ANA_MST_Type) SetI2C0_DATA_LP_I2C_ANA_MAST_I2C_MST_SEL(value uint32) {
	volatile.StoreUint32(&o.I2C0_DATA.Reg, volatile.LoadUint32(&o.I2C0_DATA.Reg)&^(0x800)|value<<11)
}
func (o *LP_I2C_ANA_MST_Type) GetI2C0_DATA_LP_I2C_ANA_MAST_I2C_MST_SEL() uint32 {
	return (volatile.LoadUint32(&o.I2C0_DATA.Reg) & 0x800) >> 11
}

// LP_I2C_ANA_MST.ANA_CONF1: need_des
func (o *LP_I2C_ANA_MST_Type) SetANA_CONF1_LP_I2C_ANA_MAST_ANA_CONF1(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF1.Reg, volatile.LoadUint32(&o.ANA_CONF1.Reg)&^(0xffffff)|value)
}
func (o *LP_I2C_ANA_MST_Type) GetANA_CONF1_LP_I2C_ANA_MAST_ANA_CONF1() uint32 {
	return volatile.LoadUint32(&o.ANA_CONF1.Reg) & 0xffffff
}

// LP_I2C_ANA_MST.NOUSE: need_des
func (o *LP_I2C_ANA_MST_Type) SetNOUSE(value uint32) {
	volatile.StoreUint32(&o.NOUSE.Reg, value)
}
func (o *LP_I2C_ANA_MST_Type) GetNOUSE() uint32 {
	return volatile.LoadUint32(&o.NOUSE.Reg)
}

// LP_I2C_ANA_MST.DEVICE_EN: need_des
func (o *LP_I2C_ANA_MST_Type) SetDEVICE_EN_LP_I2C_ANA_MAST_I2C_DEVICE_EN(value uint32) {
	volatile.StoreUint32(&o.DEVICE_EN.Reg, volatile.LoadUint32(&o.DEVICE_EN.Reg)&^(0xfff)|value)
}
func (o *LP_I2C_ANA_MST_Type) GetDEVICE_EN_LP_I2C_ANA_MAST_I2C_DEVICE_EN() uint32 {
	return volatile.LoadUint32(&o.DEVICE_EN.Reg) & 0xfff
}

// LP_I2C_ANA_MST.DATE: need_des
func (o *LP_I2C_ANA_MST_Type) SetDATE_LP_I2C_ANA_MAST_I2C_MAT_DATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *LP_I2C_ANA_MST_Type) GetDATE_LP_I2C_ANA_MAST_I2C_MAT_DATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}
func (o *LP_I2C_ANA_MST_Type) SetDATE_LP_I2C_ANA_MAST_I2C_MAT_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x10000000)|value<<28)
}
func (o *LP_I2C_ANA_MST_Type) GetDATE_LP_I2C_ANA_MAST_I2C_MAT_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.DATE.Reg) & 0x10000000) >> 28
}

// Low-power Input/Output Multiplexer
type LP_IO_Type struct {
	OUT_DATA         volatile.Register32 // 0x0
	OUT_DATA_W1TS    volatile.Register32 // 0x4
	OUT_DATA_W1TC    volatile.Register32 // 0x8
	OUT_ENABLE       volatile.Register32 // 0xC
	OUT_ENABLE_W1TS  volatile.Register32 // 0x10
	OUT_ENABLE_W1TC  volatile.Register32 // 0x14
	STATUS           volatile.Register32 // 0x18
	STATUS_W1TS      volatile.Register32 // 0x1C
	STATUS_W1TC      volatile.Register32 // 0x20
	IN               volatile.Register32 // 0x24
	PIN0             volatile.Register32 // 0x28
	PIN1             volatile.Register32 // 0x2C
	PIN2             volatile.Register32 // 0x30
	PIN3             volatile.Register32 // 0x34
	PIN4             volatile.Register32 // 0x38
	PIN5             volatile.Register32 // 0x3C
	PIN6             volatile.Register32 // 0x40
	PIN7             volatile.Register32 // 0x44
	GPIO0            volatile.Register32 // 0x48
	GPIO1            volatile.Register32 // 0x4C
	GPIO2            volatile.Register32 // 0x50
	GPIO3            volatile.Register32 // 0x54
	GPIO4            volatile.Register32 // 0x58
	GPIO5            volatile.Register32 // 0x5C
	GPIO6            volatile.Register32 // 0x60
	GPIO7            volatile.Register32 // 0x64
	STATUS_INTERRUPT volatile.Register32 // 0x68
	DEBUG_SEL0       volatile.Register32 // 0x6C
	DEBUG_SEL1       volatile.Register32 // 0x70
	LPI2C            volatile.Register32 // 0x74
	_                [900]byte
	DATE             volatile.Register32 // 0x3FC
}

// LP_IO.OUT_DATA: need des
func (o *LP_IO_Type) SetOUT_DATA_LP_GPIO_OUT_DATA(value uint32) {
	volatile.StoreUint32(&o.OUT_DATA.Reg, volatile.LoadUint32(&o.OUT_DATA.Reg)&^(0xff)|value)
}
func (o *LP_IO_Type) GetOUT_DATA_LP_GPIO_OUT_DATA() uint32 {
	return volatile.LoadUint32(&o.OUT_DATA.Reg) & 0xff
}

// LP_IO.OUT_DATA_W1TS: need des
func (o *LP_IO_Type) SetOUT_DATA_W1TS_LP_GPIO_OUT_DATA_W1TS(value uint32) {
	volatile.StoreUint32(&o.OUT_DATA_W1TS.Reg, volatile.LoadUint32(&o.OUT_DATA_W1TS.Reg)&^(0xff)|value)
}
func (o *LP_IO_Type) GetOUT_DATA_W1TS_LP_GPIO_OUT_DATA_W1TS() uint32 {
	return volatile.LoadUint32(&o.OUT_DATA_W1TS.Reg) & 0xff
}

// LP_IO.OUT_DATA_W1TC: need des
func (o *LP_IO_Type) SetOUT_DATA_W1TC_LP_GPIO_OUT_DATA_W1TC(value uint32) {
	volatile.StoreUint32(&o.OUT_DATA_W1TC.Reg, volatile.LoadUint32(&o.OUT_DATA_W1TC.Reg)&^(0xff)|value)
}
func (o *LP_IO_Type) GetOUT_DATA_W1TC_LP_GPIO_OUT_DATA_W1TC() uint32 {
	return volatile.LoadUint32(&o.OUT_DATA_W1TC.Reg) & 0xff
}

// LP_IO.OUT_ENABLE: need des
func (o *LP_IO_Type) SetOUT_ENABLE_LP_GPIO_ENABLE(value uint32) {
	volatile.StoreUint32(&o.OUT_ENABLE.Reg, volatile.LoadUint32(&o.OUT_ENABLE.Reg)&^(0xff)|value)
}
func (o *LP_IO_Type) GetOUT_ENABLE_LP_GPIO_ENABLE() uint32 {
	return volatile.LoadUint32(&o.OUT_ENABLE.Reg) & 0xff
}

// LP_IO.OUT_ENABLE_W1TS: need des
func (o *LP_IO_Type) SetOUT_ENABLE_W1TS_LP_GPIO_ENABLE_W1TS(value uint32) {
	volatile.StoreUint32(&o.OUT_ENABLE_W1TS.Reg, volatile.LoadUint32(&o.OUT_ENABLE_W1TS.Reg)&^(0xff)|value)
}
func (o *LP_IO_Type) GetOUT_ENABLE_W1TS_LP_GPIO_ENABLE_W1TS() uint32 {
	return volatile.LoadUint32(&o.OUT_ENABLE_W1TS.Reg) & 0xff
}

// LP_IO.OUT_ENABLE_W1TC: need des
func (o *LP_IO_Type) SetOUT_ENABLE_W1TC_LP_GPIO_ENABLE_W1TC(value uint32) {
	volatile.StoreUint32(&o.OUT_ENABLE_W1TC.Reg, volatile.LoadUint32(&o.OUT_ENABLE_W1TC.Reg)&^(0xff)|value)
}
func (o *LP_IO_Type) GetOUT_ENABLE_W1TC_LP_GPIO_ENABLE_W1TC() uint32 {
	return volatile.LoadUint32(&o.OUT_ENABLE_W1TC.Reg) & 0xff
}

// LP_IO.STATUS: need des
func (o *LP_IO_Type) SetSTATUS_LP_GPIO_STATUS_INTERRUPT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xff)|value)
}
func (o *LP_IO_Type) GetSTATUS_LP_GPIO_STATUS_INTERRUPT() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0xff
}

// LP_IO.STATUS_W1TS: need des
func (o *LP_IO_Type) SetSTATUS_W1TS_LP_GPIO_STATUS_W1TS(value uint32) {
	volatile.StoreUint32(&o.STATUS_W1TS.Reg, volatile.LoadUint32(&o.STATUS_W1TS.Reg)&^(0xff)|value)
}
func (o *LP_IO_Type) GetSTATUS_W1TS_LP_GPIO_STATUS_W1TS() uint32 {
	return volatile.LoadUint32(&o.STATUS_W1TS.Reg) & 0xff
}

// LP_IO.STATUS_W1TC: need des
func (o *LP_IO_Type) SetSTATUS_W1TC_LP_GPIO_STATUS_W1TC(value uint32) {
	volatile.StoreUint32(&o.STATUS_W1TC.Reg, volatile.LoadUint32(&o.STATUS_W1TC.Reg)&^(0xff)|value)
}
func (o *LP_IO_Type) GetSTATUS_W1TC_LP_GPIO_STATUS_W1TC() uint32 {
	return volatile.LoadUint32(&o.STATUS_W1TC.Reg) & 0xff
}

// LP_IO.IN: need des
func (o *LP_IO_Type) SetIN_LP_GPIO_IN_DATA_NEXT(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0xff)|value)
}
func (o *LP_IO_Type) GetIN_LP_GPIO_IN_DATA_NEXT() uint32 {
	return volatile.LoadUint32(&o.IN.Reg) & 0xff
}

// LP_IO.PIN0: need des
func (o *LP_IO_Type) SetPIN0_LP_GPIO0_SYNC_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x3)|value)
}
func (o *LP_IO_Type) GetPIN0_LP_GPIO0_SYNC_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN0.Reg) & 0x3
}
func (o *LP_IO_Type) SetPIN0_LP_GPIO0_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetPIN0_LP_GPIO0_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetPIN0_LP_GPIO0_EDGE_WAKEUP_CLR(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetPIN0_LP_GPIO0_EDGE_WAKEUP_CLR() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetPIN0_LP_GPIO0_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x380)|value<<7)
}
func (o *LP_IO_Type) GetPIN0_LP_GPIO0_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x380) >> 7
}
func (o *LP_IO_Type) SetPIN0_LP_GPIO0_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x400)|value<<10)
}
func (o *LP_IO_Type) GetPIN0_LP_GPIO0_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x400) >> 10
}
func (o *LP_IO_Type) SetPIN0_LP_GPIO0_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x800)|value<<11)
}
func (o *LP_IO_Type) GetPIN0_LP_GPIO0_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x800) >> 11
}

// LP_IO.PIN1: need des
func (o *LP_IO_Type) SetPIN1_LP_GPIO1_SYNC_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x3)|value)
}
func (o *LP_IO_Type) GetPIN1_LP_GPIO1_SYNC_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN1.Reg) & 0x3
}
func (o *LP_IO_Type) SetPIN1_LP_GPIO1_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetPIN1_LP_GPIO1_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetPIN1_LP_GPIO1_EDGE_WAKEUP_CLR(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetPIN1_LP_GPIO1_EDGE_WAKEUP_CLR() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetPIN1_LP_GPIO1_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x380)|value<<7)
}
func (o *LP_IO_Type) GetPIN1_LP_GPIO1_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x380) >> 7
}
func (o *LP_IO_Type) SetPIN1_LP_GPIO1_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x400)|value<<10)
}
func (o *LP_IO_Type) GetPIN1_LP_GPIO1_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x400) >> 10
}
func (o *LP_IO_Type) SetPIN1_LP_GPIO1_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x800)|value<<11)
}
func (o *LP_IO_Type) GetPIN1_LP_GPIO1_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x800) >> 11
}

// LP_IO.PIN2: need des
func (o *LP_IO_Type) SetPIN2_LP_GPIO2_SYNC_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x3)|value)
}
func (o *LP_IO_Type) GetPIN2_LP_GPIO2_SYNC_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN2.Reg) & 0x3
}
func (o *LP_IO_Type) SetPIN2_LP_GPIO2_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetPIN2_LP_GPIO2_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetPIN2_LP_GPIO2_EDGE_WAKEUP_CLR(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetPIN2_LP_GPIO2_EDGE_WAKEUP_CLR() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetPIN2_LP_GPIO2_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x380)|value<<7)
}
func (o *LP_IO_Type) GetPIN2_LP_GPIO2_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x380) >> 7
}
func (o *LP_IO_Type) SetPIN2_LP_GPIO2_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x400)|value<<10)
}
func (o *LP_IO_Type) GetPIN2_LP_GPIO2_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x400) >> 10
}
func (o *LP_IO_Type) SetPIN2_LP_GPIO2_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x800)|value<<11)
}
func (o *LP_IO_Type) GetPIN2_LP_GPIO2_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x800) >> 11
}

// LP_IO.PIN3: need des
func (o *LP_IO_Type) SetPIN3_LP_GPIO3_SYNC_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x3)|value)
}
func (o *LP_IO_Type) GetPIN3_LP_GPIO3_SYNC_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN3.Reg) & 0x3
}
func (o *LP_IO_Type) SetPIN3_LP_GPIO3_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetPIN3_LP_GPIO3_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetPIN3_LP_GPIO3_EDGE_WAKEUP_CLR(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetPIN3_LP_GPIO3_EDGE_WAKEUP_CLR() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetPIN3_LP_GPIO3_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x380)|value<<7)
}
func (o *LP_IO_Type) GetPIN3_LP_GPIO3_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x380) >> 7
}
func (o *LP_IO_Type) SetPIN3_LP_GPIO3_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x400)|value<<10)
}
func (o *LP_IO_Type) GetPIN3_LP_GPIO3_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x400) >> 10
}
func (o *LP_IO_Type) SetPIN3_LP_GPIO3_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x800)|value<<11)
}
func (o *LP_IO_Type) GetPIN3_LP_GPIO3_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x800) >> 11
}

// LP_IO.PIN4: need des
func (o *LP_IO_Type) SetPIN4_LP_GPIO4_SYNC_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x3)|value)
}
func (o *LP_IO_Type) GetPIN4_LP_GPIO4_SYNC_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN4.Reg) & 0x3
}
func (o *LP_IO_Type) SetPIN4_LP_GPIO4_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetPIN4_LP_GPIO4_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetPIN4_LP_GPIO4_EDGE_WAKEUP_CLR(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetPIN4_LP_GPIO4_EDGE_WAKEUP_CLR() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetPIN4_LP_GPIO4_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x380)|value<<7)
}
func (o *LP_IO_Type) GetPIN4_LP_GPIO4_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x380) >> 7
}
func (o *LP_IO_Type) SetPIN4_LP_GPIO4_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x400)|value<<10)
}
func (o *LP_IO_Type) GetPIN4_LP_GPIO4_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x400) >> 10
}
func (o *LP_IO_Type) SetPIN4_LP_GPIO4_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x800)|value<<11)
}
func (o *LP_IO_Type) GetPIN4_LP_GPIO4_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x800) >> 11
}

// LP_IO.PIN5: need des
func (o *LP_IO_Type) SetPIN5_LP_GPIO5_SYNC_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x3)|value)
}
func (o *LP_IO_Type) GetPIN5_LP_GPIO5_SYNC_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN5.Reg) & 0x3
}
func (o *LP_IO_Type) SetPIN5_LP_GPIO5_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetPIN5_LP_GPIO5_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetPIN5_LP_GPIO5_EDGE_WAKEUP_CLR(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetPIN5_LP_GPIO5_EDGE_WAKEUP_CLR() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetPIN5_LP_GPIO5_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x380)|value<<7)
}
func (o *LP_IO_Type) GetPIN5_LP_GPIO5_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x380) >> 7
}
func (o *LP_IO_Type) SetPIN5_LP_GPIO5_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x400)|value<<10)
}
func (o *LP_IO_Type) GetPIN5_LP_GPIO5_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x400) >> 10
}
func (o *LP_IO_Type) SetPIN5_LP_GPIO5_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x800)|value<<11)
}
func (o *LP_IO_Type) GetPIN5_LP_GPIO5_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x800) >> 11
}

// LP_IO.PIN6: need des
func (o *LP_IO_Type) SetPIN6_LP_GPIO6_SYNC_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x3)|value)
}
func (o *LP_IO_Type) GetPIN6_LP_GPIO6_SYNC_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN6.Reg) & 0x3
}
func (o *LP_IO_Type) SetPIN6_LP_GPIO6_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetPIN6_LP_GPIO6_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetPIN6_LP_GPIO6_EDGE_WAKEUP_CLR(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetPIN6_LP_GPIO6_EDGE_WAKEUP_CLR() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetPIN6_LP_GPIO6_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x380)|value<<7)
}
func (o *LP_IO_Type) GetPIN6_LP_GPIO6_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x380) >> 7
}
func (o *LP_IO_Type) SetPIN6_LP_GPIO6_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x400)|value<<10)
}
func (o *LP_IO_Type) GetPIN6_LP_GPIO6_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x400) >> 10
}
func (o *LP_IO_Type) SetPIN6_LP_GPIO6_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x800)|value<<11)
}
func (o *LP_IO_Type) GetPIN6_LP_GPIO6_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x800) >> 11
}

// LP_IO.PIN7: need des
func (o *LP_IO_Type) SetPIN7_LP_GPIO7_SYNC_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x3)|value)
}
func (o *LP_IO_Type) GetPIN7_LP_GPIO7_SYNC_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN7.Reg) & 0x3
}
func (o *LP_IO_Type) SetPIN7_LP_GPIO7_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetPIN7_LP_GPIO7_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetPIN7_LP_GPIO7_EDGE_WAKEUP_CLR(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetPIN7_LP_GPIO7_EDGE_WAKEUP_CLR() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetPIN7_LP_GPIO7_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x380)|value<<7)
}
func (o *LP_IO_Type) GetPIN7_LP_GPIO7_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x380) >> 7
}
func (o *LP_IO_Type) SetPIN7_LP_GPIO7_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x400)|value<<10)
}
func (o *LP_IO_Type) GetPIN7_LP_GPIO7_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x400) >> 10
}
func (o *LP_IO_Type) SetPIN7_LP_GPIO7_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x800)|value<<11)
}
func (o *LP_IO_Type) GetPIN7_LP_GPIO7_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x800) >> 11
}

// LP_IO.GPIO0: need des
func (o *LP_IO_Type) SetGPIO0_LP_GPIO0_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x1)|value)
}
func (o *LP_IO_Type) GetGPIO0_LP_GPIO0_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO0.Reg) & 0x1
}
func (o *LP_IO_Type) SetGPIO0_LP_GPIO0_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x2)|value<<1)
}
func (o *LP_IO_Type) GetGPIO0_LP_GPIO0_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x2) >> 1
}
func (o *LP_IO_Type) SetGPIO0_LP_GPIO0_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetGPIO0_LP_GPIO0_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetGPIO0_LP_GPIO0_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetGPIO0_LP_GPIO0_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetGPIO0_LP_GPIO0_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x10)|value<<4)
}
func (o *LP_IO_Type) GetGPIO0_LP_GPIO0_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x10) >> 4
}
func (o *LP_IO_Type) SetGPIO0_LP_GPIO0_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x60)|value<<5)
}
func (o *LP_IO_Type) GetGPIO0_LP_GPIO0_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x60) >> 5
}
func (o *LP_IO_Type) SetGPIO0_LP_GPIO0_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x80)|value<<7)
}
func (o *LP_IO_Type) GetGPIO0_LP_GPIO0_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x80) >> 7
}
func (o *LP_IO_Type) SetGPIO0_LP_GPIO0_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x100)|value<<8)
}
func (o *LP_IO_Type) GetGPIO0_LP_GPIO0_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x100) >> 8
}
func (o *LP_IO_Type) SetGPIO0_LP_GPIO0_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x200)|value<<9)
}
func (o *LP_IO_Type) GetGPIO0_LP_GPIO0_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x200) >> 9
}
func (o *LP_IO_Type) SetGPIO0_LP_GPIO0_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0xc00)|value<<10)
}
func (o *LP_IO_Type) GetGPIO0_LP_GPIO0_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0xc00) >> 10
}
func (o *LP_IO_Type) SetGPIO0_LP_GPIO0_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x7000)|value<<12)
}
func (o *LP_IO_Type) GetGPIO0_LP_GPIO0_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x7000) >> 12
}

// LP_IO.GPIO1: need des
func (o *LP_IO_Type) SetGPIO1_LP_GPIO1_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x1)|value)
}
func (o *LP_IO_Type) GetGPIO1_LP_GPIO1_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO1.Reg) & 0x1
}
func (o *LP_IO_Type) SetGPIO1_LP_GPIO1_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x2)|value<<1)
}
func (o *LP_IO_Type) GetGPIO1_LP_GPIO1_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x2) >> 1
}
func (o *LP_IO_Type) SetGPIO1_LP_GPIO1_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetGPIO1_LP_GPIO1_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetGPIO1_LP_GPIO1_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetGPIO1_LP_GPIO1_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetGPIO1_LP_GPIO1_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x10)|value<<4)
}
func (o *LP_IO_Type) GetGPIO1_LP_GPIO1_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x10) >> 4
}
func (o *LP_IO_Type) SetGPIO1_LP_GPIO1_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x60)|value<<5)
}
func (o *LP_IO_Type) GetGPIO1_LP_GPIO1_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x60) >> 5
}
func (o *LP_IO_Type) SetGPIO1_LP_GPIO1_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x80)|value<<7)
}
func (o *LP_IO_Type) GetGPIO1_LP_GPIO1_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x80) >> 7
}
func (o *LP_IO_Type) SetGPIO1_LP_GPIO1_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x100)|value<<8)
}
func (o *LP_IO_Type) GetGPIO1_LP_GPIO1_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x100) >> 8
}
func (o *LP_IO_Type) SetGPIO1_LP_GPIO1_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x200)|value<<9)
}
func (o *LP_IO_Type) GetGPIO1_LP_GPIO1_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x200) >> 9
}
func (o *LP_IO_Type) SetGPIO1_LP_GPIO1_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0xc00)|value<<10)
}
func (o *LP_IO_Type) GetGPIO1_LP_GPIO1_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0xc00) >> 10
}
func (o *LP_IO_Type) SetGPIO1_LP_GPIO1_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x7000)|value<<12)
}
func (o *LP_IO_Type) GetGPIO1_LP_GPIO1_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x7000) >> 12
}

// LP_IO.GPIO2: need des
func (o *LP_IO_Type) SetGPIO2_LP_GPIO2_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x1)|value)
}
func (o *LP_IO_Type) GetGPIO2_LP_GPIO2_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO2.Reg) & 0x1
}
func (o *LP_IO_Type) SetGPIO2_LP_GPIO2_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x2)|value<<1)
}
func (o *LP_IO_Type) GetGPIO2_LP_GPIO2_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x2) >> 1
}
func (o *LP_IO_Type) SetGPIO2_LP_GPIO2_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetGPIO2_LP_GPIO2_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetGPIO2_LP_GPIO2_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetGPIO2_LP_GPIO2_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetGPIO2_LP_GPIO2_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x10)|value<<4)
}
func (o *LP_IO_Type) GetGPIO2_LP_GPIO2_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x10) >> 4
}
func (o *LP_IO_Type) SetGPIO2_LP_GPIO2_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x60)|value<<5)
}
func (o *LP_IO_Type) GetGPIO2_LP_GPIO2_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x60) >> 5
}
func (o *LP_IO_Type) SetGPIO2_LP_GPIO2_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x80)|value<<7)
}
func (o *LP_IO_Type) GetGPIO2_LP_GPIO2_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x80) >> 7
}
func (o *LP_IO_Type) SetGPIO2_LP_GPIO2_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x100)|value<<8)
}
func (o *LP_IO_Type) GetGPIO2_LP_GPIO2_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x100) >> 8
}
func (o *LP_IO_Type) SetGPIO2_LP_GPIO2_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x200)|value<<9)
}
func (o *LP_IO_Type) GetGPIO2_LP_GPIO2_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x200) >> 9
}
func (o *LP_IO_Type) SetGPIO2_LP_GPIO2_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0xc00)|value<<10)
}
func (o *LP_IO_Type) GetGPIO2_LP_GPIO2_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0xc00) >> 10
}
func (o *LP_IO_Type) SetGPIO2_LP_GPIO2_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x7000)|value<<12)
}
func (o *LP_IO_Type) GetGPIO2_LP_GPIO2_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x7000) >> 12
}

// LP_IO.GPIO3: need des
func (o *LP_IO_Type) SetGPIO3_LP_GPIO3_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x1)|value)
}
func (o *LP_IO_Type) GetGPIO3_LP_GPIO3_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO3.Reg) & 0x1
}
func (o *LP_IO_Type) SetGPIO3_LP_GPIO3_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x2)|value<<1)
}
func (o *LP_IO_Type) GetGPIO3_LP_GPIO3_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x2) >> 1
}
func (o *LP_IO_Type) SetGPIO3_LP_GPIO3_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetGPIO3_LP_GPIO3_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetGPIO3_LP_GPIO3_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetGPIO3_LP_GPIO3_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetGPIO3_LP_GPIO3_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x10)|value<<4)
}
func (o *LP_IO_Type) GetGPIO3_LP_GPIO3_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x10) >> 4
}
func (o *LP_IO_Type) SetGPIO3_LP_GPIO3_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x60)|value<<5)
}
func (o *LP_IO_Type) GetGPIO3_LP_GPIO3_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x60) >> 5
}
func (o *LP_IO_Type) SetGPIO3_LP_GPIO3_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x80)|value<<7)
}
func (o *LP_IO_Type) GetGPIO3_LP_GPIO3_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x80) >> 7
}
func (o *LP_IO_Type) SetGPIO3_LP_GPIO3_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x100)|value<<8)
}
func (o *LP_IO_Type) GetGPIO3_LP_GPIO3_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x100) >> 8
}
func (o *LP_IO_Type) SetGPIO3_LP_GPIO3_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x200)|value<<9)
}
func (o *LP_IO_Type) GetGPIO3_LP_GPIO3_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x200) >> 9
}
func (o *LP_IO_Type) SetGPIO3_LP_GPIO3_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0xc00)|value<<10)
}
func (o *LP_IO_Type) GetGPIO3_LP_GPIO3_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0xc00) >> 10
}
func (o *LP_IO_Type) SetGPIO3_LP_GPIO3_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x7000)|value<<12)
}
func (o *LP_IO_Type) GetGPIO3_LP_GPIO3_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x7000) >> 12
}

// LP_IO.GPIO4: need des
func (o *LP_IO_Type) SetGPIO4_LP_GPIO4_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x1)|value)
}
func (o *LP_IO_Type) GetGPIO4_LP_GPIO4_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO4.Reg) & 0x1
}
func (o *LP_IO_Type) SetGPIO4_LP_GPIO4_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x2)|value<<1)
}
func (o *LP_IO_Type) GetGPIO4_LP_GPIO4_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x2) >> 1
}
func (o *LP_IO_Type) SetGPIO4_LP_GPIO4_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetGPIO4_LP_GPIO4_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetGPIO4_LP_GPIO4_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetGPIO4_LP_GPIO4_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetGPIO4_LP_GPIO4_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x10)|value<<4)
}
func (o *LP_IO_Type) GetGPIO4_LP_GPIO4_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x10) >> 4
}
func (o *LP_IO_Type) SetGPIO4_LP_GPIO4_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x60)|value<<5)
}
func (o *LP_IO_Type) GetGPIO4_LP_GPIO4_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x60) >> 5
}
func (o *LP_IO_Type) SetGPIO4_LP_GPIO4_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x80)|value<<7)
}
func (o *LP_IO_Type) GetGPIO4_LP_GPIO4_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x80) >> 7
}
func (o *LP_IO_Type) SetGPIO4_LP_GPIO4_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x100)|value<<8)
}
func (o *LP_IO_Type) GetGPIO4_LP_GPIO4_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x100) >> 8
}
func (o *LP_IO_Type) SetGPIO4_LP_GPIO4_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x200)|value<<9)
}
func (o *LP_IO_Type) GetGPIO4_LP_GPIO4_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x200) >> 9
}
func (o *LP_IO_Type) SetGPIO4_LP_GPIO4_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0xc00)|value<<10)
}
func (o *LP_IO_Type) GetGPIO4_LP_GPIO4_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0xc00) >> 10
}
func (o *LP_IO_Type) SetGPIO4_LP_GPIO4_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x7000)|value<<12)
}
func (o *LP_IO_Type) GetGPIO4_LP_GPIO4_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x7000) >> 12
}

// LP_IO.GPIO5: need des
func (o *LP_IO_Type) SetGPIO5_LP_GPIO5_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x1)|value)
}
func (o *LP_IO_Type) GetGPIO5_LP_GPIO5_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO5.Reg) & 0x1
}
func (o *LP_IO_Type) SetGPIO5_LP_GPIO5_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x2)|value<<1)
}
func (o *LP_IO_Type) GetGPIO5_LP_GPIO5_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x2) >> 1
}
func (o *LP_IO_Type) SetGPIO5_LP_GPIO5_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetGPIO5_LP_GPIO5_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetGPIO5_LP_GPIO5_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetGPIO5_LP_GPIO5_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetGPIO5_LP_GPIO5_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x10)|value<<4)
}
func (o *LP_IO_Type) GetGPIO5_LP_GPIO5_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x10) >> 4
}
func (o *LP_IO_Type) SetGPIO5_LP_GPIO5_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x60)|value<<5)
}
func (o *LP_IO_Type) GetGPIO5_LP_GPIO5_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x60) >> 5
}
func (o *LP_IO_Type) SetGPIO5_LP_GPIO5_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x80)|value<<7)
}
func (o *LP_IO_Type) GetGPIO5_LP_GPIO5_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x80) >> 7
}
func (o *LP_IO_Type) SetGPIO5_LP_GPIO5_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x100)|value<<8)
}
func (o *LP_IO_Type) GetGPIO5_LP_GPIO5_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x100) >> 8
}
func (o *LP_IO_Type) SetGPIO5_LP_GPIO5_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x200)|value<<9)
}
func (o *LP_IO_Type) GetGPIO5_LP_GPIO5_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x200) >> 9
}
func (o *LP_IO_Type) SetGPIO5_LP_GPIO5_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0xc00)|value<<10)
}
func (o *LP_IO_Type) GetGPIO5_LP_GPIO5_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0xc00) >> 10
}
func (o *LP_IO_Type) SetGPIO5_LP_GPIO5_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x7000)|value<<12)
}
func (o *LP_IO_Type) GetGPIO5_LP_GPIO5_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x7000) >> 12
}

// LP_IO.GPIO6: need des
func (o *LP_IO_Type) SetGPIO6_LP_GPIO6_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x1)|value)
}
func (o *LP_IO_Type) GetGPIO6_LP_GPIO6_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO6.Reg) & 0x1
}
func (o *LP_IO_Type) SetGPIO6_LP_GPIO6_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x2)|value<<1)
}
func (o *LP_IO_Type) GetGPIO6_LP_GPIO6_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x2) >> 1
}
func (o *LP_IO_Type) SetGPIO6_LP_GPIO6_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetGPIO6_LP_GPIO6_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetGPIO6_LP_GPIO6_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetGPIO6_LP_GPIO6_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetGPIO6_LP_GPIO6_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x10)|value<<4)
}
func (o *LP_IO_Type) GetGPIO6_LP_GPIO6_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x10) >> 4
}
func (o *LP_IO_Type) SetGPIO6_LP_GPIO6_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x60)|value<<5)
}
func (o *LP_IO_Type) GetGPIO6_LP_GPIO6_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x60) >> 5
}
func (o *LP_IO_Type) SetGPIO6_LP_GPIO6_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x80)|value<<7)
}
func (o *LP_IO_Type) GetGPIO6_LP_GPIO6_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x80) >> 7
}
func (o *LP_IO_Type) SetGPIO6_LP_GPIO6_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x100)|value<<8)
}
func (o *LP_IO_Type) GetGPIO6_LP_GPIO6_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x100) >> 8
}
func (o *LP_IO_Type) SetGPIO6_LP_GPIO6_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x200)|value<<9)
}
func (o *LP_IO_Type) GetGPIO6_LP_GPIO6_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x200) >> 9
}
func (o *LP_IO_Type) SetGPIO6_LP_GPIO6_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0xc00)|value<<10)
}
func (o *LP_IO_Type) GetGPIO6_LP_GPIO6_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0xc00) >> 10
}
func (o *LP_IO_Type) SetGPIO6_LP_GPIO6_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x7000)|value<<12)
}
func (o *LP_IO_Type) GetGPIO6_LP_GPIO6_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x7000) >> 12
}

// LP_IO.GPIO7: need des
func (o *LP_IO_Type) SetGPIO7_LP_GPIO7_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x1)|value)
}
func (o *LP_IO_Type) GetGPIO7_LP_GPIO7_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO7.Reg) & 0x1
}
func (o *LP_IO_Type) SetGPIO7_LP_GPIO7_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x2)|value<<1)
}
func (o *LP_IO_Type) GetGPIO7_LP_GPIO7_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x2) >> 1
}
func (o *LP_IO_Type) SetGPIO7_LP_GPIO7_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x4)|value<<2)
}
func (o *LP_IO_Type) GetGPIO7_LP_GPIO7_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x4) >> 2
}
func (o *LP_IO_Type) SetGPIO7_LP_GPIO7_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x8)|value<<3)
}
func (o *LP_IO_Type) GetGPIO7_LP_GPIO7_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x8) >> 3
}
func (o *LP_IO_Type) SetGPIO7_LP_GPIO7_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x10)|value<<4)
}
func (o *LP_IO_Type) GetGPIO7_LP_GPIO7_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x10) >> 4
}
func (o *LP_IO_Type) SetGPIO7_LP_GPIO7_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x60)|value<<5)
}
func (o *LP_IO_Type) GetGPIO7_LP_GPIO7_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x60) >> 5
}
func (o *LP_IO_Type) SetGPIO7_LP_GPIO7_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x80)|value<<7)
}
func (o *LP_IO_Type) GetGPIO7_LP_GPIO7_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x80) >> 7
}
func (o *LP_IO_Type) SetGPIO7_LP_GPIO7_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x100)|value<<8)
}
func (o *LP_IO_Type) GetGPIO7_LP_GPIO7_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x100) >> 8
}
func (o *LP_IO_Type) SetGPIO7_LP_GPIO7_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x200)|value<<9)
}
func (o *LP_IO_Type) GetGPIO7_LP_GPIO7_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x200) >> 9
}
func (o *LP_IO_Type) SetGPIO7_LP_GPIO7_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0xc00)|value<<10)
}
func (o *LP_IO_Type) GetGPIO7_LP_GPIO7_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0xc00) >> 10
}
func (o *LP_IO_Type) SetGPIO7_LP_GPIO7_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x7000)|value<<12)
}
func (o *LP_IO_Type) GetGPIO7_LP_GPIO7_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x7000) >> 12
}

// LP_IO.STATUS_INTERRUPT: need des
func (o *LP_IO_Type) SetSTATUS_INTERRUPT_LP_GPIO_STATUS_INTERRUPT_NEXT(value uint32) {
	volatile.StoreUint32(&o.STATUS_INTERRUPT.Reg, volatile.LoadUint32(&o.STATUS_INTERRUPT.Reg)&^(0xff)|value)
}
func (o *LP_IO_Type) GetSTATUS_INTERRUPT_LP_GPIO_STATUS_INTERRUPT_NEXT() uint32 {
	return volatile.LoadUint32(&o.STATUS_INTERRUPT.Reg) & 0xff
}

// LP_IO.DEBUG_SEL0: need des
func (o *LP_IO_Type) SetDEBUG_SEL0_LP_DEBUG_SEL0(value uint32) {
	volatile.StoreUint32(&o.DEBUG_SEL0.Reg, volatile.LoadUint32(&o.DEBUG_SEL0.Reg)&^(0x7f)|value)
}
func (o *LP_IO_Type) GetDEBUG_SEL0_LP_DEBUG_SEL0() uint32 {
	return volatile.LoadUint32(&o.DEBUG_SEL0.Reg) & 0x7f
}
func (o *LP_IO_Type) SetDEBUG_SEL0_LP_DEBUG_SEL1(value uint32) {
	volatile.StoreUint32(&o.DEBUG_SEL0.Reg, volatile.LoadUint32(&o.DEBUG_SEL0.Reg)&^(0x3f80)|value<<7)
}
func (o *LP_IO_Type) GetDEBUG_SEL0_LP_DEBUG_SEL1() uint32 {
	return (volatile.LoadUint32(&o.DEBUG_SEL0.Reg) & 0x3f80) >> 7
}
func (o *LP_IO_Type) SetDEBUG_SEL0_LP_DEBUG_SEL2(value uint32) {
	volatile.StoreUint32(&o.DEBUG_SEL0.Reg, volatile.LoadUint32(&o.DEBUG_SEL0.Reg)&^(0x1fc000)|value<<14)
}
func (o *LP_IO_Type) GetDEBUG_SEL0_LP_DEBUG_SEL2() uint32 {
	return (volatile.LoadUint32(&o.DEBUG_SEL0.Reg) & 0x1fc000) >> 14
}
func (o *LP_IO_Type) SetDEBUG_SEL0_LP_DEBUG_SEL3(value uint32) {
	volatile.StoreUint32(&o.DEBUG_SEL0.Reg, volatile.LoadUint32(&o.DEBUG_SEL0.Reg)&^(0xfe00000)|value<<21)
}
func (o *LP_IO_Type) GetDEBUG_SEL0_LP_DEBUG_SEL3() uint32 {
	return (volatile.LoadUint32(&o.DEBUG_SEL0.Reg) & 0xfe00000) >> 21
}

// LP_IO.DEBUG_SEL1: need des
func (o *LP_IO_Type) SetDEBUG_SEL1_LP_DEBUG_SEL4(value uint32) {
	volatile.StoreUint32(&o.DEBUG_SEL1.Reg, volatile.LoadUint32(&o.DEBUG_SEL1.Reg)&^(0x7f)|value)
}
func (o *LP_IO_Type) GetDEBUG_SEL1_LP_DEBUG_SEL4() uint32 {
	return volatile.LoadUint32(&o.DEBUG_SEL1.Reg) & 0x7f
}

// LP_IO.LPI2C: need des
func (o *LP_IO_Type) SetLPI2C_LP_I2C_SDA_IE(value uint32) {
	volatile.StoreUint32(&o.LPI2C.Reg, volatile.LoadUint32(&o.LPI2C.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_IO_Type) GetLPI2C_LP_I2C_SDA_IE() uint32 {
	return (volatile.LoadUint32(&o.LPI2C.Reg) & 0x40000000) >> 30
}
func (o *LP_IO_Type) SetLPI2C_LP_I2C_SCL_IE(value uint32) {
	volatile.StoreUint32(&o.LPI2C.Reg, volatile.LoadUint32(&o.LPI2C.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_IO_Type) GetLPI2C_LP_I2C_SCL_IE() uint32 {
	return (volatile.LoadUint32(&o.LPI2C.Reg) & 0x80000000) >> 31
}

// LP_IO.DATE: need des
func (o *LP_IO_Type) SetDATE_LP_IO_DATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x7fffffff)|value)
}
func (o *LP_IO_Type) GetDATE_LP_IO_DATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x7fffffff
}
func (o *LP_IO_Type) SetDATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_IO_Type) GetDATE_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.DATE.Reg) & 0x80000000) >> 31
}

// Low-power Trusted Execution Environment
type LP_TEE_Type struct {
	M0_MODE_CTRL volatile.Register32 // 0x0
	CLOCK_GATE   volatile.Register32 // 0x4
	_            [136]byte
	FORCE_ACC_HP volatile.Register32 // 0x90
	_            [104]byte
	DATE         volatile.Register32 // 0xFC
}

// LP_TEE.M0_MODE_CTRL: Tee mode control register
func (o *LP_TEE_Type) SetM0_MODE_CTRL_M0_MODE(value uint32) {
	volatile.StoreUint32(&o.M0_MODE_CTRL.Reg, volatile.LoadUint32(&o.M0_MODE_CTRL.Reg)&^(0x3)|value)
}
func (o *LP_TEE_Type) GetM0_MODE_CTRL_M0_MODE() uint32 {
	return volatile.LoadUint32(&o.M0_MODE_CTRL.Reg) & 0x3
}

// LP_TEE.CLOCK_GATE: Clock gating register
func (o *LP_TEE_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *LP_TEE_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// LP_TEE.FORCE_ACC_HP: need_des
func (o *LP_TEE_Type) SetFORCE_ACC_HP_LP_AON_FORCE_ACC_HPMEM_EN(value uint32) {
	volatile.StoreUint32(&o.FORCE_ACC_HP.Reg, volatile.LoadUint32(&o.FORCE_ACC_HP.Reg)&^(0x1)|value)
}
func (o *LP_TEE_Type) GetFORCE_ACC_HP_LP_AON_FORCE_ACC_HPMEM_EN() uint32 {
	return volatile.LoadUint32(&o.FORCE_ACC_HP.Reg) & 0x1
}

// LP_TEE.DATE: Version register
func (o *LP_TEE_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *LP_TEE_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// Low-power Timer
type LP_TIMER_Type struct {
	TAR0_LOW       volatile.Register32 // 0x0
	TAR0_HIGH      volatile.Register32 // 0x4
	TAR1_LOW       volatile.Register32 // 0x8
	TAR1_HIGH      volatile.Register32 // 0xC
	UPDATE         volatile.Register32 // 0x10
	MAIN_BUF0_LOW  volatile.Register32 // 0x14
	MAIN_BUF0_HIGH volatile.Register32 // 0x18
	MAIN_BUF1_LOW  volatile.Register32 // 0x1C
	MAIN_BUF1_HIGH volatile.Register32 // 0x20
	MAIN_OVERFLOW  volatile.Register32 // 0x24
	INT_RAW        volatile.Register32 // 0x28
	INT_ST         volatile.Register32 // 0x2C
	INT_ENA        volatile.Register32 // 0x30
	INT_CLR        volatile.Register32 // 0x34
	LP_INT_RAW     volatile.Register32 // 0x38
	LP_INT_ST      volatile.Register32 // 0x3C
	LP_INT_ENA     volatile.Register32 // 0x40
	LP_INT_CLR     volatile.Register32 // 0x44
	_              [948]byte
	DATE           volatile.Register32 // 0x3FC
}

// LP_TIMER.TAR0_LOW: need_des
func (o *LP_TIMER_Type) SetTAR0_LOW(value uint32) {
	volatile.StoreUint32(&o.TAR0_LOW.Reg, value)
}
func (o *LP_TIMER_Type) GetTAR0_LOW() uint32 {
	return volatile.LoadUint32(&o.TAR0_LOW.Reg)
}

// LP_TIMER.TAR0_HIGH: need_des
func (o *LP_TIMER_Type) SetTAR0_HIGH_MAIN_TIMER_TAR_HIGH0(value uint32) {
	volatile.StoreUint32(&o.TAR0_HIGH.Reg, volatile.LoadUint32(&o.TAR0_HIGH.Reg)&^(0xffff)|value)
}
func (o *LP_TIMER_Type) GetTAR0_HIGH_MAIN_TIMER_TAR_HIGH0() uint32 {
	return volatile.LoadUint32(&o.TAR0_HIGH.Reg) & 0xffff
}
func (o *LP_TIMER_Type) SetTAR0_HIGH_MAIN_TIMER_TAR_EN0(value uint32) {
	volatile.StoreUint32(&o.TAR0_HIGH.Reg, volatile.LoadUint32(&o.TAR0_HIGH.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_TIMER_Type) GetTAR0_HIGH_MAIN_TIMER_TAR_EN0() uint32 {
	return (volatile.LoadUint32(&o.TAR0_HIGH.Reg) & 0x80000000) >> 31
}

// LP_TIMER.TAR1_LOW: need_des
func (o *LP_TIMER_Type) SetTAR1_LOW(value uint32) {
	volatile.StoreUint32(&o.TAR1_LOW.Reg, value)
}
func (o *LP_TIMER_Type) GetTAR1_LOW() uint32 {
	return volatile.LoadUint32(&o.TAR1_LOW.Reg)
}

// LP_TIMER.TAR1_HIGH: need_des
func (o *LP_TIMER_Type) SetTAR1_HIGH_MAIN_TIMER_TAR_HIGH1(value uint32) {
	volatile.StoreUint32(&o.TAR1_HIGH.Reg, volatile.LoadUint32(&o.TAR1_HIGH.Reg)&^(0xffff)|value)
}
func (o *LP_TIMER_Type) GetTAR1_HIGH_MAIN_TIMER_TAR_HIGH1() uint32 {
	return volatile.LoadUint32(&o.TAR1_HIGH.Reg) & 0xffff
}
func (o *LP_TIMER_Type) SetTAR1_HIGH_MAIN_TIMER_TAR_EN1(value uint32) {
	volatile.StoreUint32(&o.TAR1_HIGH.Reg, volatile.LoadUint32(&o.TAR1_HIGH.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_TIMER_Type) GetTAR1_HIGH_MAIN_TIMER_TAR_EN1() uint32 {
	return (volatile.LoadUint32(&o.TAR1_HIGH.Reg) & 0x80000000) >> 31
}

// LP_TIMER.UPDATE: need_des
func (o *LP_TIMER_Type) SetUPDATE_MAIN_TIMER_UPDATE(value uint32) {
	volatile.StoreUint32(&o.UPDATE.Reg, volatile.LoadUint32(&o.UPDATE.Reg)&^(0x10000000)|value<<28)
}
func (o *LP_TIMER_Type) GetUPDATE_MAIN_TIMER_UPDATE() uint32 {
	return (volatile.LoadUint32(&o.UPDATE.Reg) & 0x10000000) >> 28
}
func (o *LP_TIMER_Type) SetUPDATE_MAIN_TIMER_XTAL_OFF(value uint32) {
	volatile.StoreUint32(&o.UPDATE.Reg, volatile.LoadUint32(&o.UPDATE.Reg)&^(0x20000000)|value<<29)
}
func (o *LP_TIMER_Type) GetUPDATE_MAIN_TIMER_XTAL_OFF() uint32 {
	return (volatile.LoadUint32(&o.UPDATE.Reg) & 0x20000000) >> 29
}
func (o *LP_TIMER_Type) SetUPDATE_MAIN_TIMER_SYS_STALL(value uint32) {
	volatile.StoreUint32(&o.UPDATE.Reg, volatile.LoadUint32(&o.UPDATE.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_TIMER_Type) GetUPDATE_MAIN_TIMER_SYS_STALL() uint32 {
	return (volatile.LoadUint32(&o.UPDATE.Reg) & 0x40000000) >> 30
}
func (o *LP_TIMER_Type) SetUPDATE_MAIN_TIMER_SYS_RST(value uint32) {
	volatile.StoreUint32(&o.UPDATE.Reg, volatile.LoadUint32(&o.UPDATE.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_TIMER_Type) GetUPDATE_MAIN_TIMER_SYS_RST() uint32 {
	return (volatile.LoadUint32(&o.UPDATE.Reg) & 0x80000000) >> 31
}

// LP_TIMER.MAIN_BUF0_LOW: need_des
func (o *LP_TIMER_Type) SetMAIN_BUF0_LOW(value uint32) {
	volatile.StoreUint32(&o.MAIN_BUF0_LOW.Reg, value)
}
func (o *LP_TIMER_Type) GetMAIN_BUF0_LOW() uint32 {
	return volatile.LoadUint32(&o.MAIN_BUF0_LOW.Reg)
}

// LP_TIMER.MAIN_BUF0_HIGH: need_des
func (o *LP_TIMER_Type) SetMAIN_BUF0_HIGH_MAIN_TIMER_BUF0_HIGH(value uint32) {
	volatile.StoreUint32(&o.MAIN_BUF0_HIGH.Reg, volatile.LoadUint32(&o.MAIN_BUF0_HIGH.Reg)&^(0xffff)|value)
}
func (o *LP_TIMER_Type) GetMAIN_BUF0_HIGH_MAIN_TIMER_BUF0_HIGH() uint32 {
	return volatile.LoadUint32(&o.MAIN_BUF0_HIGH.Reg) & 0xffff
}

// LP_TIMER.MAIN_BUF1_LOW: need_des
func (o *LP_TIMER_Type) SetMAIN_BUF1_LOW(value uint32) {
	volatile.StoreUint32(&o.MAIN_BUF1_LOW.Reg, value)
}
func (o *LP_TIMER_Type) GetMAIN_BUF1_LOW() uint32 {
	return volatile.LoadUint32(&o.MAIN_BUF1_LOW.Reg)
}

// LP_TIMER.MAIN_BUF1_HIGH: need_des
func (o *LP_TIMER_Type) SetMAIN_BUF1_HIGH_MAIN_TIMER_BUF1_HIGH(value uint32) {
	volatile.StoreUint32(&o.MAIN_BUF1_HIGH.Reg, volatile.LoadUint32(&o.MAIN_BUF1_HIGH.Reg)&^(0xffff)|value)
}
func (o *LP_TIMER_Type) GetMAIN_BUF1_HIGH_MAIN_TIMER_BUF1_HIGH() uint32 {
	return volatile.LoadUint32(&o.MAIN_BUF1_HIGH.Reg) & 0xffff
}

// LP_TIMER.MAIN_OVERFLOW: need_des
func (o *LP_TIMER_Type) SetMAIN_OVERFLOW_MAIN_TIMER_ALARM_LOAD(value uint32) {
	volatile.StoreUint32(&o.MAIN_OVERFLOW.Reg, volatile.LoadUint32(&o.MAIN_OVERFLOW.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_TIMER_Type) GetMAIN_OVERFLOW_MAIN_TIMER_ALARM_LOAD() uint32 {
	return (volatile.LoadUint32(&o.MAIN_OVERFLOW.Reg) & 0x80000000) >> 31
}

// LP_TIMER.INT_RAW: need_des
func (o *LP_TIMER_Type) SetINT_RAW_OVERFLOW_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_TIMER_Type) GetINT_RAW_OVERFLOW_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40000000) >> 30
}
func (o *LP_TIMER_Type) SetINT_RAW_SOC_WAKEUP_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_TIMER_Type) GetINT_RAW_SOC_WAKEUP_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80000000) >> 31
}

// LP_TIMER.INT_ST: need_des
func (o *LP_TIMER_Type) SetINT_ST_OVERFLOW_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_TIMER_Type) GetINT_ST_OVERFLOW_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40000000) >> 30
}
func (o *LP_TIMER_Type) SetINT_ST_SOC_WAKEUP_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_TIMER_Type) GetINT_ST_SOC_WAKEUP_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80000000) >> 31
}

// LP_TIMER.INT_ENA: need_des
func (o *LP_TIMER_Type) SetINT_ENA_OVERFLOW_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_TIMER_Type) GetINT_ENA_OVERFLOW_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40000000) >> 30
}
func (o *LP_TIMER_Type) SetINT_ENA_SOC_WAKEUP_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_TIMER_Type) GetINT_ENA_SOC_WAKEUP_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80000000) >> 31
}

// LP_TIMER.INT_CLR: need_des
func (o *LP_TIMER_Type) SetINT_CLR_OVERFLOW_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_TIMER_Type) GetINT_CLR_OVERFLOW_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40000000) >> 30
}
func (o *LP_TIMER_Type) SetINT_CLR_SOC_WAKEUP_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_TIMER_Type) GetINT_CLR_SOC_WAKEUP_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80000000) >> 31
}

// LP_TIMER.LP_INT_RAW: need_des
func (o *LP_TIMER_Type) SetLP_INT_RAW_MAIN_TIMER_OVERFLOW_LP_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.LP_INT_RAW.Reg, volatile.LoadUint32(&o.LP_INT_RAW.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_TIMER_Type) GetLP_INT_RAW_MAIN_TIMER_OVERFLOW_LP_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.LP_INT_RAW.Reg) & 0x40000000) >> 30
}
func (o *LP_TIMER_Type) SetLP_INT_RAW_MAIN_TIMER_LP_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.LP_INT_RAW.Reg, volatile.LoadUint32(&o.LP_INT_RAW.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_TIMER_Type) GetLP_INT_RAW_MAIN_TIMER_LP_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.LP_INT_RAW.Reg) & 0x80000000) >> 31
}

// LP_TIMER.LP_INT_ST: need_des
func (o *LP_TIMER_Type) SetLP_INT_ST_MAIN_TIMER_OVERFLOW_LP_INT_ST(value uint32) {
	volatile.StoreUint32(&o.LP_INT_ST.Reg, volatile.LoadUint32(&o.LP_INT_ST.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_TIMER_Type) GetLP_INT_ST_MAIN_TIMER_OVERFLOW_LP_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.LP_INT_ST.Reg) & 0x40000000) >> 30
}
func (o *LP_TIMER_Type) SetLP_INT_ST_MAIN_TIMER_LP_INT_ST(value uint32) {
	volatile.StoreUint32(&o.LP_INT_ST.Reg, volatile.LoadUint32(&o.LP_INT_ST.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_TIMER_Type) GetLP_INT_ST_MAIN_TIMER_LP_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.LP_INT_ST.Reg) & 0x80000000) >> 31
}

// LP_TIMER.LP_INT_ENA: need_des
func (o *LP_TIMER_Type) SetLP_INT_ENA_MAIN_TIMER_OVERFLOW_LP_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.LP_INT_ENA.Reg, volatile.LoadUint32(&o.LP_INT_ENA.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_TIMER_Type) GetLP_INT_ENA_MAIN_TIMER_OVERFLOW_LP_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.LP_INT_ENA.Reg) & 0x40000000) >> 30
}
func (o *LP_TIMER_Type) SetLP_INT_ENA_MAIN_TIMER_LP_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.LP_INT_ENA.Reg, volatile.LoadUint32(&o.LP_INT_ENA.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_TIMER_Type) GetLP_INT_ENA_MAIN_TIMER_LP_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.LP_INT_ENA.Reg) & 0x80000000) >> 31
}

// LP_TIMER.LP_INT_CLR: need_des
func (o *LP_TIMER_Type) SetLP_INT_CLR_MAIN_TIMER_OVERFLOW_LP_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.LP_INT_CLR.Reg, volatile.LoadUint32(&o.LP_INT_CLR.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_TIMER_Type) GetLP_INT_CLR_MAIN_TIMER_OVERFLOW_LP_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.LP_INT_CLR.Reg) & 0x40000000) >> 30
}
func (o *LP_TIMER_Type) SetLP_INT_CLR_MAIN_TIMER_LP_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.LP_INT_CLR.Reg, volatile.LoadUint32(&o.LP_INT_CLR.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_TIMER_Type) GetLP_INT_CLR_MAIN_TIMER_LP_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.LP_INT_CLR.Reg) & 0x80000000) >> 31
}

// LP_TIMER.DATE: need_des
func (o *LP_TIMER_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x7fffffff)|value)
}
func (o *LP_TIMER_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x7fffffff
}
func (o *LP_TIMER_Type) SetDATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_TIMER_Type) GetDATE_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.DATE.Reg) & 0x80000000) >> 31
}

// Low-power UART (Universal Asynchronous Receiver-Transmitter) Controller
type LP_UART_Type struct {
	FIFO                volatile.Register32 // 0x0
	INT_RAW             volatile.Register32 // 0x4
	INT_ST              volatile.Register32 // 0x8
	INT_ENA             volatile.Register32 // 0xC
	INT_CLR             volatile.Register32 // 0x10
	CLKDIV_SYNC         volatile.Register32 // 0x14
	RX_FILT             volatile.Register32 // 0x18
	STATUS              volatile.Register32 // 0x1C
	CONF0_SYNC          volatile.Register32 // 0x20
	CONF1               volatile.Register32 // 0x24
	_                   [4]byte
	HWFC_CONF_SYNC      volatile.Register32 // 0x2C
	SLEEP_CONF0         volatile.Register32 // 0x30
	SLEEP_CONF1         volatile.Register32 // 0x34
	SLEEP_CONF2         volatile.Register32 // 0x38
	SWFC_CONF0_SYNC     volatile.Register32 // 0x3C
	SWFC_CONF1          volatile.Register32 // 0x40
	TXBRK_CONF_SYNC     volatile.Register32 // 0x44
	IDLE_CONF_SYNC      volatile.Register32 // 0x48
	RS485_CONF_SYNC     volatile.Register32 // 0x4C
	AT_CMD_PRECNT_SYNC  volatile.Register32 // 0x50
	AT_CMD_POSTCNT_SYNC volatile.Register32 // 0x54
	AT_CMD_GAPTOUT_SYNC volatile.Register32 // 0x58
	AT_CMD_CHAR_SYNC    volatile.Register32 // 0x5C
	MEM_CONF            volatile.Register32 // 0x60
	TOUT_CONF_SYNC      volatile.Register32 // 0x64
	MEM_TX_STATUS       volatile.Register32 // 0x68
	MEM_RX_STATUS       volatile.Register32 // 0x6C
	FSM_STATUS          volatile.Register32 // 0x70
	_                   [20]byte
	CLK_CONF            volatile.Register32 // 0x88
	DATE                volatile.Register32 // 0x8C
	AFIFO_STATUS        volatile.Register32 // 0x90
	_                   [4]byte
	REG_UPDATE          volatile.Register32 // 0x98
	ID                  volatile.Register32 // 0x9C
}

// LP_UART.FIFO: FIFO data register
func (o *LP_UART_Type) SetFIFO_RXFIFO_RD_BYTE(value uint32) {
	volatile.StoreUint32(&o.FIFO.Reg, volatile.LoadUint32(&o.FIFO.Reg)&^(0xff)|value)
}
func (o *LP_UART_Type) GetFIFO_RXFIFO_RD_BYTE() uint32 {
	return volatile.LoadUint32(&o.FIFO.Reg) & 0xff
}

// LP_UART.INT_RAW: Raw interrupt status
func (o *LP_UART_Type) SetINT_RAW_RXFIFO_FULL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *LP_UART_Type) GetINT_RAW_RXFIFO_FULL_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *LP_UART_Type) SetINT_RAW_TXFIFO_EMPTY_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *LP_UART_Type) GetINT_RAW_TXFIFO_EMPTY_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *LP_UART_Type) SetINT_RAW_PARITY_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *LP_UART_Type) GetINT_RAW_PARITY_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *LP_UART_Type) SetINT_RAW_FRM_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *LP_UART_Type) GetINT_RAW_FRM_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}
func (o *LP_UART_Type) SetINT_RAW_RXFIFO_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *LP_UART_Type) GetINT_RAW_RXFIFO_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10) >> 4
}
func (o *LP_UART_Type) SetINT_RAW_DSR_CHG_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *LP_UART_Type) GetINT_RAW_DSR_CHG_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20) >> 5
}
func (o *LP_UART_Type) SetINT_RAW_CTS_CHG_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *LP_UART_Type) GetINT_RAW_CTS_CHG_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40) >> 6
}
func (o *LP_UART_Type) SetINT_RAW_BRK_DET_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *LP_UART_Type) GetINT_RAW_BRK_DET_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80) >> 7
}
func (o *LP_UART_Type) SetINT_RAW_RXFIFO_TOUT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *LP_UART_Type) GetINT_RAW_RXFIFO_TOUT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x100) >> 8
}
func (o *LP_UART_Type) SetINT_RAW_SW_XON_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *LP_UART_Type) GetINT_RAW_SW_XON_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x200) >> 9
}
func (o *LP_UART_Type) SetINT_RAW_SW_XOFF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *LP_UART_Type) GetINT_RAW_SW_XOFF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x400) >> 10
}
func (o *LP_UART_Type) SetINT_RAW_GLITCH_DET_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *LP_UART_Type) GetINT_RAW_GLITCH_DET_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x800) >> 11
}
func (o *LP_UART_Type) SetINT_RAW_TX_BRK_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *LP_UART_Type) GetINT_RAW_TX_BRK_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1000) >> 12
}
func (o *LP_UART_Type) SetINT_RAW_TX_BRK_IDLE_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *LP_UART_Type) GetINT_RAW_TX_BRK_IDLE_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2000) >> 13
}
func (o *LP_UART_Type) SetINT_RAW_TX_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4000)|value<<14)
}
func (o *LP_UART_Type) GetINT_RAW_TX_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4000) >> 14
}
func (o *LP_UART_Type) SetINT_RAW_AT_CMD_CHAR_DET_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40000)|value<<18)
}
func (o *LP_UART_Type) GetINT_RAW_AT_CMD_CHAR_DET_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40000) >> 18
}
func (o *LP_UART_Type) SetINT_RAW_WAKEUP_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80000)|value<<19)
}
func (o *LP_UART_Type) GetINT_RAW_WAKEUP_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80000) >> 19
}

// LP_UART.INT_ST: Masked interrupt status
func (o *LP_UART_Type) SetINT_ST_RXFIFO_FULL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *LP_UART_Type) GetINT_ST_RXFIFO_FULL_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *LP_UART_Type) SetINT_ST_TXFIFO_EMPTY_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *LP_UART_Type) GetINT_ST_TXFIFO_EMPTY_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}
func (o *LP_UART_Type) SetINT_ST_PARITY_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *LP_UART_Type) GetINT_ST_PARITY_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4) >> 2
}
func (o *LP_UART_Type) SetINT_ST_FRM_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *LP_UART_Type) GetINT_ST_FRM_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8) >> 3
}
func (o *LP_UART_Type) SetINT_ST_RXFIFO_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *LP_UART_Type) GetINT_ST_RXFIFO_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10) >> 4
}
func (o *LP_UART_Type) SetINT_ST_DSR_CHG_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *LP_UART_Type) GetINT_ST_DSR_CHG_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20) >> 5
}
func (o *LP_UART_Type) SetINT_ST_CTS_CHG_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40)|value<<6)
}
func (o *LP_UART_Type) GetINT_ST_CTS_CHG_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40) >> 6
}
func (o *LP_UART_Type) SetINT_ST_BRK_DET_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *LP_UART_Type) GetINT_ST_BRK_DET_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80) >> 7
}
func (o *LP_UART_Type) SetINT_ST_RXFIFO_TOUT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *LP_UART_Type) GetINT_ST_RXFIFO_TOUT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x100) >> 8
}
func (o *LP_UART_Type) SetINT_ST_SW_XON_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x200)|value<<9)
}
func (o *LP_UART_Type) GetINT_ST_SW_XON_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x200) >> 9
}
func (o *LP_UART_Type) SetINT_ST_SW_XOFF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x400)|value<<10)
}
func (o *LP_UART_Type) GetINT_ST_SW_XOFF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x400) >> 10
}
func (o *LP_UART_Type) SetINT_ST_GLITCH_DET_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x800)|value<<11)
}
func (o *LP_UART_Type) GetINT_ST_GLITCH_DET_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x800) >> 11
}
func (o *LP_UART_Type) SetINT_ST_TX_BRK_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1000)|value<<12)
}
func (o *LP_UART_Type) GetINT_ST_TX_BRK_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x1000) >> 12
}
func (o *LP_UART_Type) SetINT_ST_TX_BRK_IDLE_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2000)|value<<13)
}
func (o *LP_UART_Type) GetINT_ST_TX_BRK_IDLE_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2000) >> 13
}
func (o *LP_UART_Type) SetINT_ST_TX_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4000)|value<<14)
}
func (o *LP_UART_Type) GetINT_ST_TX_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4000) >> 14
}
func (o *LP_UART_Type) SetINT_ST_AT_CMD_CHAR_DET_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40000)|value<<18)
}
func (o *LP_UART_Type) GetINT_ST_AT_CMD_CHAR_DET_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40000) >> 18
}
func (o *LP_UART_Type) SetINT_ST_WAKEUP_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80000)|value<<19)
}
func (o *LP_UART_Type) GetINT_ST_WAKEUP_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80000) >> 19
}

// LP_UART.INT_ENA: Interrupt enable bits
func (o *LP_UART_Type) SetINT_ENA_RXFIFO_FULL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *LP_UART_Type) GetINT_ENA_RXFIFO_FULL_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *LP_UART_Type) SetINT_ENA_TXFIFO_EMPTY_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *LP_UART_Type) GetINT_ENA_TXFIFO_EMPTY_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *LP_UART_Type) SetINT_ENA_PARITY_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *LP_UART_Type) GetINT_ENA_PARITY_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *LP_UART_Type) SetINT_ENA_FRM_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *LP_UART_Type) GetINT_ENA_FRM_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}
func (o *LP_UART_Type) SetINT_ENA_RXFIFO_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *LP_UART_Type) GetINT_ENA_RXFIFO_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10) >> 4
}
func (o *LP_UART_Type) SetINT_ENA_DSR_CHG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *LP_UART_Type) GetINT_ENA_DSR_CHG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20) >> 5
}
func (o *LP_UART_Type) SetINT_ENA_CTS_CHG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *LP_UART_Type) GetINT_ENA_CTS_CHG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40) >> 6
}
func (o *LP_UART_Type) SetINT_ENA_BRK_DET_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *LP_UART_Type) GetINT_ENA_BRK_DET_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80) >> 7
}
func (o *LP_UART_Type) SetINT_ENA_RXFIFO_TOUT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *LP_UART_Type) GetINT_ENA_RXFIFO_TOUT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x100) >> 8
}
func (o *LP_UART_Type) SetINT_ENA_SW_XON_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *LP_UART_Type) GetINT_ENA_SW_XON_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x200) >> 9
}
func (o *LP_UART_Type) SetINT_ENA_SW_XOFF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *LP_UART_Type) GetINT_ENA_SW_XOFF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x400) >> 10
}
func (o *LP_UART_Type) SetINT_ENA_GLITCH_DET_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *LP_UART_Type) GetINT_ENA_GLITCH_DET_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x800) >> 11
}
func (o *LP_UART_Type) SetINT_ENA_TX_BRK_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *LP_UART_Type) GetINT_ENA_TX_BRK_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1000) >> 12
}
func (o *LP_UART_Type) SetINT_ENA_TX_BRK_IDLE_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *LP_UART_Type) GetINT_ENA_TX_BRK_IDLE_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2000) >> 13
}
func (o *LP_UART_Type) SetINT_ENA_TX_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4000)|value<<14)
}
func (o *LP_UART_Type) GetINT_ENA_TX_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4000) >> 14
}
func (o *LP_UART_Type) SetINT_ENA_AT_CMD_CHAR_DET_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40000)|value<<18)
}
func (o *LP_UART_Type) GetINT_ENA_AT_CMD_CHAR_DET_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40000) >> 18
}
func (o *LP_UART_Type) SetINT_ENA_WAKEUP_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80000)|value<<19)
}
func (o *LP_UART_Type) GetINT_ENA_WAKEUP_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80000) >> 19
}

// LP_UART.INT_CLR: Interrupt clear bits
func (o *LP_UART_Type) SetINT_CLR_RXFIFO_FULL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *LP_UART_Type) GetINT_CLR_RXFIFO_FULL_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *LP_UART_Type) SetINT_CLR_TXFIFO_EMPTY_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *LP_UART_Type) GetINT_CLR_TXFIFO_EMPTY_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *LP_UART_Type) SetINT_CLR_PARITY_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *LP_UART_Type) GetINT_CLR_PARITY_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *LP_UART_Type) SetINT_CLR_FRM_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *LP_UART_Type) GetINT_CLR_FRM_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}
func (o *LP_UART_Type) SetINT_CLR_RXFIFO_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *LP_UART_Type) GetINT_CLR_RXFIFO_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10) >> 4
}
func (o *LP_UART_Type) SetINT_CLR_DSR_CHG_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *LP_UART_Type) GetINT_CLR_DSR_CHG_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20) >> 5
}
func (o *LP_UART_Type) SetINT_CLR_CTS_CHG_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *LP_UART_Type) GetINT_CLR_CTS_CHG_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40) >> 6
}
func (o *LP_UART_Type) SetINT_CLR_BRK_DET_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *LP_UART_Type) GetINT_CLR_BRK_DET_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80) >> 7
}
func (o *LP_UART_Type) SetINT_CLR_RXFIFO_TOUT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *LP_UART_Type) GetINT_CLR_RXFIFO_TOUT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x100) >> 8
}
func (o *LP_UART_Type) SetINT_CLR_SW_XON_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *LP_UART_Type) GetINT_CLR_SW_XON_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x200) >> 9
}
func (o *LP_UART_Type) SetINT_CLR_SW_XOFF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *LP_UART_Type) GetINT_CLR_SW_XOFF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x400) >> 10
}
func (o *LP_UART_Type) SetINT_CLR_GLITCH_DET_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *LP_UART_Type) GetINT_CLR_GLITCH_DET_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x800) >> 11
}
func (o *LP_UART_Type) SetINT_CLR_TX_BRK_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *LP_UART_Type) GetINT_CLR_TX_BRK_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1000) >> 12
}
func (o *LP_UART_Type) SetINT_CLR_TX_BRK_IDLE_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *LP_UART_Type) GetINT_CLR_TX_BRK_IDLE_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2000) >> 13
}
func (o *LP_UART_Type) SetINT_CLR_TX_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *LP_UART_Type) GetINT_CLR_TX_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4000) >> 14
}
func (o *LP_UART_Type) SetINT_CLR_AT_CMD_CHAR_DET_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40000)|value<<18)
}
func (o *LP_UART_Type) GetINT_CLR_AT_CMD_CHAR_DET_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40000) >> 18
}
func (o *LP_UART_Type) SetINT_CLR_WAKEUP_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80000)|value<<19)
}
func (o *LP_UART_Type) GetINT_CLR_WAKEUP_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80000) >> 19
}

// LP_UART.CLKDIV_SYNC: Clock divider configuration
func (o *LP_UART_Type) SetCLKDIV_SYNC_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CLKDIV_SYNC.Reg, volatile.LoadUint32(&o.CLKDIV_SYNC.Reg)&^(0xfff)|value)
}
func (o *LP_UART_Type) GetCLKDIV_SYNC_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.CLKDIV_SYNC.Reg) & 0xfff
}
func (o *LP_UART_Type) SetCLKDIV_SYNC_CLKDIV_FRAG(value uint32) {
	volatile.StoreUint32(&o.CLKDIV_SYNC.Reg, volatile.LoadUint32(&o.CLKDIV_SYNC.Reg)&^(0xf00000)|value<<20)
}
func (o *LP_UART_Type) GetCLKDIV_SYNC_CLKDIV_FRAG() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV_SYNC.Reg) & 0xf00000) >> 20
}

// LP_UART.RX_FILT: Rx Filter configuration
func (o *LP_UART_Type) SetRX_FILT_GLITCH_FILT(value uint32) {
	volatile.StoreUint32(&o.RX_FILT.Reg, volatile.LoadUint32(&o.RX_FILT.Reg)&^(0xff)|value)
}
func (o *LP_UART_Type) GetRX_FILT_GLITCH_FILT() uint32 {
	return volatile.LoadUint32(&o.RX_FILT.Reg) & 0xff
}
func (o *LP_UART_Type) SetRX_FILT_GLITCH_FILT_EN(value uint32) {
	volatile.StoreUint32(&o.RX_FILT.Reg, volatile.LoadUint32(&o.RX_FILT.Reg)&^(0x100)|value<<8)
}
func (o *LP_UART_Type) GetRX_FILT_GLITCH_FILT_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_FILT.Reg) & 0x100) >> 8
}

// LP_UART.STATUS: UART status register
func (o *LP_UART_Type) SetSTATUS_RXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xf8)|value<<3)
}
func (o *LP_UART_Type) GetSTATUS_RXFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xf8) >> 3
}
func (o *LP_UART_Type) SetSTATUS_DSRN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *LP_UART_Type) GetSTATUS_DSRN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2000) >> 13
}
func (o *LP_UART_Type) SetSTATUS_CTSN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4000)|value<<14)
}
func (o *LP_UART_Type) GetSTATUS_CTSN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4000) >> 14
}
func (o *LP_UART_Type) SetSTATUS_RXD(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8000)|value<<15)
}
func (o *LP_UART_Type) GetSTATUS_RXD() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8000) >> 15
}
func (o *LP_UART_Type) SetSTATUS_TXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xf80000)|value<<19)
}
func (o *LP_UART_Type) GetSTATUS_TXFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xf80000) >> 19
}
func (o *LP_UART_Type) SetSTATUS_DTRN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20000000)|value<<29)
}
func (o *LP_UART_Type) GetSTATUS_DTRN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20000000) >> 29
}
func (o *LP_UART_Type) SetSTATUS_RTSN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_UART_Type) GetSTATUS_RTSN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40000000) >> 30
}
func (o *LP_UART_Type) SetSTATUS_TXD(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_UART_Type) GetSTATUS_TXD() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80000000) >> 31
}

// LP_UART.CONF0_SYNC: Configuration register 0
func (o *LP_UART_Type) SetCONF0_SYNC_PARITY(value uint32) {
	volatile.StoreUint32(&o.CONF0_SYNC.Reg, volatile.LoadUint32(&o.CONF0_SYNC.Reg)&^(0x1)|value)
}
func (o *LP_UART_Type) GetCONF0_SYNC_PARITY() uint32 {
	return volatile.LoadUint32(&o.CONF0_SYNC.Reg) & 0x1
}
func (o *LP_UART_Type) SetCONF0_SYNC_PARITY_EN(value uint32) {
	volatile.StoreUint32(&o.CONF0_SYNC.Reg, volatile.LoadUint32(&o.CONF0_SYNC.Reg)&^(0x2)|value<<1)
}
func (o *LP_UART_Type) GetCONF0_SYNC_PARITY_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF0_SYNC.Reg) & 0x2) >> 1
}
func (o *LP_UART_Type) SetCONF0_SYNC_BIT_NUM(value uint32) {
	volatile.StoreUint32(&o.CONF0_SYNC.Reg, volatile.LoadUint32(&o.CONF0_SYNC.Reg)&^(0xc)|value<<2)
}
func (o *LP_UART_Type) GetCONF0_SYNC_BIT_NUM() uint32 {
	return (volatile.LoadUint32(&o.CONF0_SYNC.Reg) & 0xc) >> 2
}
func (o *LP_UART_Type) SetCONF0_SYNC_STOP_BIT_NUM(value uint32) {
	volatile.StoreUint32(&o.CONF0_SYNC.Reg, volatile.LoadUint32(&o.CONF0_SYNC.Reg)&^(0x30)|value<<4)
}
func (o *LP_UART_Type) GetCONF0_SYNC_STOP_BIT_NUM() uint32 {
	return (volatile.LoadUint32(&o.CONF0_SYNC.Reg) & 0x30) >> 4
}
func (o *LP_UART_Type) SetCONF0_SYNC_TXD_BRK(value uint32) {
	volatile.StoreUint32(&o.CONF0_SYNC.Reg, volatile.LoadUint32(&o.CONF0_SYNC.Reg)&^(0x40)|value<<6)
}
func (o *LP_UART_Type) GetCONF0_SYNC_TXD_BRK() uint32 {
	return (volatile.LoadUint32(&o.CONF0_SYNC.Reg) & 0x40) >> 6
}
func (o *LP_UART_Type) SetCONF0_SYNC_LOOPBACK(value uint32) {
	volatile.StoreUint32(&o.CONF0_SYNC.Reg, volatile.LoadUint32(&o.CONF0_SYNC.Reg)&^(0x1000)|value<<12)
}
func (o *LP_UART_Type) GetCONF0_SYNC_LOOPBACK() uint32 {
	return (volatile.LoadUint32(&o.CONF0_SYNC.Reg) & 0x1000) >> 12
}
func (o *LP_UART_Type) SetCONF0_SYNC_TX_FLOW_EN(value uint32) {
	volatile.StoreUint32(&o.CONF0_SYNC.Reg, volatile.LoadUint32(&o.CONF0_SYNC.Reg)&^(0x2000)|value<<13)
}
func (o *LP_UART_Type) GetCONF0_SYNC_TX_FLOW_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF0_SYNC.Reg) & 0x2000) >> 13
}
func (o *LP_UART_Type) SetCONF0_SYNC_RXD_INV(value uint32) {
	volatile.StoreUint32(&o.CONF0_SYNC.Reg, volatile.LoadUint32(&o.CONF0_SYNC.Reg)&^(0x8000)|value<<15)
}
func (o *LP_UART_Type) GetCONF0_SYNC_RXD_INV() uint32 {
	return (volatile.LoadUint32(&o.CONF0_SYNC.Reg) & 0x8000) >> 15
}
func (o *LP_UART_Type) SetCONF0_SYNC_TXD_INV(value uint32) {
	volatile.StoreUint32(&o.CONF0_SYNC.Reg, volatile.LoadUint32(&o.CONF0_SYNC.Reg)&^(0x10000)|value<<16)
}
func (o *LP_UART_Type) GetCONF0_SYNC_TXD_INV() uint32 {
	return (volatile.LoadUint32(&o.CONF0_SYNC.Reg) & 0x10000) >> 16
}
func (o *LP_UART_Type) SetCONF0_SYNC_DIS_RX_DAT_OVF(value uint32) {
	volatile.StoreUint32(&o.CONF0_SYNC.Reg, volatile.LoadUint32(&o.CONF0_SYNC.Reg)&^(0x20000)|value<<17)
}
func (o *LP_UART_Type) GetCONF0_SYNC_DIS_RX_DAT_OVF() uint32 {
	return (volatile.LoadUint32(&o.CONF0_SYNC.Reg) & 0x20000) >> 17
}
func (o *LP_UART_Type) SetCONF0_SYNC_ERR_WR_MASK(value uint32) {
	volatile.StoreUint32(&o.CONF0_SYNC.Reg, volatile.LoadUint32(&o.CONF0_SYNC.Reg)&^(0x40000)|value<<18)
}
func (o *LP_UART_Type) GetCONF0_SYNC_ERR_WR_MASK() uint32 {
	return (volatile.LoadUint32(&o.CONF0_SYNC.Reg) & 0x40000) >> 18
}
func (o *LP_UART_Type) SetCONF0_SYNC_MEM_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CONF0_SYNC.Reg, volatile.LoadUint32(&o.CONF0_SYNC.Reg)&^(0x100000)|value<<20)
}
func (o *LP_UART_Type) GetCONF0_SYNC_MEM_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF0_SYNC.Reg) & 0x100000) >> 20
}
func (o *LP_UART_Type) SetCONF0_SYNC_SW_RTS(value uint32) {
	volatile.StoreUint32(&o.CONF0_SYNC.Reg, volatile.LoadUint32(&o.CONF0_SYNC.Reg)&^(0x200000)|value<<21)
}
func (o *LP_UART_Type) GetCONF0_SYNC_SW_RTS() uint32 {
	return (volatile.LoadUint32(&o.CONF0_SYNC.Reg) & 0x200000) >> 21
}
func (o *LP_UART_Type) SetCONF0_SYNC_RXFIFO_RST(value uint32) {
	volatile.StoreUint32(&o.CONF0_SYNC.Reg, volatile.LoadUint32(&o.CONF0_SYNC.Reg)&^(0x400000)|value<<22)
}
func (o *LP_UART_Type) GetCONF0_SYNC_RXFIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.CONF0_SYNC.Reg) & 0x400000) >> 22
}
func (o *LP_UART_Type) SetCONF0_SYNC_TXFIFO_RST(value uint32) {
	volatile.StoreUint32(&o.CONF0_SYNC.Reg, volatile.LoadUint32(&o.CONF0_SYNC.Reg)&^(0x800000)|value<<23)
}
func (o *LP_UART_Type) GetCONF0_SYNC_TXFIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.CONF0_SYNC.Reg) & 0x800000) >> 23
}

// LP_UART.CONF1: Configuration register 1
func (o *LP_UART_Type) SetCONF1_RXFIFO_FULL_THRHD(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0xf8)|value<<3)
}
func (o *LP_UART_Type) GetCONF1_RXFIFO_FULL_THRHD() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0xf8) >> 3
}
func (o *LP_UART_Type) SetCONF1_TXFIFO_EMPTY_THRHD(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0xf800)|value<<11)
}
func (o *LP_UART_Type) GetCONF1_TXFIFO_EMPTY_THRHD() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0xf800) >> 11
}
func (o *LP_UART_Type) SetCONF1_CTS_INV(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x10000)|value<<16)
}
func (o *LP_UART_Type) GetCONF1_CTS_INV() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x10000) >> 16
}
func (o *LP_UART_Type) SetCONF1_DSR_INV(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x20000)|value<<17)
}
func (o *LP_UART_Type) GetCONF1_DSR_INV() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x20000) >> 17
}
func (o *LP_UART_Type) SetCONF1_RTS_INV(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x40000)|value<<18)
}
func (o *LP_UART_Type) GetCONF1_RTS_INV() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x40000) >> 18
}
func (o *LP_UART_Type) SetCONF1_DTR_INV(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x80000)|value<<19)
}
func (o *LP_UART_Type) GetCONF1_DTR_INV() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x80000) >> 19
}
func (o *LP_UART_Type) SetCONF1_SW_DTR(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x100000)|value<<20)
}
func (o *LP_UART_Type) GetCONF1_SW_DTR() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x100000) >> 20
}
func (o *LP_UART_Type) SetCONF1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x200000)|value<<21)
}
func (o *LP_UART_Type) GetCONF1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x200000) >> 21
}

// LP_UART.HWFC_CONF_SYNC: Hardware flow-control configuration
func (o *LP_UART_Type) SetHWFC_CONF_SYNC_RX_FLOW_THRHD(value uint32) {
	volatile.StoreUint32(&o.HWFC_CONF_SYNC.Reg, volatile.LoadUint32(&o.HWFC_CONF_SYNC.Reg)&^(0xf8)|value<<3)
}
func (o *LP_UART_Type) GetHWFC_CONF_SYNC_RX_FLOW_THRHD() uint32 {
	return (volatile.LoadUint32(&o.HWFC_CONF_SYNC.Reg) & 0xf8) >> 3
}
func (o *LP_UART_Type) SetHWFC_CONF_SYNC_RX_FLOW_EN(value uint32) {
	volatile.StoreUint32(&o.HWFC_CONF_SYNC.Reg, volatile.LoadUint32(&o.HWFC_CONF_SYNC.Reg)&^(0x100)|value<<8)
}
func (o *LP_UART_Type) GetHWFC_CONF_SYNC_RX_FLOW_EN() uint32 {
	return (volatile.LoadUint32(&o.HWFC_CONF_SYNC.Reg) & 0x100) >> 8
}

// LP_UART.SLEEP_CONF0: UART sleep configure register 0
func (o *LP_UART_Type) SetSLEEP_CONF0_WK_CHAR1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_CONF0.Reg, volatile.LoadUint32(&o.SLEEP_CONF0.Reg)&^(0xff)|value)
}
func (o *LP_UART_Type) GetSLEEP_CONF0_WK_CHAR1() uint32 {
	return volatile.LoadUint32(&o.SLEEP_CONF0.Reg) & 0xff
}
func (o *LP_UART_Type) SetSLEEP_CONF0_WK_CHAR2(value uint32) {
	volatile.StoreUint32(&o.SLEEP_CONF0.Reg, volatile.LoadUint32(&o.SLEEP_CONF0.Reg)&^(0xff00)|value<<8)
}
func (o *LP_UART_Type) GetSLEEP_CONF0_WK_CHAR2() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_CONF0.Reg) & 0xff00) >> 8
}
func (o *LP_UART_Type) SetSLEEP_CONF0_WK_CHAR3(value uint32) {
	volatile.StoreUint32(&o.SLEEP_CONF0.Reg, volatile.LoadUint32(&o.SLEEP_CONF0.Reg)&^(0xff0000)|value<<16)
}
func (o *LP_UART_Type) GetSLEEP_CONF0_WK_CHAR3() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_CONF0.Reg) & 0xff0000) >> 16
}
func (o *LP_UART_Type) SetSLEEP_CONF0_WK_CHAR4(value uint32) {
	volatile.StoreUint32(&o.SLEEP_CONF0.Reg, volatile.LoadUint32(&o.SLEEP_CONF0.Reg)&^(0xff000000)|value<<24)
}
func (o *LP_UART_Type) GetSLEEP_CONF0_WK_CHAR4() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_CONF0.Reg) & 0xff000000) >> 24
}

// LP_UART.SLEEP_CONF1: UART sleep configure register 1
func (o *LP_UART_Type) SetSLEEP_CONF1_WK_CHAR0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_CONF1.Reg, volatile.LoadUint32(&o.SLEEP_CONF1.Reg)&^(0xff)|value)
}
func (o *LP_UART_Type) GetSLEEP_CONF1_WK_CHAR0() uint32 {
	return volatile.LoadUint32(&o.SLEEP_CONF1.Reg) & 0xff
}

// LP_UART.SLEEP_CONF2: UART sleep configure register 2
func (o *LP_UART_Type) SetSLEEP_CONF2_ACTIVE_THRESHOLD(value uint32) {
	volatile.StoreUint32(&o.SLEEP_CONF2.Reg, volatile.LoadUint32(&o.SLEEP_CONF2.Reg)&^(0x3ff)|value)
}
func (o *LP_UART_Type) GetSLEEP_CONF2_ACTIVE_THRESHOLD() uint32 {
	return volatile.LoadUint32(&o.SLEEP_CONF2.Reg) & 0x3ff
}
func (o *LP_UART_Type) SetSLEEP_CONF2_RX_WAKE_UP_THRHD(value uint32) {
	volatile.StoreUint32(&o.SLEEP_CONF2.Reg, volatile.LoadUint32(&o.SLEEP_CONF2.Reg)&^(0x3e000)|value<<13)
}
func (o *LP_UART_Type) GetSLEEP_CONF2_RX_WAKE_UP_THRHD() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_CONF2.Reg) & 0x3e000) >> 13
}
func (o *LP_UART_Type) SetSLEEP_CONF2_WK_CHAR_NUM(value uint32) {
	volatile.StoreUint32(&o.SLEEP_CONF2.Reg, volatile.LoadUint32(&o.SLEEP_CONF2.Reg)&^(0x1c0000)|value<<18)
}
func (o *LP_UART_Type) GetSLEEP_CONF2_WK_CHAR_NUM() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_CONF2.Reg) & 0x1c0000) >> 18
}
func (o *LP_UART_Type) SetSLEEP_CONF2_WK_CHAR_MASK(value uint32) {
	volatile.StoreUint32(&o.SLEEP_CONF2.Reg, volatile.LoadUint32(&o.SLEEP_CONF2.Reg)&^(0x3e00000)|value<<21)
}
func (o *LP_UART_Type) GetSLEEP_CONF2_WK_CHAR_MASK() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_CONF2.Reg) & 0x3e00000) >> 21
}
func (o *LP_UART_Type) SetSLEEP_CONF2_WK_MODE_SEL(value uint32) {
	volatile.StoreUint32(&o.SLEEP_CONF2.Reg, volatile.LoadUint32(&o.SLEEP_CONF2.Reg)&^(0xc000000)|value<<26)
}
func (o *LP_UART_Type) GetSLEEP_CONF2_WK_MODE_SEL() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_CONF2.Reg) & 0xc000000) >> 26
}

// LP_UART.SWFC_CONF0_SYNC: Software flow-control character configuration
func (o *LP_UART_Type) SetSWFC_CONF0_SYNC_XON_CHAR(value uint32) {
	volatile.StoreUint32(&o.SWFC_CONF0_SYNC.Reg, volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg)&^(0xff)|value)
}
func (o *LP_UART_Type) GetSWFC_CONF0_SYNC_XON_CHAR() uint32 {
	return volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg) & 0xff
}
func (o *LP_UART_Type) SetSWFC_CONF0_SYNC_XOFF_CHAR(value uint32) {
	volatile.StoreUint32(&o.SWFC_CONF0_SYNC.Reg, volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg)&^(0xff00)|value<<8)
}
func (o *LP_UART_Type) GetSWFC_CONF0_SYNC_XOFF_CHAR() uint32 {
	return (volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg) & 0xff00) >> 8
}
func (o *LP_UART_Type) SetSWFC_CONF0_SYNC_XON_XOFF_STILL_SEND(value uint32) {
	volatile.StoreUint32(&o.SWFC_CONF0_SYNC.Reg, volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg)&^(0x10000)|value<<16)
}
func (o *LP_UART_Type) GetSWFC_CONF0_SYNC_XON_XOFF_STILL_SEND() uint32 {
	return (volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg) & 0x10000) >> 16
}
func (o *LP_UART_Type) SetSWFC_CONF0_SYNC_SW_FLOW_CON_EN(value uint32) {
	volatile.StoreUint32(&o.SWFC_CONF0_SYNC.Reg, volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg)&^(0x20000)|value<<17)
}
func (o *LP_UART_Type) GetSWFC_CONF0_SYNC_SW_FLOW_CON_EN() uint32 {
	return (volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg) & 0x20000) >> 17
}
func (o *LP_UART_Type) SetSWFC_CONF0_SYNC_XONOFF_DEL(value uint32) {
	volatile.StoreUint32(&o.SWFC_CONF0_SYNC.Reg, volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg)&^(0x40000)|value<<18)
}
func (o *LP_UART_Type) GetSWFC_CONF0_SYNC_XONOFF_DEL() uint32 {
	return (volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg) & 0x40000) >> 18
}
func (o *LP_UART_Type) SetSWFC_CONF0_SYNC_FORCE_XON(value uint32) {
	volatile.StoreUint32(&o.SWFC_CONF0_SYNC.Reg, volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg)&^(0x80000)|value<<19)
}
func (o *LP_UART_Type) GetSWFC_CONF0_SYNC_FORCE_XON() uint32 {
	return (volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg) & 0x80000) >> 19
}
func (o *LP_UART_Type) SetSWFC_CONF0_SYNC_FORCE_XOFF(value uint32) {
	volatile.StoreUint32(&o.SWFC_CONF0_SYNC.Reg, volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg)&^(0x100000)|value<<20)
}
func (o *LP_UART_Type) GetSWFC_CONF0_SYNC_FORCE_XOFF() uint32 {
	return (volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg) & 0x100000) >> 20
}
func (o *LP_UART_Type) SetSWFC_CONF0_SYNC_SEND_XON(value uint32) {
	volatile.StoreUint32(&o.SWFC_CONF0_SYNC.Reg, volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg)&^(0x200000)|value<<21)
}
func (o *LP_UART_Type) GetSWFC_CONF0_SYNC_SEND_XON() uint32 {
	return (volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg) & 0x200000) >> 21
}
func (o *LP_UART_Type) SetSWFC_CONF0_SYNC_SEND_XOFF(value uint32) {
	volatile.StoreUint32(&o.SWFC_CONF0_SYNC.Reg, volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg)&^(0x400000)|value<<22)
}
func (o *LP_UART_Type) GetSWFC_CONF0_SYNC_SEND_XOFF() uint32 {
	return (volatile.LoadUint32(&o.SWFC_CONF0_SYNC.Reg) & 0x400000) >> 22
}

// LP_UART.SWFC_CONF1: Software flow-control character configuration
func (o *LP_UART_Type) SetSWFC_CONF1_XON_THRESHOLD(value uint32) {
	volatile.StoreUint32(&o.SWFC_CONF1.Reg, volatile.LoadUint32(&o.SWFC_CONF1.Reg)&^(0xf8)|value<<3)
}
func (o *LP_UART_Type) GetSWFC_CONF1_XON_THRESHOLD() uint32 {
	return (volatile.LoadUint32(&o.SWFC_CONF1.Reg) & 0xf8) >> 3
}
func (o *LP_UART_Type) SetSWFC_CONF1_XOFF_THRESHOLD(value uint32) {
	volatile.StoreUint32(&o.SWFC_CONF1.Reg, volatile.LoadUint32(&o.SWFC_CONF1.Reg)&^(0xf800)|value<<11)
}
func (o *LP_UART_Type) GetSWFC_CONF1_XOFF_THRESHOLD() uint32 {
	return (volatile.LoadUint32(&o.SWFC_CONF1.Reg) & 0xf800) >> 11
}

// LP_UART.TXBRK_CONF_SYNC: Tx Break character configuration
func (o *LP_UART_Type) SetTXBRK_CONF_SYNC_TX_BRK_NUM(value uint32) {
	volatile.StoreUint32(&o.TXBRK_CONF_SYNC.Reg, volatile.LoadUint32(&o.TXBRK_CONF_SYNC.Reg)&^(0xff)|value)
}
func (o *LP_UART_Type) GetTXBRK_CONF_SYNC_TX_BRK_NUM() uint32 {
	return volatile.LoadUint32(&o.TXBRK_CONF_SYNC.Reg) & 0xff
}

// LP_UART.IDLE_CONF_SYNC: Frame-end idle configuration
func (o *LP_UART_Type) SetIDLE_CONF_SYNC_RX_IDLE_THRHD(value uint32) {
	volatile.StoreUint32(&o.IDLE_CONF_SYNC.Reg, volatile.LoadUint32(&o.IDLE_CONF_SYNC.Reg)&^(0x3ff)|value)
}
func (o *LP_UART_Type) GetIDLE_CONF_SYNC_RX_IDLE_THRHD() uint32 {
	return volatile.LoadUint32(&o.IDLE_CONF_SYNC.Reg) & 0x3ff
}
func (o *LP_UART_Type) SetIDLE_CONF_SYNC_TX_IDLE_NUM(value uint32) {
	volatile.StoreUint32(&o.IDLE_CONF_SYNC.Reg, volatile.LoadUint32(&o.IDLE_CONF_SYNC.Reg)&^(0xffc00)|value<<10)
}
func (o *LP_UART_Type) GetIDLE_CONF_SYNC_TX_IDLE_NUM() uint32 {
	return (volatile.LoadUint32(&o.IDLE_CONF_SYNC.Reg) & 0xffc00) >> 10
}

// LP_UART.RS485_CONF_SYNC: RS485 mode configuration
func (o *LP_UART_Type) SetRS485_CONF_SYNC_DL0_EN(value uint32) {
	volatile.StoreUint32(&o.RS485_CONF_SYNC.Reg, volatile.LoadUint32(&o.RS485_CONF_SYNC.Reg)&^(0x2)|value<<1)
}
func (o *LP_UART_Type) GetRS485_CONF_SYNC_DL0_EN() uint32 {
	return (volatile.LoadUint32(&o.RS485_CONF_SYNC.Reg) & 0x2) >> 1
}
func (o *LP_UART_Type) SetRS485_CONF_SYNC_DL1_EN(value uint32) {
	volatile.StoreUint32(&o.RS485_CONF_SYNC.Reg, volatile.LoadUint32(&o.RS485_CONF_SYNC.Reg)&^(0x4)|value<<2)
}
func (o *LP_UART_Type) GetRS485_CONF_SYNC_DL1_EN() uint32 {
	return (volatile.LoadUint32(&o.RS485_CONF_SYNC.Reg) & 0x4) >> 2
}

// LP_UART.AT_CMD_PRECNT_SYNC: Pre-sequence timing configuration
func (o *LP_UART_Type) SetAT_CMD_PRECNT_SYNC_PRE_IDLE_NUM(value uint32) {
	volatile.StoreUint32(&o.AT_CMD_PRECNT_SYNC.Reg, volatile.LoadUint32(&o.AT_CMD_PRECNT_SYNC.Reg)&^(0xffff)|value)
}
func (o *LP_UART_Type) GetAT_CMD_PRECNT_SYNC_PRE_IDLE_NUM() uint32 {
	return volatile.LoadUint32(&o.AT_CMD_PRECNT_SYNC.Reg) & 0xffff
}

// LP_UART.AT_CMD_POSTCNT_SYNC: Post-sequence timing configuration
func (o *LP_UART_Type) SetAT_CMD_POSTCNT_SYNC_POST_IDLE_NUM(value uint32) {
	volatile.StoreUint32(&o.AT_CMD_POSTCNT_SYNC.Reg, volatile.LoadUint32(&o.AT_CMD_POSTCNT_SYNC.Reg)&^(0xffff)|value)
}
func (o *LP_UART_Type) GetAT_CMD_POSTCNT_SYNC_POST_IDLE_NUM() uint32 {
	return volatile.LoadUint32(&o.AT_CMD_POSTCNT_SYNC.Reg) & 0xffff
}

// LP_UART.AT_CMD_GAPTOUT_SYNC: Timeout configuration
func (o *LP_UART_Type) SetAT_CMD_GAPTOUT_SYNC_RX_GAP_TOUT(value uint32) {
	volatile.StoreUint32(&o.AT_CMD_GAPTOUT_SYNC.Reg, volatile.LoadUint32(&o.AT_CMD_GAPTOUT_SYNC.Reg)&^(0xffff)|value)
}
func (o *LP_UART_Type) GetAT_CMD_GAPTOUT_SYNC_RX_GAP_TOUT() uint32 {
	return volatile.LoadUint32(&o.AT_CMD_GAPTOUT_SYNC.Reg) & 0xffff
}

// LP_UART.AT_CMD_CHAR_SYNC: AT escape sequence detection configuration
func (o *LP_UART_Type) SetAT_CMD_CHAR_SYNC_AT_CMD_CHAR(value uint32) {
	volatile.StoreUint32(&o.AT_CMD_CHAR_SYNC.Reg, volatile.LoadUint32(&o.AT_CMD_CHAR_SYNC.Reg)&^(0xff)|value)
}
func (o *LP_UART_Type) GetAT_CMD_CHAR_SYNC_AT_CMD_CHAR() uint32 {
	return volatile.LoadUint32(&o.AT_CMD_CHAR_SYNC.Reg) & 0xff
}
func (o *LP_UART_Type) SetAT_CMD_CHAR_SYNC_CHAR_NUM(value uint32) {
	volatile.StoreUint32(&o.AT_CMD_CHAR_SYNC.Reg, volatile.LoadUint32(&o.AT_CMD_CHAR_SYNC.Reg)&^(0xff00)|value<<8)
}
func (o *LP_UART_Type) GetAT_CMD_CHAR_SYNC_CHAR_NUM() uint32 {
	return (volatile.LoadUint32(&o.AT_CMD_CHAR_SYNC.Reg) & 0xff00) >> 8
}

// LP_UART.MEM_CONF: UART memory power configuration
func (o *LP_UART_Type) SetMEM_CONF_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.MEM_CONF.Reg, volatile.LoadUint32(&o.MEM_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *LP_UART_Type) GetMEM_CONF_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.MEM_CONF.Reg) & 0x2000000) >> 25
}
func (o *LP_UART_Type) SetMEM_CONF_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.MEM_CONF.Reg, volatile.LoadUint32(&o.MEM_CONF.Reg)&^(0x4000000)|value<<26)
}
func (o *LP_UART_Type) GetMEM_CONF_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.MEM_CONF.Reg) & 0x4000000) >> 26
}

// LP_UART.TOUT_CONF_SYNC: UART threshold and allocation configuration
func (o *LP_UART_Type) SetTOUT_CONF_SYNC_RX_TOUT_EN(value uint32) {
	volatile.StoreUint32(&o.TOUT_CONF_SYNC.Reg, volatile.LoadUint32(&o.TOUT_CONF_SYNC.Reg)&^(0x1)|value)
}
func (o *LP_UART_Type) GetTOUT_CONF_SYNC_RX_TOUT_EN() uint32 {
	return volatile.LoadUint32(&o.TOUT_CONF_SYNC.Reg) & 0x1
}
func (o *LP_UART_Type) SetTOUT_CONF_SYNC_RX_TOUT_FLOW_DIS(value uint32) {
	volatile.StoreUint32(&o.TOUT_CONF_SYNC.Reg, volatile.LoadUint32(&o.TOUT_CONF_SYNC.Reg)&^(0x2)|value<<1)
}
func (o *LP_UART_Type) GetTOUT_CONF_SYNC_RX_TOUT_FLOW_DIS() uint32 {
	return (volatile.LoadUint32(&o.TOUT_CONF_SYNC.Reg) & 0x2) >> 1
}
func (o *LP_UART_Type) SetTOUT_CONF_SYNC_RX_TOUT_THRHD(value uint32) {
	volatile.StoreUint32(&o.TOUT_CONF_SYNC.Reg, volatile.LoadUint32(&o.TOUT_CONF_SYNC.Reg)&^(0xffc)|value<<2)
}
func (o *LP_UART_Type) GetTOUT_CONF_SYNC_RX_TOUT_THRHD() uint32 {
	return (volatile.LoadUint32(&o.TOUT_CONF_SYNC.Reg) & 0xffc) >> 2
}

// LP_UART.MEM_TX_STATUS: Tx-SRAM write and read offset address.
func (o *LP_UART_Type) SetMEM_TX_STATUS_TX_SRAM_WADDR(value uint32) {
	volatile.StoreUint32(&o.MEM_TX_STATUS.Reg, volatile.LoadUint32(&o.MEM_TX_STATUS.Reg)&^(0xf8)|value<<3)
}
func (o *LP_UART_Type) GetMEM_TX_STATUS_TX_SRAM_WADDR() uint32 {
	return (volatile.LoadUint32(&o.MEM_TX_STATUS.Reg) & 0xf8) >> 3
}
func (o *LP_UART_Type) SetMEM_TX_STATUS_TX_SRAM_RADDR(value uint32) {
	volatile.StoreUint32(&o.MEM_TX_STATUS.Reg, volatile.LoadUint32(&o.MEM_TX_STATUS.Reg)&^(0x1f000)|value<<12)
}
func (o *LP_UART_Type) GetMEM_TX_STATUS_TX_SRAM_RADDR() uint32 {
	return (volatile.LoadUint32(&o.MEM_TX_STATUS.Reg) & 0x1f000) >> 12
}

// LP_UART.MEM_RX_STATUS: Rx-SRAM write and read offset address.
func (o *LP_UART_Type) SetMEM_RX_STATUS_RX_SRAM_RADDR(value uint32) {
	volatile.StoreUint32(&o.MEM_RX_STATUS.Reg, volatile.LoadUint32(&o.MEM_RX_STATUS.Reg)&^(0xf8)|value<<3)
}
func (o *LP_UART_Type) GetMEM_RX_STATUS_RX_SRAM_RADDR() uint32 {
	return (volatile.LoadUint32(&o.MEM_RX_STATUS.Reg) & 0xf8) >> 3
}
func (o *LP_UART_Type) SetMEM_RX_STATUS_RX_SRAM_WADDR(value uint32) {
	volatile.StoreUint32(&o.MEM_RX_STATUS.Reg, volatile.LoadUint32(&o.MEM_RX_STATUS.Reg)&^(0x1f000)|value<<12)
}
func (o *LP_UART_Type) GetMEM_RX_STATUS_RX_SRAM_WADDR() uint32 {
	return (volatile.LoadUint32(&o.MEM_RX_STATUS.Reg) & 0x1f000) >> 12
}

// LP_UART.FSM_STATUS: UART transmit and receive status.
func (o *LP_UART_Type) SetFSM_STATUS_ST_URX_OUT(value uint32) {
	volatile.StoreUint32(&o.FSM_STATUS.Reg, volatile.LoadUint32(&o.FSM_STATUS.Reg)&^(0xf)|value)
}
func (o *LP_UART_Type) GetFSM_STATUS_ST_URX_OUT() uint32 {
	return volatile.LoadUint32(&o.FSM_STATUS.Reg) & 0xf
}
func (o *LP_UART_Type) SetFSM_STATUS_ST_UTX_OUT(value uint32) {
	volatile.StoreUint32(&o.FSM_STATUS.Reg, volatile.LoadUint32(&o.FSM_STATUS.Reg)&^(0xf0)|value<<4)
}
func (o *LP_UART_Type) GetFSM_STATUS_ST_UTX_OUT() uint32 {
	return (volatile.LoadUint32(&o.FSM_STATUS.Reg) & 0xf0) >> 4
}

// LP_UART.CLK_CONF: UART core clock configuration
func (o *LP_UART_Type) SetCLK_CONF_SCLK_DIV_B(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x3f)|value)
}
func (o *LP_UART_Type) GetCLK_CONF_SCLK_DIV_B() uint32 {
	return volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x3f
}
func (o *LP_UART_Type) SetCLK_CONF_SCLK_DIV_A(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0xfc0)|value<<6)
}
func (o *LP_UART_Type) GetCLK_CONF_SCLK_DIV_A() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0xfc0) >> 6
}
func (o *LP_UART_Type) SetCLK_CONF_SCLK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0xff000)|value<<12)
}
func (o *LP_UART_Type) GetCLK_CONF_SCLK_DIV_NUM() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0xff000) >> 12
}
func (o *LP_UART_Type) SetCLK_CONF_SCLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x300000)|value<<20)
}
func (o *LP_UART_Type) GetCLK_CONF_SCLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x300000) >> 20
}
func (o *LP_UART_Type) SetCLK_CONF_SCLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *LP_UART_Type) GetCLK_CONF_SCLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x400000) >> 22
}
func (o *LP_UART_Type) SetCLK_CONF_RST_CORE(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *LP_UART_Type) GetCLK_CONF_RST_CORE() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x800000) >> 23
}
func (o *LP_UART_Type) SetCLK_CONF_TX_SCLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *LP_UART_Type) GetCLK_CONF_TX_SCLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x1000000) >> 24
}
func (o *LP_UART_Type) SetCLK_CONF_RX_SCLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *LP_UART_Type) GetCLK_CONF_RX_SCLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x2000000) >> 25
}
func (o *LP_UART_Type) SetCLK_CONF_TX_RST_CORE(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x4000000)|value<<26)
}
func (o *LP_UART_Type) GetCLK_CONF_TX_RST_CORE() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x4000000) >> 26
}
func (o *LP_UART_Type) SetCLK_CONF_RX_RST_CORE(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x8000000)|value<<27)
}
func (o *LP_UART_Type) GetCLK_CONF_RX_RST_CORE() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x8000000) >> 27
}

// LP_UART.DATE: UART Version register
func (o *LP_UART_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *LP_UART_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// LP_UART.AFIFO_STATUS: UART AFIFO Status
func (o *LP_UART_Type) SetAFIFO_STATUS_TX_AFIFO_FULL(value uint32) {
	volatile.StoreUint32(&o.AFIFO_STATUS.Reg, volatile.LoadUint32(&o.AFIFO_STATUS.Reg)&^(0x1)|value)
}
func (o *LP_UART_Type) GetAFIFO_STATUS_TX_AFIFO_FULL() uint32 {
	return volatile.LoadUint32(&o.AFIFO_STATUS.Reg) & 0x1
}
func (o *LP_UART_Type) SetAFIFO_STATUS_TX_AFIFO_EMPTY(value uint32) {
	volatile.StoreUint32(&o.AFIFO_STATUS.Reg, volatile.LoadUint32(&o.AFIFO_STATUS.Reg)&^(0x2)|value<<1)
}
func (o *LP_UART_Type) GetAFIFO_STATUS_TX_AFIFO_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.AFIFO_STATUS.Reg) & 0x2) >> 1
}
func (o *LP_UART_Type) SetAFIFO_STATUS_RX_AFIFO_FULL(value uint32) {
	volatile.StoreUint32(&o.AFIFO_STATUS.Reg, volatile.LoadUint32(&o.AFIFO_STATUS.Reg)&^(0x4)|value<<2)
}
func (o *LP_UART_Type) GetAFIFO_STATUS_RX_AFIFO_FULL() uint32 {
	return (volatile.LoadUint32(&o.AFIFO_STATUS.Reg) & 0x4) >> 2
}
func (o *LP_UART_Type) SetAFIFO_STATUS_RX_AFIFO_EMPTY(value uint32) {
	volatile.StoreUint32(&o.AFIFO_STATUS.Reg, volatile.LoadUint32(&o.AFIFO_STATUS.Reg)&^(0x8)|value<<3)
}
func (o *LP_UART_Type) GetAFIFO_STATUS_RX_AFIFO_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.AFIFO_STATUS.Reg) & 0x8) >> 3
}

// LP_UART.REG_UPDATE: UART Registers Configuration Update register
func (o *LP_UART_Type) SetREG_UPDATE(value uint32) {
	volatile.StoreUint32(&o.REG_UPDATE.Reg, volatile.LoadUint32(&o.REG_UPDATE.Reg)&^(0x1)|value)
}
func (o *LP_UART_Type) GetREG_UPDATE() uint32 {
	return volatile.LoadUint32(&o.REG_UPDATE.Reg) & 0x1
}

// LP_UART.ID: UART ID register
func (o *LP_UART_Type) SetID(value uint32) {
	volatile.StoreUint32(&o.ID.Reg, value)
}
func (o *LP_UART_Type) GetID() uint32 {
	return volatile.LoadUint32(&o.ID.Reg)
}

// Low-power Watchdog Timer
type LP_WDT_Type struct {
	CONFIG0      volatile.Register32 // 0x0
	CONFIG1      volatile.Register32 // 0x4
	CONFIG2      volatile.Register32 // 0x8
	CONFIG3      volatile.Register32 // 0xC
	CONFIG4      volatile.Register32 // 0x10
	FEED         volatile.Register32 // 0x14
	WPROTECT     volatile.Register32 // 0x18
	SWD_CONFIG   volatile.Register32 // 0x1C
	SWD_WPROTECT volatile.Register32 // 0x20
	INT_RAW      volatile.Register32 // 0x24
	INT_ST       volatile.Register32 // 0x28
	INT_ENA      volatile.Register32 // 0x2C
	INT_CLR      volatile.Register32 // 0x30
	_            [968]byte
	DATE         volatile.Register32 // 0x3FC
}

// LP_WDT.CONFIG0: need_des
func (o *LP_WDT_Type) SetCONFIG0_WDT_CHIP_RESET_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0xff)|value)
}
func (o *LP_WDT_Type) GetCONFIG0_WDT_CHIP_RESET_WIDTH() uint32 {
	return volatile.LoadUint32(&o.CONFIG0.Reg) & 0xff
}
func (o *LP_WDT_Type) SetCONFIG0_WDT_CHIP_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x100)|value<<8)
}
func (o *LP_WDT_Type) GetCONFIG0_WDT_CHIP_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x100) >> 8
}
func (o *LP_WDT_Type) SetCONFIG0_WDT_PAUSE_IN_SLP(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x200)|value<<9)
}
func (o *LP_WDT_Type) GetCONFIG0_WDT_PAUSE_IN_SLP() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x200) >> 9
}
func (o *LP_WDT_Type) SetCONFIG0_WDT_APPCPU_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x400)|value<<10)
}
func (o *LP_WDT_Type) GetCONFIG0_WDT_APPCPU_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x400) >> 10
}
func (o *LP_WDT_Type) SetCONFIG0_WDT_PROCPU_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x800)|value<<11)
}
func (o *LP_WDT_Type) GetCONFIG0_WDT_PROCPU_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x800) >> 11
}
func (o *LP_WDT_Type) SetCONFIG0_WDT_FLASHBOOT_MOD_EN(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x1000)|value<<12)
}
func (o *LP_WDT_Type) GetCONFIG0_WDT_FLASHBOOT_MOD_EN() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x1000) >> 12
}
func (o *LP_WDT_Type) SetCONFIG0_WDT_SYS_RESET_LENGTH(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0xe000)|value<<13)
}
func (o *LP_WDT_Type) GetCONFIG0_WDT_SYS_RESET_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0xe000) >> 13
}
func (o *LP_WDT_Type) SetCONFIG0_WDT_CPU_RESET_LENGTH(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x70000)|value<<16)
}
func (o *LP_WDT_Type) GetCONFIG0_WDT_CPU_RESET_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x70000) >> 16
}
func (o *LP_WDT_Type) SetCONFIG0_WDT_STG3(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x380000)|value<<19)
}
func (o *LP_WDT_Type) GetCONFIG0_WDT_STG3() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x380000) >> 19
}
func (o *LP_WDT_Type) SetCONFIG0_WDT_STG2(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x1c00000)|value<<22)
}
func (o *LP_WDT_Type) GetCONFIG0_WDT_STG2() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x1c00000) >> 22
}
func (o *LP_WDT_Type) SetCONFIG0_WDT_STG1(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0xe000000)|value<<25)
}
func (o *LP_WDT_Type) GetCONFIG0_WDT_STG1() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0xe000000) >> 25
}
func (o *LP_WDT_Type) SetCONFIG0_WDT_STG0(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x70000000)|value<<28)
}
func (o *LP_WDT_Type) GetCONFIG0_WDT_STG0() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x70000000) >> 28
}
func (o *LP_WDT_Type) SetCONFIG0_WDT_EN(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_WDT_Type) GetCONFIG0_WDT_EN() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x80000000) >> 31
}

// LP_WDT.CONFIG1: need_des
func (o *LP_WDT_Type) SetCONFIG1(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, value)
}
func (o *LP_WDT_Type) GetCONFIG1() uint32 {
	return volatile.LoadUint32(&o.CONFIG1.Reg)
}

// LP_WDT.CONFIG2: need_des
func (o *LP_WDT_Type) SetCONFIG2(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, value)
}
func (o *LP_WDT_Type) GetCONFIG2() uint32 {
	return volatile.LoadUint32(&o.CONFIG2.Reg)
}

// LP_WDT.CONFIG3: need_des
func (o *LP_WDT_Type) SetCONFIG3(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, value)
}
func (o *LP_WDT_Type) GetCONFIG3() uint32 {
	return volatile.LoadUint32(&o.CONFIG3.Reg)
}

// LP_WDT.CONFIG4: need_des
func (o *LP_WDT_Type) SetCONFIG4(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, value)
}
func (o *LP_WDT_Type) GetCONFIG4() uint32 {
	return volatile.LoadUint32(&o.CONFIG4.Reg)
}

// LP_WDT.FEED: need_des
func (o *LP_WDT_Type) SetFEED_RTC_WDT_FEED(value uint32) {
	volatile.StoreUint32(&o.FEED.Reg, volatile.LoadUint32(&o.FEED.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_WDT_Type) GetFEED_RTC_WDT_FEED() uint32 {
	return (volatile.LoadUint32(&o.FEED.Reg) & 0x80000000) >> 31
}

// LP_WDT.WPROTECT: need_des
func (o *LP_WDT_Type) SetWPROTECT(value uint32) {
	volatile.StoreUint32(&o.WPROTECT.Reg, value)
}
func (o *LP_WDT_Type) GetWPROTECT() uint32 {
	return volatile.LoadUint32(&o.WPROTECT.Reg)
}

// LP_WDT.SWD_CONFIG: need_des
func (o *LP_WDT_Type) SetSWD_CONFIG_SWD_RESET_FLAG(value uint32) {
	volatile.StoreUint32(&o.SWD_CONFIG.Reg, volatile.LoadUint32(&o.SWD_CONFIG.Reg)&^(0x1)|value)
}
func (o *LP_WDT_Type) GetSWD_CONFIG_SWD_RESET_FLAG() uint32 {
	return volatile.LoadUint32(&o.SWD_CONFIG.Reg) & 0x1
}
func (o *LP_WDT_Type) SetSWD_CONFIG_SWD_AUTO_FEED_EN(value uint32) {
	volatile.StoreUint32(&o.SWD_CONFIG.Reg, volatile.LoadUint32(&o.SWD_CONFIG.Reg)&^(0x40000)|value<<18)
}
func (o *LP_WDT_Type) GetSWD_CONFIG_SWD_AUTO_FEED_EN() uint32 {
	return (volatile.LoadUint32(&o.SWD_CONFIG.Reg) & 0x40000) >> 18
}
func (o *LP_WDT_Type) SetSWD_CONFIG_SWD_RST_FLAG_CLR(value uint32) {
	volatile.StoreUint32(&o.SWD_CONFIG.Reg, volatile.LoadUint32(&o.SWD_CONFIG.Reg)&^(0x80000)|value<<19)
}
func (o *LP_WDT_Type) GetSWD_CONFIG_SWD_RST_FLAG_CLR() uint32 {
	return (volatile.LoadUint32(&o.SWD_CONFIG.Reg) & 0x80000) >> 19
}
func (o *LP_WDT_Type) SetSWD_CONFIG_SWD_SIGNAL_WIDTH(value uint32) {
	volatile.StoreUint32(&o.SWD_CONFIG.Reg, volatile.LoadUint32(&o.SWD_CONFIG.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LP_WDT_Type) GetSWD_CONFIG_SWD_SIGNAL_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.SWD_CONFIG.Reg) & 0x3ff00000) >> 20
}
func (o *LP_WDT_Type) SetSWD_CONFIG_SWD_DISABLE(value uint32) {
	volatile.StoreUint32(&o.SWD_CONFIG.Reg, volatile.LoadUint32(&o.SWD_CONFIG.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_WDT_Type) GetSWD_CONFIG_SWD_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.SWD_CONFIG.Reg) & 0x40000000) >> 30
}
func (o *LP_WDT_Type) SetSWD_CONFIG_SWD_FEED(value uint32) {
	volatile.StoreUint32(&o.SWD_CONFIG.Reg, volatile.LoadUint32(&o.SWD_CONFIG.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_WDT_Type) GetSWD_CONFIG_SWD_FEED() uint32 {
	return (volatile.LoadUint32(&o.SWD_CONFIG.Reg) & 0x80000000) >> 31
}

// LP_WDT.SWD_WPROTECT: need_des
func (o *LP_WDT_Type) SetSWD_WPROTECT(value uint32) {
	volatile.StoreUint32(&o.SWD_WPROTECT.Reg, value)
}
func (o *LP_WDT_Type) GetSWD_WPROTECT() uint32 {
	return volatile.LoadUint32(&o.SWD_WPROTECT.Reg)
}

// LP_WDT.INT_RAW: need_des
func (o *LP_WDT_Type) SetINT_RAW_SUPER_WDT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_WDT_Type) GetINT_RAW_SUPER_WDT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40000000) >> 30
}
func (o *LP_WDT_Type) SetINT_RAW_LP_WDT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_WDT_Type) GetINT_RAW_LP_WDT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80000000) >> 31
}

// LP_WDT.INT_ST: need_des
func (o *LP_WDT_Type) SetINT_ST_SUPER_WDT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_WDT_Type) GetINT_ST_SUPER_WDT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40000000) >> 30
}
func (o *LP_WDT_Type) SetINT_ST_LP_WDT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_WDT_Type) GetINT_ST_LP_WDT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80000000) >> 31
}

// LP_WDT.INT_ENA: need_des
func (o *LP_WDT_Type) SetINT_ENA_SUPER_WDT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_WDT_Type) GetINT_ENA_SUPER_WDT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40000000) >> 30
}
func (o *LP_WDT_Type) SetINT_ENA_LP_WDT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_WDT_Type) GetINT_ENA_LP_WDT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80000000) >> 31
}

// LP_WDT.INT_CLR: need_des
func (o *LP_WDT_Type) SetINT_CLR_SUPER_WDT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40000000)|value<<30)
}
func (o *LP_WDT_Type) GetINT_CLR_SUPER_WDT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40000000) >> 30
}
func (o *LP_WDT_Type) SetINT_CLR_LP_WDT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_WDT_Type) GetINT_CLR_LP_WDT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80000000) >> 31
}

// LP_WDT.DATE: need_des
func (o *LP_WDT_Type) SetDATE_LP_WDT_DATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x7fffffff)|value)
}
func (o *LP_WDT_Type) GetDATE_LP_WDT_DATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x7fffffff
}
func (o *LP_WDT_Type) SetDATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x80000000)|value<<31)
}
func (o *LP_WDT_Type) GetDATE_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.DATE.Reg) & 0x80000000) >> 31
}

// Constants for LP_I2C: Low-power I2C (Inter-Integrated Circuit) Controller
const (
	// SCL_LOW_PERIOD: Configures the low level width of the SCL Clock
	// Position of SCL_LOW_PERIOD field.
	I2C_SCL_LOW_PERIOD_SCL_LOW_PERIOD_Pos = 0x0
	// Bit mask of SCL_LOW_PERIOD field.
	I2C_SCL_LOW_PERIOD_SCL_LOW_PERIOD_Msk = 0x1ff

	// CTR: Transmission setting
	// Position of SDA_FORCE_OUT field.
	I2C_CTR_SDA_FORCE_OUT_Pos = 0x0
	// Bit mask of SDA_FORCE_OUT field.
	I2C_CTR_SDA_FORCE_OUT_Msk = 0x1
	// Bit SDA_FORCE_OUT.
	I2C_CTR_SDA_FORCE_OUT = 0x1
	// Position of SCL_FORCE_OUT field.
	I2C_CTR_SCL_FORCE_OUT_Pos = 0x1
	// Bit mask of SCL_FORCE_OUT field.
	I2C_CTR_SCL_FORCE_OUT_Msk = 0x2
	// Bit SCL_FORCE_OUT.
	I2C_CTR_SCL_FORCE_OUT = 0x2
	// Position of SAMPLE_SCL_LEVEL field.
	I2C_CTR_SAMPLE_SCL_LEVEL_Pos = 0x2
	// Bit mask of SAMPLE_SCL_LEVEL field.
	I2C_CTR_SAMPLE_SCL_LEVEL_Msk = 0x4
	// Bit SAMPLE_SCL_LEVEL.
	I2C_CTR_SAMPLE_SCL_LEVEL = 0x4
	// Position of RX_FULL_ACK_LEVEL field.
	I2C_CTR_RX_FULL_ACK_LEVEL_Pos = 0x3
	// Bit mask of RX_FULL_ACK_LEVEL field.
	I2C_CTR_RX_FULL_ACK_LEVEL_Msk = 0x8
	// Bit RX_FULL_ACK_LEVEL.
	I2C_CTR_RX_FULL_ACK_LEVEL = 0x8
	// Position of TRANS_START field.
	I2C_CTR_TRANS_START_Pos = 0x5
	// Bit mask of TRANS_START field.
	I2C_CTR_TRANS_START_Msk = 0x20
	// Bit TRANS_START.
	I2C_CTR_TRANS_START = 0x20
	// Position of TX_LSB_FIRST field.
	I2C_CTR_TX_LSB_FIRST_Pos = 0x6
	// Bit mask of TX_LSB_FIRST field.
	I2C_CTR_TX_LSB_FIRST_Msk = 0x40
	// Bit TX_LSB_FIRST.
	I2C_CTR_TX_LSB_FIRST = 0x40
	// Position of RX_LSB_FIRST field.
	I2C_CTR_RX_LSB_FIRST_Pos = 0x7
	// Bit mask of RX_LSB_FIRST field.
	I2C_CTR_RX_LSB_FIRST_Msk = 0x80
	// Bit RX_LSB_FIRST.
	I2C_CTR_RX_LSB_FIRST = 0x80
	// Position of CLK_EN field.
	I2C_CTR_CLK_EN_Pos = 0x8
	// Bit mask of CLK_EN field.
	I2C_CTR_CLK_EN_Msk = 0x100
	// Bit CLK_EN.
	I2C_CTR_CLK_EN = 0x100
	// Position of ARBITRATION_EN field.
	I2C_CTR_ARBITRATION_EN_Pos = 0x9
	// Bit mask of ARBITRATION_EN field.
	I2C_CTR_ARBITRATION_EN_Msk = 0x200
	// Bit ARBITRATION_EN.
	I2C_CTR_ARBITRATION_EN = 0x200
	// Position of FSM_RST field.
	I2C_CTR_FSM_RST_Pos = 0xa
	// Bit mask of FSM_RST field.
	I2C_CTR_FSM_RST_Msk = 0x400
	// Bit FSM_RST.
	I2C_CTR_FSM_RST = 0x400
	// Position of CONF_UPGATE field.
	I2C_CTR_CONF_UPGATE_Pos = 0xb
	// Bit mask of CONF_UPGATE field.
	I2C_CTR_CONF_UPGATE_Msk = 0x800
	// Bit CONF_UPGATE.
	I2C_CTR_CONF_UPGATE = 0x800

	// SR: Describe I2C work status.
	// Position of RESP_REC field.
	I2C_SR_RESP_REC_Pos = 0x0
	// Bit mask of RESP_REC field.
	I2C_SR_RESP_REC_Msk = 0x1
	// Bit RESP_REC.
	I2C_SR_RESP_REC = 0x1
	// Position of ARB_LOST field.
	I2C_SR_ARB_LOST_Pos = 0x3
	// Bit mask of ARB_LOST field.
	I2C_SR_ARB_LOST_Msk = 0x8
	// Bit ARB_LOST.
	I2C_SR_ARB_LOST = 0x8
	// Position of BUS_BUSY field.
	I2C_SR_BUS_BUSY_Pos = 0x4
	// Bit mask of BUS_BUSY field.
	I2C_SR_BUS_BUSY_Msk = 0x10
	// Bit BUS_BUSY.
	I2C_SR_BUS_BUSY = 0x10
	// Position of RXFIFO_CNT field.
	I2C_SR_RXFIFO_CNT_Pos = 0x8
	// Bit mask of RXFIFO_CNT field.
	I2C_SR_RXFIFO_CNT_Msk = 0x1f00
	// Position of TXFIFO_CNT field.
	I2C_SR_TXFIFO_CNT_Pos = 0x12
	// Bit mask of TXFIFO_CNT field.
	I2C_SR_TXFIFO_CNT_Msk = 0x7c0000
	// Position of SCL_MAIN_STATE_LAST field.
	I2C_SR_SCL_MAIN_STATE_LAST_Pos = 0x18
	// Bit mask of SCL_MAIN_STATE_LAST field.
	I2C_SR_SCL_MAIN_STATE_LAST_Msk = 0x7000000
	// Position of SCL_STATE_LAST field.
	I2C_SR_SCL_STATE_LAST_Pos = 0x1c
	// Bit mask of SCL_STATE_LAST field.
	I2C_SR_SCL_STATE_LAST_Msk = 0x70000000

	// TO: Setting time out control for receiving data.
	// Position of TIME_OUT_VALUE field.
	I2C_TO_TIME_OUT_VALUE_Pos = 0x0
	// Bit mask of TIME_OUT_VALUE field.
	I2C_TO_TIME_OUT_VALUE_Msk = 0x1f
	// Position of TIME_OUT_EN field.
	I2C_TO_TIME_OUT_EN_Pos = 0x5
	// Bit mask of TIME_OUT_EN field.
	I2C_TO_TIME_OUT_EN_Msk = 0x20
	// Bit TIME_OUT_EN.
	I2C_TO_TIME_OUT_EN = 0x20

	// FIFO_ST: FIFO status register.
	// Position of RXFIFO_RADDR field.
	I2C_FIFO_ST_RXFIFO_RADDR_Pos = 0x0
	// Bit mask of RXFIFO_RADDR field.
	I2C_FIFO_ST_RXFIFO_RADDR_Msk = 0xf
	// Position of RXFIFO_WADDR field.
	I2C_FIFO_ST_RXFIFO_WADDR_Pos = 0x5
	// Bit mask of RXFIFO_WADDR field.
	I2C_FIFO_ST_RXFIFO_WADDR_Msk = 0x1e0
	// Position of TXFIFO_RADDR field.
	I2C_FIFO_ST_TXFIFO_RADDR_Pos = 0xa
	// Bit mask of TXFIFO_RADDR field.
	I2C_FIFO_ST_TXFIFO_RADDR_Msk = 0x3c00
	// Position of TXFIFO_WADDR field.
	I2C_FIFO_ST_TXFIFO_WADDR_Pos = 0xf
	// Bit mask of TXFIFO_WADDR field.
	I2C_FIFO_ST_TXFIFO_WADDR_Msk = 0x78000

	// FIFO_CONF: FIFO configuration register.
	// Position of RXFIFO_WM_THRHD field.
	I2C_FIFO_CONF_RXFIFO_WM_THRHD_Pos = 0x0
	// Bit mask of RXFIFO_WM_THRHD field.
	I2C_FIFO_CONF_RXFIFO_WM_THRHD_Msk = 0xf
	// Position of TXFIFO_WM_THRHD field.
	I2C_FIFO_CONF_TXFIFO_WM_THRHD_Pos = 0x5
	// Bit mask of TXFIFO_WM_THRHD field.
	I2C_FIFO_CONF_TXFIFO_WM_THRHD_Msk = 0x1e0
	// Position of NONFIFO_EN field.
	I2C_FIFO_CONF_NONFIFO_EN_Pos = 0xa
	// Bit mask of NONFIFO_EN field.
	I2C_FIFO_CONF_NONFIFO_EN_Msk = 0x400
	// Bit NONFIFO_EN.
	I2C_FIFO_CONF_NONFIFO_EN = 0x400
	// Position of RX_FIFO_RST field.
	I2C_FIFO_CONF_RX_FIFO_RST_Pos = 0xc
	// Bit mask of RX_FIFO_RST field.
	I2C_FIFO_CONF_RX_FIFO_RST_Msk = 0x1000
	// Bit RX_FIFO_RST.
	I2C_FIFO_CONF_RX_FIFO_RST = 0x1000
	// Position of TX_FIFO_RST field.
	I2C_FIFO_CONF_TX_FIFO_RST_Pos = 0xd
	// Bit mask of TX_FIFO_RST field.
	I2C_FIFO_CONF_TX_FIFO_RST_Msk = 0x2000
	// Bit TX_FIFO_RST.
	I2C_FIFO_CONF_TX_FIFO_RST = 0x2000
	// Position of FIFO_PRT_EN field.
	I2C_FIFO_CONF_FIFO_PRT_EN_Pos = 0xe
	// Bit mask of FIFO_PRT_EN field.
	I2C_FIFO_CONF_FIFO_PRT_EN_Msk = 0x4000
	// Bit FIFO_PRT_EN.
	I2C_FIFO_CONF_FIFO_PRT_EN = 0x4000

	// DATA: Rx FIFO read data.
	// Position of FIFO_RDATA field.
	I2C_DATA_FIFO_RDATA_Pos = 0x0
	// Bit mask of FIFO_RDATA field.
	I2C_DATA_FIFO_RDATA_Msk = 0xff

	// INT_RAW: Raw interrupt status
	// Position of RXFIFO_WM_INT_RAW field.
	I2C_INT_RAW_RXFIFO_WM_INT_RAW_Pos = 0x0
	// Bit mask of RXFIFO_WM_INT_RAW field.
	I2C_INT_RAW_RXFIFO_WM_INT_RAW_Msk = 0x1
	// Bit RXFIFO_WM_INT_RAW.
	I2C_INT_RAW_RXFIFO_WM_INT_RAW = 0x1
	// Position of TXFIFO_WM_INT_RAW field.
	I2C_INT_RAW_TXFIFO_WM_INT_RAW_Pos = 0x1
	// Bit mask of TXFIFO_WM_INT_RAW field.
	I2C_INT_RAW_TXFIFO_WM_INT_RAW_Msk = 0x2
	// Bit TXFIFO_WM_INT_RAW.
	I2C_INT_RAW_TXFIFO_WM_INT_RAW = 0x2
	// Position of RXFIFO_OVF_INT_RAW field.
	I2C_INT_RAW_RXFIFO_OVF_INT_RAW_Pos = 0x2
	// Bit mask of RXFIFO_OVF_INT_RAW field.
	I2C_INT_RAW_RXFIFO_OVF_INT_RAW_Msk = 0x4
	// Bit RXFIFO_OVF_INT_RAW.
	I2C_INT_RAW_RXFIFO_OVF_INT_RAW = 0x4
	// Position of END_DETECT_INT_RAW field.
	I2C_INT_RAW_END_DETECT_INT_RAW_Pos = 0x3
	// Bit mask of END_DETECT_INT_RAW field.
	I2C_INT_RAW_END_DETECT_INT_RAW_Msk = 0x8
	// Bit END_DETECT_INT_RAW.
	I2C_INT_RAW_END_DETECT_INT_RAW = 0x8
	// Position of BYTE_TRANS_DONE_INT_RAW field.
	I2C_INT_RAW_BYTE_TRANS_DONE_INT_RAW_Pos = 0x4
	// Bit mask of BYTE_TRANS_DONE_INT_RAW field.
	I2C_INT_RAW_BYTE_TRANS_DONE_INT_RAW_Msk = 0x10
	// Bit BYTE_TRANS_DONE_INT_RAW.
	I2C_INT_RAW_BYTE_TRANS_DONE_INT_RAW = 0x10
	// Position of ARBITRATION_LOST_INT_RAW field.
	I2C_INT_RAW_ARBITRATION_LOST_INT_RAW_Pos = 0x5
	// Bit mask of ARBITRATION_LOST_INT_RAW field.
	I2C_INT_RAW_ARBITRATION_LOST_INT_RAW_Msk = 0x20
	// Bit ARBITRATION_LOST_INT_RAW.
	I2C_INT_RAW_ARBITRATION_LOST_INT_RAW = 0x20
	// Position of MST_TXFIFO_UDF_INT_RAW field.
	I2C_INT_RAW_MST_TXFIFO_UDF_INT_RAW_Pos = 0x6
	// Bit mask of MST_TXFIFO_UDF_INT_RAW field.
	I2C_INT_RAW_MST_TXFIFO_UDF_INT_RAW_Msk = 0x40
	// Bit MST_TXFIFO_UDF_INT_RAW.
	I2C_INT_RAW_MST_TXFIFO_UDF_INT_RAW = 0x40
	// Position of TRANS_COMPLETE_INT_RAW field.
	I2C_INT_RAW_TRANS_COMPLETE_INT_RAW_Pos = 0x7
	// Bit mask of TRANS_COMPLETE_INT_RAW field.
	I2C_INT_RAW_TRANS_COMPLETE_INT_RAW_Msk = 0x80
	// Bit TRANS_COMPLETE_INT_RAW.
	I2C_INT_RAW_TRANS_COMPLETE_INT_RAW = 0x80
	// Position of TIME_OUT_INT_RAW field.
	I2C_INT_RAW_TIME_OUT_INT_RAW_Pos = 0x8
	// Bit mask of TIME_OUT_INT_RAW field.
	I2C_INT_RAW_TIME_OUT_INT_RAW_Msk = 0x100
	// Bit TIME_OUT_INT_RAW.
	I2C_INT_RAW_TIME_OUT_INT_RAW = 0x100
	// Position of TRANS_START_INT_RAW field.
	I2C_INT_RAW_TRANS_START_INT_RAW_Pos = 0x9
	// Bit mask of TRANS_START_INT_RAW field.
	I2C_INT_RAW_TRANS_START_INT_RAW_Msk = 0x200
	// Bit TRANS_START_INT_RAW.
	I2C_INT_RAW_TRANS_START_INT_RAW = 0x200
	// Position of NACK_INT_RAW field.
	I2C_INT_RAW_NACK_INT_RAW_Pos = 0xa
	// Bit mask of NACK_INT_RAW field.
	I2C_INT_RAW_NACK_INT_RAW_Msk = 0x400
	// Bit NACK_INT_RAW.
	I2C_INT_RAW_NACK_INT_RAW = 0x400
	// Position of TXFIFO_OVF_INT_RAW field.
	I2C_INT_RAW_TXFIFO_OVF_INT_RAW_Pos = 0xb
	// Bit mask of TXFIFO_OVF_INT_RAW field.
	I2C_INT_RAW_TXFIFO_OVF_INT_RAW_Msk = 0x800
	// Bit TXFIFO_OVF_INT_RAW.
	I2C_INT_RAW_TXFIFO_OVF_INT_RAW = 0x800
	// Position of RXFIFO_UDF_INT_RAW field.
	I2C_INT_RAW_RXFIFO_UDF_INT_RAW_Pos = 0xc
	// Bit mask of RXFIFO_UDF_INT_RAW field.
	I2C_INT_RAW_RXFIFO_UDF_INT_RAW_Msk = 0x1000
	// Bit RXFIFO_UDF_INT_RAW.
	I2C_INT_RAW_RXFIFO_UDF_INT_RAW = 0x1000
	// Position of SCL_ST_TO_INT_RAW field.
	I2C_INT_RAW_SCL_ST_TO_INT_RAW_Pos = 0xd
	// Bit mask of SCL_ST_TO_INT_RAW field.
	I2C_INT_RAW_SCL_ST_TO_INT_RAW_Msk = 0x2000
	// Bit SCL_ST_TO_INT_RAW.
	I2C_INT_RAW_SCL_ST_TO_INT_RAW = 0x2000
	// Position of SCL_MAIN_ST_TO_INT_RAW field.
	I2C_INT_RAW_SCL_MAIN_ST_TO_INT_RAW_Pos = 0xe
	// Bit mask of SCL_MAIN_ST_TO_INT_RAW field.
	I2C_INT_RAW_SCL_MAIN_ST_TO_INT_RAW_Msk = 0x4000
	// Bit SCL_MAIN_ST_TO_INT_RAW.
	I2C_INT_RAW_SCL_MAIN_ST_TO_INT_RAW = 0x4000
	// Position of DET_START_INT_RAW field.
	I2C_INT_RAW_DET_START_INT_RAW_Pos = 0xf
	// Bit mask of DET_START_INT_RAW field.
	I2C_INT_RAW_DET_START_INT_RAW_Msk = 0x8000
	// Bit DET_START_INT_RAW.
	I2C_INT_RAW_DET_START_INT_RAW = 0x8000

	// INT_CLR: Interrupt clear bits
	// Position of RXFIFO_WM_INT_CLR field.
	I2C_INT_CLR_RXFIFO_WM_INT_CLR_Pos = 0x0
	// Bit mask of RXFIFO_WM_INT_CLR field.
	I2C_INT_CLR_RXFIFO_WM_INT_CLR_Msk = 0x1
	// Bit RXFIFO_WM_INT_CLR.
	I2C_INT_CLR_RXFIFO_WM_INT_CLR = 0x1
	// Position of TXFIFO_WM_INT_CLR field.
	I2C_INT_CLR_TXFIFO_WM_INT_CLR_Pos = 0x1
	// Bit mask of TXFIFO_WM_INT_CLR field.
	I2C_INT_CLR_TXFIFO_WM_INT_CLR_Msk = 0x2
	// Bit TXFIFO_WM_INT_CLR.
	I2C_INT_CLR_TXFIFO_WM_INT_CLR = 0x2
	// Position of RXFIFO_OVF_INT_CLR field.
	I2C_INT_CLR_RXFIFO_OVF_INT_CLR_Pos = 0x2
	// Bit mask of RXFIFO_OVF_INT_CLR field.
	I2C_INT_CLR_RXFIFO_OVF_INT_CLR_Msk = 0x4
	// Bit RXFIFO_OVF_INT_CLR.
	I2C_INT_CLR_RXFIFO_OVF_INT_CLR = 0x4
	// Position of END_DETECT_INT_CLR field.
	I2C_INT_CLR_END_DETECT_INT_CLR_Pos = 0x3
	// Bit mask of END_DETECT_INT_CLR field.
	I2C_INT_CLR_END_DETECT_INT_CLR_Msk = 0x8
	// Bit END_DETECT_INT_CLR.
	I2C_INT_CLR_END_DETECT_INT_CLR = 0x8
	// Position of BYTE_TRANS_DONE_INT_CLR field.
	I2C_INT_CLR_BYTE_TRANS_DONE_INT_CLR_Pos = 0x4
	// Bit mask of BYTE_TRANS_DONE_INT_CLR field.
	I2C_INT_CLR_BYTE_TRANS_DONE_INT_CLR_Msk = 0x10
	// Bit BYTE_TRANS_DONE_INT_CLR.
	I2C_INT_CLR_BYTE_TRANS_DONE_INT_CLR = 0x10
	// Position of ARBITRATION_LOST_INT_CLR field.
	I2C_INT_CLR_ARBITRATION_LOST_INT_CLR_Pos = 0x5
	// Bit mask of ARBITRATION_LOST_INT_CLR field.
	I2C_INT_CLR_ARBITRATION_LOST_INT_CLR_Msk = 0x20
	// Bit ARBITRATION_LOST_INT_CLR.
	I2C_INT_CLR_ARBITRATION_LOST_INT_CLR = 0x20
	// Position of MST_TXFIFO_UDF_INT_CLR field.
	I2C_INT_CLR_MST_TXFIFO_UDF_INT_CLR_Pos = 0x6
	// Bit mask of MST_TXFIFO_UDF_INT_CLR field.
	I2C_INT_CLR_MST_TXFIFO_UDF_INT_CLR_Msk = 0x40
	// Bit MST_TXFIFO_UDF_INT_CLR.
	I2C_INT_CLR_MST_TXFIFO_UDF_INT_CLR = 0x40
	// Position of TRANS_COMPLETE_INT_CLR field.
	I2C_INT_CLR_TRANS_COMPLETE_INT_CLR_Pos = 0x7
	// Bit mask of TRANS_COMPLETE_INT_CLR field.
	I2C_INT_CLR_TRANS_COMPLETE_INT_CLR_Msk = 0x80
	// Bit TRANS_COMPLETE_INT_CLR.
	I2C_INT_CLR_TRANS_COMPLETE_INT_CLR = 0x80
	// Position of TIME_OUT_INT_CLR field.
	I2C_INT_CLR_TIME_OUT_INT_CLR_Pos = 0x8
	// Bit mask of TIME_OUT_INT_CLR field.
	I2C_INT_CLR_TIME_OUT_INT_CLR_Msk = 0x100
	// Bit TIME_OUT_INT_CLR.
	I2C_INT_CLR_TIME_OUT_INT_CLR = 0x100
	// Position of TRANS_START_INT_CLR field.
	I2C_INT_CLR_TRANS_START_INT_CLR_Pos = 0x9
	// Bit mask of TRANS_START_INT_CLR field.
	I2C_INT_CLR_TRANS_START_INT_CLR_Msk = 0x200
	// Bit TRANS_START_INT_CLR.
	I2C_INT_CLR_TRANS_START_INT_CLR = 0x200
	// Position of NACK_INT_CLR field.
	I2C_INT_CLR_NACK_INT_CLR_Pos = 0xa
	// Bit mask of NACK_INT_CLR field.
	I2C_INT_CLR_NACK_INT_CLR_Msk = 0x400
	// Bit NACK_INT_CLR.
	I2C_INT_CLR_NACK_INT_CLR = 0x400
	// Position of TXFIFO_OVF_INT_CLR field.
	I2C_INT_CLR_TXFIFO_OVF_INT_CLR_Pos = 0xb
	// Bit mask of TXFIFO_OVF_INT_CLR field.
	I2C_INT_CLR_TXFIFO_OVF_INT_CLR_Msk = 0x800
	// Bit TXFIFO_OVF_INT_CLR.
	I2C_INT_CLR_TXFIFO_OVF_INT_CLR = 0x800
	// Position of RXFIFO_UDF_INT_CLR field.
	I2C_INT_CLR_RXFIFO_UDF_INT_CLR_Pos = 0xc
	// Bit mask of RXFIFO_UDF_INT_CLR field.
	I2C_INT_CLR_RXFIFO_UDF_INT_CLR_Msk = 0x1000
	// Bit RXFIFO_UDF_INT_CLR.
	I2C_INT_CLR_RXFIFO_UDF_INT_CLR = 0x1000
	// Position of SCL_ST_TO_INT_CLR field.
	I2C_INT_CLR_SCL_ST_TO_INT_CLR_Pos = 0xd
	// Bit mask of SCL_ST_TO_INT_CLR field.
	I2C_INT_CLR_SCL_ST_TO_INT_CLR_Msk = 0x2000
	// Bit SCL_ST_TO_INT_CLR.
	I2C_INT_CLR_SCL_ST_TO_INT_CLR = 0x2000
	// Position of SCL_MAIN_ST_TO_INT_CLR field.
	I2C_INT_CLR_SCL_MAIN_ST_TO_INT_CLR_Pos = 0xe
	// Bit mask of SCL_MAIN_ST_TO_INT_CLR field.
	I2C_INT_CLR_SCL_MAIN_ST_TO_INT_CLR_Msk = 0x4000
	// Bit SCL_MAIN_ST_TO_INT_CLR.
	I2C_INT_CLR_SCL_MAIN_ST_TO_INT_CLR = 0x4000
	// Position of DET_START_INT_CLR field.
	I2C_INT_CLR_DET_START_INT_CLR_Pos = 0xf
	// Bit mask of DET_START_INT_CLR field.
	I2C_INT_CLR_DET_START_INT_CLR_Msk = 0x8000
	// Bit DET_START_INT_CLR.
	I2C_INT_CLR_DET_START_INT_CLR = 0x8000

	// INT_ENA: Interrupt enable bits
	// Position of RXFIFO_WM_INT_ENA field.
	I2C_INT_ENA_RXFIFO_WM_INT_ENA_Pos = 0x0
	// Bit mask of RXFIFO_WM_INT_ENA field.
	I2C_INT_ENA_RXFIFO_WM_INT_ENA_Msk = 0x1
	// Bit RXFIFO_WM_INT_ENA.
	I2C_INT_ENA_RXFIFO_WM_INT_ENA = 0x1
	// Position of TXFIFO_WM_INT_ENA field.
	I2C_INT_ENA_TXFIFO_WM_INT_ENA_Pos = 0x1
	// Bit mask of TXFIFO_WM_INT_ENA field.
	I2C_INT_ENA_TXFIFO_WM_INT_ENA_Msk = 0x2
	// Bit TXFIFO_WM_INT_ENA.
	I2C_INT_ENA_TXFIFO_WM_INT_ENA = 0x2
	// Position of RXFIFO_OVF_INT_ENA field.
	I2C_INT_ENA_RXFIFO_OVF_INT_ENA_Pos = 0x2
	// Bit mask of RXFIFO_OVF_INT_ENA field.
	I2C_INT_ENA_RXFIFO_OVF_INT_ENA_Msk = 0x4
	// Bit RXFIFO_OVF_INT_ENA.
	I2C_INT_ENA_RXFIFO_OVF_INT_ENA = 0x4
	// Position of END_DETECT_INT_ENA field.
	I2C_INT_ENA_END_DETECT_INT_ENA_Pos = 0x3
	// Bit mask of END_DETECT_INT_ENA field.
	I2C_INT_ENA_END_DETECT_INT_ENA_Msk = 0x8
	// Bit END_DETECT_INT_ENA.
	I2C_INT_ENA_END_DETECT_INT_ENA = 0x8
	// Position of BYTE_TRANS_DONE_INT_ENA field.
	I2C_INT_ENA_BYTE_TRANS_DONE_INT_ENA_Pos = 0x4
	// Bit mask of BYTE_TRANS_DONE_INT_ENA field.
	I2C_INT_ENA_BYTE_TRANS_DONE_INT_ENA_Msk = 0x10
	// Bit BYTE_TRANS_DONE_INT_ENA.
	I2C_INT_ENA_BYTE_TRANS_DONE_INT_ENA = 0x10
	// Position of ARBITRATION_LOST_INT_ENA field.
	I2C_INT_ENA_ARBITRATION_LOST_INT_ENA_Pos = 0x5
	// Bit mask of ARBITRATION_LOST_INT_ENA field.
	I2C_INT_ENA_ARBITRATION_LOST_INT_ENA_Msk = 0x20
	// Bit ARBITRATION_LOST_INT_ENA.
	I2C_INT_ENA_ARBITRATION_LOST_INT_ENA = 0x20
	// Position of MST_TXFIFO_UDF_INT_ENA field.
	I2C_INT_ENA_MST_TXFIFO_UDF_INT_ENA_Pos = 0x6
	// Bit mask of MST_TXFIFO_UDF_INT_ENA field.
	I2C_INT_ENA_MST_TXFIFO_UDF_INT_ENA_Msk = 0x40
	// Bit MST_TXFIFO_UDF_INT_ENA.
	I2C_INT_ENA_MST_TXFIFO_UDF_INT_ENA = 0x40
	// Position of TRANS_COMPLETE_INT_ENA field.
	I2C_INT_ENA_TRANS_COMPLETE_INT_ENA_Pos = 0x7
	// Bit mask of TRANS_COMPLETE_INT_ENA field.
	I2C_INT_ENA_TRANS_COMPLETE_INT_ENA_Msk = 0x80
	// Bit TRANS_COMPLETE_INT_ENA.
	I2C_INT_ENA_TRANS_COMPLETE_INT_ENA = 0x80
	// Position of TIME_OUT_INT_ENA field.
	I2C_INT_ENA_TIME_OUT_INT_ENA_Pos = 0x8
	// Bit mask of TIME_OUT_INT_ENA field.
	I2C_INT_ENA_TIME_OUT_INT_ENA_Msk = 0x100
	// Bit TIME_OUT_INT_ENA.
	I2C_INT_ENA_TIME_OUT_INT_ENA = 0x100
	// Position of TRANS_START_INT_ENA field.
	I2C_INT_ENA_TRANS_START_INT_ENA_Pos = 0x9
	// Bit mask of TRANS_START_INT_ENA field.
	I2C_INT_ENA_TRANS_START_INT_ENA_Msk = 0x200
	// Bit TRANS_START_INT_ENA.
	I2C_INT_ENA_TRANS_START_INT_ENA = 0x200
	// Position of NACK_INT_ENA field.
	I2C_INT_ENA_NACK_INT_ENA_Pos = 0xa
	// Bit mask of NACK_INT_ENA field.
	I2C_INT_ENA_NACK_INT_ENA_Msk = 0x400
	// Bit NACK_INT_ENA.
	I2C_INT_ENA_NACK_INT_ENA = 0x400
	// Position of TXFIFO_OVF_INT_ENA field.
	I2C_INT_ENA_TXFIFO_OVF_INT_ENA_Pos = 0xb
	// Bit mask of TXFIFO_OVF_INT_ENA field.
	I2C_INT_ENA_TXFIFO_OVF_INT_ENA_Msk = 0x800
	// Bit TXFIFO_OVF_INT_ENA.
	I2C_INT_ENA_TXFIFO_OVF_INT_ENA = 0x800
	// Position of RXFIFO_UDF_INT_ENA field.
	I2C_INT_ENA_RXFIFO_UDF_INT_ENA_Pos = 0xc
	// Bit mask of RXFIFO_UDF_INT_ENA field.
	I2C_INT_ENA_RXFIFO_UDF_INT_ENA_Msk = 0x1000
	// Bit RXFIFO_UDF_INT_ENA.
	I2C_INT_ENA_RXFIFO_UDF_INT_ENA = 0x1000
	// Position of SCL_ST_TO_INT_ENA field.
	I2C_INT_ENA_SCL_ST_TO_INT_ENA_Pos = 0xd
	// Bit mask of SCL_ST_TO_INT_ENA field.
	I2C_INT_ENA_SCL_ST_TO_INT_ENA_Msk = 0x2000
	// Bit SCL_ST_TO_INT_ENA.
	I2C_INT_ENA_SCL_ST_TO_INT_ENA = 0x2000
	// Position of SCL_MAIN_ST_TO_INT_ENA field.
	I2C_INT_ENA_SCL_MAIN_ST_TO_INT_ENA_Pos = 0xe
	// Bit mask of SCL_MAIN_ST_TO_INT_ENA field.
	I2C_INT_ENA_SCL_MAIN_ST_TO_INT_ENA_Msk = 0x4000
	// Bit SCL_MAIN_ST_TO_INT_ENA.
	I2C_INT_ENA_SCL_MAIN_ST_TO_INT_ENA = 0x4000
	// Position of DET_START_INT_ENA field.
	I2C_INT_ENA_DET_START_INT_ENA_Pos = 0xf
	// Bit mask of DET_START_INT_ENA field.
	I2C_INT_ENA_DET_START_INT_ENA_Msk = 0x8000
	// Bit DET_START_INT_ENA.
	I2C_INT_ENA_DET_START_INT_ENA = 0x8000

	// INT_STATUS: Status of captured I2C communication events
	// Position of RXFIFO_WM_INT_ST field.
	I2C_INT_STATUS_RXFIFO_WM_INT_ST_Pos = 0x0
	// Bit mask of RXFIFO_WM_INT_ST field.
	I2C_INT_STATUS_RXFIFO_WM_INT_ST_Msk = 0x1
	// Bit RXFIFO_WM_INT_ST.
	I2C_INT_STATUS_RXFIFO_WM_INT_ST = 0x1
	// Position of TXFIFO_WM_INT_ST field.
	I2C_INT_STATUS_TXFIFO_WM_INT_ST_Pos = 0x1
	// Bit mask of TXFIFO_WM_INT_ST field.
	I2C_INT_STATUS_TXFIFO_WM_INT_ST_Msk = 0x2
	// Bit TXFIFO_WM_INT_ST.
	I2C_INT_STATUS_TXFIFO_WM_INT_ST = 0x2
	// Position of RXFIFO_OVF_INT_ST field.
	I2C_INT_STATUS_RXFIFO_OVF_INT_ST_Pos = 0x2
	// Bit mask of RXFIFO_OVF_INT_ST field.
	I2C_INT_STATUS_RXFIFO_OVF_INT_ST_Msk = 0x4
	// Bit RXFIFO_OVF_INT_ST.
	I2C_INT_STATUS_RXFIFO_OVF_INT_ST = 0x4
	// Position of END_DETECT_INT_ST field.
	I2C_INT_STATUS_END_DETECT_INT_ST_Pos = 0x3
	// Bit mask of END_DETECT_INT_ST field.
	I2C_INT_STATUS_END_DETECT_INT_ST_Msk = 0x8
	// Bit END_DETECT_INT_ST.
	I2C_INT_STATUS_END_DETECT_INT_ST = 0x8
	// Position of BYTE_TRANS_DONE_INT_ST field.
	I2C_INT_STATUS_BYTE_TRANS_DONE_INT_ST_Pos = 0x4
	// Bit mask of BYTE_TRANS_DONE_INT_ST field.
	I2C_INT_STATUS_BYTE_TRANS_DONE_INT_ST_Msk = 0x10
	// Bit BYTE_TRANS_DONE_INT_ST.
	I2C_INT_STATUS_BYTE_TRANS_DONE_INT_ST = 0x10
	// Position of ARBITRATION_LOST_INT_ST field.
	I2C_INT_STATUS_ARBITRATION_LOST_INT_ST_Pos = 0x5
	// Bit mask of ARBITRATION_LOST_INT_ST field.
	I2C_INT_STATUS_ARBITRATION_LOST_INT_ST_Msk = 0x20
	// Bit ARBITRATION_LOST_INT_ST.
	I2C_INT_STATUS_ARBITRATION_LOST_INT_ST = 0x20
	// Position of MST_TXFIFO_UDF_INT_ST field.
	I2C_INT_STATUS_MST_TXFIFO_UDF_INT_ST_Pos = 0x6
	// Bit mask of MST_TXFIFO_UDF_INT_ST field.
	I2C_INT_STATUS_MST_TXFIFO_UDF_INT_ST_Msk = 0x40
	// Bit MST_TXFIFO_UDF_INT_ST.
	I2C_INT_STATUS_MST_TXFIFO_UDF_INT_ST = 0x40
	// Position of TRANS_COMPLETE_INT_ST field.
	I2C_INT_STATUS_TRANS_COMPLETE_INT_ST_Pos = 0x7
	// Bit mask of TRANS_COMPLETE_INT_ST field.
	I2C_INT_STATUS_TRANS_COMPLETE_INT_ST_Msk = 0x80
	// Bit TRANS_COMPLETE_INT_ST.
	I2C_INT_STATUS_TRANS_COMPLETE_INT_ST = 0x80
	// Position of TIME_OUT_INT_ST field.
	I2C_INT_STATUS_TIME_OUT_INT_ST_Pos = 0x8
	// Bit mask of TIME_OUT_INT_ST field.
	I2C_INT_STATUS_TIME_OUT_INT_ST_Msk = 0x100
	// Bit TIME_OUT_INT_ST.
	I2C_INT_STATUS_TIME_OUT_INT_ST = 0x100
	// Position of TRANS_START_INT_ST field.
	I2C_INT_STATUS_TRANS_START_INT_ST_Pos = 0x9
	// Bit mask of TRANS_START_INT_ST field.
	I2C_INT_STATUS_TRANS_START_INT_ST_Msk = 0x200
	// Bit TRANS_START_INT_ST.
	I2C_INT_STATUS_TRANS_START_INT_ST = 0x200
	// Position of NACK_INT_ST field.
	I2C_INT_STATUS_NACK_INT_ST_Pos = 0xa
	// Bit mask of NACK_INT_ST field.
	I2C_INT_STATUS_NACK_INT_ST_Msk = 0x400
	// Bit NACK_INT_ST.
	I2C_INT_STATUS_NACK_INT_ST = 0x400
	// Position of TXFIFO_OVF_INT_ST field.
	I2C_INT_STATUS_TXFIFO_OVF_INT_ST_Pos = 0xb
	// Bit mask of TXFIFO_OVF_INT_ST field.
	I2C_INT_STATUS_TXFIFO_OVF_INT_ST_Msk = 0x800
	// Bit TXFIFO_OVF_INT_ST.
	I2C_INT_STATUS_TXFIFO_OVF_INT_ST = 0x800
	// Position of RXFIFO_UDF_INT_ST field.
	I2C_INT_STATUS_RXFIFO_UDF_INT_ST_Pos = 0xc
	// Bit mask of RXFIFO_UDF_INT_ST field.
	I2C_INT_STATUS_RXFIFO_UDF_INT_ST_Msk = 0x1000
	// Bit RXFIFO_UDF_INT_ST.
	I2C_INT_STATUS_RXFIFO_UDF_INT_ST = 0x1000
	// Position of SCL_ST_TO_INT_ST field.
	I2C_INT_STATUS_SCL_ST_TO_INT_ST_Pos = 0xd
	// Bit mask of SCL_ST_TO_INT_ST field.
	I2C_INT_STATUS_SCL_ST_TO_INT_ST_Msk = 0x2000
	// Bit SCL_ST_TO_INT_ST.
	I2C_INT_STATUS_SCL_ST_TO_INT_ST = 0x2000
	// Position of SCL_MAIN_ST_TO_INT_ST field.
	I2C_INT_STATUS_SCL_MAIN_ST_TO_INT_ST_Pos = 0xe
	// Bit mask of SCL_MAIN_ST_TO_INT_ST field.
	I2C_INT_STATUS_SCL_MAIN_ST_TO_INT_ST_Msk = 0x4000
	// Bit SCL_MAIN_ST_TO_INT_ST.
	I2C_INT_STATUS_SCL_MAIN_ST_TO_INT_ST = 0x4000
	// Position of DET_START_INT_ST field.
	I2C_INT_STATUS_DET_START_INT_ST_Pos = 0xf
	// Bit mask of DET_START_INT_ST field.
	I2C_INT_STATUS_DET_START_INT_ST_Msk = 0x8000
	// Bit DET_START_INT_ST.
	I2C_INT_STATUS_DET_START_INT_ST = 0x8000

	// SDA_HOLD: Configures the hold time after a negative SCL edge.
	// Position of TIME field.
	I2C_SDA_HOLD_TIME_Pos = 0x0
	// Bit mask of TIME field.
	I2C_SDA_HOLD_TIME_Msk = 0x1ff

	// SDA_SAMPLE: Configures the sample time after a positive SCL edge.
	// Position of TIME field.
	I2C_SDA_SAMPLE_TIME_Pos = 0x0
	// Bit mask of TIME field.
	I2C_SDA_SAMPLE_TIME_Msk = 0x1ff

	// SCL_HIGH_PERIOD: Configures the high level width of SCL
	// Position of SCL_HIGH_PERIOD field.
	I2C_SCL_HIGH_PERIOD_SCL_HIGH_PERIOD_Pos = 0x0
	// Bit mask of SCL_HIGH_PERIOD field.
	I2C_SCL_HIGH_PERIOD_SCL_HIGH_PERIOD_Msk = 0x1ff
	// Position of SCL_WAIT_HIGH_PERIOD field.
	I2C_SCL_HIGH_PERIOD_SCL_WAIT_HIGH_PERIOD_Pos = 0x9
	// Bit mask of SCL_WAIT_HIGH_PERIOD field.
	I2C_SCL_HIGH_PERIOD_SCL_WAIT_HIGH_PERIOD_Msk = 0xfe00

	// SCL_START_HOLD: Configures the delay between the SDA and SCL negative edge for a start condition
	// Position of TIME field.
	I2C_SCL_START_HOLD_TIME_Pos = 0x0
	// Bit mask of TIME field.
	I2C_SCL_START_HOLD_TIME_Msk = 0x1ff

	// SCL_RSTART_SETUP: Configures the delay between the positive edge of SCL and the negative edge of SDA
	// Position of TIME field.
	I2C_SCL_RSTART_SETUP_TIME_Pos = 0x0
	// Bit mask of TIME field.
	I2C_SCL_RSTART_SETUP_TIME_Msk = 0x1ff

	// SCL_STOP_HOLD: Configures the delay after the SCL clock edge for a stop condition
	// Position of TIME field.
	I2C_SCL_STOP_HOLD_TIME_Pos = 0x0
	// Bit mask of TIME field.
	I2C_SCL_STOP_HOLD_TIME_Msk = 0x1ff

	// SCL_STOP_SETUP: Configures the delay between the SDA and SCL positive edge for a stop condition
	// Position of TIME field.
	I2C_SCL_STOP_SETUP_TIME_Pos = 0x0
	// Bit mask of TIME field.
	I2C_SCL_STOP_SETUP_TIME_Msk = 0x1ff

	// FILTER_CFG: SCL and SDA filter configuration register
	// Position of SCL_FILTER_THRES field.
	I2C_FILTER_CFG_SCL_FILTER_THRES_Pos = 0x0
	// Bit mask of SCL_FILTER_THRES field.
	I2C_FILTER_CFG_SCL_FILTER_THRES_Msk = 0xf
	// Position of SDA_FILTER_THRES field.
	I2C_FILTER_CFG_SDA_FILTER_THRES_Pos = 0x4
	// Bit mask of SDA_FILTER_THRES field.
	I2C_FILTER_CFG_SDA_FILTER_THRES_Msk = 0xf0
	// Position of SCL_FILTER_EN field.
	I2C_FILTER_CFG_SCL_FILTER_EN_Pos = 0x8
	// Bit mask of SCL_FILTER_EN field.
	I2C_FILTER_CFG_SCL_FILTER_EN_Msk = 0x100
	// Bit SCL_FILTER_EN.
	I2C_FILTER_CFG_SCL_FILTER_EN = 0x100
	// Position of SDA_FILTER_EN field.
	I2C_FILTER_CFG_SDA_FILTER_EN_Pos = 0x9
	// Bit mask of SDA_FILTER_EN field.
	I2C_FILTER_CFG_SDA_FILTER_EN_Msk = 0x200
	// Bit SDA_FILTER_EN.
	I2C_FILTER_CFG_SDA_FILTER_EN = 0x200

	// CLK_CONF: I2C CLK configuration register
	// Position of SCLK_DIV_NUM field.
	I2C_CLK_CONF_SCLK_DIV_NUM_Pos = 0x0
	// Bit mask of SCLK_DIV_NUM field.
	I2C_CLK_CONF_SCLK_DIV_NUM_Msk = 0xff
	// Position of SCLK_DIV_A field.
	I2C_CLK_CONF_SCLK_DIV_A_Pos = 0x8
	// Bit mask of SCLK_DIV_A field.
	I2C_CLK_CONF_SCLK_DIV_A_Msk = 0x3f00
	// Position of SCLK_DIV_B field.
	I2C_CLK_CONF_SCLK_DIV_B_Pos = 0xe
	// Bit mask of SCLK_DIV_B field.
	I2C_CLK_CONF_SCLK_DIV_B_Msk = 0xfc000
	// Position of SCLK_SEL field.
	I2C_CLK_CONF_SCLK_SEL_Pos = 0x14
	// Bit mask of SCLK_SEL field.
	I2C_CLK_CONF_SCLK_SEL_Msk = 0x100000
	// Bit SCLK_SEL.
	I2C_CLK_CONF_SCLK_SEL = 0x100000
	// Position of SCLK_ACTIVE field.
	I2C_CLK_CONF_SCLK_ACTIVE_Pos = 0x15
	// Bit mask of SCLK_ACTIVE field.
	I2C_CLK_CONF_SCLK_ACTIVE_Msk = 0x200000
	// Bit SCLK_ACTIVE.
	I2C_CLK_CONF_SCLK_ACTIVE = 0x200000

	// COMD0: I2C command register 0
	// Position of COMMAND0 field.
	I2C_COMD0_COMMAND0_Pos = 0x0
	// Bit mask of COMMAND0 field.
	I2C_COMD0_COMMAND0_Msk = 0x3fff
	// Position of COMMAND0_DONE field.
	I2C_COMD0_COMMAND0_DONE_Pos = 0x1f
	// Bit mask of COMMAND0_DONE field.
	I2C_COMD0_COMMAND0_DONE_Msk = 0x80000000
	// Bit COMMAND0_DONE.
	I2C_COMD0_COMMAND0_DONE = 0x80000000

	// COMD1: I2C command register 1
	// Position of COMMAND1 field.
	I2C_COMD1_COMMAND1_Pos = 0x0
	// Bit mask of COMMAND1 field.
	I2C_COMD1_COMMAND1_Msk = 0x3fff
	// Position of COMMAND1_DONE field.
	I2C_COMD1_COMMAND1_DONE_Pos = 0x1f
	// Bit mask of COMMAND1_DONE field.
	I2C_COMD1_COMMAND1_DONE_Msk = 0x80000000
	// Bit COMMAND1_DONE.
	I2C_COMD1_COMMAND1_DONE = 0x80000000

	// COMD2: I2C command register 2
	// Position of COMMAND2 field.
	I2C_COMD2_COMMAND2_Pos = 0x0
	// Bit mask of COMMAND2 field.
	I2C_COMD2_COMMAND2_Msk = 0x3fff
	// Position of COMMAND2_DONE field.
	I2C_COMD2_COMMAND2_DONE_Pos = 0x1f
	// Bit mask of COMMAND2_DONE field.
	I2C_COMD2_COMMAND2_DONE_Msk = 0x80000000
	// Bit COMMAND2_DONE.
	I2C_COMD2_COMMAND2_DONE = 0x80000000

	// COMD3: I2C command register 3
	// Position of COMMAND3 field.
	I2C_COMD3_COMMAND3_Pos = 0x0
	// Bit mask of COMMAND3 field.
	I2C_COMD3_COMMAND3_Msk = 0x3fff
	// Position of COMMAND3_DONE field.
	I2C_COMD3_COMMAND3_DONE_Pos = 0x1f
	// Bit mask of COMMAND3_DONE field.
	I2C_COMD3_COMMAND3_DONE_Msk = 0x80000000
	// Bit COMMAND3_DONE.
	I2C_COMD3_COMMAND3_DONE = 0x80000000

	// COMD4: I2C command register 4
	// Position of COMMAND4 field.
	I2C_COMD4_COMMAND4_Pos = 0x0
	// Bit mask of COMMAND4 field.
	I2C_COMD4_COMMAND4_Msk = 0x3fff
	// Position of COMMAND4_DONE field.
	I2C_COMD4_COMMAND4_DONE_Pos = 0x1f
	// Bit mask of COMMAND4_DONE field.
	I2C_COMD4_COMMAND4_DONE_Msk = 0x80000000
	// Bit COMMAND4_DONE.
	I2C_COMD4_COMMAND4_DONE = 0x80000000

	// COMD5: I2C command register 5
	// Position of COMMAND5 field.
	I2C_COMD5_COMMAND5_Pos = 0x0
	// Bit mask of COMMAND5 field.
	I2C_COMD5_COMMAND5_Msk = 0x3fff
	// Position of COMMAND5_DONE field.
	I2C_COMD5_COMMAND5_DONE_Pos = 0x1f
	// Bit mask of COMMAND5_DONE field.
	I2C_COMD5_COMMAND5_DONE_Msk = 0x80000000
	// Bit COMMAND5_DONE.
	I2C_COMD5_COMMAND5_DONE = 0x80000000

	// COMD6: I2C command register 6
	// Position of COMMAND6 field.
	I2C_COMD6_COMMAND6_Pos = 0x0
	// Bit mask of COMMAND6 field.
	I2C_COMD6_COMMAND6_Msk = 0x3fff
	// Position of COMMAND6_DONE field.
	I2C_COMD6_COMMAND6_DONE_Pos = 0x1f
	// Bit mask of COMMAND6_DONE field.
	I2C_COMD6_COMMAND6_DONE_Msk = 0x80000000
	// Bit COMMAND6_DONE.
	I2C_COMD6_COMMAND6_DONE = 0x80000000

	// COMD7: I2C command register 7
	// Position of COMMAND7 field.
	I2C_COMD7_COMMAND7_Pos = 0x0
	// Bit mask of COMMAND7 field.
	I2C_COMD7_COMMAND7_Msk = 0x3fff
	// Position of COMMAND7_DONE field.
	I2C_COMD7_COMMAND7_DONE_Pos = 0x1f
	// Bit mask of COMMAND7_DONE field.
	I2C_COMD7_COMMAND7_DONE_Msk = 0x80000000
	// Bit COMMAND7_DONE.
	I2C_COMD7_COMMAND7_DONE = 0x80000000

	// SCL_ST_TIME_OUT: SCL status time out register
	// Position of SCL_ST_TO_I2C field.
	I2C_SCL_ST_TIME_OUT_SCL_ST_TO_I2C_Pos = 0x0
	// Bit mask of SCL_ST_TO_I2C field.
	I2C_SCL_ST_TIME_OUT_SCL_ST_TO_I2C_Msk = 0x1f

	// SCL_MAIN_ST_TIME_OUT: SCL main status time out register
	// Position of SCL_MAIN_ST_TO_I2C field.
	I2C_SCL_MAIN_ST_TIME_OUT_SCL_MAIN_ST_TO_I2C_Pos = 0x0
	// Bit mask of SCL_MAIN_ST_TO_I2C field.
	I2C_SCL_MAIN_ST_TIME_OUT_SCL_MAIN_ST_TO_I2C_Msk = 0x1f

	// SCL_SP_CONF: Power configuration register
	// Position of SCL_RST_SLV_EN field.
	I2C_SCL_SP_CONF_SCL_RST_SLV_EN_Pos = 0x0
	// Bit mask of SCL_RST_SLV_EN field.
	I2C_SCL_SP_CONF_SCL_RST_SLV_EN_Msk = 0x1
	// Bit SCL_RST_SLV_EN.
	I2C_SCL_SP_CONF_SCL_RST_SLV_EN = 0x1
	// Position of SCL_RST_SLV_NUM field.
	I2C_SCL_SP_CONF_SCL_RST_SLV_NUM_Pos = 0x1
	// Bit mask of SCL_RST_SLV_NUM field.
	I2C_SCL_SP_CONF_SCL_RST_SLV_NUM_Msk = 0x3e
	// Position of SCL_PD_EN field.
	I2C_SCL_SP_CONF_SCL_PD_EN_Pos = 0x6
	// Bit mask of SCL_PD_EN field.
	I2C_SCL_SP_CONF_SCL_PD_EN_Msk = 0x40
	// Bit SCL_PD_EN.
	I2C_SCL_SP_CONF_SCL_PD_EN = 0x40
	// Position of SDA_PD_EN field.
	I2C_SCL_SP_CONF_SDA_PD_EN_Pos = 0x7
	// Bit mask of SDA_PD_EN field.
	I2C_SCL_SP_CONF_SDA_PD_EN_Msk = 0x80
	// Bit SDA_PD_EN.
	I2C_SCL_SP_CONF_SDA_PD_EN = 0x80

	// DATE: Version register
	// Position of DATE field.
	I2C_DATE_DATE_Pos = 0x0
	// Bit mask of DATE field.
	I2C_DATE_DATE_Msk = 0xffffffff

	// TXFIFO_START_ADDR: I2C TXFIFO base address register
	// Position of TXFIFO_START_ADDR field.
	I2C_TXFIFO_START_ADDR_TXFIFO_START_ADDR_Pos = 0x0
	// Bit mask of TXFIFO_START_ADDR field.
	I2C_TXFIFO_START_ADDR_TXFIFO_START_ADDR_Msk = 0xffffffff

	// RXFIFO_START_ADDR: I2C RXFIFO base address register
	// Position of RXFIFO_START_ADDR field.
	I2C_RXFIFO_START_ADDR_RXFIFO_START_ADDR_Pos = 0x0
	// Bit mask of RXFIFO_START_ADDR field.
	I2C_RXFIFO_START_ADDR_RXFIFO_START_ADDR_Msk = 0xffffffff
)

// Constants for LP_PERI: LP_PERI Peripheral
const (
	// CLK_EN: need_des
	// Position of LP_TOUCH_CK_EN field.
	LPPERI_CLK_EN_LP_TOUCH_CK_EN_Pos = 0x17
	// Bit mask of LP_TOUCH_CK_EN field.
	LPPERI_CLK_EN_LP_TOUCH_CK_EN_Msk = 0x800000
	// Bit LP_TOUCH_CK_EN.
	LPPERI_CLK_EN_LP_TOUCH_CK_EN = 0x800000
	// Position of RNG_CK_EN field.
	LPPERI_CLK_EN_RNG_CK_EN_Pos = 0x18
	// Bit mask of RNG_CK_EN field.
	LPPERI_CLK_EN_RNG_CK_EN_Msk = 0x1000000
	// Bit RNG_CK_EN.
	LPPERI_CLK_EN_RNG_CK_EN = 0x1000000
	// Position of OTP_DBG_CK_EN field.
	LPPERI_CLK_EN_OTP_DBG_CK_EN_Pos = 0x19
	// Bit mask of OTP_DBG_CK_EN field.
	LPPERI_CLK_EN_OTP_DBG_CK_EN_Msk = 0x2000000
	// Bit OTP_DBG_CK_EN.
	LPPERI_CLK_EN_OTP_DBG_CK_EN = 0x2000000
	// Position of LP_UART_CK_EN field.
	LPPERI_CLK_EN_LP_UART_CK_EN_Pos = 0x1a
	// Bit mask of LP_UART_CK_EN field.
	LPPERI_CLK_EN_LP_UART_CK_EN_Msk = 0x4000000
	// Bit LP_UART_CK_EN.
	LPPERI_CLK_EN_LP_UART_CK_EN = 0x4000000
	// Position of LP_IO_CK_EN field.
	LPPERI_CLK_EN_LP_IO_CK_EN_Pos = 0x1b
	// Bit mask of LP_IO_CK_EN field.
	LPPERI_CLK_EN_LP_IO_CK_EN_Msk = 0x8000000
	// Bit LP_IO_CK_EN.
	LPPERI_CLK_EN_LP_IO_CK_EN = 0x8000000
	// Position of LP_EXT_I2C_CK_EN field.
	LPPERI_CLK_EN_LP_EXT_I2C_CK_EN_Pos = 0x1c
	// Bit mask of LP_EXT_I2C_CK_EN field.
	LPPERI_CLK_EN_LP_EXT_I2C_CK_EN_Msk = 0x10000000
	// Bit LP_EXT_I2C_CK_EN.
	LPPERI_CLK_EN_LP_EXT_I2C_CK_EN = 0x10000000
	// Position of LP_ANA_I2C_CK_EN field.
	LPPERI_CLK_EN_LP_ANA_I2C_CK_EN_Pos = 0x1d
	// Bit mask of LP_ANA_I2C_CK_EN field.
	LPPERI_CLK_EN_LP_ANA_I2C_CK_EN_Msk = 0x20000000
	// Bit LP_ANA_I2C_CK_EN.
	LPPERI_CLK_EN_LP_ANA_I2C_CK_EN = 0x20000000
	// Position of EFUSE_CK_EN field.
	LPPERI_CLK_EN_EFUSE_CK_EN_Pos = 0x1e
	// Bit mask of EFUSE_CK_EN field.
	LPPERI_CLK_EN_EFUSE_CK_EN_Msk = 0x40000000
	// Bit EFUSE_CK_EN.
	LPPERI_CLK_EN_EFUSE_CK_EN = 0x40000000
	// Position of LP_CPU_CK_EN field.
	LPPERI_CLK_EN_LP_CPU_CK_EN_Pos = 0x1f
	// Bit mask of LP_CPU_CK_EN field.
	LPPERI_CLK_EN_LP_CPU_CK_EN_Msk = 0x80000000
	// Bit LP_CPU_CK_EN.
	LPPERI_CLK_EN_LP_CPU_CK_EN = 0x80000000

	// RESET_EN: need_des
	// Position of BUS_RESET_EN field.
	LPPERI_RESET_EN_BUS_RESET_EN_Pos = 0x17
	// Bit mask of BUS_RESET_EN field.
	LPPERI_RESET_EN_BUS_RESET_EN_Msk = 0x800000
	// Bit BUS_RESET_EN.
	LPPERI_RESET_EN_BUS_RESET_EN = 0x800000
	// Position of LP_TOUCH_RESET_EN field.
	LPPERI_RESET_EN_LP_TOUCH_RESET_EN_Pos = 0x18
	// Bit mask of LP_TOUCH_RESET_EN field.
	LPPERI_RESET_EN_LP_TOUCH_RESET_EN_Msk = 0x1000000
	// Bit LP_TOUCH_RESET_EN.
	LPPERI_RESET_EN_LP_TOUCH_RESET_EN = 0x1000000
	// Position of OTP_DBG_RESET_EN field.
	LPPERI_RESET_EN_OTP_DBG_RESET_EN_Pos = 0x19
	// Bit mask of OTP_DBG_RESET_EN field.
	LPPERI_RESET_EN_OTP_DBG_RESET_EN_Msk = 0x2000000
	// Bit OTP_DBG_RESET_EN.
	LPPERI_RESET_EN_OTP_DBG_RESET_EN = 0x2000000
	// Position of LP_UART_RESET_EN field.
	LPPERI_RESET_EN_LP_UART_RESET_EN_Pos = 0x1a
	// Bit mask of LP_UART_RESET_EN field.
	LPPERI_RESET_EN_LP_UART_RESET_EN_Msk = 0x4000000
	// Bit LP_UART_RESET_EN.
	LPPERI_RESET_EN_LP_UART_RESET_EN = 0x4000000
	// Position of LP_IO_RESET_EN field.
	LPPERI_RESET_EN_LP_IO_RESET_EN_Pos = 0x1b
	// Bit mask of LP_IO_RESET_EN field.
	LPPERI_RESET_EN_LP_IO_RESET_EN_Msk = 0x8000000
	// Bit LP_IO_RESET_EN.
	LPPERI_RESET_EN_LP_IO_RESET_EN = 0x8000000
	// Position of LP_EXT_I2C_RESET_EN field.
	LPPERI_RESET_EN_LP_EXT_I2C_RESET_EN_Pos = 0x1c
	// Bit mask of LP_EXT_I2C_RESET_EN field.
	LPPERI_RESET_EN_LP_EXT_I2C_RESET_EN_Msk = 0x10000000
	// Bit LP_EXT_I2C_RESET_EN.
	LPPERI_RESET_EN_LP_EXT_I2C_RESET_EN = 0x10000000
	// Position of LP_ANA_I2C_RESET_EN field.
	LPPERI_RESET_EN_LP_ANA_I2C_RESET_EN_Pos = 0x1d
	// Bit mask of LP_ANA_I2C_RESET_EN field.
	LPPERI_RESET_EN_LP_ANA_I2C_RESET_EN_Msk = 0x20000000
	// Bit LP_ANA_I2C_RESET_EN.
	LPPERI_RESET_EN_LP_ANA_I2C_RESET_EN = 0x20000000
	// Position of EFUSE_RESET_EN field.
	LPPERI_RESET_EN_EFUSE_RESET_EN_Pos = 0x1e
	// Bit mask of EFUSE_RESET_EN field.
	LPPERI_RESET_EN_EFUSE_RESET_EN_Msk = 0x40000000
	// Bit EFUSE_RESET_EN.
	LPPERI_RESET_EN_EFUSE_RESET_EN = 0x40000000
	// Position of LP_CPU_RESET_EN field.
	LPPERI_RESET_EN_LP_CPU_RESET_EN_Pos = 0x1f
	// Bit mask of LP_CPU_RESET_EN field.
	LPPERI_RESET_EN_LP_CPU_RESET_EN_Msk = 0x80000000
	// Bit LP_CPU_RESET_EN.
	LPPERI_RESET_EN_LP_CPU_RESET_EN = 0x80000000

	// RNG_DATA: need_des
	// Position of RND_DATA field.
	LPPERI_RNG_DATA_RND_DATA_Pos = 0x0
	// Bit mask of RND_DATA field.
	LPPERI_RNG_DATA_RND_DATA_Msk = 0xffffffff

	// CPU: need_des
	// Position of LPCORE_DBGM_UNAVALIABLE field.
	LPPERI_CPU_LPCORE_DBGM_UNAVALIABLE_Pos = 0x1f
	// Bit mask of LPCORE_DBGM_UNAVALIABLE field.
	LPPERI_CPU_LPCORE_DBGM_UNAVALIABLE_Msk = 0x80000000
	// Bit LPCORE_DBGM_UNAVALIABLE.
	LPPERI_CPU_LPCORE_DBGM_UNAVALIABLE = 0x80000000

	// BUS_TIMEOUT: need_des
	// Position of LP_PERI_TIMEOUT_THRES field.
	LPPERI_BUS_TIMEOUT_LP_PERI_TIMEOUT_THRES_Pos = 0xe
	// Bit mask of LP_PERI_TIMEOUT_THRES field.
	LPPERI_BUS_TIMEOUT_LP_PERI_TIMEOUT_THRES_Msk = 0x3fffc000
	// Position of LP_PERI_TIMEOUT_INT_CLEAR field.
	LPPERI_BUS_TIMEOUT_LP_PERI_TIMEOUT_INT_CLEAR_Pos = 0x1e
	// Bit mask of LP_PERI_TIMEOUT_INT_CLEAR field.
	LPPERI_BUS_TIMEOUT_LP_PERI_TIMEOUT_INT_CLEAR_Msk = 0x40000000
	// Bit LP_PERI_TIMEOUT_INT_CLEAR.
	LPPERI_BUS_TIMEOUT_LP_PERI_TIMEOUT_INT_CLEAR = 0x40000000
	// Position of LP_PERI_TIMEOUT_PROTECT_EN field.
	LPPERI_BUS_TIMEOUT_LP_PERI_TIMEOUT_PROTECT_EN_Pos = 0x1f
	// Bit mask of LP_PERI_TIMEOUT_PROTECT_EN field.
	LPPERI_BUS_TIMEOUT_LP_PERI_TIMEOUT_PROTECT_EN_Msk = 0x80000000
	// Bit LP_PERI_TIMEOUT_PROTECT_EN.
	LPPERI_BUS_TIMEOUT_LP_PERI_TIMEOUT_PROTECT_EN = 0x80000000

	// BUS_TIMEOUT_ADDR: need_des
	// Position of LP_PERI_TIMEOUT_ADDR field.
	LPPERI_BUS_TIMEOUT_ADDR_LP_PERI_TIMEOUT_ADDR_Pos = 0x0
	// Bit mask of LP_PERI_TIMEOUT_ADDR field.
	LPPERI_BUS_TIMEOUT_ADDR_LP_PERI_TIMEOUT_ADDR_Msk = 0xffffffff

	// BUS_TIMEOUT_UID: need_des
	// Position of LP_PERI_TIMEOUT_UID field.
	LPPERI_BUS_TIMEOUT_UID_LP_PERI_TIMEOUT_UID_Pos = 0x0
	// Bit mask of LP_PERI_TIMEOUT_UID field.
	LPPERI_BUS_TIMEOUT_UID_LP_PERI_TIMEOUT_UID_Msk = 0x7f

	// MEM_CTRL: need_des
	// Position of UART_WAKEUP_FLAG_CLR field.
	LPPERI_MEM_CTRL_UART_WAKEUP_FLAG_CLR_Pos = 0x0
	// Bit mask of UART_WAKEUP_FLAG_CLR field.
	LPPERI_MEM_CTRL_UART_WAKEUP_FLAG_CLR_Msk = 0x1
	// Bit UART_WAKEUP_FLAG_CLR.
	LPPERI_MEM_CTRL_UART_WAKEUP_FLAG_CLR = 0x1
	// Position of UART_WAKEUP_FLAG field.
	LPPERI_MEM_CTRL_UART_WAKEUP_FLAG_Pos = 0x1
	// Bit mask of UART_WAKEUP_FLAG field.
	LPPERI_MEM_CTRL_UART_WAKEUP_FLAG_Msk = 0x2
	// Bit UART_WAKEUP_FLAG.
	LPPERI_MEM_CTRL_UART_WAKEUP_FLAG = 0x2
	// Position of UART_WAKEUP_EN field.
	LPPERI_MEM_CTRL_UART_WAKEUP_EN_Pos = 0x1d
	// Bit mask of UART_WAKEUP_EN field.
	LPPERI_MEM_CTRL_UART_WAKEUP_EN_Msk = 0x20000000
	// Bit UART_WAKEUP_EN.
	LPPERI_MEM_CTRL_UART_WAKEUP_EN = 0x20000000
	// Position of UART_MEM_FORCE_PD field.
	LPPERI_MEM_CTRL_UART_MEM_FORCE_PD_Pos = 0x1e
	// Bit mask of UART_MEM_FORCE_PD field.
	LPPERI_MEM_CTRL_UART_MEM_FORCE_PD_Msk = 0x40000000
	// Bit UART_MEM_FORCE_PD.
	LPPERI_MEM_CTRL_UART_MEM_FORCE_PD = 0x40000000
	// Position of UART_MEM_FORCE_PU field.
	LPPERI_MEM_CTRL_UART_MEM_FORCE_PU_Pos = 0x1f
	// Bit mask of UART_MEM_FORCE_PU field.
	LPPERI_MEM_CTRL_UART_MEM_FORCE_PU_Msk = 0x80000000
	// Bit UART_MEM_FORCE_PU.
	LPPERI_MEM_CTRL_UART_MEM_FORCE_PU = 0x80000000

	// INTERRUPT_SOURCE: need_des
	// Position of LP_INTERRUPT_SOURCE field.
	LPPERI_INTERRUPT_SOURCE_LP_INTERRUPT_SOURCE_Pos = 0x0
	// Bit mask of LP_INTERRUPT_SOURCE field.
	LPPERI_INTERRUPT_SOURCE_LP_INTERRUPT_SOURCE_Msk = 0x3f

	// DATE: need_des
	// Position of LPPERI_DATE field.
	LPPERI_DATE_LPPERI_DATE_Pos = 0x0
	// Bit mask of LPPERI_DATE field.
	LPPERI_DATE_LPPERI_DATE_Msk = 0x7fffffff
	// Position of CLK_EN field.
	LPPERI_DATE_CLK_EN_Pos = 0x1f
	// Bit mask of CLK_EN field.
	LPPERI_DATE_CLK_EN_Msk = 0x80000000
	// Bit CLK_EN.
	LPPERI_DATE_CLK_EN = 0x80000000
)

// Constants for LP_ANA_PERI: LP_ANA_PERI Peripheral
const (
	// BOD_MODE0_CNTL: need_des
	// Position of BOD_MODE0_CLOSE_FLASH_ENA field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_CLOSE_FLASH_ENA_Pos = 0x6
	// Bit mask of BOD_MODE0_CLOSE_FLASH_ENA field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_CLOSE_FLASH_ENA_Msk = 0x40
	// Bit BOD_MODE0_CLOSE_FLASH_ENA.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_CLOSE_FLASH_ENA = 0x40
	// Position of BOD_MODE0_PD_RF_ENA field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_PD_RF_ENA_Pos = 0x7
	// Bit mask of BOD_MODE0_PD_RF_ENA field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_PD_RF_ENA_Msk = 0x80
	// Bit BOD_MODE0_PD_RF_ENA.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_PD_RF_ENA = 0x80
	// Position of BOD_MODE0_INTR_WAIT field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_INTR_WAIT_Pos = 0x8
	// Bit mask of BOD_MODE0_INTR_WAIT field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_INTR_WAIT_Msk = 0x3ff00
	// Position of BOD_MODE0_RESET_WAIT field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_RESET_WAIT_Pos = 0x12
	// Bit mask of BOD_MODE0_RESET_WAIT field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_RESET_WAIT_Msk = 0xffc0000
	// Position of BOD_MODE0_CNT_CLR field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_CNT_CLR_Pos = 0x1c
	// Bit mask of BOD_MODE0_CNT_CLR field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_CNT_CLR_Msk = 0x10000000
	// Bit BOD_MODE0_CNT_CLR.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_CNT_CLR = 0x10000000
	// Position of BOD_MODE0_INTR_ENA field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_INTR_ENA_Pos = 0x1d
	// Bit mask of BOD_MODE0_INTR_ENA field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_INTR_ENA_Msk = 0x20000000
	// Bit BOD_MODE0_INTR_ENA.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_INTR_ENA = 0x20000000
	// Position of BOD_MODE0_RESET_SEL field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_RESET_SEL_Pos = 0x1e
	// Bit mask of BOD_MODE0_RESET_SEL field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_RESET_SEL_Msk = 0x40000000
	// Bit BOD_MODE0_RESET_SEL.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_RESET_SEL = 0x40000000
	// Position of BOD_MODE0_RESET_ENA field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_RESET_ENA_Pos = 0x1f
	// Bit mask of BOD_MODE0_RESET_ENA field.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_RESET_ENA_Msk = 0x80000000
	// Bit BOD_MODE0_RESET_ENA.
	LP_ANA_BOD_MODE0_CNTL_BOD_MODE0_RESET_ENA = 0x80000000

	// BOD_MODE1_CNTL: need_des
	// Position of BOD_MODE1_RESET_ENA field.
	LP_ANA_BOD_MODE1_CNTL_BOD_MODE1_RESET_ENA_Pos = 0x1f
	// Bit mask of BOD_MODE1_RESET_ENA field.
	LP_ANA_BOD_MODE1_CNTL_BOD_MODE1_RESET_ENA_Msk = 0x80000000
	// Bit BOD_MODE1_RESET_ENA.
	LP_ANA_BOD_MODE1_CNTL_BOD_MODE1_RESET_ENA = 0x80000000

	// CK_GLITCH_CNTL: need_des
	// Position of CK_GLITCH_RESET_ENA field.
	LP_ANA_CK_GLITCH_CNTL_CK_GLITCH_RESET_ENA_Pos = 0x1f
	// Bit mask of CK_GLITCH_RESET_ENA field.
	LP_ANA_CK_GLITCH_CNTL_CK_GLITCH_RESET_ENA_Msk = 0x80000000
	// Bit CK_GLITCH_RESET_ENA.
	LP_ANA_CK_GLITCH_CNTL_CK_GLITCH_RESET_ENA = 0x80000000

	// FIB_ENABLE: need_des
	// Position of ANA_FIB_ENA field.
	LP_ANA_FIB_ENABLE_ANA_FIB_ENA_Pos = 0x0
	// Bit mask of ANA_FIB_ENA field.
	LP_ANA_FIB_ENABLE_ANA_FIB_ENA_Msk = 0xffffffff

	// INT_RAW: need_des
	// Position of BOD_MODE0_INT_RAW field.
	LP_ANA_INT_RAW_BOD_MODE0_INT_RAW_Pos = 0x1f
	// Bit mask of BOD_MODE0_INT_RAW field.
	LP_ANA_INT_RAW_BOD_MODE0_INT_RAW_Msk = 0x80000000
	// Bit BOD_MODE0_INT_RAW.
	LP_ANA_INT_RAW_BOD_MODE0_INT_RAW = 0x80000000

	// INT_ST: need_des
	// Position of BOD_MODE0_INT_ST field.
	LP_ANA_INT_ST_BOD_MODE0_INT_ST_Pos = 0x1f
	// Bit mask of BOD_MODE0_INT_ST field.
	LP_ANA_INT_ST_BOD_MODE0_INT_ST_Msk = 0x80000000
	// Bit BOD_MODE0_INT_ST.
	LP_ANA_INT_ST_BOD_MODE0_INT_ST = 0x80000000

	// INT_ENA: need_des
	// Position of BOD_MODE0_INT_ENA field.
	LP_ANA_INT_ENA_BOD_MODE0_INT_ENA_Pos = 0x1f
	// Bit mask of BOD_MODE0_INT_ENA field.
	LP_ANA_INT_ENA_BOD_MODE0_INT_ENA_Msk = 0x80000000
	// Bit BOD_MODE0_INT_ENA.
	LP_ANA_INT_ENA_BOD_MODE0_INT_ENA = 0x80000000

	// INT_CLR: need_des
	// Position of BOD_MODE0_INT_CLR field.
	LP_ANA_INT_CLR_BOD_MODE0_INT_CLR_Pos = 0x1f
	// Bit mask of BOD_MODE0_INT_CLR field.
	LP_ANA_INT_CLR_BOD_MODE0_INT_CLR_Msk = 0x80000000
	// Bit BOD_MODE0_INT_CLR.
	LP_ANA_INT_CLR_BOD_MODE0_INT_CLR = 0x80000000

	// LP_INT_RAW: need_des
	// Position of BOD_MODE0_LP_INT_RAW field.
	LP_ANA_LP_INT_RAW_BOD_MODE0_LP_INT_RAW_Pos = 0x1f
	// Bit mask of BOD_MODE0_LP_INT_RAW field.
	LP_ANA_LP_INT_RAW_BOD_MODE0_LP_INT_RAW_Msk = 0x80000000
	// Bit BOD_MODE0_LP_INT_RAW.
	LP_ANA_LP_INT_RAW_BOD_MODE0_LP_INT_RAW = 0x80000000

	// LP_INT_ST: need_des
	// Position of BOD_MODE0_LP_INT_ST field.
	LP_ANA_LP_INT_ST_BOD_MODE0_LP_INT_ST_Pos = 0x1f
	// Bit mask of BOD_MODE0_LP_INT_ST field.
	LP_ANA_LP_INT_ST_BOD_MODE0_LP_INT_ST_Msk = 0x80000000
	// Bit BOD_MODE0_LP_INT_ST.
	LP_ANA_LP_INT_ST_BOD_MODE0_LP_INT_ST = 0x80000000

	// LP_INT_ENA: need_des
	// Position of BOD_MODE0_LP_INT_ENA field.
	LP_ANA_LP_INT_ENA_BOD_MODE0_LP_INT_ENA_Pos = 0x1f
	// Bit mask of BOD_MODE0_LP_INT_ENA field.
	LP_ANA_LP_INT_ENA_BOD_MODE0_LP_INT_ENA_Msk = 0x80000000
	// Bit BOD_MODE0_LP_INT_ENA.
	LP_ANA_LP_INT_ENA_BOD_MODE0_LP_INT_ENA = 0x80000000

	// LP_INT_CLR: need_des
	// Position of BOD_MODE0_LP_INT_CLR field.
	LP_ANA_LP_INT_CLR_BOD_MODE0_LP_INT_CLR_Pos = 0x1f
	// Bit mask of BOD_MODE0_LP_INT_CLR field.
	LP_ANA_LP_INT_CLR_BOD_MODE0_LP_INT_CLR_Msk = 0x80000000
	// Bit BOD_MODE0_LP_INT_CLR.
	LP_ANA_LP_INT_CLR_BOD_MODE0_LP_INT_CLR = 0x80000000

	// DATE: need_des
	// Position of LP_ANA_DATE field.
	LP_ANA_DATE_LP_ANA_DATE_Pos = 0x0
	// Bit mask of LP_ANA_DATE field.
	LP_ANA_DATE_LP_ANA_DATE_Msk = 0x7fffffff
	// Position of CLK_EN field.
	LP_ANA_DATE_CLK_EN_Pos = 0x1f
	// Bit mask of CLK_EN field.
	LP_ANA_DATE_CLK_EN_Msk = 0x80000000
	// Bit CLK_EN.
	LP_ANA_DATE_CLK_EN = 0x80000000
)

// Constants for LP_AON: LP_AON Peripheral
const (
	// STORE0: need_des
	// Position of LP_AON_STORE0 field.
	LP_AON_STORE0_LP_AON_STORE0_Pos = 0x0
	// Bit mask of LP_AON_STORE0 field.
	LP_AON_STORE0_LP_AON_STORE0_Msk = 0xffffffff

	// STORE1: need_des
	// Position of LP_AON_STORE1 field.
	LP_AON_STORE1_LP_AON_STORE1_Pos = 0x0
	// Bit mask of LP_AON_STORE1 field.
	LP_AON_STORE1_LP_AON_STORE1_Msk = 0xffffffff

	// STORE2: need_des
	// Position of LP_AON_STORE2 field.
	LP_AON_STORE2_LP_AON_STORE2_Pos = 0x0
	// Bit mask of LP_AON_STORE2 field.
	LP_AON_STORE2_LP_AON_STORE2_Msk = 0xffffffff

	// STORE3: need_des
	// Position of LP_AON_STORE3 field.
	LP_AON_STORE3_LP_AON_STORE3_Pos = 0x0
	// Bit mask of LP_AON_STORE3 field.
	LP_AON_STORE3_LP_AON_STORE3_Msk = 0xffffffff

	// STORE4: need_des
	// Position of LP_AON_STORE4 field.
	LP_AON_STORE4_LP_AON_STORE4_Pos = 0x0
	// Bit mask of LP_AON_STORE4 field.
	LP_AON_STORE4_LP_AON_STORE4_Msk = 0xffffffff

	// STORE5: need_des
	// Position of LP_AON_STORE5 field.
	LP_AON_STORE5_LP_AON_STORE5_Pos = 0x0
	// Bit mask of LP_AON_STORE5 field.
	LP_AON_STORE5_LP_AON_STORE5_Msk = 0xffffffff

	// STORE6: need_des
	// Position of LP_AON_STORE6 field.
	LP_AON_STORE6_LP_AON_STORE6_Pos = 0x0
	// Bit mask of LP_AON_STORE6 field.
	LP_AON_STORE6_LP_AON_STORE6_Msk = 0xffffffff

	// STORE7: need_des
	// Position of LP_AON_STORE7 field.
	LP_AON_STORE7_LP_AON_STORE7_Pos = 0x0
	// Bit mask of LP_AON_STORE7 field.
	LP_AON_STORE7_LP_AON_STORE7_Msk = 0xffffffff

	// STORE8: need_des
	// Position of LP_AON_STORE8 field.
	LP_AON_STORE8_LP_AON_STORE8_Pos = 0x0
	// Bit mask of LP_AON_STORE8 field.
	LP_AON_STORE8_LP_AON_STORE8_Msk = 0xffffffff

	// STORE9: need_des
	// Position of LP_AON_STORE9 field.
	LP_AON_STORE9_LP_AON_STORE9_Pos = 0x0
	// Bit mask of LP_AON_STORE9 field.
	LP_AON_STORE9_LP_AON_STORE9_Msk = 0xffffffff

	// GPIO_MUX: need_des
	// Position of SEL field.
	LP_AON_GPIO_MUX_SEL_Pos = 0x0
	// Bit mask of SEL field.
	LP_AON_GPIO_MUX_SEL_Msk = 0xff

	// GPIO_HOLD0: need_des
	// Position of GPIO_HOLD0 field.
	LP_AON_GPIO_HOLD0_GPIO_HOLD0_Pos = 0x0
	// Bit mask of GPIO_HOLD0 field.
	LP_AON_GPIO_HOLD0_GPIO_HOLD0_Msk = 0xffffffff

	// GPIO_HOLD1: need_des
	// Position of GPIO_HOLD1 field.
	LP_AON_GPIO_HOLD1_GPIO_HOLD1_Pos = 0x0
	// Bit mask of GPIO_HOLD1 field.
	LP_AON_GPIO_HOLD1_GPIO_HOLD1_Msk = 0xffffffff

	// SYS_CFG: need_des
	// Position of FORCE_DOWNLOAD_BOOT field.
	LP_AON_SYS_CFG_FORCE_DOWNLOAD_BOOT_Pos = 0x1e
	// Bit mask of FORCE_DOWNLOAD_BOOT field.
	LP_AON_SYS_CFG_FORCE_DOWNLOAD_BOOT_Msk = 0x40000000
	// Bit FORCE_DOWNLOAD_BOOT.
	LP_AON_SYS_CFG_FORCE_DOWNLOAD_BOOT = 0x40000000
	// Position of HPSYS_SW_RESET field.
	LP_AON_SYS_CFG_HPSYS_SW_RESET_Pos = 0x1f
	// Bit mask of HPSYS_SW_RESET field.
	LP_AON_SYS_CFG_HPSYS_SW_RESET_Msk = 0x80000000
	// Bit HPSYS_SW_RESET.
	LP_AON_SYS_CFG_HPSYS_SW_RESET = 0x80000000

	// CPUCORE0_CFG: need_des
	// Position of CPU_CORE0_SW_STALL field.
	LP_AON_CPUCORE0_CFG_CPU_CORE0_SW_STALL_Pos = 0x0
	// Bit mask of CPU_CORE0_SW_STALL field.
	LP_AON_CPUCORE0_CFG_CPU_CORE0_SW_STALL_Msk = 0xff
	// Position of CPU_CORE0_SW_RESET field.
	LP_AON_CPUCORE0_CFG_CPU_CORE0_SW_RESET_Pos = 0x1c
	// Bit mask of CPU_CORE0_SW_RESET field.
	LP_AON_CPUCORE0_CFG_CPU_CORE0_SW_RESET_Msk = 0x10000000
	// Bit CPU_CORE0_SW_RESET.
	LP_AON_CPUCORE0_CFG_CPU_CORE0_SW_RESET = 0x10000000
	// Position of CPU_CORE0_OCD_HALT_ON_RESET field.
	LP_AON_CPUCORE0_CFG_CPU_CORE0_OCD_HALT_ON_RESET_Pos = 0x1d
	// Bit mask of CPU_CORE0_OCD_HALT_ON_RESET field.
	LP_AON_CPUCORE0_CFG_CPU_CORE0_OCD_HALT_ON_RESET_Msk = 0x20000000
	// Bit CPU_CORE0_OCD_HALT_ON_RESET.
	LP_AON_CPUCORE0_CFG_CPU_CORE0_OCD_HALT_ON_RESET = 0x20000000
	// Position of CPU_CORE0_STAT_VECTOR_SEL field.
	LP_AON_CPUCORE0_CFG_CPU_CORE0_STAT_VECTOR_SEL_Pos = 0x1e
	// Bit mask of CPU_CORE0_STAT_VECTOR_SEL field.
	LP_AON_CPUCORE0_CFG_CPU_CORE0_STAT_VECTOR_SEL_Msk = 0x40000000
	// Bit CPU_CORE0_STAT_VECTOR_SEL.
	LP_AON_CPUCORE0_CFG_CPU_CORE0_STAT_VECTOR_SEL = 0x40000000
	// Position of CPU_CORE0_DRESET_MASK field.
	LP_AON_CPUCORE0_CFG_CPU_CORE0_DRESET_MASK_Pos = 0x1f
	// Bit mask of CPU_CORE0_DRESET_MASK field.
	LP_AON_CPUCORE0_CFG_CPU_CORE0_DRESET_MASK_Msk = 0x80000000
	// Bit CPU_CORE0_DRESET_MASK.
	LP_AON_CPUCORE0_CFG_CPU_CORE0_DRESET_MASK = 0x80000000

	// IO_MUX: need_des
	// Position of RESET_DISABLE field.
	LP_AON_IO_MUX_RESET_DISABLE_Pos = 0x1f
	// Bit mask of RESET_DISABLE field.
	LP_AON_IO_MUX_RESET_DISABLE_Msk = 0x80000000
	// Bit RESET_DISABLE.
	LP_AON_IO_MUX_RESET_DISABLE = 0x80000000

	// EXT_WAKEUP_CNTL: need_des
	// Position of EXT_WAKEUP_STATUS field.
	LP_AON_EXT_WAKEUP_CNTL_EXT_WAKEUP_STATUS_Pos = 0x0
	// Bit mask of EXT_WAKEUP_STATUS field.
	LP_AON_EXT_WAKEUP_CNTL_EXT_WAKEUP_STATUS_Msk = 0xff
	// Position of EXT_WAKEUP_STATUS_CLR field.
	LP_AON_EXT_WAKEUP_CNTL_EXT_WAKEUP_STATUS_CLR_Pos = 0xe
	// Bit mask of EXT_WAKEUP_STATUS_CLR field.
	LP_AON_EXT_WAKEUP_CNTL_EXT_WAKEUP_STATUS_CLR_Msk = 0x4000
	// Bit EXT_WAKEUP_STATUS_CLR.
	LP_AON_EXT_WAKEUP_CNTL_EXT_WAKEUP_STATUS_CLR = 0x4000
	// Position of EXT_WAKEUP_SEL field.
	LP_AON_EXT_WAKEUP_CNTL_EXT_WAKEUP_SEL_Pos = 0xf
	// Bit mask of EXT_WAKEUP_SEL field.
	LP_AON_EXT_WAKEUP_CNTL_EXT_WAKEUP_SEL_Msk = 0x7f8000
	// Position of EXT_WAKEUP_LV field.
	LP_AON_EXT_WAKEUP_CNTL_EXT_WAKEUP_LV_Pos = 0x17
	// Bit mask of EXT_WAKEUP_LV field.
	LP_AON_EXT_WAKEUP_CNTL_EXT_WAKEUP_LV_Msk = 0x7f800000
	// Position of EXT_WAKEUP_FILTER field.
	LP_AON_EXT_WAKEUP_CNTL_EXT_WAKEUP_FILTER_Pos = 0x1f
	// Bit mask of EXT_WAKEUP_FILTER field.
	LP_AON_EXT_WAKEUP_CNTL_EXT_WAKEUP_FILTER_Msk = 0x80000000
	// Bit EXT_WAKEUP_FILTER.
	LP_AON_EXT_WAKEUP_CNTL_EXT_WAKEUP_FILTER = 0x80000000

	// USB: need_des
	// Position of RESET_DISABLE field.
	LP_AON_USB_RESET_DISABLE_Pos = 0x1f
	// Bit mask of RESET_DISABLE field.
	LP_AON_USB_RESET_DISABLE_Msk = 0x80000000
	// Bit RESET_DISABLE.
	LP_AON_USB_RESET_DISABLE = 0x80000000

	// LPBUS: need_des
	// Position of FAST_MEM_WPULSE field.
	LP_AON_LPBUS_FAST_MEM_WPULSE_Pos = 0x10
	// Bit mask of FAST_MEM_WPULSE field.
	LP_AON_LPBUS_FAST_MEM_WPULSE_Msk = 0x70000
	// Position of FAST_MEM_WA field.
	LP_AON_LPBUS_FAST_MEM_WA_Pos = 0x13
	// Bit mask of FAST_MEM_WA field.
	LP_AON_LPBUS_FAST_MEM_WA_Msk = 0x380000
	// Position of FAST_MEM_RA field.
	LP_AON_LPBUS_FAST_MEM_RA_Pos = 0x16
	// Bit mask of FAST_MEM_RA field.
	LP_AON_LPBUS_FAST_MEM_RA_Msk = 0xc00000
	// Position of FAST_MEM_MUX_FSM_IDLE field.
	LP_AON_LPBUS_FAST_MEM_MUX_FSM_IDLE_Pos = 0x1c
	// Bit mask of FAST_MEM_MUX_FSM_IDLE field.
	LP_AON_LPBUS_FAST_MEM_MUX_FSM_IDLE_Msk = 0x10000000
	// Bit FAST_MEM_MUX_FSM_IDLE.
	LP_AON_LPBUS_FAST_MEM_MUX_FSM_IDLE = 0x10000000
	// Position of FAST_MEM_MUX_SEL_STATUS field.
	LP_AON_LPBUS_FAST_MEM_MUX_SEL_STATUS_Pos = 0x1d
	// Bit mask of FAST_MEM_MUX_SEL_STATUS field.
	LP_AON_LPBUS_FAST_MEM_MUX_SEL_STATUS_Msk = 0x20000000
	// Bit FAST_MEM_MUX_SEL_STATUS.
	LP_AON_LPBUS_FAST_MEM_MUX_SEL_STATUS = 0x20000000
	// Position of FAST_MEM_MUX_SEL_UPDATE field.
	LP_AON_LPBUS_FAST_MEM_MUX_SEL_UPDATE_Pos = 0x1e
	// Bit mask of FAST_MEM_MUX_SEL_UPDATE field.
	LP_AON_LPBUS_FAST_MEM_MUX_SEL_UPDATE_Msk = 0x40000000
	// Bit FAST_MEM_MUX_SEL_UPDATE.
	LP_AON_LPBUS_FAST_MEM_MUX_SEL_UPDATE = 0x40000000
	// Position of FAST_MEM_MUX_SEL field.
	LP_AON_LPBUS_FAST_MEM_MUX_SEL_Pos = 0x1f
	// Bit mask of FAST_MEM_MUX_SEL field.
	LP_AON_LPBUS_FAST_MEM_MUX_SEL_Msk = 0x80000000
	// Bit FAST_MEM_MUX_SEL.
	LP_AON_LPBUS_FAST_MEM_MUX_SEL = 0x80000000

	// SDIO_ACTIVE: need_des
	// Position of SDIO_ACT_DNUM field.
	LP_AON_SDIO_ACTIVE_SDIO_ACT_DNUM_Pos = 0x16
	// Bit mask of SDIO_ACT_DNUM field.
	LP_AON_SDIO_ACTIVE_SDIO_ACT_DNUM_Msk = 0xffc00000

	// LPCORE: need_des
	// Position of ETM_WAKEUP_FLAG_CLR field.
	LP_AON_LPCORE_ETM_WAKEUP_FLAG_CLR_Pos = 0x0
	// Bit mask of ETM_WAKEUP_FLAG_CLR field.
	LP_AON_LPCORE_ETM_WAKEUP_FLAG_CLR_Msk = 0x1
	// Bit ETM_WAKEUP_FLAG_CLR.
	LP_AON_LPCORE_ETM_WAKEUP_FLAG_CLR = 0x1
	// Position of ETM_WAKEUP_FLAG field.
	LP_AON_LPCORE_ETM_WAKEUP_FLAG_Pos = 0x1
	// Bit mask of ETM_WAKEUP_FLAG field.
	LP_AON_LPCORE_ETM_WAKEUP_FLAG_Msk = 0x2
	// Bit ETM_WAKEUP_FLAG.
	LP_AON_LPCORE_ETM_WAKEUP_FLAG = 0x2
	// Position of DISABLE field.
	LP_AON_LPCORE_DISABLE_Pos = 0x1f
	// Bit mask of DISABLE field.
	LP_AON_LPCORE_DISABLE_Msk = 0x80000000
	// Bit DISABLE.
	LP_AON_LPCORE_DISABLE = 0x80000000

	// SAR_CCT: need_des
	// Position of SAR2_PWDET_CCT field.
	LP_AON_SAR_CCT_SAR2_PWDET_CCT_Pos = 0x1d
	// Bit mask of SAR2_PWDET_CCT field.
	LP_AON_SAR_CCT_SAR2_PWDET_CCT_Msk = 0xe0000000

	// DATE: need_des
	// Position of DATE field.
	LP_AON_DATE_DATE_Pos = 0x0
	// Bit mask of DATE field.
	LP_AON_DATE_DATE_Msk = 0x7fffffff
	// Position of CLK_EN field.
	LP_AON_DATE_CLK_EN_Pos = 0x1f
	// Bit mask of CLK_EN field.
	LP_AON_DATE_CLK_EN_Msk = 0x80000000
	// Bit CLK_EN.
	LP_AON_DATE_CLK_EN = 0x80000000
)

// Constants for LP_APM: Low-power Access Permission Management Controller
const (
	// REGION_FILTER_EN: Region filter enable register
	// Position of REGION_FILTER_EN field.
	LP_APM_REGION_FILTER_EN_REGION_FILTER_EN_Pos = 0x0
	// Bit mask of REGION_FILTER_EN field.
	LP_APM_REGION_FILTER_EN_REGION_FILTER_EN_Msk = 0xf

	// REGION0_ADDR_START: Region address register
	// Position of REGION0_ADDR_START field.
	LP_APM_REGION0_ADDR_START_REGION0_ADDR_START_Pos = 0x0
	// Bit mask of REGION0_ADDR_START field.
	LP_APM_REGION0_ADDR_START_REGION0_ADDR_START_Msk = 0xffffffff

	// REGION0_ADDR_END: Region address register
	// Position of REGION0_ADDR_END field.
	LP_APM_REGION0_ADDR_END_REGION0_ADDR_END_Pos = 0x0
	// Bit mask of REGION0_ADDR_END field.
	LP_APM_REGION0_ADDR_END_REGION0_ADDR_END_Msk = 0xffffffff

	// REGION0_PMS_ATTR: Region access authority attribute register
	// Position of REGION0_R0_PMS_X field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R0_PMS_X_Pos = 0x0
	// Bit mask of REGION0_R0_PMS_X field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R0_PMS_X_Msk = 0x1
	// Bit REGION0_R0_PMS_X.
	LP_APM_REGION0_PMS_ATTR_REGION0_R0_PMS_X = 0x1
	// Position of REGION0_R0_PMS_W field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R0_PMS_W_Pos = 0x1
	// Bit mask of REGION0_R0_PMS_W field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R0_PMS_W_Msk = 0x2
	// Bit REGION0_R0_PMS_W.
	LP_APM_REGION0_PMS_ATTR_REGION0_R0_PMS_W = 0x2
	// Position of REGION0_R0_PMS_R field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R0_PMS_R_Pos = 0x2
	// Bit mask of REGION0_R0_PMS_R field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R0_PMS_R_Msk = 0x4
	// Bit REGION0_R0_PMS_R.
	LP_APM_REGION0_PMS_ATTR_REGION0_R0_PMS_R = 0x4
	// Position of REGION0_R1_PMS_X field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R1_PMS_X_Pos = 0x4
	// Bit mask of REGION0_R1_PMS_X field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R1_PMS_X_Msk = 0x10
	// Bit REGION0_R1_PMS_X.
	LP_APM_REGION0_PMS_ATTR_REGION0_R1_PMS_X = 0x10
	// Position of REGION0_R1_PMS_W field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R1_PMS_W_Pos = 0x5
	// Bit mask of REGION0_R1_PMS_W field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R1_PMS_W_Msk = 0x20
	// Bit REGION0_R1_PMS_W.
	LP_APM_REGION0_PMS_ATTR_REGION0_R1_PMS_W = 0x20
	// Position of REGION0_R1_PMS_R field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R1_PMS_R_Pos = 0x6
	// Bit mask of REGION0_R1_PMS_R field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R1_PMS_R_Msk = 0x40
	// Bit REGION0_R1_PMS_R.
	LP_APM_REGION0_PMS_ATTR_REGION0_R1_PMS_R = 0x40
	// Position of REGION0_R2_PMS_X field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R2_PMS_X_Pos = 0x8
	// Bit mask of REGION0_R2_PMS_X field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R2_PMS_X_Msk = 0x100
	// Bit REGION0_R2_PMS_X.
	LP_APM_REGION0_PMS_ATTR_REGION0_R2_PMS_X = 0x100
	// Position of REGION0_R2_PMS_W field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R2_PMS_W_Pos = 0x9
	// Bit mask of REGION0_R2_PMS_W field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R2_PMS_W_Msk = 0x200
	// Bit REGION0_R2_PMS_W.
	LP_APM_REGION0_PMS_ATTR_REGION0_R2_PMS_W = 0x200
	// Position of REGION0_R2_PMS_R field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R2_PMS_R_Pos = 0xa
	// Bit mask of REGION0_R2_PMS_R field.
	LP_APM_REGION0_PMS_ATTR_REGION0_R2_PMS_R_Msk = 0x400
	// Bit REGION0_R2_PMS_R.
	LP_APM_REGION0_PMS_ATTR_REGION0_R2_PMS_R = 0x400

	// REGION1_ADDR_START: Region address register
	// Position of REGION1_ADDR_START field.
	LP_APM_REGION1_ADDR_START_REGION1_ADDR_START_Pos = 0x0
	// Bit mask of REGION1_ADDR_START field.
	LP_APM_REGION1_ADDR_START_REGION1_ADDR_START_Msk = 0xffffffff

	// REGION1_ADDR_END: Region address register
	// Position of REGION1_ADDR_END field.
	LP_APM_REGION1_ADDR_END_REGION1_ADDR_END_Pos = 0x0
	// Bit mask of REGION1_ADDR_END field.
	LP_APM_REGION1_ADDR_END_REGION1_ADDR_END_Msk = 0xffffffff

	// REGION1_PMS_ATTR: Region access authority attribute register
	// Position of REGION1_R0_PMS_X field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R0_PMS_X_Pos = 0x0
	// Bit mask of REGION1_R0_PMS_X field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R0_PMS_X_Msk = 0x1
	// Bit REGION1_R0_PMS_X.
	LP_APM_REGION1_PMS_ATTR_REGION1_R0_PMS_X = 0x1
	// Position of REGION1_R0_PMS_W field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R0_PMS_W_Pos = 0x1
	// Bit mask of REGION1_R0_PMS_W field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R0_PMS_W_Msk = 0x2
	// Bit REGION1_R0_PMS_W.
	LP_APM_REGION1_PMS_ATTR_REGION1_R0_PMS_W = 0x2
	// Position of REGION1_R0_PMS_R field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R0_PMS_R_Pos = 0x2
	// Bit mask of REGION1_R0_PMS_R field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R0_PMS_R_Msk = 0x4
	// Bit REGION1_R0_PMS_R.
	LP_APM_REGION1_PMS_ATTR_REGION1_R0_PMS_R = 0x4
	// Position of REGION1_R1_PMS_X field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R1_PMS_X_Pos = 0x4
	// Bit mask of REGION1_R1_PMS_X field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R1_PMS_X_Msk = 0x10
	// Bit REGION1_R1_PMS_X.
	LP_APM_REGION1_PMS_ATTR_REGION1_R1_PMS_X = 0x10
	// Position of REGION1_R1_PMS_W field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R1_PMS_W_Pos = 0x5
	// Bit mask of REGION1_R1_PMS_W field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R1_PMS_W_Msk = 0x20
	// Bit REGION1_R1_PMS_W.
	LP_APM_REGION1_PMS_ATTR_REGION1_R1_PMS_W = 0x20
	// Position of REGION1_R1_PMS_R field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R1_PMS_R_Pos = 0x6
	// Bit mask of REGION1_R1_PMS_R field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R1_PMS_R_Msk = 0x40
	// Bit REGION1_R1_PMS_R.
	LP_APM_REGION1_PMS_ATTR_REGION1_R1_PMS_R = 0x40
	// Position of REGION1_R2_PMS_X field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R2_PMS_X_Pos = 0x8
	// Bit mask of REGION1_R2_PMS_X field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R2_PMS_X_Msk = 0x100
	// Bit REGION1_R2_PMS_X.
	LP_APM_REGION1_PMS_ATTR_REGION1_R2_PMS_X = 0x100
	// Position of REGION1_R2_PMS_W field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R2_PMS_W_Pos = 0x9
	// Bit mask of REGION1_R2_PMS_W field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R2_PMS_W_Msk = 0x200
	// Bit REGION1_R2_PMS_W.
	LP_APM_REGION1_PMS_ATTR_REGION1_R2_PMS_W = 0x200
	// Position of REGION1_R2_PMS_R field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R2_PMS_R_Pos = 0xa
	// Bit mask of REGION1_R2_PMS_R field.
	LP_APM_REGION1_PMS_ATTR_REGION1_R2_PMS_R_Msk = 0x400
	// Bit REGION1_R2_PMS_R.
	LP_APM_REGION1_PMS_ATTR_REGION1_R2_PMS_R = 0x400

	// REGION2_ADDR_START: Region address register
	// Position of REGION2_ADDR_START field.
	LP_APM_REGION2_ADDR_START_REGION2_ADDR_START_Pos = 0x0
	// Bit mask of REGION2_ADDR_START field.
	LP_APM_REGION2_ADDR_START_REGION2_ADDR_START_Msk = 0xffffffff

	// REGION2_ADDR_END: Region address register
	// Position of REGION2_ADDR_END field.
	LP_APM_REGION2_ADDR_END_REGION2_ADDR_END_Pos = 0x0
	// Bit mask of REGION2_ADDR_END field.
	LP_APM_REGION2_ADDR_END_REGION2_ADDR_END_Msk = 0xffffffff

	// REGION2_PMS_ATTR: Region access authority attribute register
	// Position of REGION2_R0_PMS_X field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R0_PMS_X_Pos = 0x0
	// Bit mask of REGION2_R0_PMS_X field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R0_PMS_X_Msk = 0x1
	// Bit REGION2_R0_PMS_X.
	LP_APM_REGION2_PMS_ATTR_REGION2_R0_PMS_X = 0x1
	// Position of REGION2_R0_PMS_W field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R0_PMS_W_Pos = 0x1
	// Bit mask of REGION2_R0_PMS_W field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R0_PMS_W_Msk = 0x2
	// Bit REGION2_R0_PMS_W.
	LP_APM_REGION2_PMS_ATTR_REGION2_R0_PMS_W = 0x2
	// Position of REGION2_R0_PMS_R field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R0_PMS_R_Pos = 0x2
	// Bit mask of REGION2_R0_PMS_R field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R0_PMS_R_Msk = 0x4
	// Bit REGION2_R0_PMS_R.
	LP_APM_REGION2_PMS_ATTR_REGION2_R0_PMS_R = 0x4
	// Position of REGION2_R1_PMS_X field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R1_PMS_X_Pos = 0x4
	// Bit mask of REGION2_R1_PMS_X field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R1_PMS_X_Msk = 0x10
	// Bit REGION2_R1_PMS_X.
	LP_APM_REGION2_PMS_ATTR_REGION2_R1_PMS_X = 0x10
	// Position of REGION2_R1_PMS_W field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R1_PMS_W_Pos = 0x5
	// Bit mask of REGION2_R1_PMS_W field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R1_PMS_W_Msk = 0x20
	// Bit REGION2_R1_PMS_W.
	LP_APM_REGION2_PMS_ATTR_REGION2_R1_PMS_W = 0x20
	// Position of REGION2_R1_PMS_R field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R1_PMS_R_Pos = 0x6
	// Bit mask of REGION2_R1_PMS_R field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R1_PMS_R_Msk = 0x40
	// Bit REGION2_R1_PMS_R.
	LP_APM_REGION2_PMS_ATTR_REGION2_R1_PMS_R = 0x40
	// Position of REGION2_R2_PMS_X field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R2_PMS_X_Pos = 0x8
	// Bit mask of REGION2_R2_PMS_X field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R2_PMS_X_Msk = 0x100
	// Bit REGION2_R2_PMS_X.
	LP_APM_REGION2_PMS_ATTR_REGION2_R2_PMS_X = 0x100
	// Position of REGION2_R2_PMS_W field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R2_PMS_W_Pos = 0x9
	// Bit mask of REGION2_R2_PMS_W field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R2_PMS_W_Msk = 0x200
	// Bit REGION2_R2_PMS_W.
	LP_APM_REGION2_PMS_ATTR_REGION2_R2_PMS_W = 0x200
	// Position of REGION2_R2_PMS_R field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R2_PMS_R_Pos = 0xa
	// Bit mask of REGION2_R2_PMS_R field.
	LP_APM_REGION2_PMS_ATTR_REGION2_R2_PMS_R_Msk = 0x400
	// Bit REGION2_R2_PMS_R.
	LP_APM_REGION2_PMS_ATTR_REGION2_R2_PMS_R = 0x400

	// REGION3_ADDR_START: Region address register
	// Position of REGION3_ADDR_START field.
	LP_APM_REGION3_ADDR_START_REGION3_ADDR_START_Pos = 0x0
	// Bit mask of REGION3_ADDR_START field.
	LP_APM_REGION3_ADDR_START_REGION3_ADDR_START_Msk = 0xffffffff

	// REGION3_ADDR_END: Region address register
	// Position of REGION3_ADDR_END field.
	LP_APM_REGION3_ADDR_END_REGION3_ADDR_END_Pos = 0x0
	// Bit mask of REGION3_ADDR_END field.
	LP_APM_REGION3_ADDR_END_REGION3_ADDR_END_Msk = 0xffffffff

	// REGION3_PMS_ATTR: Region access authority attribute register
	// Position of REGION3_R0_PMS_X field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R0_PMS_X_Pos = 0x0
	// Bit mask of REGION3_R0_PMS_X field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R0_PMS_X_Msk = 0x1
	// Bit REGION3_R0_PMS_X.
	LP_APM_REGION3_PMS_ATTR_REGION3_R0_PMS_X = 0x1
	// Position of REGION3_R0_PMS_W field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R0_PMS_W_Pos = 0x1
	// Bit mask of REGION3_R0_PMS_W field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R0_PMS_W_Msk = 0x2
	// Bit REGION3_R0_PMS_W.
	LP_APM_REGION3_PMS_ATTR_REGION3_R0_PMS_W = 0x2
	// Position of REGION3_R0_PMS_R field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R0_PMS_R_Pos = 0x2
	// Bit mask of REGION3_R0_PMS_R field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R0_PMS_R_Msk = 0x4
	// Bit REGION3_R0_PMS_R.
	LP_APM_REGION3_PMS_ATTR_REGION3_R0_PMS_R = 0x4
	// Position of REGION3_R1_PMS_X field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R1_PMS_X_Pos = 0x4
	// Bit mask of REGION3_R1_PMS_X field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R1_PMS_X_Msk = 0x10
	// Bit REGION3_R1_PMS_X.
	LP_APM_REGION3_PMS_ATTR_REGION3_R1_PMS_X = 0x10
	// Position of REGION3_R1_PMS_W field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R1_PMS_W_Pos = 0x5
	// Bit mask of REGION3_R1_PMS_W field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R1_PMS_W_Msk = 0x20
	// Bit REGION3_R1_PMS_W.
	LP_APM_REGION3_PMS_ATTR_REGION3_R1_PMS_W = 0x20
	// Position of REGION3_R1_PMS_R field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R1_PMS_R_Pos = 0x6
	// Bit mask of REGION3_R1_PMS_R field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R1_PMS_R_Msk = 0x40
	// Bit REGION3_R1_PMS_R.
	LP_APM_REGION3_PMS_ATTR_REGION3_R1_PMS_R = 0x40
	// Position of REGION3_R2_PMS_X field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R2_PMS_X_Pos = 0x8
	// Bit mask of REGION3_R2_PMS_X field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R2_PMS_X_Msk = 0x100
	// Bit REGION3_R2_PMS_X.
	LP_APM_REGION3_PMS_ATTR_REGION3_R2_PMS_X = 0x100
	// Position of REGION3_R2_PMS_W field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R2_PMS_W_Pos = 0x9
	// Bit mask of REGION3_R2_PMS_W field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R2_PMS_W_Msk = 0x200
	// Bit REGION3_R2_PMS_W.
	LP_APM_REGION3_PMS_ATTR_REGION3_R2_PMS_W = 0x200
	// Position of REGION3_R2_PMS_R field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R2_PMS_R_Pos = 0xa
	// Bit mask of REGION3_R2_PMS_R field.
	LP_APM_REGION3_PMS_ATTR_REGION3_R2_PMS_R_Msk = 0x400
	// Bit REGION3_R2_PMS_R.
	LP_APM_REGION3_PMS_ATTR_REGION3_R2_PMS_R = 0x400

	// FUNC_CTRL: PMS function control register
	// Position of M0_PMS_FUNC_EN field.
	LP_APM_FUNC_CTRL_M0_PMS_FUNC_EN_Pos = 0x0
	// Bit mask of M0_PMS_FUNC_EN field.
	LP_APM_FUNC_CTRL_M0_PMS_FUNC_EN_Msk = 0x1
	// Bit M0_PMS_FUNC_EN.
	LP_APM_FUNC_CTRL_M0_PMS_FUNC_EN = 0x1
	// Position of M1_PMS_FUNC_EN field.
	LP_APM_FUNC_CTRL_M1_PMS_FUNC_EN_Pos = 0x1
	// Bit mask of M1_PMS_FUNC_EN field.
	LP_APM_FUNC_CTRL_M1_PMS_FUNC_EN_Msk = 0x2
	// Bit M1_PMS_FUNC_EN.
	LP_APM_FUNC_CTRL_M1_PMS_FUNC_EN = 0x2

	// M0_STATUS: M0 status register
	// Position of M0_EXCEPTION_STATUS field.
	LP_APM_M0_STATUS_M0_EXCEPTION_STATUS_Pos = 0x0
	// Bit mask of M0_EXCEPTION_STATUS field.
	LP_APM_M0_STATUS_M0_EXCEPTION_STATUS_Msk = 0x3

	// M0_STATUS_CLR: M0 status clear register
	// Position of M0_REGION_STATUS_CLR field.
	LP_APM_M0_STATUS_CLR_M0_REGION_STATUS_CLR_Pos = 0x0
	// Bit mask of M0_REGION_STATUS_CLR field.
	LP_APM_M0_STATUS_CLR_M0_REGION_STATUS_CLR_Msk = 0x1
	// Bit M0_REGION_STATUS_CLR.
	LP_APM_M0_STATUS_CLR_M0_REGION_STATUS_CLR = 0x1

	// M0_EXCEPTION_INFO0: M0 exception_info0 register
	// Position of M0_EXCEPTION_REGION field.
	LP_APM_M0_EXCEPTION_INFO0_M0_EXCEPTION_REGION_Pos = 0x0
	// Bit mask of M0_EXCEPTION_REGION field.
	LP_APM_M0_EXCEPTION_INFO0_M0_EXCEPTION_REGION_Msk = 0xf
	// Position of M0_EXCEPTION_MODE field.
	LP_APM_M0_EXCEPTION_INFO0_M0_EXCEPTION_MODE_Pos = 0x10
	// Bit mask of M0_EXCEPTION_MODE field.
	LP_APM_M0_EXCEPTION_INFO0_M0_EXCEPTION_MODE_Msk = 0x30000
	// Position of M0_EXCEPTION_ID field.
	LP_APM_M0_EXCEPTION_INFO0_M0_EXCEPTION_ID_Pos = 0x12
	// Bit mask of M0_EXCEPTION_ID field.
	LP_APM_M0_EXCEPTION_INFO0_M0_EXCEPTION_ID_Msk = 0x7c0000

	// M0_EXCEPTION_INFO1: M0 exception_info1 register
	// Position of M0_EXCEPTION_ADDR field.
	LP_APM_M0_EXCEPTION_INFO1_M0_EXCEPTION_ADDR_Pos = 0x0
	// Bit mask of M0_EXCEPTION_ADDR field.
	LP_APM_M0_EXCEPTION_INFO1_M0_EXCEPTION_ADDR_Msk = 0xffffffff

	// M1_STATUS: M1 status register
	// Position of M1_EXCEPTION_STATUS field.
	LP_APM_M1_STATUS_M1_EXCEPTION_STATUS_Pos = 0x0
	// Bit mask of M1_EXCEPTION_STATUS field.
	LP_APM_M1_STATUS_M1_EXCEPTION_STATUS_Msk = 0x3

	// M1_STATUS_CLR: M1 status clear register
	// Position of M1_REGION_STATUS_CLR field.
	LP_APM_M1_STATUS_CLR_M1_REGION_STATUS_CLR_Pos = 0x0
	// Bit mask of M1_REGION_STATUS_CLR field.
	LP_APM_M1_STATUS_CLR_M1_REGION_STATUS_CLR_Msk = 0x1
	// Bit M1_REGION_STATUS_CLR.
	LP_APM_M1_STATUS_CLR_M1_REGION_STATUS_CLR = 0x1

	// M1_EXCEPTION_INFO0: M1 exception_info0 register
	// Position of M1_EXCEPTION_REGION field.
	LP_APM_M1_EXCEPTION_INFO0_M1_EXCEPTION_REGION_Pos = 0x0
	// Bit mask of M1_EXCEPTION_REGION field.
	LP_APM_M1_EXCEPTION_INFO0_M1_EXCEPTION_REGION_Msk = 0xf
	// Position of M1_EXCEPTION_MODE field.
	LP_APM_M1_EXCEPTION_INFO0_M1_EXCEPTION_MODE_Pos = 0x10
	// Bit mask of M1_EXCEPTION_MODE field.
	LP_APM_M1_EXCEPTION_INFO0_M1_EXCEPTION_MODE_Msk = 0x30000
	// Position of M1_EXCEPTION_ID field.
	LP_APM_M1_EXCEPTION_INFO0_M1_EXCEPTION_ID_Pos = 0x12
	// Bit mask of M1_EXCEPTION_ID field.
	LP_APM_M1_EXCEPTION_INFO0_M1_EXCEPTION_ID_Msk = 0x7c0000

	// M1_EXCEPTION_INFO1: M1 exception_info1 register
	// Position of M1_EXCEPTION_ADDR field.
	LP_APM_M1_EXCEPTION_INFO1_M1_EXCEPTION_ADDR_Pos = 0x0
	// Bit mask of M1_EXCEPTION_ADDR field.
	LP_APM_M1_EXCEPTION_INFO1_M1_EXCEPTION_ADDR_Msk = 0xffffffff

	// INT_EN: APM interrupt enable register
	// Position of M0_APM_INT_EN field.
	LP_APM_INT_EN_M0_APM_INT_EN_Pos = 0x0
	// Bit mask of M0_APM_INT_EN field.
	LP_APM_INT_EN_M0_APM_INT_EN_Msk = 0x1
	// Bit M0_APM_INT_EN.
	LP_APM_INT_EN_M0_APM_INT_EN = 0x1
	// Position of M1_APM_INT_EN field.
	LP_APM_INT_EN_M1_APM_INT_EN_Pos = 0x1
	// Bit mask of M1_APM_INT_EN field.
	LP_APM_INT_EN_M1_APM_INT_EN_Msk = 0x2
	// Bit M1_APM_INT_EN.
	LP_APM_INT_EN_M1_APM_INT_EN = 0x2

	// CLOCK_GATE: clock gating register
	// Position of CLK_EN field.
	LP_APM_CLOCK_GATE_CLK_EN_Pos = 0x0
	// Bit mask of CLK_EN field.
	LP_APM_CLOCK_GATE_CLK_EN_Msk = 0x1
	// Bit CLK_EN.
	LP_APM_CLOCK_GATE_CLK_EN = 0x1

	// DATE: Version register
	// Position of DATE field.
	LP_APM_DATE_DATE_Pos = 0x0
	// Bit mask of DATE field.
	LP_APM_DATE_DATE_Msk = 0xfffffff
)

// Constants for LP_CLKRST: LP_CLKRST Peripheral
const (
	// LP_CLK_CONF: need_des
	// Position of SLOW_CLK_SEL field.
	LP_CLKRST_LP_CLK_CONF_SLOW_CLK_SEL_Pos = 0x0
	// Bit mask of SLOW_CLK_SEL field.
	LP_CLKRST_LP_CLK_CONF_SLOW_CLK_SEL_Msk = 0x3
	// Position of FAST_CLK_SEL field.
	LP_CLKRST_LP_CLK_CONF_FAST_CLK_SEL_Pos = 0x2
	// Bit mask of FAST_CLK_SEL field.
	LP_CLKRST_LP_CLK_CONF_FAST_CLK_SEL_Msk = 0x4
	// Bit FAST_CLK_SEL.
	LP_CLKRST_LP_CLK_CONF_FAST_CLK_SEL = 0x4
	// Position of LP_PERI_DIV_NUM field.
	LP_CLKRST_LP_CLK_CONF_LP_PERI_DIV_NUM_Pos = 0x3
	// Bit mask of LP_PERI_DIV_NUM field.
	LP_CLKRST_LP_CLK_CONF_LP_PERI_DIV_NUM_Msk = 0x7f8

	// LP_CLK_PO_EN: need_des
	// Position of AON_SLOW_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_AON_SLOW_OEN_Pos = 0x0
	// Bit mask of AON_SLOW_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_AON_SLOW_OEN_Msk = 0x1
	// Bit AON_SLOW_OEN.
	LP_CLKRST_LP_CLK_PO_EN_AON_SLOW_OEN = 0x1
	// Position of AON_FAST_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_AON_FAST_OEN_Pos = 0x1
	// Bit mask of AON_FAST_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_AON_FAST_OEN_Msk = 0x2
	// Bit AON_FAST_OEN.
	LP_CLKRST_LP_CLK_PO_EN_AON_FAST_OEN = 0x2
	// Position of SOSC_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_SOSC_OEN_Pos = 0x2
	// Bit mask of SOSC_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_SOSC_OEN_Msk = 0x4
	// Bit SOSC_OEN.
	LP_CLKRST_LP_CLK_PO_EN_SOSC_OEN = 0x4
	// Position of FOSC_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_FOSC_OEN_Pos = 0x3
	// Bit mask of FOSC_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_FOSC_OEN_Msk = 0x8
	// Bit FOSC_OEN.
	LP_CLKRST_LP_CLK_PO_EN_FOSC_OEN = 0x8
	// Position of OSC32K_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_OSC32K_OEN_Pos = 0x4
	// Bit mask of OSC32K_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_OSC32K_OEN_Msk = 0x10
	// Bit OSC32K_OEN.
	LP_CLKRST_LP_CLK_PO_EN_OSC32K_OEN = 0x10
	// Position of XTAL32K_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_XTAL32K_OEN_Pos = 0x5
	// Bit mask of XTAL32K_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_XTAL32K_OEN_Msk = 0x20
	// Bit XTAL32K_OEN.
	LP_CLKRST_LP_CLK_PO_EN_XTAL32K_OEN = 0x20
	// Position of CORE_EFUSE_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_CORE_EFUSE_OEN_Pos = 0x6
	// Bit mask of CORE_EFUSE_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_CORE_EFUSE_OEN_Msk = 0x40
	// Bit CORE_EFUSE_OEN.
	LP_CLKRST_LP_CLK_PO_EN_CORE_EFUSE_OEN = 0x40
	// Position of SLOW_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_SLOW_OEN_Pos = 0x7
	// Bit mask of SLOW_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_SLOW_OEN_Msk = 0x80
	// Bit SLOW_OEN.
	LP_CLKRST_LP_CLK_PO_EN_SLOW_OEN = 0x80
	// Position of FAST_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_FAST_OEN_Pos = 0x8
	// Bit mask of FAST_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_FAST_OEN_Msk = 0x100
	// Bit FAST_OEN.
	LP_CLKRST_LP_CLK_PO_EN_FAST_OEN = 0x100
	// Position of RNG_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_RNG_OEN_Pos = 0x9
	// Bit mask of RNG_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_RNG_OEN_Msk = 0x200
	// Bit RNG_OEN.
	LP_CLKRST_LP_CLK_PO_EN_RNG_OEN = 0x200
	// Position of LPBUS_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_LPBUS_OEN_Pos = 0xa
	// Bit mask of LPBUS_OEN field.
	LP_CLKRST_LP_CLK_PO_EN_LPBUS_OEN_Msk = 0x400
	// Bit LPBUS_OEN.
	LP_CLKRST_LP_CLK_PO_EN_LPBUS_OEN = 0x400

	// LP_CLK_EN: need_des
	// Position of FAST_ORI_GATE field.
	LP_CLKRST_LP_CLK_EN_FAST_ORI_GATE_Pos = 0x1f
	// Bit mask of FAST_ORI_GATE field.
	LP_CLKRST_LP_CLK_EN_FAST_ORI_GATE_Msk = 0x80000000
	// Bit FAST_ORI_GATE.
	LP_CLKRST_LP_CLK_EN_FAST_ORI_GATE = 0x80000000

	// LP_RST_EN: need_des
	// Position of AON_EFUSE_CORE_RESET_EN field.
	LP_CLKRST_LP_RST_EN_AON_EFUSE_CORE_RESET_EN_Pos = 0x1c
	// Bit mask of AON_EFUSE_CORE_RESET_EN field.
	LP_CLKRST_LP_RST_EN_AON_EFUSE_CORE_RESET_EN_Msk = 0x10000000
	// Bit AON_EFUSE_CORE_RESET_EN.
	LP_CLKRST_LP_RST_EN_AON_EFUSE_CORE_RESET_EN = 0x10000000
	// Position of LP_TIMER_RESET_EN field.
	LP_CLKRST_LP_RST_EN_LP_TIMER_RESET_EN_Pos = 0x1d
	// Bit mask of LP_TIMER_RESET_EN field.
	LP_CLKRST_LP_RST_EN_LP_TIMER_RESET_EN_Msk = 0x20000000
	// Bit LP_TIMER_RESET_EN.
	LP_CLKRST_LP_RST_EN_LP_TIMER_RESET_EN = 0x20000000
	// Position of WDT_RESET_EN field.
	LP_CLKRST_LP_RST_EN_WDT_RESET_EN_Pos = 0x1e
	// Bit mask of WDT_RESET_EN field.
	LP_CLKRST_LP_RST_EN_WDT_RESET_EN_Msk = 0x40000000
	// Bit WDT_RESET_EN.
	LP_CLKRST_LP_RST_EN_WDT_RESET_EN = 0x40000000
	// Position of ANA_PERI_RESET_EN field.
	LP_CLKRST_LP_RST_EN_ANA_PERI_RESET_EN_Pos = 0x1f
	// Bit mask of ANA_PERI_RESET_EN field.
	LP_CLKRST_LP_RST_EN_ANA_PERI_RESET_EN_Msk = 0x80000000
	// Bit ANA_PERI_RESET_EN.
	LP_CLKRST_LP_RST_EN_ANA_PERI_RESET_EN = 0x80000000

	// RESET_CAUSE: need_des
	// Position of RESET_CAUSE field.
	LP_CLKRST_RESET_CAUSE_RESET_CAUSE_Pos = 0x0
	// Bit mask of RESET_CAUSE field.
	LP_CLKRST_RESET_CAUSE_RESET_CAUSE_Msk = 0x1f
	// Position of CORE0_RESET_FLAG field.
	LP_CLKRST_RESET_CAUSE_CORE0_RESET_FLAG_Pos = 0x5
	// Bit mask of CORE0_RESET_FLAG field.
	LP_CLKRST_RESET_CAUSE_CORE0_RESET_FLAG_Msk = 0x20
	// Bit CORE0_RESET_FLAG.
	LP_CLKRST_RESET_CAUSE_CORE0_RESET_FLAG = 0x20
	// Position of CORE0_RESET_CAUSE_CLR field.
	LP_CLKRST_RESET_CAUSE_CORE0_RESET_CAUSE_CLR_Pos = 0x1d
	// Bit mask of CORE0_RESET_CAUSE_CLR field.
	LP_CLKRST_RESET_CAUSE_CORE0_RESET_CAUSE_CLR_Msk = 0x20000000
	// Bit CORE0_RESET_CAUSE_CLR.
	LP_CLKRST_RESET_CAUSE_CORE0_RESET_CAUSE_CLR = 0x20000000
	// Position of CORE0_RESET_FLAG_SET field.
	LP_CLKRST_RESET_CAUSE_CORE0_RESET_FLAG_SET_Pos = 0x1e
	// Bit mask of CORE0_RESET_FLAG_SET field.
	LP_CLKRST_RESET_CAUSE_CORE0_RESET_FLAG_SET_Msk = 0x40000000
	// Bit CORE0_RESET_FLAG_SET.
	LP_CLKRST_RESET_CAUSE_CORE0_RESET_FLAG_SET = 0x40000000
	// Position of CORE0_RESET_FLAG_CLR field.
	LP_CLKRST_RESET_CAUSE_CORE0_RESET_FLAG_CLR_Pos = 0x1f
	// Bit mask of CORE0_RESET_FLAG_CLR field.
	LP_CLKRST_RESET_CAUSE_CORE0_RESET_FLAG_CLR_Msk = 0x80000000
	// Bit CORE0_RESET_FLAG_CLR.
	LP_CLKRST_RESET_CAUSE_CORE0_RESET_FLAG_CLR = 0x80000000

	// CPU_RESET: need_des
	// Position of RTC_WDT_CPU_RESET_LENGTH field.
	LP_CLKRST_CPU_RESET_RTC_WDT_CPU_RESET_LENGTH_Pos = 0x16
	// Bit mask of RTC_WDT_CPU_RESET_LENGTH field.
	LP_CLKRST_CPU_RESET_RTC_WDT_CPU_RESET_LENGTH_Msk = 0x1c00000
	// Position of RTC_WDT_CPU_RESET_EN field.
	LP_CLKRST_CPU_RESET_RTC_WDT_CPU_RESET_EN_Pos = 0x19
	// Bit mask of RTC_WDT_CPU_RESET_EN field.
	LP_CLKRST_CPU_RESET_RTC_WDT_CPU_RESET_EN_Msk = 0x2000000
	// Bit RTC_WDT_CPU_RESET_EN.
	LP_CLKRST_CPU_RESET_RTC_WDT_CPU_RESET_EN = 0x2000000
	// Position of CPU_STALL_WAIT field.
	LP_CLKRST_CPU_RESET_CPU_STALL_WAIT_Pos = 0x1a
	// Bit mask of CPU_STALL_WAIT field.
	LP_CLKRST_CPU_RESET_CPU_STALL_WAIT_Msk = 0x7c000000
	// Position of CPU_STALL_EN field.
	LP_CLKRST_CPU_RESET_CPU_STALL_EN_Pos = 0x1f
	// Bit mask of CPU_STALL_EN field.
	LP_CLKRST_CPU_RESET_CPU_STALL_EN_Msk = 0x80000000
	// Bit CPU_STALL_EN.
	LP_CLKRST_CPU_RESET_CPU_STALL_EN = 0x80000000

	// FOSC_CNTL: need_des
	// Position of FOSC_DFREQ field.
	LP_CLKRST_FOSC_CNTL_FOSC_DFREQ_Pos = 0x16
	// Bit mask of FOSC_DFREQ field.
	LP_CLKRST_FOSC_CNTL_FOSC_DFREQ_Msk = 0xffc00000

	// RC32K_CNTL: need_des
	// Position of RC32K_DFREQ field.
	LP_CLKRST_RC32K_CNTL_RC32K_DFREQ_Pos = 0x16
	// Bit mask of RC32K_DFREQ field.
	LP_CLKRST_RC32K_CNTL_RC32K_DFREQ_Msk = 0xffc00000

	// CLK_TO_HP: need_des
	// Position of ICG_HP_XTAL32K field.
	LP_CLKRST_CLK_TO_HP_ICG_HP_XTAL32K_Pos = 0x1c
	// Bit mask of ICG_HP_XTAL32K field.
	LP_CLKRST_CLK_TO_HP_ICG_HP_XTAL32K_Msk = 0x10000000
	// Bit ICG_HP_XTAL32K.
	LP_CLKRST_CLK_TO_HP_ICG_HP_XTAL32K = 0x10000000
	// Position of ICG_HP_SOSC field.
	LP_CLKRST_CLK_TO_HP_ICG_HP_SOSC_Pos = 0x1d
	// Bit mask of ICG_HP_SOSC field.
	LP_CLKRST_CLK_TO_HP_ICG_HP_SOSC_Msk = 0x20000000
	// Bit ICG_HP_SOSC.
	LP_CLKRST_CLK_TO_HP_ICG_HP_SOSC = 0x20000000
	// Position of ICG_HP_OSC32K field.
	LP_CLKRST_CLK_TO_HP_ICG_HP_OSC32K_Pos = 0x1e
	// Bit mask of ICG_HP_OSC32K field.
	LP_CLKRST_CLK_TO_HP_ICG_HP_OSC32K_Msk = 0x40000000
	// Bit ICG_HP_OSC32K.
	LP_CLKRST_CLK_TO_HP_ICG_HP_OSC32K = 0x40000000
	// Position of ICG_HP_FOSC field.
	LP_CLKRST_CLK_TO_HP_ICG_HP_FOSC_Pos = 0x1f
	// Bit mask of ICG_HP_FOSC field.
	LP_CLKRST_CLK_TO_HP_ICG_HP_FOSC_Msk = 0x80000000
	// Bit ICG_HP_FOSC.
	LP_CLKRST_CLK_TO_HP_ICG_HP_FOSC = 0x80000000

	// LPMEM_FORCE: need_des
	// Position of LPMEM_CLK_FORCE_ON field.
	LP_CLKRST_LPMEM_FORCE_LPMEM_CLK_FORCE_ON_Pos = 0x1f
	// Bit mask of LPMEM_CLK_FORCE_ON field.
	LP_CLKRST_LPMEM_FORCE_LPMEM_CLK_FORCE_ON_Msk = 0x80000000
	// Bit LPMEM_CLK_FORCE_ON.
	LP_CLKRST_LPMEM_FORCE_LPMEM_CLK_FORCE_ON = 0x80000000

	// LPPERI: need_des
	// Position of LP_I2C_CLK_SEL field.
	LP_CLKRST_LPPERI_LP_I2C_CLK_SEL_Pos = 0x1e
	// Bit mask of LP_I2C_CLK_SEL field.
	LP_CLKRST_LPPERI_LP_I2C_CLK_SEL_Msk = 0x40000000
	// Bit LP_I2C_CLK_SEL.
	LP_CLKRST_LPPERI_LP_I2C_CLK_SEL = 0x40000000
	// Position of LP_UART_CLK_SEL field.
	LP_CLKRST_LPPERI_LP_UART_CLK_SEL_Pos = 0x1f
	// Bit mask of LP_UART_CLK_SEL field.
	LP_CLKRST_LPPERI_LP_UART_CLK_SEL_Msk = 0x80000000
	// Bit LP_UART_CLK_SEL.
	LP_CLKRST_LPPERI_LP_UART_CLK_SEL = 0x80000000

	// XTAL32K: need_des
	// Position of DRES_XTAL32K field.
	LP_CLKRST_XTAL32K_DRES_XTAL32K_Pos = 0x16
	// Bit mask of DRES_XTAL32K field.
	LP_CLKRST_XTAL32K_DRES_XTAL32K_Msk = 0x1c00000
	// Position of DGM_XTAL32K field.
	LP_CLKRST_XTAL32K_DGM_XTAL32K_Pos = 0x19
	// Bit mask of DGM_XTAL32K field.
	LP_CLKRST_XTAL32K_DGM_XTAL32K_Msk = 0xe000000
	// Position of DBUF_XTAL32K field.
	LP_CLKRST_XTAL32K_DBUF_XTAL32K_Pos = 0x1c
	// Bit mask of DBUF_XTAL32K field.
	LP_CLKRST_XTAL32K_DBUF_XTAL32K_Msk = 0x10000000
	// Bit DBUF_XTAL32K.
	LP_CLKRST_XTAL32K_DBUF_XTAL32K = 0x10000000
	// Position of DAC_XTAL32K field.
	LP_CLKRST_XTAL32K_DAC_XTAL32K_Pos = 0x1d
	// Bit mask of DAC_XTAL32K field.
	LP_CLKRST_XTAL32K_DAC_XTAL32K_Msk = 0xe0000000

	// DATE: need_des
	// Position of CLKRST_DATE field.
	LP_CLKRST_DATE_CLKRST_DATE_Pos = 0x0
	// Bit mask of CLKRST_DATE field.
	LP_CLKRST_DATE_CLKRST_DATE_Msk = 0x7fffffff
	// Position of CLK_EN field.
	LP_CLKRST_DATE_CLK_EN_Pos = 0x1f
	// Bit mask of CLK_EN field.
	LP_CLKRST_DATE_CLK_EN_Msk = 0x80000000
	// Bit CLK_EN.
	LP_CLKRST_DATE_CLK_EN = 0x80000000
)

// Constants for LP_I2C_ANA_MST: LP_I2C_ANA_MST Peripheral
const (
	// I2C0_CTRL: need_des
	// Position of LP_I2C_ANA_MAST_I2C0_CTRL field.
	LP_I2C_ANA_MST_I2C0_CTRL_LP_I2C_ANA_MAST_I2C0_CTRL_Pos = 0x0
	// Bit mask of LP_I2C_ANA_MAST_I2C0_CTRL field.
	LP_I2C_ANA_MST_I2C0_CTRL_LP_I2C_ANA_MAST_I2C0_CTRL_Msk = 0x1ffffff
	// Position of LP_I2C_ANA_MAST_I2C0_BUSY field.
	LP_I2C_ANA_MST_I2C0_CTRL_LP_I2C_ANA_MAST_I2C0_BUSY_Pos = 0x19
	// Bit mask of LP_I2C_ANA_MAST_I2C0_BUSY field.
	LP_I2C_ANA_MST_I2C0_CTRL_LP_I2C_ANA_MAST_I2C0_BUSY_Msk = 0x2000000
	// Bit LP_I2C_ANA_MAST_I2C0_BUSY.
	LP_I2C_ANA_MST_I2C0_CTRL_LP_I2C_ANA_MAST_I2C0_BUSY = 0x2000000

	// I2C0_CONF: need_des
	// Position of LP_I2C_ANA_MAST_I2C0_CONF field.
	LP_I2C_ANA_MST_I2C0_CONF_LP_I2C_ANA_MAST_I2C0_CONF_Pos = 0x0
	// Bit mask of LP_I2C_ANA_MAST_I2C0_CONF field.
	LP_I2C_ANA_MST_I2C0_CONF_LP_I2C_ANA_MAST_I2C0_CONF_Msk = 0xffffff
	// Position of LP_I2C_ANA_MAST_I2C0_STATUS field.
	LP_I2C_ANA_MST_I2C0_CONF_LP_I2C_ANA_MAST_I2C0_STATUS_Pos = 0x18
	// Bit mask of LP_I2C_ANA_MAST_I2C0_STATUS field.
	LP_I2C_ANA_MST_I2C0_CONF_LP_I2C_ANA_MAST_I2C0_STATUS_Msk = 0xff000000

	// I2C0_DATA: need_des
	// Position of LP_I2C_ANA_MAST_I2C0_RDATA field.
	LP_I2C_ANA_MST_I2C0_DATA_LP_I2C_ANA_MAST_I2C0_RDATA_Pos = 0x0
	// Bit mask of LP_I2C_ANA_MAST_I2C0_RDATA field.
	LP_I2C_ANA_MST_I2C0_DATA_LP_I2C_ANA_MAST_I2C0_RDATA_Msk = 0xff
	// Position of LP_I2C_ANA_MAST_I2C0_CLK_SEL field.
	LP_I2C_ANA_MST_I2C0_DATA_LP_I2C_ANA_MAST_I2C0_CLK_SEL_Pos = 0x8
	// Bit mask of LP_I2C_ANA_MAST_I2C0_CLK_SEL field.
	LP_I2C_ANA_MST_I2C0_DATA_LP_I2C_ANA_MAST_I2C0_CLK_SEL_Msk = 0x700
	// Position of LP_I2C_ANA_MAST_I2C_MST_SEL field.
	LP_I2C_ANA_MST_I2C0_DATA_LP_I2C_ANA_MAST_I2C_MST_SEL_Pos = 0xb
	// Bit mask of LP_I2C_ANA_MAST_I2C_MST_SEL field.
	LP_I2C_ANA_MST_I2C0_DATA_LP_I2C_ANA_MAST_I2C_MST_SEL_Msk = 0x800
	// Bit LP_I2C_ANA_MAST_I2C_MST_SEL.
	LP_I2C_ANA_MST_I2C0_DATA_LP_I2C_ANA_MAST_I2C_MST_SEL = 0x800

	// ANA_CONF1: need_des
	// Position of LP_I2C_ANA_MAST_ANA_CONF1 field.
	LP_I2C_ANA_MST_ANA_CONF1_LP_I2C_ANA_MAST_ANA_CONF1_Pos = 0x0
	// Bit mask of LP_I2C_ANA_MAST_ANA_CONF1 field.
	LP_I2C_ANA_MST_ANA_CONF1_LP_I2C_ANA_MAST_ANA_CONF1_Msk = 0xffffff

	// NOUSE: need_des
	// Position of LP_I2C_ANA_MAST_I2C_MST_NOUSE field.
	LP_I2C_ANA_MST_NOUSE_LP_I2C_ANA_MAST_I2C_MST_NOUSE_Pos = 0x0
	// Bit mask of LP_I2C_ANA_MAST_I2C_MST_NOUSE field.
	LP_I2C_ANA_MST_NOUSE_LP_I2C_ANA_MAST_I2C_MST_NOUSE_Msk = 0xffffffff

	// DEVICE_EN: need_des
	// Position of LP_I2C_ANA_MAST_I2C_DEVICE_EN field.
	LP_I2C_ANA_MST_DEVICE_EN_LP_I2C_ANA_MAST_I2C_DEVICE_EN_Pos = 0x0
	// Bit mask of LP_I2C_ANA_MAST_I2C_DEVICE_EN field.
	LP_I2C_ANA_MST_DEVICE_EN_LP_I2C_ANA_MAST_I2C_DEVICE_EN_Msk = 0xfff

	// DATE: need_des
	// Position of LP_I2C_ANA_MAST_I2C_MAT_DATE field.
	LP_I2C_ANA_MST_DATE_LP_I2C_ANA_MAST_I2C_MAT_DATE_Pos = 0x0
	// Bit mask of LP_I2C_ANA_MAST_I2C_MAT_DATE field.
	LP_I2C_ANA_MST_DATE_LP_I2C_ANA_MAST_I2C_MAT_DATE_Msk = 0xfffffff
	// Position of LP_I2C_ANA_MAST_I2C_MAT_CLK_EN field.
	LP_I2C_ANA_MST_DATE_LP_I2C_ANA_MAST_I2C_MAT_CLK_EN_Pos = 0x1c
	// Bit mask of LP_I2C_ANA_MAST_I2C_MAT_CLK_EN field.
	LP_I2C_ANA_MST_DATE_LP_I2C_ANA_MAST_I2C_MAT_CLK_EN_Msk = 0x10000000
	// Bit LP_I2C_ANA_MAST_I2C_MAT_CLK_EN.
	LP_I2C_ANA_MST_DATE_LP_I2C_ANA_MAST_I2C_MAT_CLK_EN = 0x10000000
)

// Constants for LP_IO_MUX: Low-power Input/Output Multiplexer
const (
	// OUT_DATA: need des
	// Position of LP_GPIO_OUT_DATA field.
	LP_IO_OUT_DATA_LP_GPIO_OUT_DATA_Pos = 0x0
	// Bit mask of LP_GPIO_OUT_DATA field.
	LP_IO_OUT_DATA_LP_GPIO_OUT_DATA_Msk = 0xff

	// OUT_DATA_W1TS: need des
	// Position of LP_GPIO_OUT_DATA_W1TS field.
	LP_IO_OUT_DATA_W1TS_LP_GPIO_OUT_DATA_W1TS_Pos = 0x0
	// Bit mask of LP_GPIO_OUT_DATA_W1TS field.
	LP_IO_OUT_DATA_W1TS_LP_GPIO_OUT_DATA_W1TS_Msk = 0xff

	// OUT_DATA_W1TC: need des
	// Position of LP_GPIO_OUT_DATA_W1TC field.
	LP_IO_OUT_DATA_W1TC_LP_GPIO_OUT_DATA_W1TC_Pos = 0x0
	// Bit mask of LP_GPIO_OUT_DATA_W1TC field.
	LP_IO_OUT_DATA_W1TC_LP_GPIO_OUT_DATA_W1TC_Msk = 0xff

	// OUT_ENABLE: need des
	// Position of LP_GPIO_ENABLE field.
	LP_IO_OUT_ENABLE_LP_GPIO_ENABLE_Pos = 0x0
	// Bit mask of LP_GPIO_ENABLE field.
	LP_IO_OUT_ENABLE_LP_GPIO_ENABLE_Msk = 0xff

	// OUT_ENABLE_W1TS: need des
	// Position of LP_GPIO_ENABLE_W1TS field.
	LP_IO_OUT_ENABLE_W1TS_LP_GPIO_ENABLE_W1TS_Pos = 0x0
	// Bit mask of LP_GPIO_ENABLE_W1TS field.
	LP_IO_OUT_ENABLE_W1TS_LP_GPIO_ENABLE_W1TS_Msk = 0xff

	// OUT_ENABLE_W1TC: need des
	// Position of LP_GPIO_ENABLE_W1TC field.
	LP_IO_OUT_ENABLE_W1TC_LP_GPIO_ENABLE_W1TC_Pos = 0x0
	// Bit mask of LP_GPIO_ENABLE_W1TC field.
	LP_IO_OUT_ENABLE_W1TC_LP_GPIO_ENABLE_W1TC_Msk = 0xff

	// STATUS: need des
	// Position of LP_GPIO_STATUS_INTERRUPT field.
	LP_IO_STATUS_LP_GPIO_STATUS_INTERRUPT_Pos = 0x0
	// Bit mask of LP_GPIO_STATUS_INTERRUPT field.
	LP_IO_STATUS_LP_GPIO_STATUS_INTERRUPT_Msk = 0xff

	// STATUS_W1TS: need des
	// Position of LP_GPIO_STATUS_W1TS field.
	LP_IO_STATUS_W1TS_LP_GPIO_STATUS_W1TS_Pos = 0x0
	// Bit mask of LP_GPIO_STATUS_W1TS field.
	LP_IO_STATUS_W1TS_LP_GPIO_STATUS_W1TS_Msk = 0xff

	// STATUS_W1TC: need des
	// Position of LP_GPIO_STATUS_W1TC field.
	LP_IO_STATUS_W1TC_LP_GPIO_STATUS_W1TC_Pos = 0x0
	// Bit mask of LP_GPIO_STATUS_W1TC field.
	LP_IO_STATUS_W1TC_LP_GPIO_STATUS_W1TC_Msk = 0xff

	// IN: need des
	// Position of LP_GPIO_IN_DATA_NEXT field.
	LP_IO_IN_LP_GPIO_IN_DATA_NEXT_Pos = 0x0
	// Bit mask of LP_GPIO_IN_DATA_NEXT field.
	LP_IO_IN_LP_GPIO_IN_DATA_NEXT_Msk = 0xff

	// PIN0: need des
	// Position of LP_GPIO0_SYNC_BYPASS field.
	LP_IO_PIN0_LP_GPIO0_SYNC_BYPASS_Pos = 0x0
	// Bit mask of LP_GPIO0_SYNC_BYPASS field.
	LP_IO_PIN0_LP_GPIO0_SYNC_BYPASS_Msk = 0x3
	// Position of LP_GPIO0_PAD_DRIVER field.
	LP_IO_PIN0_LP_GPIO0_PAD_DRIVER_Pos = 0x2
	// Bit mask of LP_GPIO0_PAD_DRIVER field.
	LP_IO_PIN0_LP_GPIO0_PAD_DRIVER_Msk = 0x4
	// Bit LP_GPIO0_PAD_DRIVER.
	LP_IO_PIN0_LP_GPIO0_PAD_DRIVER = 0x4
	// Position of LP_GPIO0_EDGE_WAKEUP_CLR field.
	LP_IO_PIN0_LP_GPIO0_EDGE_WAKEUP_CLR_Pos = 0x3
	// Bit mask of LP_GPIO0_EDGE_WAKEUP_CLR field.
	LP_IO_PIN0_LP_GPIO0_EDGE_WAKEUP_CLR_Msk = 0x8
	// Bit LP_GPIO0_EDGE_WAKEUP_CLR.
	LP_IO_PIN0_LP_GPIO0_EDGE_WAKEUP_CLR = 0x8
	// Position of LP_GPIO0_INT_TYPE field.
	LP_IO_PIN0_LP_GPIO0_INT_TYPE_Pos = 0x7
	// Bit mask of LP_GPIO0_INT_TYPE field.
	LP_IO_PIN0_LP_GPIO0_INT_TYPE_Msk = 0x380
	// Position of LP_GPIO0_WAKEUP_ENABLE field.
	LP_IO_PIN0_LP_GPIO0_WAKEUP_ENABLE_Pos = 0xa
	// Bit mask of LP_GPIO0_WAKEUP_ENABLE field.
	LP_IO_PIN0_LP_GPIO0_WAKEUP_ENABLE_Msk = 0x400
	// Bit LP_GPIO0_WAKEUP_ENABLE.
	LP_IO_PIN0_LP_GPIO0_WAKEUP_ENABLE = 0x400
	// Position of LP_GPIO0_FILTER_EN field.
	LP_IO_PIN0_LP_GPIO0_FILTER_EN_Pos = 0xb
	// Bit mask of LP_GPIO0_FILTER_EN field.
	LP_IO_PIN0_LP_GPIO0_FILTER_EN_Msk = 0x800
	// Bit LP_GPIO0_FILTER_EN.
	LP_IO_PIN0_LP_GPIO0_FILTER_EN = 0x800

	// PIN1: need des
	// Position of LP_GPIO1_SYNC_BYPASS field.
	LP_IO_PIN1_LP_GPIO1_SYNC_BYPASS_Pos = 0x0
	// Bit mask of LP_GPIO1_SYNC_BYPASS field.
	LP_IO_PIN1_LP_GPIO1_SYNC_BYPASS_Msk = 0x3
	// Position of LP_GPIO1_PAD_DRIVER field.
	LP_IO_PIN1_LP_GPIO1_PAD_DRIVER_Pos = 0x2
	// Bit mask of LP_GPIO1_PAD_DRIVER field.
	LP_IO_PIN1_LP_GPIO1_PAD_DRIVER_Msk = 0x4
	// Bit LP_GPIO1_PAD_DRIVER.
	LP_IO_PIN1_LP_GPIO1_PAD_DRIVER = 0x4
	// Position of LP_GPIO1_EDGE_WAKEUP_CLR field.
	LP_IO_PIN1_LP_GPIO1_EDGE_WAKEUP_CLR_Pos = 0x3
	// Bit mask of LP_GPIO1_EDGE_WAKEUP_CLR field.
	LP_IO_PIN1_LP_GPIO1_EDGE_WAKEUP_CLR_Msk = 0x8
	// Bit LP_GPIO1_EDGE_WAKEUP_CLR.
	LP_IO_PIN1_LP_GPIO1_EDGE_WAKEUP_CLR = 0x8
	// Position of LP_GPIO1_INT_TYPE field.
	LP_IO_PIN1_LP_GPIO1_INT_TYPE_Pos = 0x7
	// Bit mask of LP_GPIO1_INT_TYPE field.
	LP_IO_PIN1_LP_GPIO1_INT_TYPE_Msk = 0x380
	// Position of LP_GPIO1_WAKEUP_ENABLE field.
	LP_IO_PIN1_LP_GPIO1_WAKEUP_ENABLE_Pos = 0xa
	// Bit mask of LP_GPIO1_WAKEUP_ENABLE field.
	LP_IO_PIN1_LP_GPIO1_WAKEUP_ENABLE_Msk = 0x400
	// Bit LP_GPIO1_WAKEUP_ENABLE.
	LP_IO_PIN1_LP_GPIO1_WAKEUP_ENABLE = 0x400
	// Position of LP_GPIO1_FILTER_EN field.
	LP_IO_PIN1_LP_GPIO1_FILTER_EN_Pos = 0xb
	// Bit mask of LP_GPIO1_FILTER_EN field.
	LP_IO_PIN1_LP_GPIO1_FILTER_EN_Msk = 0x800
	// Bit LP_GPIO1_FILTER_EN.
	LP_IO_PIN1_LP_GPIO1_FILTER_EN = 0x800

	// PIN2: need des
	// Position of LP_GPIO2_SYNC_BYPASS field.
	LP_IO_PIN2_LP_GPIO2_SYNC_BYPASS_Pos = 0x0
	// Bit mask of LP_GPIO2_SYNC_BYPASS field.
	LP_IO_PIN2_LP_GPIO2_SYNC_BYPASS_Msk = 0x3
	// Position of LP_GPIO2_PAD_DRIVER field.
	LP_IO_PIN2_LP_GPIO2_PAD_DRIVER_Pos = 0x2
	// Bit mask of LP_GPIO2_PAD_DRIVER field.
	LP_IO_PIN2_LP_GPIO2_PAD_DRIVER_Msk = 0x4
	// Bit LP_GPIO2_PAD_DRIVER.
	LP_IO_PIN2_LP_GPIO2_PAD_DRIVER = 0x4
	// Position of LP_GPIO2_EDGE_WAKEUP_CLR field.
	LP_IO_PIN2_LP_GPIO2_EDGE_WAKEUP_CLR_Pos = 0x3
	// Bit mask of LP_GPIO2_EDGE_WAKEUP_CLR field.
	LP_IO_PIN2_LP_GPIO2_EDGE_WAKEUP_CLR_Msk = 0x8
	// Bit LP_GPIO2_EDGE_WAKEUP_CLR.
	LP_IO_PIN2_LP_GPIO2_EDGE_WAKEUP_CLR = 0x8
	// Position of LP_GPIO2_INT_TYPE field.
	LP_IO_PIN2_LP_GPIO2_INT_TYPE_Pos = 0x7
	// Bit mask of LP_GPIO2_INT_TYPE field.
	LP_IO_PIN2_LP_GPIO2_INT_TYPE_Msk = 0x380
	// Position of LP_GPIO2_WAKEUP_ENABLE field.
	LP_IO_PIN2_LP_GPIO2_WAKEUP_ENABLE_Pos = 0xa
	// Bit mask of LP_GPIO2_WAKEUP_ENABLE field.
	LP_IO_PIN2_LP_GPIO2_WAKEUP_ENABLE_Msk = 0x400
	// Bit LP_GPIO2_WAKEUP_ENABLE.
	LP_IO_PIN2_LP_GPIO2_WAKEUP_ENABLE = 0x400
	// Position of LP_GPIO2_FILTER_EN field.
	LP_IO_PIN2_LP_GPIO2_FILTER_EN_Pos = 0xb
	// Bit mask of LP_GPIO2_FILTER_EN field.
	LP_IO_PIN2_LP_GPIO2_FILTER_EN_Msk = 0x800
	// Bit LP_GPIO2_FILTER_EN.
	LP_IO_PIN2_LP_GPIO2_FILTER_EN = 0x800

	// PIN3: need des
	// Position of LP_GPIO3_SYNC_BYPASS field.
	LP_IO_PIN3_LP_GPIO3_SYNC_BYPASS_Pos = 0x0
	// Bit mask of LP_GPIO3_SYNC_BYPASS field.
	LP_IO_PIN3_LP_GPIO3_SYNC_BYPASS_Msk = 0x3
	// Position of LP_GPIO3_PAD_DRIVER field.
	LP_IO_PIN3_LP_GPIO3_PAD_DRIVER_Pos = 0x2
	// Bit mask of LP_GPIO3_PAD_DRIVER field.
	LP_IO_PIN3_LP_GPIO3_PAD_DRIVER_Msk = 0x4
	// Bit LP_GPIO3_PAD_DRIVER.
	LP_IO_PIN3_LP_GPIO3_PAD_DRIVER = 0x4
	// Position of LP_GPIO3_EDGE_WAKEUP_CLR field.
	LP_IO_PIN3_LP_GPIO3_EDGE_WAKEUP_CLR_Pos = 0x3
	// Bit mask of LP_GPIO3_EDGE_WAKEUP_CLR field.
	LP_IO_PIN3_LP_GPIO3_EDGE_WAKEUP_CLR_Msk = 0x8
	// Bit LP_GPIO3_EDGE_WAKEUP_CLR.
	LP_IO_PIN3_LP_GPIO3_EDGE_WAKEUP_CLR = 0x8
	// Position of LP_GPIO3_INT_TYPE field.
	LP_IO_PIN3_LP_GPIO3_INT_TYPE_Pos = 0x7
	// Bit mask of LP_GPIO3_INT_TYPE field.
	LP_IO_PIN3_LP_GPIO3_INT_TYPE_Msk = 0x380
	// Position of LP_GPIO3_WAKEUP_ENABLE field.
	LP_IO_PIN3_LP_GPIO3_WAKEUP_ENABLE_Pos = 0xa
	// Bit mask of LP_GPIO3_WAKEUP_ENABLE field.
	LP_IO_PIN3_LP_GPIO3_WAKEUP_ENABLE_Msk = 0x400
	// Bit LP_GPIO3_WAKEUP_ENABLE.
	LP_IO_PIN3_LP_GPIO3_WAKEUP_ENABLE = 0x400
	// Position of LP_GPIO3_FILTER_EN field.
	LP_IO_PIN3_LP_GPIO3_FILTER_EN_Pos = 0xb
	// Bit mask of LP_GPIO3_FILTER_EN field.
	LP_IO_PIN3_LP_GPIO3_FILTER_EN_Msk = 0x800
	// Bit LP_GPIO3_FILTER_EN.
	LP_IO_PIN3_LP_GPIO3_FILTER_EN = 0x800

	// PIN4: need des
	// Position of LP_GPIO4_SYNC_BYPASS field.
	LP_IO_PIN4_LP_GPIO4_SYNC_BYPASS_Pos = 0x0
	// Bit mask of LP_GPIO4_SYNC_BYPASS field.
	LP_IO_PIN4_LP_GPIO4_SYNC_BYPASS_Msk = 0x3
	// Position of LP_GPIO4_PAD_DRIVER field.
	LP_IO_PIN4_LP_GPIO4_PAD_DRIVER_Pos = 0x2
	// Bit mask of LP_GPIO4_PAD_DRIVER field.
	LP_IO_PIN4_LP_GPIO4_PAD_DRIVER_Msk = 0x4
	// Bit LP_GPIO4_PAD_DRIVER.
	LP_IO_PIN4_LP_GPIO4_PAD_DRIVER = 0x4
	// Position of LP_GPIO4_EDGE_WAKEUP_CLR field.
	LP_IO_PIN4_LP_GPIO4_EDGE_WAKEUP_CLR_Pos = 0x3
	// Bit mask of LP_GPIO4_EDGE_WAKEUP_CLR field.
	LP_IO_PIN4_LP_GPIO4_EDGE_WAKEUP_CLR_Msk = 0x8
	// Bit LP_GPIO4_EDGE_WAKEUP_CLR.
	LP_IO_PIN4_LP_GPIO4_EDGE_WAKEUP_CLR = 0x8
	// Position of LP_GPIO4_INT_TYPE field.
	LP_IO_PIN4_LP_GPIO4_INT_TYPE_Pos = 0x7
	// Bit mask of LP_GPIO4_INT_TYPE field.
	LP_IO_PIN4_LP_GPIO4_INT_TYPE_Msk = 0x380
	// Position of LP_GPIO4_WAKEUP_ENABLE field.
	LP_IO_PIN4_LP_GPIO4_WAKEUP_ENABLE_Pos = 0xa
	// Bit mask of LP_GPIO4_WAKEUP_ENABLE field.
	LP_IO_PIN4_LP_GPIO4_WAKEUP_ENABLE_Msk = 0x400
	// Bit LP_GPIO4_WAKEUP_ENABLE.
	LP_IO_PIN4_LP_GPIO4_WAKEUP_ENABLE = 0x400
	// Position of LP_GPIO4_FILTER_EN field.
	LP_IO_PIN4_LP_GPIO4_FILTER_EN_Pos = 0xb
	// Bit mask of LP_GPIO4_FILTER_EN field.
	LP_IO_PIN4_LP_GPIO4_FILTER_EN_Msk = 0x800
	// Bit LP_GPIO4_FILTER_EN.
	LP_IO_PIN4_LP_GPIO4_FILTER_EN = 0x800

	// PIN5: need des
	// Position of LP_GPIO5_SYNC_BYPASS field.
	LP_IO_PIN5_LP_GPIO5_SYNC_BYPASS_Pos = 0x0
	// Bit mask of LP_GPIO5_SYNC_BYPASS field.
	LP_IO_PIN5_LP_GPIO5_SYNC_BYPASS_Msk = 0x3
	// Position of LP_GPIO5_PAD_DRIVER field.
	LP_IO_PIN5_LP_GPIO5_PAD_DRIVER_Pos = 0x2
	// Bit mask of LP_GPIO5_PAD_DRIVER field.
	LP_IO_PIN5_LP_GPIO5_PAD_DRIVER_Msk = 0x4
	// Bit LP_GPIO5_PAD_DRIVER.
	LP_IO_PIN5_LP_GPIO5_PAD_DRIVER = 0x4
	// Position of LP_GPIO5_EDGE_WAKEUP_CLR field.
	LP_IO_PIN5_LP_GPIO5_EDGE_WAKEUP_CLR_Pos = 0x3
	// Bit mask of LP_GPIO5_EDGE_WAKEUP_CLR field.
	LP_IO_PIN5_LP_GPIO5_EDGE_WAKEUP_CLR_Msk = 0x8
	// Bit LP_GPIO5_EDGE_WAKEUP_CLR.
	LP_IO_PIN5_LP_GPIO5_EDGE_WAKEUP_CLR = 0x8
	// Position of LP_GPIO5_INT_TYPE field.
	LP_IO_PIN5_LP_GPIO5_INT_TYPE_Pos = 0x7
	// Bit mask of LP_GPIO5_INT_TYPE field.
	LP_IO_PIN5_LP_GPIO5_INT_TYPE_Msk = 0x380
	// Position of LP_GPIO5_WAKEUP_ENABLE field.
	LP_IO_PIN5_LP_GPIO5_WAKEUP_ENABLE_Pos = 0xa
	// Bit mask of LP_GPIO5_WAKEUP_ENABLE field.
	LP_IO_PIN5_LP_GPIO5_WAKEUP_ENABLE_Msk = 0x400
	// Bit LP_GPIO5_WAKEUP_ENABLE.
	LP_IO_PIN5_LP_GPIO5_WAKEUP_ENABLE = 0x400
	// Position of LP_GPIO5_FILTER_EN field.
	LP_IO_PIN5_LP_GPIO5_FILTER_EN_Pos = 0xb
	// Bit mask of LP_GPIO5_FILTER_EN field.
	LP_IO_PIN5_LP_GPIO5_FILTER_EN_Msk = 0x800
	// Bit LP_GPIO5_FILTER_EN.
	LP_IO_PIN5_LP_GPIO5_FILTER_EN = 0x800

	// PIN6: need des
	// Position of LP_GPIO6_SYNC_BYPASS field.
	LP_IO_PIN6_LP_GPIO6_SYNC_BYPASS_Pos = 0x0
	// Bit mask of LP_GPIO6_SYNC_BYPASS field.
	LP_IO_PIN6_LP_GPIO6_SYNC_BYPASS_Msk = 0x3
	// Position of LP_GPIO6_PAD_DRIVER field.
	LP_IO_PIN6_LP_GPIO6_PAD_DRIVER_Pos = 0x2
	// Bit mask of LP_GPIO6_PAD_DRIVER field.
	LP_IO_PIN6_LP_GPIO6_PAD_DRIVER_Msk = 0x4
	// Bit LP_GPIO6_PAD_DRIVER.
	LP_IO_PIN6_LP_GPIO6_PAD_DRIVER = 0x4
	// Position of LP_GPIO6_EDGE_WAKEUP_CLR field.
	LP_IO_PIN6_LP_GPIO6_EDGE_WAKEUP_CLR_Pos = 0x3
	// Bit mask of LP_GPIO6_EDGE_WAKEUP_CLR field.
	LP_IO_PIN6_LP_GPIO6_EDGE_WAKEUP_CLR_Msk = 0x8
	// Bit LP_GPIO6_EDGE_WAKEUP_CLR.
	LP_IO_PIN6_LP_GPIO6_EDGE_WAKEUP_CLR = 0x8
	// Position of LP_GPIO6_INT_TYPE field.
	LP_IO_PIN6_LP_GPIO6_INT_TYPE_Pos = 0x7
	// Bit mask of LP_GPIO6_INT_TYPE field.
	LP_IO_PIN6_LP_GPIO6_INT_TYPE_Msk = 0x380
	// Position of LP_GPIO6_WAKEUP_ENABLE field.
	LP_IO_PIN6_LP_GPIO6_WAKEUP_ENABLE_Pos = 0xa
	// Bit mask of LP_GPIO6_WAKEUP_ENABLE field.
	LP_IO_PIN6_LP_GPIO6_WAKEUP_ENABLE_Msk = 0x400
	// Bit LP_GPIO6_WAKEUP_ENABLE.
	LP_IO_PIN6_LP_GPIO6_WAKEUP_ENABLE = 0x400
	// Position of LP_GPIO6_FILTER_EN field.
	LP_IO_PIN6_LP_GPIO6_FILTER_EN_Pos = 0xb
	// Bit mask of LP_GPIO6_FILTER_EN field.
	LP_IO_PIN6_LP_GPIO6_FILTER_EN_Msk = 0x800
	// Bit LP_GPIO6_FILTER_EN.
	LP_IO_PIN6_LP_GPIO6_FILTER_EN = 0x800

	// PIN7: need des
	// Position of LP_GPIO7_SYNC_BYPASS field.
	LP_IO_PIN7_LP_GPIO7_SYNC_BYPASS_Pos = 0x0
	// Bit mask of LP_GPIO7_SYNC_BYPASS field.
	LP_IO_PIN7_LP_GPIO7_SYNC_BYPASS_Msk = 0x3
	// Position of LP_GPIO7_PAD_DRIVER field.
	LP_IO_PIN7_LP_GPIO7_PAD_DRIVER_Pos = 0x2
	// Bit mask of LP_GPIO7_PAD_DRIVER field.
	LP_IO_PIN7_LP_GPIO7_PAD_DRIVER_Msk = 0x4
	// Bit LP_GPIO7_PAD_DRIVER.
	LP_IO_PIN7_LP_GPIO7_PAD_DRIVER = 0x4
	// Position of LP_GPIO7_EDGE_WAKEUP_CLR field.
	LP_IO_PIN7_LP_GPIO7_EDGE_WAKEUP_CLR_Pos = 0x3
	// Bit mask of LP_GPIO7_EDGE_WAKEUP_CLR field.
	LP_IO_PIN7_LP_GPIO7_EDGE_WAKEUP_CLR_Msk = 0x8
	// Bit LP_GPIO7_EDGE_WAKEUP_CLR.
	LP_IO_PIN7_LP_GPIO7_EDGE_WAKEUP_CLR = 0x8
	// Position of LP_GPIO7_INT_TYPE field.
	LP_IO_PIN7_LP_GPIO7_INT_TYPE_Pos = 0x7
	// Bit mask of LP_GPIO7_INT_TYPE field.
	LP_IO_PIN7_LP_GPIO7_INT_TYPE_Msk = 0x380
	// Position of LP_GPIO7_WAKEUP_ENABLE field.
	LP_IO_PIN7_LP_GPIO7_WAKEUP_ENABLE_Pos = 0xa
	// Bit mask of LP_GPIO7_WAKEUP_ENABLE field.
	LP_IO_PIN7_LP_GPIO7_WAKEUP_ENABLE_Msk = 0x400
	// Bit LP_GPIO7_WAKEUP_ENABLE.
	LP_IO_PIN7_LP_GPIO7_WAKEUP_ENABLE = 0x400
	// Position of LP_GPIO7_FILTER_EN field.
	LP_IO_PIN7_LP_GPIO7_FILTER_EN_Pos = 0xb
	// Bit mask of LP_GPIO7_FILTER_EN field.
	LP_IO_PIN7_LP_GPIO7_FILTER_EN_Msk = 0x800
	// Bit LP_GPIO7_FILTER_EN.
	LP_IO_PIN7_LP_GPIO7_FILTER_EN = 0x800

	// GPIO0: need des
	// Position of LP_GPIO0_MCU_OE field.
	LP_IO_GPIO0_LP_GPIO0_MCU_OE_Pos = 0x0
	// Bit mask of LP_GPIO0_MCU_OE field.
	LP_IO_GPIO0_LP_GPIO0_MCU_OE_Msk = 0x1
	// Bit LP_GPIO0_MCU_OE.
	LP_IO_GPIO0_LP_GPIO0_MCU_OE = 0x1
	// Position of LP_GPIO0_SLP_SEL field.
	LP_IO_GPIO0_LP_GPIO0_SLP_SEL_Pos = 0x1
	// Bit mask of LP_GPIO0_SLP_SEL field.
	LP_IO_GPIO0_LP_GPIO0_SLP_SEL_Msk = 0x2
	// Bit LP_GPIO0_SLP_SEL.
	LP_IO_GPIO0_LP_GPIO0_SLP_SEL = 0x2
	// Position of LP_GPIO0_MCU_WPD field.
	LP_IO_GPIO0_LP_GPIO0_MCU_WPD_Pos = 0x2
	// Bit mask of LP_GPIO0_MCU_WPD field.
	LP_IO_GPIO0_LP_GPIO0_MCU_WPD_Msk = 0x4
	// Bit LP_GPIO0_MCU_WPD.
	LP_IO_GPIO0_LP_GPIO0_MCU_WPD = 0x4
	// Position of LP_GPIO0_MCU_WPU field.
	LP_IO_GPIO0_LP_GPIO0_MCU_WPU_Pos = 0x3
	// Bit mask of LP_GPIO0_MCU_WPU field.
	LP_IO_GPIO0_LP_GPIO0_MCU_WPU_Msk = 0x8
	// Bit LP_GPIO0_MCU_WPU.
	LP_IO_GPIO0_LP_GPIO0_MCU_WPU = 0x8
	// Position of LP_GPIO0_MCU_IE field.
	LP_IO_GPIO0_LP_GPIO0_MCU_IE_Pos = 0x4
	// Bit mask of LP_GPIO0_MCU_IE field.
	LP_IO_GPIO0_LP_GPIO0_MCU_IE_Msk = 0x10
	// Bit LP_GPIO0_MCU_IE.
	LP_IO_GPIO0_LP_GPIO0_MCU_IE = 0x10
	// Position of LP_GPIO0_MCU_DRV field.
	LP_IO_GPIO0_LP_GPIO0_MCU_DRV_Pos = 0x5
	// Bit mask of LP_GPIO0_MCU_DRV field.
	LP_IO_GPIO0_LP_GPIO0_MCU_DRV_Msk = 0x60
	// Position of LP_GPIO0_FUN_WPD field.
	LP_IO_GPIO0_LP_GPIO0_FUN_WPD_Pos = 0x7
	// Bit mask of LP_GPIO0_FUN_WPD field.
	LP_IO_GPIO0_LP_GPIO0_FUN_WPD_Msk = 0x80
	// Bit LP_GPIO0_FUN_WPD.
	LP_IO_GPIO0_LP_GPIO0_FUN_WPD = 0x80
	// Position of LP_GPIO0_FUN_WPU field.
	LP_IO_GPIO0_LP_GPIO0_FUN_WPU_Pos = 0x8
	// Bit mask of LP_GPIO0_FUN_WPU field.
	LP_IO_GPIO0_LP_GPIO0_FUN_WPU_Msk = 0x100
	// Bit LP_GPIO0_FUN_WPU.
	LP_IO_GPIO0_LP_GPIO0_FUN_WPU = 0x100
	// Position of LP_GPIO0_FUN_IE field.
	LP_IO_GPIO0_LP_GPIO0_FUN_IE_Pos = 0x9
	// Bit mask of LP_GPIO0_FUN_IE field.
	LP_IO_GPIO0_LP_GPIO0_FUN_IE_Msk = 0x200
	// Bit LP_GPIO0_FUN_IE.
	LP_IO_GPIO0_LP_GPIO0_FUN_IE = 0x200
	// Position of LP_GPIO0_FUN_DRV field.
	LP_IO_GPIO0_LP_GPIO0_FUN_DRV_Pos = 0xa
	// Bit mask of LP_GPIO0_FUN_DRV field.
	LP_IO_GPIO0_LP_GPIO0_FUN_DRV_Msk = 0xc00
	// Position of LP_GPIO0_MCU_SEL field.
	LP_IO_GPIO0_LP_GPIO0_MCU_SEL_Pos = 0xc
	// Bit mask of LP_GPIO0_MCU_SEL field.
	LP_IO_GPIO0_LP_GPIO0_MCU_SEL_Msk = 0x7000

	// GPIO1: need des
	// Position of LP_GPIO1_MCU_OE field.
	LP_IO_GPIO1_LP_GPIO1_MCU_OE_Pos = 0x0
	// Bit mask of LP_GPIO1_MCU_OE field.
	LP_IO_GPIO1_LP_GPIO1_MCU_OE_Msk = 0x1
	// Bit LP_GPIO1_MCU_OE.
	LP_IO_GPIO1_LP_GPIO1_MCU_OE = 0x1
	// Position of LP_GPIO1_SLP_SEL field.
	LP_IO_GPIO1_LP_GPIO1_SLP_SEL_Pos = 0x1
	// Bit mask of LP_GPIO1_SLP_SEL field.
	LP_IO_GPIO1_LP_GPIO1_SLP_SEL_Msk = 0x2
	// Bit LP_GPIO1_SLP_SEL.
	LP_IO_GPIO1_LP_GPIO1_SLP_SEL = 0x2
	// Position of LP_GPIO1_MCU_WPD field.
	LP_IO_GPIO1_LP_GPIO1_MCU_WPD_Pos = 0x2
	// Bit mask of LP_GPIO1_MCU_WPD field.
	LP_IO_GPIO1_LP_GPIO1_MCU_WPD_Msk = 0x4
	// Bit LP_GPIO1_MCU_WPD.
	LP_IO_GPIO1_LP_GPIO1_MCU_WPD = 0x4
	// Position of LP_GPIO1_MCU_WPU field.
	LP_IO_GPIO1_LP_GPIO1_MCU_WPU_Pos = 0x3
	// Bit mask of LP_GPIO1_MCU_WPU field.
	LP_IO_GPIO1_LP_GPIO1_MCU_WPU_Msk = 0x8
	// Bit LP_GPIO1_MCU_WPU.
	LP_IO_GPIO1_LP_GPIO1_MCU_WPU = 0x8
	// Position of LP_GPIO1_MCU_IE field.
	LP_IO_GPIO1_LP_GPIO1_MCU_IE_Pos = 0x4
	// Bit mask of LP_GPIO1_MCU_IE field.
	LP_IO_GPIO1_LP_GPIO1_MCU_IE_Msk = 0x10
	// Bit LP_GPIO1_MCU_IE.
	LP_IO_GPIO1_LP_GPIO1_MCU_IE = 0x10
	// Position of LP_GPIO1_MCU_DRV field.
	LP_IO_GPIO1_LP_GPIO1_MCU_DRV_Pos = 0x5
	// Bit mask of LP_GPIO1_MCU_DRV field.
	LP_IO_GPIO1_LP_GPIO1_MCU_DRV_Msk = 0x60
	// Position of LP_GPIO1_FUN_WPD field.
	LP_IO_GPIO1_LP_GPIO1_FUN_WPD_Pos = 0x7
	// Bit mask of LP_GPIO1_FUN_WPD field.
	LP_IO_GPIO1_LP_GPIO1_FUN_WPD_Msk = 0x80
	// Bit LP_GPIO1_FUN_WPD.
	LP_IO_GPIO1_LP_GPIO1_FUN_WPD = 0x80
	// Position of LP_GPIO1_FUN_WPU field.
	LP_IO_GPIO1_LP_GPIO1_FUN_WPU_Pos = 0x8
	// Bit mask of LP_GPIO1_FUN_WPU field.
	LP_IO_GPIO1_LP_GPIO1_FUN_WPU_Msk = 0x100
	// Bit LP_GPIO1_FUN_WPU.
	LP_IO_GPIO1_LP_GPIO1_FUN_WPU = 0x100
	// Position of LP_GPIO1_FUN_IE field.
	LP_IO_GPIO1_LP_GPIO1_FUN_IE_Pos = 0x9
	// Bit mask of LP_GPIO1_FUN_IE field.
	LP_IO_GPIO1_LP_GPIO1_FUN_IE_Msk = 0x200
	// Bit LP_GPIO1_FUN_IE.
	LP_IO_GPIO1_LP_GPIO1_FUN_IE = 0x200
	// Position of LP_GPIO1_FUN_DRV field.
	LP_IO_GPIO1_LP_GPIO1_FUN_DRV_Pos = 0xa
	// Bit mask of LP_GPIO1_FUN_DRV field.
	LP_IO_GPIO1_LP_GPIO1_FUN_DRV_Msk = 0xc00
	// Position of LP_GPIO1_MCU_SEL field.
	LP_IO_GPIO1_LP_GPIO1_MCU_SEL_Pos = 0xc
	// Bit mask of LP_GPIO1_MCU_SEL field.
	LP_IO_GPIO1_LP_GPIO1_MCU_SEL_Msk = 0x7000

	// GPIO2: need des
	// Position of LP_GPIO2_MCU_OE field.
	LP_IO_GPIO2_LP_GPIO2_MCU_OE_Pos = 0x0
	// Bit mask of LP_GPIO2_MCU_OE field.
	LP_IO_GPIO2_LP_GPIO2_MCU_OE_Msk = 0x1
	// Bit LP_GPIO2_MCU_OE.
	LP_IO_GPIO2_LP_GPIO2_MCU_OE = 0x1
	// Position of LP_GPIO2_SLP_SEL field.
	LP_IO_GPIO2_LP_GPIO2_SLP_SEL_Pos = 0x1
	// Bit mask of LP_GPIO2_SLP_SEL field.
	LP_IO_GPIO2_LP_GPIO2_SLP_SEL_Msk = 0x2
	// Bit LP_GPIO2_SLP_SEL.
	LP_IO_GPIO2_LP_GPIO2_SLP_SEL = 0x2
	// Position of LP_GPIO2_MCU_WPD field.
	LP_IO_GPIO2_LP_GPIO2_MCU_WPD_Pos = 0x2
	// Bit mask of LP_GPIO2_MCU_WPD field.
	LP_IO_GPIO2_LP_GPIO2_MCU_WPD_Msk = 0x4
	// Bit LP_GPIO2_MCU_WPD.
	LP_IO_GPIO2_LP_GPIO2_MCU_WPD = 0x4
	// Position of LP_GPIO2_MCU_WPU field.
	LP_IO_GPIO2_LP_GPIO2_MCU_WPU_Pos = 0x3
	// Bit mask of LP_GPIO2_MCU_WPU field.
	LP_IO_GPIO2_LP_GPIO2_MCU_WPU_Msk = 0x8
	// Bit LP_GPIO2_MCU_WPU.
	LP_IO_GPIO2_LP_GPIO2_MCU_WPU = 0x8
	// Position of LP_GPIO2_MCU_IE field.
	LP_IO_GPIO2_LP_GPIO2_MCU_IE_Pos = 0x4
	// Bit mask of LP_GPIO2_MCU_IE field.
	LP_IO_GPIO2_LP_GPIO2_MCU_IE_Msk = 0x10
	// Bit LP_GPIO2_MCU_IE.
	LP_IO_GPIO2_LP_GPIO2_MCU_IE = 0x10
	// Position of LP_GPIO2_MCU_DRV field.
	LP_IO_GPIO2_LP_GPIO2_MCU_DRV_Pos = 0x5
	// Bit mask of LP_GPIO2_MCU_DRV field.
	LP_IO_GPIO2_LP_GPIO2_MCU_DRV_Msk = 0x60
	// Position of LP_GPIO2_FUN_WPD field.
	LP_IO_GPIO2_LP_GPIO2_FUN_WPD_Pos = 0x7
	// Bit mask of LP_GPIO2_FUN_WPD field.
	LP_IO_GPIO2_LP_GPIO2_FUN_WPD_Msk = 0x80
	// Bit LP_GPIO2_FUN_WPD.
	LP_IO_GPIO2_LP_GPIO2_FUN_WPD = 0x80
	// Position of LP_GPIO2_FUN_WPU field.
	LP_IO_GPIO2_LP_GPIO2_FUN_WPU_Pos = 0x8
	// Bit mask of LP_GPIO2_FUN_WPU field.
	LP_IO_GPIO2_LP_GPIO2_FUN_WPU_Msk = 0x100
	// Bit LP_GPIO2_FUN_WPU.
	LP_IO_GPIO2_LP_GPIO2_FUN_WPU = 0x100
	// Position of LP_GPIO2_FUN_IE field.
	LP_IO_GPIO2_LP_GPIO2_FUN_IE_Pos = 0x9
	// Bit mask of LP_GPIO2_FUN_IE field.
	LP_IO_GPIO2_LP_GPIO2_FUN_IE_Msk = 0x200
	// Bit LP_GPIO2_FUN_IE.
	LP_IO_GPIO2_LP_GPIO2_FUN_IE = 0x200
	// Position of LP_GPIO2_FUN_DRV field.
	LP_IO_GPIO2_LP_GPIO2_FUN_DRV_Pos = 0xa
	// Bit mask of LP_GPIO2_FUN_DRV field.
	LP_IO_GPIO2_LP_GPIO2_FUN_DRV_Msk = 0xc00
	// Position of LP_GPIO2_MCU_SEL field.
	LP_IO_GPIO2_LP_GPIO2_MCU_SEL_Pos = 0xc
	// Bit mask of LP_GPIO2_MCU_SEL field.
	LP_IO_GPIO2_LP_GPIO2_MCU_SEL_Msk = 0x7000

	// GPIO3: need des
	// Position of LP_GPIO3_MCU_OE field.
	LP_IO_GPIO3_LP_GPIO3_MCU_OE_Pos = 0x0
	// Bit mask of LP_GPIO3_MCU_OE field.
	LP_IO_GPIO3_LP_GPIO3_MCU_OE_Msk = 0x1
	// Bit LP_GPIO3_MCU_OE.
	LP_IO_GPIO3_LP_GPIO3_MCU_OE = 0x1
	// Position of LP_GPIO3_SLP_SEL field.
	LP_IO_GPIO3_LP_GPIO3_SLP_SEL_Pos = 0x1
	// Bit mask of LP_GPIO3_SLP_SEL field.
	LP_IO_GPIO3_LP_GPIO3_SLP_SEL_Msk = 0x2
	// Bit LP_GPIO3_SLP_SEL.
	LP_IO_GPIO3_LP_GPIO3_SLP_SEL = 0x2
	// Position of LP_GPIO3_MCU_WPD field.
	LP_IO_GPIO3_LP_GPIO3_MCU_WPD_Pos = 0x2
	// Bit mask of LP_GPIO3_MCU_WPD field.
	LP_IO_GPIO3_LP_GPIO3_MCU_WPD_Msk = 0x4
	// Bit LP_GPIO3_MCU_WPD.
	LP_IO_GPIO3_LP_GPIO3_MCU_WPD = 0x4
	// Position of LP_GPIO3_MCU_WPU field.
	LP_IO_GPIO3_LP_GPIO3_MCU_WPU_Pos = 0x3
	// Bit mask of LP_GPIO3_MCU_WPU field.
	LP_IO_GPIO3_LP_GPIO3_MCU_WPU_Msk = 0x8
	// Bit LP_GPIO3_MCU_WPU.
	LP_IO_GPIO3_LP_GPIO3_MCU_WPU = 0x8
	// Position of LP_GPIO3_MCU_IE field.
	LP_IO_GPIO3_LP_GPIO3_MCU_IE_Pos = 0x4
	// Bit mask of LP_GPIO3_MCU_IE field.
	LP_IO_GPIO3_LP_GPIO3_MCU_IE_Msk = 0x10
	// Bit LP_GPIO3_MCU_IE.
	LP_IO_GPIO3_LP_GPIO3_MCU_IE = 0x10
	// Position of LP_GPIO3_MCU_DRV field.
	LP_IO_GPIO3_LP_GPIO3_MCU_DRV_Pos = 0x5
	// Bit mask of LP_GPIO3_MCU_DRV field.
	LP_IO_GPIO3_LP_GPIO3_MCU_DRV_Msk = 0x60
	// Position of LP_GPIO3_FUN_WPD field.
	LP_IO_GPIO3_LP_GPIO3_FUN_WPD_Pos = 0x7
	// Bit mask of LP_GPIO3_FUN_WPD field.
	LP_IO_GPIO3_LP_GPIO3_FUN_WPD_Msk = 0x80
	// Bit LP_GPIO3_FUN_WPD.
	LP_IO_GPIO3_LP_GPIO3_FUN_WPD = 0x80
	// Position of LP_GPIO3_FUN_WPU field.
	LP_IO_GPIO3_LP_GPIO3_FUN_WPU_Pos = 0x8
	// Bit mask of LP_GPIO3_FUN_WPU field.
	LP_IO_GPIO3_LP_GPIO3_FUN_WPU_Msk = 0x100
	// Bit LP_GPIO3_FUN_WPU.
	LP_IO_GPIO3_LP_GPIO3_FUN_WPU = 0x100
	// Position of LP_GPIO3_FUN_IE field.
	LP_IO_GPIO3_LP_GPIO3_FUN_IE_Pos = 0x9
	// Bit mask of LP_GPIO3_FUN_IE field.
	LP_IO_GPIO3_LP_GPIO3_FUN_IE_Msk = 0x200
	// Bit LP_GPIO3_FUN_IE.
	LP_IO_GPIO3_LP_GPIO3_FUN_IE = 0x200
	// Position of LP_GPIO3_FUN_DRV field.
	LP_IO_GPIO3_LP_GPIO3_FUN_DRV_Pos = 0xa
	// Bit mask of LP_GPIO3_FUN_DRV field.
	LP_IO_GPIO3_LP_GPIO3_FUN_DRV_Msk = 0xc00
	// Position of LP_GPIO3_MCU_SEL field.
	LP_IO_GPIO3_LP_GPIO3_MCU_SEL_Pos = 0xc
	// Bit mask of LP_GPIO3_MCU_SEL field.
	LP_IO_GPIO3_LP_GPIO3_MCU_SEL_Msk = 0x7000

	// GPIO4: need des
	// Position of LP_GPIO4_MCU_OE field.
	LP_IO_GPIO4_LP_GPIO4_MCU_OE_Pos = 0x0
	// Bit mask of LP_GPIO4_MCU_OE field.
	LP_IO_GPIO4_LP_GPIO4_MCU_OE_Msk = 0x1
	// Bit LP_GPIO4_MCU_OE.
	LP_IO_GPIO4_LP_GPIO4_MCU_OE = 0x1
	// Position of LP_GPIO4_SLP_SEL field.
	LP_IO_GPIO4_LP_GPIO4_SLP_SEL_Pos = 0x1
	// Bit mask of LP_GPIO4_SLP_SEL field.
	LP_IO_GPIO4_LP_GPIO4_SLP_SEL_Msk = 0x2
	// Bit LP_GPIO4_SLP_SEL.
	LP_IO_GPIO4_LP_GPIO4_SLP_SEL = 0x2
	// Position of LP_GPIO4_MCU_WPD field.
	LP_IO_GPIO4_LP_GPIO4_MCU_WPD_Pos = 0x2
	// Bit mask of LP_GPIO4_MCU_WPD field.
	LP_IO_GPIO4_LP_GPIO4_MCU_WPD_Msk = 0x4
	// Bit LP_GPIO4_MCU_WPD.
	LP_IO_GPIO4_LP_GPIO4_MCU_WPD = 0x4
	// Position of LP_GPIO4_MCU_WPU field.
	LP_IO_GPIO4_LP_GPIO4_MCU_WPU_Pos = 0x3
	// Bit mask of LP_GPIO4_MCU_WPU field.
	LP_IO_GPIO4_LP_GPIO4_MCU_WPU_Msk = 0x8
	// Bit LP_GPIO4_MCU_WPU.
	LP_IO_GPIO4_LP_GPIO4_MCU_WPU = 0x8
	// Position of LP_GPIO4_MCU_IE field.
	LP_IO_GPIO4_LP_GPIO4_MCU_IE_Pos = 0x4
	// Bit mask of LP_GPIO4_MCU_IE field.
	LP_IO_GPIO4_LP_GPIO4_MCU_IE_Msk = 0x10
	// Bit LP_GPIO4_MCU_IE.
	LP_IO_GPIO4_LP_GPIO4_MCU_IE = 0x10
	// Position of LP_GPIO4_MCU_DRV field.
	LP_IO_GPIO4_LP_GPIO4_MCU_DRV_Pos = 0x5
	// Bit mask of LP_GPIO4_MCU_DRV field.
	LP_IO_GPIO4_LP_GPIO4_MCU_DRV_Msk = 0x60
	// Position of LP_GPIO4_FUN_WPD field.
	LP_IO_GPIO4_LP_GPIO4_FUN_WPD_Pos = 0x7
	// Bit mask of LP_GPIO4_FUN_WPD field.
	LP_IO_GPIO4_LP_GPIO4_FUN_WPD_Msk = 0x80
	// Bit LP_GPIO4_FUN_WPD.
	LP_IO_GPIO4_LP_GPIO4_FUN_WPD = 0x80
	// Position of LP_GPIO4_FUN_WPU field.
	LP_IO_GPIO4_LP_GPIO4_FUN_WPU_Pos = 0x8
	// Bit mask of LP_GPIO4_FUN_WPU field.
	LP_IO_GPIO4_LP_GPIO4_FUN_WPU_Msk = 0x100
	// Bit LP_GPIO4_FUN_WPU.
	LP_IO_GPIO4_LP_GPIO4_FUN_WPU = 0x100
	// Position of LP_GPIO4_FUN_IE field.
	LP_IO_GPIO4_LP_GPIO4_FUN_IE_Pos = 0x9
	// Bit mask of LP_GPIO4_FUN_IE field.
	LP_IO_GPIO4_LP_GPIO4_FUN_IE_Msk = 0x200
	// Bit LP_GPIO4_FUN_IE.
	LP_IO_GPIO4_LP_GPIO4_FUN_IE = 0x200
	// Position of LP_GPIO4_FUN_DRV field.
	LP_IO_GPIO4_LP_GPIO4_FUN_DRV_Pos = 0xa
	// Bit mask of LP_GPIO4_FUN_DRV field.
	LP_IO_GPIO4_LP_GPIO4_FUN_DRV_Msk = 0xc00
	// Position of LP_GPIO4_MCU_SEL field.
	LP_IO_GPIO4_LP_GPIO4_MCU_SEL_Pos = 0xc
	// Bit mask of LP_GPIO4_MCU_SEL field.
	LP_IO_GPIO4_LP_GPIO4_MCU_SEL_Msk = 0x7000

	// GPIO5: need des
	// Position of LP_GPIO5_MCU_OE field.
	LP_IO_GPIO5_LP_GPIO5_MCU_OE_Pos = 0x0
	// Bit mask of LP_GPIO5_MCU_OE field.
	LP_IO_GPIO5_LP_GPIO5_MCU_OE_Msk = 0x1
	// Bit LP_GPIO5_MCU_OE.
	LP_IO_GPIO5_LP_GPIO5_MCU_OE = 0x1
	// Position of LP_GPIO5_SLP_SEL field.
	LP_IO_GPIO5_LP_GPIO5_SLP_SEL_Pos = 0x1
	// Bit mask of LP_GPIO5_SLP_SEL field.
	LP_IO_GPIO5_LP_GPIO5_SLP_SEL_Msk = 0x2
	// Bit LP_GPIO5_SLP_SEL.
	LP_IO_GPIO5_LP_GPIO5_SLP_SEL = 0x2
	// Position of LP_GPIO5_MCU_WPD field.
	LP_IO_GPIO5_LP_GPIO5_MCU_WPD_Pos = 0x2
	// Bit mask of LP_GPIO5_MCU_WPD field.
	LP_IO_GPIO5_LP_GPIO5_MCU_WPD_Msk = 0x4
	// Bit LP_GPIO5_MCU_WPD.
	LP_IO_GPIO5_LP_GPIO5_MCU_WPD = 0x4
	// Position of LP_GPIO5_MCU_WPU field.
	LP_IO_GPIO5_LP_GPIO5_MCU_WPU_Pos = 0x3
	// Bit mask of LP_GPIO5_MCU_WPU field.
	LP_IO_GPIO5_LP_GPIO5_MCU_WPU_Msk = 0x8
	// Bit LP_GPIO5_MCU_WPU.
	LP_IO_GPIO5_LP_GPIO5_MCU_WPU = 0x8
	// Position of LP_GPIO5_MCU_IE field.
	LP_IO_GPIO5_LP_GPIO5_MCU_IE_Pos = 0x4
	// Bit mask of LP_GPIO5_MCU_IE field.
	LP_IO_GPIO5_LP_GPIO5_MCU_IE_Msk = 0x10
	// Bit LP_GPIO5_MCU_IE.
	LP_IO_GPIO5_LP_GPIO5_MCU_IE = 0x10
	// Position of LP_GPIO5_MCU_DRV field.
	LP_IO_GPIO5_LP_GPIO5_MCU_DRV_Pos = 0x5
	// Bit mask of LP_GPIO5_MCU_DRV field.
	LP_IO_GPIO5_LP_GPIO5_MCU_DRV_Msk = 0x60
	// Position of LP_GPIO5_FUN_WPD field.
	LP_IO_GPIO5_LP_GPIO5_FUN_WPD_Pos = 0x7
	// Bit mask of LP_GPIO5_FUN_WPD field.
	LP_IO_GPIO5_LP_GPIO5_FUN_WPD_Msk = 0x80
	// Bit LP_GPIO5_FUN_WPD.
	LP_IO_GPIO5_LP_GPIO5_FUN_WPD = 0x80
	// Position of LP_GPIO5_FUN_WPU field.
	LP_IO_GPIO5_LP_GPIO5_FUN_WPU_Pos = 0x8
	// Bit mask of LP_GPIO5_FUN_WPU field.
	LP_IO_GPIO5_LP_GPIO5_FUN_WPU_Msk = 0x100
	// Bit LP_GPIO5_FUN_WPU.
	LP_IO_GPIO5_LP_GPIO5_FUN_WPU = 0x100
	// Position of LP_GPIO5_FUN_IE field.
	LP_IO_GPIO5_LP_GPIO5_FUN_IE_Pos = 0x9
	// Bit mask of LP_GPIO5_FUN_IE field.
	LP_IO_GPIO5_LP_GPIO5_FUN_IE_Msk = 0x200
	// Bit LP_GPIO5_FUN_IE.
	LP_IO_GPIO5_LP_GPIO5_FUN_IE = 0x200
	// Position of LP_GPIO5_FUN_DRV field.
	LP_IO_GPIO5_LP_GPIO5_FUN_DRV_Pos = 0xa
	// Bit mask of LP_GPIO5_FUN_DRV field.
	LP_IO_GPIO5_LP_GPIO5_FUN_DRV_Msk = 0xc00
	// Position of LP_GPIO5_MCU_SEL field.
	LP_IO_GPIO5_LP_GPIO5_MCU_SEL_Pos = 0xc
	// Bit mask of LP_GPIO5_MCU_SEL field.
	LP_IO_GPIO5_LP_GPIO5_MCU_SEL_Msk = 0x7000

	// GPIO6: need des
	// Position of LP_GPIO6_MCU_OE field.
	LP_IO_GPIO6_LP_GPIO6_MCU_OE_Pos = 0x0
	// Bit mask of LP_GPIO6_MCU_OE field.
	LP_IO_GPIO6_LP_GPIO6_MCU_OE_Msk = 0x1
	// Bit LP_GPIO6_MCU_OE.
	LP_IO_GPIO6_LP_GPIO6_MCU_OE = 0x1
	// Position of LP_GPIO6_SLP_SEL field.
	LP_IO_GPIO6_LP_GPIO6_SLP_SEL_Pos = 0x1
	// Bit mask of LP_GPIO6_SLP_SEL field.
	LP_IO_GPIO6_LP_GPIO6_SLP_SEL_Msk = 0x2
	// Bit LP_GPIO6_SLP_SEL.
	LP_IO_GPIO6_LP_GPIO6_SLP_SEL = 0x2
	// Position of LP_GPIO6_MCU_WPD field.
	LP_IO_GPIO6_LP_GPIO6_MCU_WPD_Pos = 0x2
	// Bit mask of LP_GPIO6_MCU_WPD field.
	LP_IO_GPIO6_LP_GPIO6_MCU_WPD_Msk = 0x4
	// Bit LP_GPIO6_MCU_WPD.
	LP_IO_GPIO6_LP_GPIO6_MCU_WPD = 0x4
	// Position of LP_GPIO6_MCU_WPU field.
	LP_IO_GPIO6_LP_GPIO6_MCU_WPU_Pos = 0x3
	// Bit mask of LP_GPIO6_MCU_WPU field.
	LP_IO_GPIO6_LP_GPIO6_MCU_WPU_Msk = 0x8
	// Bit LP_GPIO6_MCU_WPU.
	LP_IO_GPIO6_LP_GPIO6_MCU_WPU = 0x8
	// Position of LP_GPIO6_MCU_IE field.
	LP_IO_GPIO6_LP_GPIO6_MCU_IE_Pos = 0x4
	// Bit mask of LP_GPIO6_MCU_IE field.
	LP_IO_GPIO6_LP_GPIO6_MCU_IE_Msk = 0x10
	// Bit LP_GPIO6_MCU_IE.
	LP_IO_GPIO6_LP_GPIO6_MCU_IE = 0x10
	// Position of LP_GPIO6_MCU_DRV field.
	LP_IO_GPIO6_LP_GPIO6_MCU_DRV_Pos = 0x5
	// Bit mask of LP_GPIO6_MCU_DRV field.
	LP_IO_GPIO6_LP_GPIO6_MCU_DRV_Msk = 0x60
	// Position of LP_GPIO6_FUN_WPD field.
	LP_IO_GPIO6_LP_GPIO6_FUN_WPD_Pos = 0x7
	// Bit mask of LP_GPIO6_FUN_WPD field.
	LP_IO_GPIO6_LP_GPIO6_FUN_WPD_Msk = 0x80
	// Bit LP_GPIO6_FUN_WPD.
	LP_IO_GPIO6_LP_GPIO6_FUN_WPD = 0x80
	// Position of LP_GPIO6_FUN_WPU field.
	LP_IO_GPIO6_LP_GPIO6_FUN_WPU_Pos = 0x8
	// Bit mask of LP_GPIO6_FUN_WPU field.
	LP_IO_GPIO6_LP_GPIO6_FUN_WPU_Msk = 0x100
	// Bit LP_GPIO6_FUN_WPU.
	LP_IO_GPIO6_LP_GPIO6_FUN_WPU = 0x100
	// Position of LP_GPIO6_FUN_IE field.
	LP_IO_GPIO6_LP_GPIO6_FUN_IE_Pos = 0x9
	// Bit mask of LP_GPIO6_FUN_IE field.
	LP_IO_GPIO6_LP_GPIO6_FUN_IE_Msk = 0x200
	// Bit LP_GPIO6_FUN_IE.
	LP_IO_GPIO6_LP_GPIO6_FUN_IE = 0x200
	// Position of LP_GPIO6_FUN_DRV field.
	LP_IO_GPIO6_LP_GPIO6_FUN_DRV_Pos = 0xa
	// Bit mask of LP_GPIO6_FUN_DRV field.
	LP_IO_GPIO6_LP_GPIO6_FUN_DRV_Msk = 0xc00
	// Position of LP_GPIO6_MCU_SEL field.
	LP_IO_GPIO6_LP_GPIO6_MCU_SEL_Pos = 0xc
	// Bit mask of LP_GPIO6_MCU_SEL field.
	LP_IO_GPIO6_LP_GPIO6_MCU_SEL_Msk = 0x7000

	// GPIO7: need des
	// Position of LP_GPIO7_MCU_OE field.
	LP_IO_GPIO7_LP_GPIO7_MCU_OE_Pos = 0x0
	// Bit mask of LP_GPIO7_MCU_OE field.
	LP_IO_GPIO7_LP_GPIO7_MCU_OE_Msk = 0x1
	// Bit LP_GPIO7_MCU_OE.
	LP_IO_GPIO7_LP_GPIO7_MCU_OE = 0x1
	// Position of LP_GPIO7_SLP_SEL field.
	LP_IO_GPIO7_LP_GPIO7_SLP_SEL_Pos = 0x1
	// Bit mask of LP_GPIO7_SLP_SEL field.
	LP_IO_GPIO7_LP_GPIO7_SLP_SEL_Msk = 0x2
	// Bit LP_GPIO7_SLP_SEL.
	LP_IO_GPIO7_LP_GPIO7_SLP_SEL = 0x2
	// Position of LP_GPIO7_MCU_WPD field.
	LP_IO_GPIO7_LP_GPIO7_MCU_WPD_Pos = 0x2
	// Bit mask of LP_GPIO7_MCU_WPD field.
	LP_IO_GPIO7_LP_GPIO7_MCU_WPD_Msk = 0x4
	// Bit LP_GPIO7_MCU_WPD.
	LP_IO_GPIO7_LP_GPIO7_MCU_WPD = 0x4
	// Position of LP_GPIO7_MCU_WPU field.
	LP_IO_GPIO7_LP_GPIO7_MCU_WPU_Pos = 0x3
	// Bit mask of LP_GPIO7_MCU_WPU field.
	LP_IO_GPIO7_LP_GPIO7_MCU_WPU_Msk = 0x8
	// Bit LP_GPIO7_MCU_WPU.
	LP_IO_GPIO7_LP_GPIO7_MCU_WPU = 0x8
	// Position of LP_GPIO7_MCU_IE field.
	LP_IO_GPIO7_LP_GPIO7_MCU_IE_Pos = 0x4
	// Bit mask of LP_GPIO7_MCU_IE field.
	LP_IO_GPIO7_LP_GPIO7_MCU_IE_Msk = 0x10
	// Bit LP_GPIO7_MCU_IE.
	LP_IO_GPIO7_LP_GPIO7_MCU_IE = 0x10
	// Position of LP_GPIO7_MCU_DRV field.
	LP_IO_GPIO7_LP_GPIO7_MCU_DRV_Pos = 0x5
	// Bit mask of LP_GPIO7_MCU_DRV field.
	LP_IO_GPIO7_LP_GPIO7_MCU_DRV_Msk = 0x60
	// Position of LP_GPIO7_FUN_WPD field.
	LP_IO_GPIO7_LP_GPIO7_FUN_WPD_Pos = 0x7
	// Bit mask of LP_GPIO7_FUN_WPD field.
	LP_IO_GPIO7_LP_GPIO7_FUN_WPD_Msk = 0x80
	// Bit LP_GPIO7_FUN_WPD.
	LP_IO_GPIO7_LP_GPIO7_FUN_WPD = 0x80
	// Position of LP_GPIO7_FUN_WPU field.
	LP_IO_GPIO7_LP_GPIO7_FUN_WPU_Pos = 0x8
	// Bit mask of LP_GPIO7_FUN_WPU field.
	LP_IO_GPIO7_LP_GPIO7_FUN_WPU_Msk = 0x100
	// Bit LP_GPIO7_FUN_WPU.
	LP_IO_GPIO7_LP_GPIO7_FUN_WPU = 0x100
	// Position of LP_GPIO7_FUN_IE field.
	LP_IO_GPIO7_LP_GPIO7_FUN_IE_Pos = 0x9
	// Bit mask of LP_GPIO7_FUN_IE field.
	LP_IO_GPIO7_LP_GPIO7_FUN_IE_Msk = 0x200
	// Bit LP_GPIO7_FUN_IE.
	LP_IO_GPIO7_LP_GPIO7_FUN_IE = 0x200
	// Position of LP_GPIO7_FUN_DRV field.
	LP_IO_GPIO7_LP_GPIO7_FUN_DRV_Pos = 0xa
	// Bit mask of LP_GPIO7_FUN_DRV field.
	LP_IO_GPIO7_LP_GPIO7_FUN_DRV_Msk = 0xc00
	// Position of LP_GPIO7_MCU_SEL field.
	LP_IO_GPIO7_LP_GPIO7_MCU_SEL_Pos = 0xc
	// Bit mask of LP_GPIO7_MCU_SEL field.
	LP_IO_GPIO7_LP_GPIO7_MCU_SEL_Msk = 0x7000

	// STATUS_INTERRUPT: need des
	// Position of LP_GPIO_STATUS_INTERRUPT_NEXT field.
	LP_IO_STATUS_INTERRUPT_LP_GPIO_STATUS_INTERRUPT_NEXT_Pos = 0x0
	// Bit mask of LP_GPIO_STATUS_INTERRUPT_NEXT field.
	LP_IO_STATUS_INTERRUPT_LP_GPIO_STATUS_INTERRUPT_NEXT_Msk = 0xff

	// DEBUG_SEL0: need des
	// Position of LP_DEBUG_SEL0 field.
	LP_IO_DEBUG_SEL0_LP_DEBUG_SEL0_Pos = 0x0
	// Bit mask of LP_DEBUG_SEL0 field.
	LP_IO_DEBUG_SEL0_LP_DEBUG_SEL0_Msk = 0x7f
	// Position of LP_DEBUG_SEL1 field.
	LP_IO_DEBUG_SEL0_LP_DEBUG_SEL1_Pos = 0x7
	// Bit mask of LP_DEBUG_SEL1 field.
	LP_IO_DEBUG_SEL0_LP_DEBUG_SEL1_Msk = 0x3f80
	// Position of LP_DEBUG_SEL2 field.
	LP_IO_DEBUG_SEL0_LP_DEBUG_SEL2_Pos = 0xe
	// Bit mask of LP_DEBUG_SEL2 field.
	LP_IO_DEBUG_SEL0_LP_DEBUG_SEL2_Msk = 0x1fc000
	// Position of LP_DEBUG_SEL3 field.
	LP_IO_DEBUG_SEL0_LP_DEBUG_SEL3_Pos = 0x15
	// Bit mask of LP_DEBUG_SEL3 field.
	LP_IO_DEBUG_SEL0_LP_DEBUG_SEL3_Msk = 0xfe00000

	// DEBUG_SEL1: need des
	// Position of LP_DEBUG_SEL4 field.
	LP_IO_DEBUG_SEL1_LP_DEBUG_SEL4_Pos = 0x0
	// Bit mask of LP_DEBUG_SEL4 field.
	LP_IO_DEBUG_SEL1_LP_DEBUG_SEL4_Msk = 0x7f

	// LPI2C: need des
	// Position of LP_I2C_SDA_IE field.
	LP_IO_LPI2C_LP_I2C_SDA_IE_Pos = 0x1e
	// Bit mask of LP_I2C_SDA_IE field.
	LP_IO_LPI2C_LP_I2C_SDA_IE_Msk = 0x40000000
	// Bit LP_I2C_SDA_IE.
	LP_IO_LPI2C_LP_I2C_SDA_IE = 0x40000000
	// Position of LP_I2C_SCL_IE field.
	LP_IO_LPI2C_LP_I2C_SCL_IE_Pos = 0x1f
	// Bit mask of LP_I2C_SCL_IE field.
	LP_IO_LPI2C_LP_I2C_SCL_IE_Msk = 0x80000000
	// Bit LP_I2C_SCL_IE.
	LP_IO_LPI2C_LP_I2C_SCL_IE = 0x80000000

	// DATE: need des
	// Position of LP_IO_DATE field.
	LP_IO_DATE_LP_IO_DATE_Pos = 0x0
	// Bit mask of LP_IO_DATE field.
	LP_IO_DATE_LP_IO_DATE_Msk = 0x7fffffff
	// Position of CLK_EN field.
	LP_IO_DATE_CLK_EN_Pos = 0x1f
	// Bit mask of CLK_EN field.
	LP_IO_DATE_CLK_EN_Msk = 0x80000000
	// Bit CLK_EN.
	LP_IO_DATE_CLK_EN = 0x80000000
)

// Constants for LP_TEE: Low-power Trusted Execution Environment
const (
	// M0_MODE_CTRL: Tee mode control register
	// Position of M0_MODE field.
	LP_TEE_M0_MODE_CTRL_M0_MODE_Pos = 0x0
	// Bit mask of M0_MODE field.
	LP_TEE_M0_MODE_CTRL_M0_MODE_Msk = 0x3

	// CLOCK_GATE: Clock gating register
	// Position of CLK_EN field.
	LP_TEE_CLOCK_GATE_CLK_EN_Pos = 0x0
	// Bit mask of CLK_EN field.
	LP_TEE_CLOCK_GATE_CLK_EN_Msk = 0x1
	// Bit CLK_EN.
	LP_TEE_CLOCK_GATE_CLK_EN = 0x1

	// FORCE_ACC_HP: need_des
	// Position of LP_AON_FORCE_ACC_HPMEM_EN field.
	LP_TEE_FORCE_ACC_HP_LP_AON_FORCE_ACC_HPMEM_EN_Pos = 0x0
	// Bit mask of LP_AON_FORCE_ACC_HPMEM_EN field.
	LP_TEE_FORCE_ACC_HP_LP_AON_FORCE_ACC_HPMEM_EN_Msk = 0x1
	// Bit LP_AON_FORCE_ACC_HPMEM_EN.
	LP_TEE_FORCE_ACC_HP_LP_AON_FORCE_ACC_HPMEM_EN = 0x1

	// DATE: Version register
	// Position of DATE field.
	LP_TEE_DATE_DATE_Pos = 0x0
	// Bit mask of DATE field.
	LP_TEE_DATE_DATE_Msk = 0xfffffff
)

// Constants for LP_TIMER: Low-power Timer
const (
	// TAR0_LOW: need_des
	// Position of MAIN_TIMER_TAR_LOW0 field.
	LP_TIMER_TAR0_LOW_MAIN_TIMER_TAR_LOW0_Pos = 0x0
	// Bit mask of MAIN_TIMER_TAR_LOW0 field.
	LP_TIMER_TAR0_LOW_MAIN_TIMER_TAR_LOW0_Msk = 0xffffffff

	// TAR0_HIGH: need_des
	// Position of MAIN_TIMER_TAR_HIGH0 field.
	LP_TIMER_TAR0_HIGH_MAIN_TIMER_TAR_HIGH0_Pos = 0x0
	// Bit mask of MAIN_TIMER_TAR_HIGH0 field.
	LP_TIMER_TAR0_HIGH_MAIN_TIMER_TAR_HIGH0_Msk = 0xffff
	// Position of MAIN_TIMER_TAR_EN0 field.
	LP_TIMER_TAR0_HIGH_MAIN_TIMER_TAR_EN0_Pos = 0x1f
	// Bit mask of MAIN_TIMER_TAR_EN0 field.
	LP_TIMER_TAR0_HIGH_MAIN_TIMER_TAR_EN0_Msk = 0x80000000
	// Bit MAIN_TIMER_TAR_EN0.
	LP_TIMER_TAR0_HIGH_MAIN_TIMER_TAR_EN0 = 0x80000000

	// TAR1_LOW: need_des
	// Position of MAIN_TIMER_TAR_LOW1 field.
	LP_TIMER_TAR1_LOW_MAIN_TIMER_TAR_LOW1_Pos = 0x0
	// Bit mask of MAIN_TIMER_TAR_LOW1 field.
	LP_TIMER_TAR1_LOW_MAIN_TIMER_TAR_LOW1_Msk = 0xffffffff

	// TAR1_HIGH: need_des
	// Position of MAIN_TIMER_TAR_HIGH1 field.
	LP_TIMER_TAR1_HIGH_MAIN_TIMER_TAR_HIGH1_Pos = 0x0
	// Bit mask of MAIN_TIMER_TAR_HIGH1 field.
	LP_TIMER_TAR1_HIGH_MAIN_TIMER_TAR_HIGH1_Msk = 0xffff
	// Position of MAIN_TIMER_TAR_EN1 field.
	LP_TIMER_TAR1_HIGH_MAIN_TIMER_TAR_EN1_Pos = 0x1f
	// Bit mask of MAIN_TIMER_TAR_EN1 field.
	LP_TIMER_TAR1_HIGH_MAIN_TIMER_TAR_EN1_Msk = 0x80000000
	// Bit MAIN_TIMER_TAR_EN1.
	LP_TIMER_TAR1_HIGH_MAIN_TIMER_TAR_EN1 = 0x80000000

	// UPDATE: need_des
	// Position of MAIN_TIMER_UPDATE field.
	LP_TIMER_UPDATE_MAIN_TIMER_UPDATE_Pos = 0x1c
	// Bit mask of MAIN_TIMER_UPDATE field.
	LP_TIMER_UPDATE_MAIN_TIMER_UPDATE_Msk = 0x10000000
	// Bit MAIN_TIMER_UPDATE.
	LP_TIMER_UPDATE_MAIN_TIMER_UPDATE = 0x10000000
	// Position of MAIN_TIMER_XTAL_OFF field.
	LP_TIMER_UPDATE_MAIN_TIMER_XTAL_OFF_Pos = 0x1d
	// Bit mask of MAIN_TIMER_XTAL_OFF field.
	LP_TIMER_UPDATE_MAIN_TIMER_XTAL_OFF_Msk = 0x20000000
	// Bit MAIN_TIMER_XTAL_OFF.
	LP_TIMER_UPDATE_MAIN_TIMER_XTAL_OFF = 0x20000000
	// Position of MAIN_TIMER_SYS_STALL field.
	LP_TIMER_UPDATE_MAIN_TIMER_SYS_STALL_Pos = 0x1e
	// Bit mask of MAIN_TIMER_SYS_STALL field.
	LP_TIMER_UPDATE_MAIN_TIMER_SYS_STALL_Msk = 0x40000000
	// Bit MAIN_TIMER_SYS_STALL.
	LP_TIMER_UPDATE_MAIN_TIMER_SYS_STALL = 0x40000000
	// Position of MAIN_TIMER_SYS_RST field.
	LP_TIMER_UPDATE_MAIN_TIMER_SYS_RST_Pos = 0x1f
	// Bit mask of MAIN_TIMER_SYS_RST field.
	LP_TIMER_UPDATE_MAIN_TIMER_SYS_RST_Msk = 0x80000000
	// Bit MAIN_TIMER_SYS_RST.
	LP_TIMER_UPDATE_MAIN_TIMER_SYS_RST = 0x80000000

	// MAIN_BUF0_LOW: need_des
	// Position of MAIN_TIMER_BUF0_LOW field.
	LP_TIMER_MAIN_BUF0_LOW_MAIN_TIMER_BUF0_LOW_Pos = 0x0
	// Bit mask of MAIN_TIMER_BUF0_LOW field.
	LP_TIMER_MAIN_BUF0_LOW_MAIN_TIMER_BUF0_LOW_Msk = 0xffffffff

	// MAIN_BUF0_HIGH: need_des
	// Position of MAIN_TIMER_BUF0_HIGH field.
	LP_TIMER_MAIN_BUF0_HIGH_MAIN_TIMER_BUF0_HIGH_Pos = 0x0
	// Bit mask of MAIN_TIMER_BUF0_HIGH field.
	LP_TIMER_MAIN_BUF0_HIGH_MAIN_TIMER_BUF0_HIGH_Msk = 0xffff

	// MAIN_BUF1_LOW: need_des
	// Position of MAIN_TIMER_BUF1_LOW field.
	LP_TIMER_MAIN_BUF1_LOW_MAIN_TIMER_BUF1_LOW_Pos = 0x0
	// Bit mask of MAIN_TIMER_BUF1_LOW field.
	LP_TIMER_MAIN_BUF1_LOW_MAIN_TIMER_BUF1_LOW_Msk = 0xffffffff

	// MAIN_BUF1_HIGH: need_des
	// Position of MAIN_TIMER_BUF1_HIGH field.
	LP_TIMER_MAIN_BUF1_HIGH_MAIN_TIMER_BUF1_HIGH_Pos = 0x0
	// Bit mask of MAIN_TIMER_BUF1_HIGH field.
	LP_TIMER_MAIN_BUF1_HIGH_MAIN_TIMER_BUF1_HIGH_Msk = 0xffff

	// MAIN_OVERFLOW: need_des
	// Position of MAIN_TIMER_ALARM_LOAD field.
	LP_TIMER_MAIN_OVERFLOW_MAIN_TIMER_ALARM_LOAD_Pos = 0x1f
	// Bit mask of MAIN_TIMER_ALARM_LOAD field.
	LP_TIMER_MAIN_OVERFLOW_MAIN_TIMER_ALARM_LOAD_Msk = 0x80000000
	// Bit MAIN_TIMER_ALARM_LOAD.
	LP_TIMER_MAIN_OVERFLOW_MAIN_TIMER_ALARM_LOAD = 0x80000000

	// INT_RAW: need_des
	// Position of OVERFLOW_RAW field.
	LP_TIMER_INT_RAW_OVERFLOW_RAW_Pos = 0x1e
	// Bit mask of OVERFLOW_RAW field.
	LP_TIMER_INT_RAW_OVERFLOW_RAW_Msk = 0x40000000
	// Bit OVERFLOW_RAW.
	LP_TIMER_INT_RAW_OVERFLOW_RAW = 0x40000000
	// Position of SOC_WAKEUP_INT_RAW field.
	LP_TIMER_INT_RAW_SOC_WAKEUP_INT_RAW_Pos = 0x1f
	// Bit mask of SOC_WAKEUP_INT_RAW field.
	LP_TIMER_INT_RAW_SOC_WAKEUP_INT_RAW_Msk = 0x80000000
	// Bit SOC_WAKEUP_INT_RAW.
	LP_TIMER_INT_RAW_SOC_WAKEUP_INT_RAW = 0x80000000

	// INT_ST: need_des
	// Position of OVERFLOW_ST field.
	LP_TIMER_INT_ST_OVERFLOW_ST_Pos = 0x1e
	// Bit mask of OVERFLOW_ST field.
	LP_TIMER_INT_ST_OVERFLOW_ST_Msk = 0x40000000
	// Bit OVERFLOW_ST.
	LP_TIMER_INT_ST_OVERFLOW_ST = 0x40000000
	// Position of SOC_WAKEUP_INT_ST field.
	LP_TIMER_INT_ST_SOC_WAKEUP_INT_ST_Pos = 0x1f
	// Bit mask of SOC_WAKEUP_INT_ST field.
	LP_TIMER_INT_ST_SOC_WAKEUP_INT_ST_Msk = 0x80000000
	// Bit SOC_WAKEUP_INT_ST.
	LP_TIMER_INT_ST_SOC_WAKEUP_INT_ST = 0x80000000

	// INT_ENA: need_des
	// Position of OVERFLOW_ENA field.
	LP_TIMER_INT_ENA_OVERFLOW_ENA_Pos = 0x1e
	// Bit mask of OVERFLOW_ENA field.
	LP_TIMER_INT_ENA_OVERFLOW_ENA_Msk = 0x40000000
	// Bit OVERFLOW_ENA.
	LP_TIMER_INT_ENA_OVERFLOW_ENA = 0x40000000
	// Position of SOC_WAKEUP_INT_ENA field.
	LP_TIMER_INT_ENA_SOC_WAKEUP_INT_ENA_Pos = 0x1f
	// Bit mask of SOC_WAKEUP_INT_ENA field.
	LP_TIMER_INT_ENA_SOC_WAKEUP_INT_ENA_Msk = 0x80000000
	// Bit SOC_WAKEUP_INT_ENA.
	LP_TIMER_INT_ENA_SOC_WAKEUP_INT_ENA = 0x80000000

	// INT_CLR: need_des
	// Position of OVERFLOW_CLR field.
	LP_TIMER_INT_CLR_OVERFLOW_CLR_Pos = 0x1e
	// Bit mask of OVERFLOW_CLR field.
	LP_TIMER_INT_CLR_OVERFLOW_CLR_Msk = 0x40000000
	// Bit OVERFLOW_CLR.
	LP_TIMER_INT_CLR_OVERFLOW_CLR = 0x40000000
	// Position of SOC_WAKEUP_INT_CLR field.
	LP_TIMER_INT_CLR_SOC_WAKEUP_INT_CLR_Pos = 0x1f
	// Bit mask of SOC_WAKEUP_INT_CLR field.
	LP_TIMER_INT_CLR_SOC_WAKEUP_INT_CLR_Msk = 0x80000000
	// Bit SOC_WAKEUP_INT_CLR.
	LP_TIMER_INT_CLR_SOC_WAKEUP_INT_CLR = 0x80000000

	// LP_INT_RAW: need_des
	// Position of MAIN_TIMER_OVERFLOW_LP_INT_RAW field.
	LP_TIMER_LP_INT_RAW_MAIN_TIMER_OVERFLOW_LP_INT_RAW_Pos = 0x1e
	// Bit mask of MAIN_TIMER_OVERFLOW_LP_INT_RAW field.
	LP_TIMER_LP_INT_RAW_MAIN_TIMER_OVERFLOW_LP_INT_RAW_Msk = 0x40000000
	// Bit MAIN_TIMER_OVERFLOW_LP_INT_RAW.
	LP_TIMER_LP_INT_RAW_MAIN_TIMER_OVERFLOW_LP_INT_RAW = 0x40000000
	// Position of MAIN_TIMER_LP_INT_RAW field.
	LP_TIMER_LP_INT_RAW_MAIN_TIMER_LP_INT_RAW_Pos = 0x1f
	// Bit mask of MAIN_TIMER_LP_INT_RAW field.
	LP_TIMER_LP_INT_RAW_MAIN_TIMER_LP_INT_RAW_Msk = 0x80000000
	// Bit MAIN_TIMER_LP_INT_RAW.
	LP_TIMER_LP_INT_RAW_MAIN_TIMER_LP_INT_RAW = 0x80000000

	// LP_INT_ST: need_des
	// Position of MAIN_TIMER_OVERFLOW_LP_INT_ST field.
	LP_TIMER_LP_INT_ST_MAIN_TIMER_OVERFLOW_LP_INT_ST_Pos = 0x1e
	// Bit mask of MAIN_TIMER_OVERFLOW_LP_INT_ST field.
	LP_TIMER_LP_INT_ST_MAIN_TIMER_OVERFLOW_LP_INT_ST_Msk = 0x40000000
	// Bit MAIN_TIMER_OVERFLOW_LP_INT_ST.
	LP_TIMER_LP_INT_ST_MAIN_TIMER_OVERFLOW_LP_INT_ST = 0x40000000
	// Position of MAIN_TIMER_LP_INT_ST field.
	LP_TIMER_LP_INT_ST_MAIN_TIMER_LP_INT_ST_Pos = 0x1f
	// Bit mask of MAIN_TIMER_LP_INT_ST field.
	LP_TIMER_LP_INT_ST_MAIN_TIMER_LP_INT_ST_Msk = 0x80000000
	// Bit MAIN_TIMER_LP_INT_ST.
	LP_TIMER_LP_INT_ST_MAIN_TIMER_LP_INT_ST = 0x80000000

	// LP_INT_ENA: need_des
	// Position of MAIN_TIMER_OVERFLOW_LP_INT_ENA field.
	LP_TIMER_LP_INT_ENA_MAIN_TIMER_OVERFLOW_LP_INT_ENA_Pos = 0x1e
	// Bit mask of MAIN_TIMER_OVERFLOW_LP_INT_ENA field.
	LP_TIMER_LP_INT_ENA_MAIN_TIMER_OVERFLOW_LP_INT_ENA_Msk = 0x40000000
	// Bit MAIN_TIMER_OVERFLOW_LP_INT_ENA.
	LP_TIMER_LP_INT_ENA_MAIN_TIMER_OVERFLOW_LP_INT_ENA = 0x40000000
	// Position of MAIN_TIMER_LP_INT_ENA field.
	LP_TIMER_LP_INT_ENA_MAIN_TIMER_LP_INT_ENA_Pos = 0x1f
	// Bit mask of MAIN_TIMER_LP_INT_ENA field.
	LP_TIMER_LP_INT_ENA_MAIN_TIMER_LP_INT_ENA_Msk = 0x80000000
	// Bit MAIN_TIMER_LP_INT_ENA.
	LP_TIMER_LP_INT_ENA_MAIN_TIMER_LP_INT_ENA = 0x80000000

	// LP_INT_CLR: need_des
	// Position of MAIN_TIMER_OVERFLOW_LP_INT_CLR field.
	LP_TIMER_LP_INT_CLR_MAIN_TIMER_OVERFLOW_LP_INT_CLR_Pos = 0x1e
	// Bit mask of MAIN_TIMER_OVERFLOW_LP_INT_CLR field.
	LP_TIMER_LP_INT_CLR_MAIN_TIMER_OVERFLOW_LP_INT_CLR_Msk = 0x40000000
	// Bit MAIN_TIMER_OVERFLOW_LP_INT_CLR.
	LP_TIMER_LP_INT_CLR_MAIN_TIMER_OVERFLOW_LP_INT_CLR = 0x40000000
	// Position of MAIN_TIMER_LP_INT_CLR field.
	LP_TIMER_LP_INT_CLR_MAIN_TIMER_LP_INT_CLR_Pos = 0x1f
	// Bit mask of MAIN_TIMER_LP_INT_CLR field.
	LP_TIMER_LP_INT_CLR_MAIN_TIMER_LP_INT_CLR_Msk = 0x80000000
	// Bit MAIN_TIMER_LP_INT_CLR.
	LP_TIMER_LP_INT_CLR_MAIN_TIMER_LP_INT_CLR = 0x80000000

	// DATE: need_des
	// Position of DATE field.
	LP_TIMER_DATE_DATE_Pos = 0x0
	// Bit mask of DATE field.
	LP_TIMER_DATE_DATE_Msk = 0x7fffffff
	// Position of CLK_EN field.
	LP_TIMER_DATE_CLK_EN_Pos = 0x1f
	// Bit mask of CLK_EN field.
	LP_TIMER_DATE_CLK_EN_Msk = 0x80000000
	// Bit CLK_EN.
	LP_TIMER_DATE_CLK_EN = 0x80000000
)

// Constants for LP_UART: Low-power UART (Universal Asynchronous Receiver-Transmitter) Controller
const (
	// FIFO: FIFO data register
	// Position of RXFIFO_RD_BYTE field.
	LP_UART_FIFO_RXFIFO_RD_BYTE_Pos = 0x0
	// Bit mask of RXFIFO_RD_BYTE field.
	LP_UART_FIFO_RXFIFO_RD_BYTE_Msk = 0xff

	// INT_RAW: Raw interrupt status
	// Position of RXFIFO_FULL_INT_RAW field.
	LP_UART_INT_RAW_RXFIFO_FULL_INT_RAW_Pos = 0x0
	// Bit mask of RXFIFO_FULL_INT_RAW field.
	LP_UART_INT_RAW_RXFIFO_FULL_INT_RAW_Msk = 0x1
	// Bit RXFIFO_FULL_INT_RAW.
	LP_UART_INT_RAW_RXFIFO_FULL_INT_RAW = 0x1
	// Position of TXFIFO_EMPTY_INT_RAW field.
	LP_UART_INT_RAW_TXFIFO_EMPTY_INT_RAW_Pos = 0x1
	// Bit mask of TXFIFO_EMPTY_INT_RAW field.
	LP_UART_INT_RAW_TXFIFO_EMPTY_INT_RAW_Msk = 0x2
	// Bit TXFIFO_EMPTY_INT_RAW.
	LP_UART_INT_RAW_TXFIFO_EMPTY_INT_RAW = 0x2
	// Position of PARITY_ERR_INT_RAW field.
	LP_UART_INT_RAW_PARITY_ERR_INT_RAW_Pos = 0x2
	// Bit mask of PARITY_ERR_INT_RAW field.
	LP_UART_INT_RAW_PARITY_ERR_INT_RAW_Msk = 0x4
	// Bit PARITY_ERR_INT_RAW.
	LP_UART_INT_RAW_PARITY_ERR_INT_RAW = 0x4
	// Position of FRM_ERR_INT_RAW field.
	LP_UART_INT_RAW_FRM_ERR_INT_RAW_Pos = 0x3
	// Bit mask of FRM_ERR_INT_RAW field.
	LP_UART_INT_RAW_FRM_ERR_INT_RAW_Msk = 0x8
	// Bit FRM_ERR_INT_RAW.
	LP_UART_INT_RAW_FRM_ERR_INT_RAW = 0x8
	// Position of RXFIFO_OVF_INT_RAW field.
	LP_UART_INT_RAW_RXFIFO_OVF_INT_RAW_Pos = 0x4
	// Bit mask of RXFIFO_OVF_INT_RAW field.
	LP_UART_INT_RAW_RXFIFO_OVF_INT_RAW_Msk = 0x10
	// Bit RXFIFO_OVF_INT_RAW.
	LP_UART_INT_RAW_RXFIFO_OVF_INT_RAW = 0x10
	// Position of DSR_CHG_INT_RAW field.
	LP_UART_INT_RAW_DSR_CHG_INT_RAW_Pos = 0x5
	// Bit mask of DSR_CHG_INT_RAW field.
	LP_UART_INT_RAW_DSR_CHG_INT_RAW_Msk = 0x20
	// Bit DSR_CHG_INT_RAW.
	LP_UART_INT_RAW_DSR_CHG_INT_RAW = 0x20
	// Position of CTS_CHG_INT_RAW field.
	LP_UART_INT_RAW_CTS_CHG_INT_RAW_Pos = 0x6
	// Bit mask of CTS_CHG_INT_RAW field.
	LP_UART_INT_RAW_CTS_CHG_INT_RAW_Msk = 0x40
	// Bit CTS_CHG_INT_RAW.
	LP_UART_INT_RAW_CTS_CHG_INT_RAW = 0x40
	// Position of BRK_DET_INT_RAW field.
	LP_UART_INT_RAW_BRK_DET_INT_RAW_Pos = 0x7
	// Bit mask of BRK_DET_INT_RAW field.
	LP_UART_INT_RAW_BRK_DET_INT_RAW_Msk = 0x80
	// Bit BRK_DET_INT_RAW.
	LP_UART_INT_RAW_BRK_DET_INT_RAW = 0x80
	// Position of RXFIFO_TOUT_INT_RAW field.
	LP_UART_INT_RAW_RXFIFO_TOUT_INT_RAW_Pos = 0x8
	// Bit mask of RXFIFO_TOUT_INT_RAW field.
	LP_UART_INT_RAW_RXFIFO_TOUT_INT_RAW_Msk = 0x100
	// Bit RXFIFO_TOUT_INT_RAW.
	LP_UART_INT_RAW_RXFIFO_TOUT_INT_RAW = 0x100
	// Position of SW_XON_INT_RAW field.
	LP_UART_INT_RAW_SW_XON_INT_RAW_Pos = 0x9
	// Bit mask of SW_XON_INT_RAW field.
	LP_UART_INT_RAW_SW_XON_INT_RAW_Msk = 0x200
	// Bit SW_XON_INT_RAW.
	LP_UART_INT_RAW_SW_XON_INT_RAW = 0x200
	// Position of SW_XOFF_INT_RAW field.
	LP_UART_INT_RAW_SW_XOFF_INT_RAW_Pos = 0xa
	// Bit mask of SW_XOFF_INT_RAW field.
	LP_UART_INT_RAW_SW_XOFF_INT_RAW_Msk = 0x400
	// Bit SW_XOFF_INT_RAW.
	LP_UART_INT_RAW_SW_XOFF_INT_RAW = 0x400
	// Position of GLITCH_DET_INT_RAW field.
	LP_UART_INT_RAW_GLITCH_DET_INT_RAW_Pos = 0xb
	// Bit mask of GLITCH_DET_INT_RAW field.
	LP_UART_INT_RAW_GLITCH_DET_INT_RAW_Msk = 0x800
	// Bit GLITCH_DET_INT_RAW.
	LP_UART_INT_RAW_GLITCH_DET_INT_RAW = 0x800
	// Position of TX_BRK_DONE_INT_RAW field.
	LP_UART_INT_RAW_TX_BRK_DONE_INT_RAW_Pos = 0xc
	// Bit mask of TX_BRK_DONE_INT_RAW field.
	LP_UART_INT_RAW_TX_BRK_DONE_INT_RAW_Msk = 0x1000
	// Bit TX_BRK_DONE_INT_RAW.
	LP_UART_INT_RAW_TX_BRK_DONE_INT_RAW = 0x1000
	// Position of TX_BRK_IDLE_DONE_INT_RAW field.
	LP_UART_INT_RAW_TX_BRK_IDLE_DONE_INT_RAW_Pos = 0xd
	// Bit mask of TX_BRK_IDLE_DONE_INT_RAW field.
	LP_UART_INT_RAW_TX_BRK_IDLE_DONE_INT_RAW_Msk = 0x2000
	// Bit TX_BRK_IDLE_DONE_INT_RAW.
	LP_UART_INT_RAW_TX_BRK_IDLE_DONE_INT_RAW = 0x2000
	// Position of TX_DONE_INT_RAW field.
	LP_UART_INT_RAW_TX_DONE_INT_RAW_Pos = 0xe
	// Bit mask of TX_DONE_INT_RAW field.
	LP_UART_INT_RAW_TX_DONE_INT_RAW_Msk = 0x4000
	// Bit TX_DONE_INT_RAW.
	LP_UART_INT_RAW_TX_DONE_INT_RAW = 0x4000
	// Position of AT_CMD_CHAR_DET_INT_RAW field.
	LP_UART_INT_RAW_AT_CMD_CHAR_DET_INT_RAW_Pos = 0x12
	// Bit mask of AT_CMD_CHAR_DET_INT_RAW field.
	LP_UART_INT_RAW_AT_CMD_CHAR_DET_INT_RAW_Msk = 0x40000
	// Bit AT_CMD_CHAR_DET_INT_RAW.
	LP_UART_INT_RAW_AT_CMD_CHAR_DET_INT_RAW = 0x40000
	// Position of WAKEUP_INT_RAW field.
	LP_UART_INT_RAW_WAKEUP_INT_RAW_Pos = 0x13
	// Bit mask of WAKEUP_INT_RAW field.
	LP_UART_INT_RAW_WAKEUP_INT_RAW_Msk = 0x80000
	// Bit WAKEUP_INT_RAW.
	LP_UART_INT_RAW_WAKEUP_INT_RAW = 0x80000

	// INT_ST: Masked interrupt status
	// Position of RXFIFO_FULL_INT_ST field.
	LP_UART_INT_ST_RXFIFO_FULL_INT_ST_Pos = 0x0
	// Bit mask of RXFIFO_FULL_INT_ST field.
	LP_UART_INT_ST_RXFIFO_FULL_INT_ST_Msk = 0x1
	// Bit RXFIFO_FULL_INT_ST.
	LP_UART_INT_ST_RXFIFO_FULL_INT_ST = 0x1
	// Position of TXFIFO_EMPTY_INT_ST field.
	LP_UART_INT_ST_TXFIFO_EMPTY_INT_ST_Pos = 0x1
	// Bit mask of TXFIFO_EMPTY_INT_ST field.
	LP_UART_INT_ST_TXFIFO_EMPTY_INT_ST_Msk = 0x2
	// Bit TXFIFO_EMPTY_INT_ST.
	LP_UART_INT_ST_TXFIFO_EMPTY_INT_ST = 0x2
	// Position of PARITY_ERR_INT_ST field.
	LP_UART_INT_ST_PARITY_ERR_INT_ST_Pos = 0x2
	// Bit mask of PARITY_ERR_INT_ST field.
	LP_UART_INT_ST_PARITY_ERR_INT_ST_Msk = 0x4
	// Bit PARITY_ERR_INT_ST.
	LP_UART_INT_ST_PARITY_ERR_INT_ST = 0x4
	// Position of FRM_ERR_INT_ST field.
	LP_UART_INT_ST_FRM_ERR_INT_ST_Pos = 0x3
	// Bit mask of FRM_ERR_INT_ST field.
	LP_UART_INT_ST_FRM_ERR_INT_ST_Msk = 0x8
	// Bit FRM_ERR_INT_ST.
	LP_UART_INT_ST_FRM_ERR_INT_ST = 0x8
	// Position of RXFIFO_OVF_INT_ST field.
	LP_UART_INT_ST_RXFIFO_OVF_INT_ST_Pos = 0x4
	// Bit mask of RXFIFO_OVF_INT_ST field.
	LP_UART_INT_ST_RXFIFO_OVF_INT_ST_Msk = 0x10
	// Bit RXFIFO_OVF_INT_ST.
	LP_UART_INT_ST_RXFIFO_OVF_INT_ST = 0x10
	// Position of DSR_CHG_INT_ST field.
	LP_UART_INT_ST_DSR_CHG_INT_ST_Pos = 0x5
	// Bit mask of DSR_CHG_INT_ST field.
	LP_UART_INT_ST_DSR_CHG_INT_ST_Msk = 0x20
	// Bit DSR_CHG_INT_ST.
	LP_UART_INT_ST_DSR_CHG_INT_ST = 0x20
	// Position of CTS_CHG_INT_ST field.
	LP_UART_INT_ST_CTS_CHG_INT_ST_Pos = 0x6
	// Bit mask of CTS_CHG_INT_ST field.
	LP_UART_INT_ST_CTS_CHG_INT_ST_Msk = 0x40
	// Bit CTS_CHG_INT_ST.
	LP_UART_INT_ST_CTS_CHG_INT_ST = 0x40
	// Position of BRK_DET_INT_ST field.
	LP_UART_INT_ST_BRK_DET_INT_ST_Pos = 0x7
	// Bit mask of BRK_DET_INT_ST field.
	LP_UART_INT_ST_BRK_DET_INT_ST_Msk = 0x80
	// Bit BRK_DET_INT_ST.
	LP_UART_INT_ST_BRK_DET_INT_ST = 0x80
	// Position of RXFIFO_TOUT_INT_ST field.
	LP_UART_INT_ST_RXFIFO_TOUT_INT_ST_Pos = 0x8
	// Bit mask of RXFIFO_TOUT_INT_ST field.
	LP_UART_INT_ST_RXFIFO_TOUT_INT_ST_Msk = 0x100
	// Bit RXFIFO_TOUT_INT_ST.
	LP_UART_INT_ST_RXFIFO_TOUT_INT_ST = 0x100
	// Position of SW_XON_INT_ST field.
	LP_UART_INT_ST_SW_XON_INT_ST_Pos = 0x9
	// Bit mask of SW_XON_INT_ST field.
	LP_UART_INT_ST_SW_XON_INT_ST_Msk = 0x200
	// Bit SW_XON_INT_ST.
	LP_UART_INT_ST_SW_XON_INT_ST = 0x200
	// Position of SW_XOFF_INT_ST field.
	LP_UART_INT_ST_SW_XOFF_INT_ST_Pos = 0xa
	// Bit mask of SW_XOFF_INT_ST field.
	LP_UART_INT_ST_SW_XOFF_INT_ST_Msk = 0x400
	// Bit SW_XOFF_INT_ST.
	LP_UART_INT_ST_SW_XOFF_INT_ST = 0x400
	// Position of GLITCH_DET_INT_ST field.
	LP_UART_INT_ST_GLITCH_DET_INT_ST_Pos = 0xb
	// Bit mask of GLITCH_DET_INT_ST field.
	LP_UART_INT_ST_GLITCH_DET_INT_ST_Msk = 0x800
	// Bit GLITCH_DET_INT_ST.
	LP_UART_INT_ST_GLITCH_DET_INT_ST = 0x800
	// Position of TX_BRK_DONE_INT_ST field.
	LP_UART_INT_ST_TX_BRK_DONE_INT_ST_Pos = 0xc
	// Bit mask of TX_BRK_DONE_INT_ST field.
	LP_UART_INT_ST_TX_BRK_DONE_INT_ST_Msk = 0x1000
	// Bit TX_BRK_DONE_INT_ST.
	LP_UART_INT_ST_TX_BRK_DONE_INT_ST = 0x1000
	// Position of TX_BRK_IDLE_DONE_INT_ST field.
	LP_UART_INT_ST_TX_BRK_IDLE_DONE_INT_ST_Pos = 0xd
	// Bit mask of TX_BRK_IDLE_DONE_INT_ST field.
	LP_UART_INT_ST_TX_BRK_IDLE_DONE_INT_ST_Msk = 0x2000
	// Bit TX_BRK_IDLE_DONE_INT_ST.
	LP_UART_INT_ST_TX_BRK_IDLE_DONE_INT_ST = 0x2000
	// Position of TX_DONE_INT_ST field.
	LP_UART_INT_ST_TX_DONE_INT_ST_Pos = 0xe
	// Bit mask of TX_DONE_INT_ST field.
	LP_UART_INT_ST_TX_DONE_INT_ST_Msk = 0x4000
	// Bit TX_DONE_INT_ST.
	LP_UART_INT_ST_TX_DONE_INT_ST = 0x4000
	// Position of AT_CMD_CHAR_DET_INT_ST field.
	LP_UART_INT_ST_AT_CMD_CHAR_DET_INT_ST_Pos = 0x12
	// Bit mask of AT_CMD_CHAR_DET_INT_ST field.
	LP_UART_INT_ST_AT_CMD_CHAR_DET_INT_ST_Msk = 0x40000
	// Bit AT_CMD_CHAR_DET_INT_ST.
	LP_UART_INT_ST_AT_CMD_CHAR_DET_INT_ST = 0x40000
	// Position of WAKEUP_INT_ST field.
	LP_UART_INT_ST_WAKEUP_INT_ST_Pos = 0x13
	// Bit mask of WAKEUP_INT_ST field.
	LP_UART_INT_ST_WAKEUP_INT_ST_Msk = 0x80000
	// Bit WAKEUP_INT_ST.
	LP_UART_INT_ST_WAKEUP_INT_ST = 0x80000

	// INT_ENA: Interrupt enable bits
	// Position of RXFIFO_FULL_INT_ENA field.
	LP_UART_INT_ENA_RXFIFO_FULL_INT_ENA_Pos = 0x0
	// Bit mask of RXFIFO_FULL_INT_ENA field.
	LP_UART_INT_ENA_RXFIFO_FULL_INT_ENA_Msk = 0x1
	// Bit RXFIFO_FULL_INT_ENA.
	LP_UART_INT_ENA_RXFIFO_FULL_INT_ENA = 0x1
	// Position of TXFIFO_EMPTY_INT_ENA field.
	LP_UART_INT_ENA_TXFIFO_EMPTY_INT_ENA_Pos = 0x1
	// Bit mask of TXFIFO_EMPTY_INT_ENA field.
	LP_UART_INT_ENA_TXFIFO_EMPTY_INT_ENA_Msk = 0x2
	// Bit TXFIFO_EMPTY_INT_ENA.
	LP_UART_INT_ENA_TXFIFO_EMPTY_INT_ENA = 0x2
	// Position of PARITY_ERR_INT_ENA field.
	LP_UART_INT_ENA_PARITY_ERR_INT_ENA_Pos = 0x2
	// Bit mask of PARITY_ERR_INT_ENA field.
	LP_UART_INT_ENA_PARITY_ERR_INT_ENA_Msk = 0x4
	// Bit PARITY_ERR_INT_ENA.
	LP_UART_INT_ENA_PARITY_ERR_INT_ENA = 0x4
	// Position of FRM_ERR_INT_ENA field.
	LP_UART_INT_ENA_FRM_ERR_INT_ENA_Pos = 0x3
	// Bit mask of FRM_ERR_INT_ENA field.
	LP_UART_INT_ENA_FRM_ERR_INT_ENA_Msk = 0x8
	// Bit FRM_ERR_INT_ENA.
	LP_UART_INT_ENA_FRM_ERR_INT_ENA = 0x8
	// Position of RXFIFO_OVF_INT_ENA field.
	LP_UART_INT_ENA_RXFIFO_OVF_INT_ENA_Pos = 0x4
	// Bit mask of RXFIFO_OVF_INT_ENA field.
	LP_UART_INT_ENA_RXFIFO_OVF_INT_ENA_Msk = 0x10
	// Bit RXFIFO_OVF_INT_ENA.
	LP_UART_INT_ENA_RXFIFO_OVF_INT_ENA = 0x10
	// Position of DSR_CHG_INT_ENA field.
	LP_UART_INT_ENA_DSR_CHG_INT_ENA_Pos = 0x5
	// Bit mask of DSR_CHG_INT_ENA field.
	LP_UART_INT_ENA_DSR_CHG_INT_ENA_Msk = 0x20
	// Bit DSR_CHG_INT_ENA.
	LP_UART_INT_ENA_DSR_CHG_INT_ENA = 0x20
	// Position of CTS_CHG_INT_ENA field.
	LP_UART_INT_ENA_CTS_CHG_INT_ENA_Pos = 0x6
	// Bit mask of CTS_CHG_INT_ENA field.
	LP_UART_INT_ENA_CTS_CHG_INT_ENA_Msk = 0x40
	// Bit CTS_CHG_INT_ENA.
	LP_UART_INT_ENA_CTS_CHG_INT_ENA = 0x40
	// Position of BRK_DET_INT_ENA field.
	LP_UART_INT_ENA_BRK_DET_INT_ENA_Pos = 0x7
	// Bit mask of BRK_DET_INT_ENA field.
	LP_UART_INT_ENA_BRK_DET_INT_ENA_Msk = 0x80
	// Bit BRK_DET_INT_ENA.
	LP_UART_INT_ENA_BRK_DET_INT_ENA = 0x80
	// Position of RXFIFO_TOUT_INT_ENA field.
	LP_UART_INT_ENA_RXFIFO_TOUT_INT_ENA_Pos = 0x8
	// Bit mask of RXFIFO_TOUT_INT_ENA field.
	LP_UART_INT_ENA_RXFIFO_TOUT_INT_ENA_Msk = 0x100
	// Bit RXFIFO_TOUT_INT_ENA.
	LP_UART_INT_ENA_RXFIFO_TOUT_INT_ENA = 0x100
	// Position of SW_XON_INT_ENA field.
	LP_UART_INT_ENA_SW_XON_INT_ENA_Pos = 0x9
	// Bit mask of SW_XON_INT_ENA field.
	LP_UART_INT_ENA_SW_XON_INT_ENA_Msk = 0x200
	// Bit SW_XON_INT_ENA.
	LP_UART_INT_ENA_SW_XON_INT_ENA = 0x200
	// Position of SW_XOFF_INT_ENA field.
	LP_UART_INT_ENA_SW_XOFF_INT_ENA_Pos = 0xa
	// Bit mask of SW_XOFF_INT_ENA field.
	LP_UART_INT_ENA_SW_XOFF_INT_ENA_Msk = 0x400
	// Bit SW_XOFF_INT_ENA.
	LP_UART_INT_ENA_SW_XOFF_INT_ENA = 0x400
	// Position of GLITCH_DET_INT_ENA field.
	LP_UART_INT_ENA_GLITCH_DET_INT_ENA_Pos = 0xb
	// Bit mask of GLITCH_DET_INT_ENA field.
	LP_UART_INT_ENA_GLITCH_DET_INT_ENA_Msk = 0x800
	// Bit GLITCH_DET_INT_ENA.
	LP_UART_INT_ENA_GLITCH_DET_INT_ENA = 0x800
	// Position of TX_BRK_DONE_INT_ENA field.
	LP_UART_INT_ENA_TX_BRK_DONE_INT_ENA_Pos = 0xc
	// Bit mask of TX_BRK_DONE_INT_ENA field.
	LP_UART_INT_ENA_TX_BRK_DONE_INT_ENA_Msk = 0x1000
	// Bit TX_BRK_DONE_INT_ENA.
	LP_UART_INT_ENA_TX_BRK_DONE_INT_ENA = 0x1000
	// Position of TX_BRK_IDLE_DONE_INT_ENA field.
	LP_UART_INT_ENA_TX_BRK_IDLE_DONE_INT_ENA_Pos = 0xd
	// Bit mask of TX_BRK_IDLE_DONE_INT_ENA field.
	LP_UART_INT_ENA_TX_BRK_IDLE_DONE_INT_ENA_Msk = 0x2000
	// Bit TX_BRK_IDLE_DONE_INT_ENA.
	LP_UART_INT_ENA_TX_BRK_IDLE_DONE_INT_ENA = 0x2000
	// Position of TX_DONE_INT_ENA field.
	LP_UART_INT_ENA_TX_DONE_INT_ENA_Pos = 0xe
	// Bit mask of TX_DONE_INT_ENA field.
	LP_UART_INT_ENA_TX_DONE_INT_ENA_Msk = 0x4000
	// Bit TX_DONE_INT_ENA.
	LP_UART_INT_ENA_TX_DONE_INT_ENA = 0x4000
	// Position of AT_CMD_CHAR_DET_INT_ENA field.
	LP_UART_INT_ENA_AT_CMD_CHAR_DET_INT_ENA_Pos = 0x12
	// Bit mask of AT_CMD_CHAR_DET_INT_ENA field.
	LP_UART_INT_ENA_AT_CMD_CHAR_DET_INT_ENA_Msk = 0x40000
	// Bit AT_CMD_CHAR_DET_INT_ENA.
	LP_UART_INT_ENA_AT_CMD_CHAR_DET_INT_ENA = 0x40000
	// Position of WAKEUP_INT_ENA field.
	LP_UART_INT_ENA_WAKEUP_INT_ENA_Pos = 0x13
	// Bit mask of WAKEUP_INT_ENA field.
	LP_UART_INT_ENA_WAKEUP_INT_ENA_Msk = 0x80000
	// Bit WAKEUP_INT_ENA.
	LP_UART_INT_ENA_WAKEUP_INT_ENA = 0x80000

	// INT_CLR: Interrupt clear bits
	// Position of RXFIFO_FULL_INT_CLR field.
	LP_UART_INT_CLR_RXFIFO_FULL_INT_CLR_Pos = 0x0
	// Bit mask of RXFIFO_FULL_INT_CLR field.
	LP_UART_INT_CLR_RXFIFO_FULL_INT_CLR_Msk = 0x1
	// Bit RXFIFO_FULL_INT_CLR.
	LP_UART_INT_CLR_RXFIFO_FULL_INT_CLR = 0x1
	// Position of TXFIFO_EMPTY_INT_CLR field.
	LP_UART_INT_CLR_TXFIFO_EMPTY_INT_CLR_Pos = 0x1
	// Bit mask of TXFIFO_EMPTY_INT_CLR field.
	LP_UART_INT_CLR_TXFIFO_EMPTY_INT_CLR_Msk = 0x2
	// Bit TXFIFO_EMPTY_INT_CLR.
	LP_UART_INT_CLR_TXFIFO_EMPTY_INT_CLR = 0x2
	// Position of PARITY_ERR_INT_CLR field.
	LP_UART_INT_CLR_PARITY_ERR_INT_CLR_Pos = 0x2
	// Bit mask of PARITY_ERR_INT_CLR field.
	LP_UART_INT_CLR_PARITY_ERR_INT_CLR_Msk = 0x4
	// Bit PARITY_ERR_INT_CLR.
	LP_UART_INT_CLR_PARITY_ERR_INT_CLR = 0x4
	// Position of FRM_ERR_INT_CLR field.
	LP_UART_INT_CLR_FRM_ERR_INT_CLR_Pos = 0x3
	// Bit mask of FRM_ERR_INT_CLR field.
	LP_UART_INT_CLR_FRM_ERR_INT_CLR_Msk = 0x8
	// Bit FRM_ERR_INT_CLR.
	LP_UART_INT_CLR_FRM_ERR_INT_CLR = 0x8
	// Position of RXFIFO_OVF_INT_CLR field.
	LP_UART_INT_CLR_RXFIFO_OVF_INT_CLR_Pos = 0x4
	// Bit mask of RXFIFO_OVF_INT_CLR field.
	LP_UART_INT_CLR_RXFIFO_OVF_INT_CLR_Msk = 0x10
	// Bit RXFIFO_OVF_INT_CLR.
	LP_UART_INT_CLR_RXFIFO_OVF_INT_CLR = 0x10
	// Position of DSR_CHG_INT_CLR field.
	LP_UART_INT_CLR_DSR_CHG_INT_CLR_Pos = 0x5
	// Bit mask of DSR_CHG_INT_CLR field.
	LP_UART_INT_CLR_DSR_CHG_INT_CLR_Msk = 0x20
	// Bit DSR_CHG_INT_CLR.
	LP_UART_INT_CLR_DSR_CHG_INT_CLR = 0x20
	// Position of CTS_CHG_INT_CLR field.
	LP_UART_INT_CLR_CTS_CHG_INT_CLR_Pos = 0x6
	// Bit mask of CTS_CHG_INT_CLR field.
	LP_UART_INT_CLR_CTS_CHG_INT_CLR_Msk = 0x40
	// Bit CTS_CHG_INT_CLR.
	LP_UART_INT_CLR_CTS_CHG_INT_CLR = 0x40
	// Position of BRK_DET_INT_CLR field.
	LP_UART_INT_CLR_BRK_DET_INT_CLR_Pos = 0x7
	// Bit mask of BRK_DET_INT_CLR field.
	LP_UART_INT_CLR_BRK_DET_INT_CLR_Msk = 0x80
	// Bit BRK_DET_INT_CLR.
	LP_UART_INT_CLR_BRK_DET_INT_CLR = 0x80
	// Position of RXFIFO_TOUT_INT_CLR field.
	LP_UART_INT_CLR_RXFIFO_TOUT_INT_CLR_Pos = 0x8
	// Bit mask of RXFIFO_TOUT_INT_CLR field.
	LP_UART_INT_CLR_RXFIFO_TOUT_INT_CLR_Msk = 0x100
	// Bit RXFIFO_TOUT_INT_CLR.
	LP_UART_INT_CLR_RXFIFO_TOUT_INT_CLR = 0x100
	// Position of SW_XON_INT_CLR field.
	LP_UART_INT_CLR_SW_XON_INT_CLR_Pos = 0x9
	// Bit mask of SW_XON_INT_CLR field.
	LP_UART_INT_CLR_SW_XON_INT_CLR_Msk = 0x200
	// Bit SW_XON_INT_CLR.
	LP_UART_INT_CLR_SW_XON_INT_CLR = 0x200
	// Position of SW_XOFF_INT_CLR field.
	LP_UART_INT_CLR_SW_XOFF_INT_CLR_Pos = 0xa
	// Bit mask of SW_XOFF_INT_CLR field.
	LP_UART_INT_CLR_SW_XOFF_INT_CLR_Msk = 0x400
	// Bit SW_XOFF_INT_CLR.
	LP_UART_INT_CLR_SW_XOFF_INT_CLR = 0x400
	// Position of GLITCH_DET_INT_CLR field.
	LP_UART_INT_CLR_GLITCH_DET_INT_CLR_Pos = 0xb
	// Bit mask of GLITCH_DET_INT_CLR field.
	LP_UART_INT_CLR_GLITCH_DET_INT_CLR_Msk = 0x800
	// Bit GLITCH_DET_INT_CLR.
	LP_UART_INT_CLR_GLITCH_DET_INT_CLR = 0x800
	// Position of TX_BRK_DONE_INT_CLR field.
	LP_UART_INT_CLR_TX_BRK_DONE_INT_CLR_Pos = 0xc
	// Bit mask of TX_BRK_DONE_INT_CLR field.
	LP_UART_INT_CLR_TX_BRK_DONE_INT_CLR_Msk = 0x1000
	// Bit TX_BRK_DONE_INT_CLR.
	LP_UART_INT_CLR_TX_BRK_DONE_INT_CLR = 0x1000
	// Position of TX_BRK_IDLE_DONE_INT_CLR field.
	LP_UART_INT_CLR_TX_BRK_IDLE_DONE_INT_CLR_Pos = 0xd
	// Bit mask of TX_BRK_IDLE_DONE_INT_CLR field.
	LP_UART_INT_CLR_TX_BRK_IDLE_DONE_INT_CLR_Msk = 0x2000
	// Bit TX_BRK_IDLE_DONE_INT_CLR.
	LP_UART_INT_CLR_TX_BRK_IDLE_DONE_INT_CLR = 0x2000
	// Position of TX_DONE_INT_CLR field.
	LP_UART_INT_CLR_TX_DONE_INT_CLR_Pos = 0xe
	// Bit mask of TX_DONE_INT_CLR field.
	LP_UART_INT_CLR_TX_DONE_INT_CLR_Msk = 0x4000
	// Bit TX_DONE_INT_CLR.
	LP_UART_INT_CLR_TX_DONE_INT_CLR = 0x4000
	// Position of AT_CMD_CHAR_DET_INT_CLR field.
	LP_UART_INT_CLR_AT_CMD_CHAR_DET_INT_CLR_Pos = 0x12
	// Bit mask of AT_CMD_CHAR_DET_INT_CLR field.
	LP_UART_INT_CLR_AT_CMD_CHAR_DET_INT_CLR_Msk = 0x40000
	// Bit AT_CMD_CHAR_DET_INT_CLR.
	LP_UART_INT_CLR_AT_CMD_CHAR_DET_INT_CLR = 0x40000
	// Position of WAKEUP_INT_CLR field.
	LP_UART_INT_CLR_WAKEUP_INT_CLR_Pos = 0x13
	// Bit mask of WAKEUP_INT_CLR field.
	LP_UART_INT_CLR_WAKEUP_INT_CLR_Msk = 0x80000
	// Bit WAKEUP_INT_CLR.
	LP_UART_INT_CLR_WAKEUP_INT_CLR = 0x80000

	// CLKDIV_SYNC: Clock divider configuration
	// Position of CLKDIV field.
	LP_UART_CLKDIV_SYNC_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	LP_UART_CLKDIV_SYNC_CLKDIV_Msk = 0xfff
	// Position of CLKDIV_FRAG field.
	LP_UART_CLKDIV_SYNC_CLKDIV_FRAG_Pos = 0x14
	// Bit mask of CLKDIV_FRAG field.
	LP_UART_CLKDIV_SYNC_CLKDIV_FRAG_Msk = 0xf00000

	// RX_FILT: Rx Filter configuration
	// Position of GLITCH_FILT field.
	LP_UART_RX_FILT_GLITCH_FILT_Pos = 0x0
	// Bit mask of GLITCH_FILT field.
	LP_UART_RX_FILT_GLITCH_FILT_Msk = 0xff
	// Position of GLITCH_FILT_EN field.
	LP_UART_RX_FILT_GLITCH_FILT_EN_Pos = 0x8
	// Bit mask of GLITCH_FILT_EN field.
	LP_UART_RX_FILT_GLITCH_FILT_EN_Msk = 0x100
	// Bit GLITCH_FILT_EN.
	LP_UART_RX_FILT_GLITCH_FILT_EN = 0x100

	// STATUS: UART status register
	// Position of RXFIFO_CNT field.
	LP_UART_STATUS_RXFIFO_CNT_Pos = 0x3
	// Bit mask of RXFIFO_CNT field.
	LP_UART_STATUS_RXFIFO_CNT_Msk = 0xf8
	// Position of DSRN field.
	LP_UART_STATUS_DSRN_Pos = 0xd
	// Bit mask of DSRN field.
	LP_UART_STATUS_DSRN_Msk = 0x2000
	// Bit DSRN.
	LP_UART_STATUS_DSRN = 0x2000
	// Position of CTSN field.
	LP_UART_STATUS_CTSN_Pos = 0xe
	// Bit mask of CTSN field.
	LP_UART_STATUS_CTSN_Msk = 0x4000
	// Bit CTSN.
	LP_UART_STATUS_CTSN = 0x4000
	// Position of RXD field.
	LP_UART_STATUS_RXD_Pos = 0xf
	// Bit mask of RXD field.
	LP_UART_STATUS_RXD_Msk = 0x8000
	// Bit RXD.
	LP_UART_STATUS_RXD = 0x8000
	// Position of TXFIFO_CNT field.
	LP_UART_STATUS_TXFIFO_CNT_Pos = 0x13
	// Bit mask of TXFIFO_CNT field.
	LP_UART_STATUS_TXFIFO_CNT_Msk = 0xf80000
	// Position of DTRN field.
	LP_UART_STATUS_DTRN_Pos = 0x1d
	// Bit mask of DTRN field.
	LP_UART_STATUS_DTRN_Msk = 0x20000000
	// Bit DTRN.
	LP_UART_STATUS_DTRN = 0x20000000
	// Position of RTSN field.
	LP_UART_STATUS_RTSN_Pos = 0x1e
	// Bit mask of RTSN field.
	LP_UART_STATUS_RTSN_Msk = 0x40000000
	// Bit RTSN.
	LP_UART_STATUS_RTSN = 0x40000000
	// Position of TXD field.
	LP_UART_STATUS_TXD_Pos = 0x1f
	// Bit mask of TXD field.
	LP_UART_STATUS_TXD_Msk = 0x80000000
	// Bit TXD.
	LP_UART_STATUS_TXD = 0x80000000

	// CONF0_SYNC: Configuration register 0
	// Position of PARITY field.
	LP_UART_CONF0_SYNC_PARITY_Pos = 0x0
	// Bit mask of PARITY field.
	LP_UART_CONF0_SYNC_PARITY_Msk = 0x1
	// Bit PARITY.
	LP_UART_CONF0_SYNC_PARITY = 0x1
	// Position of PARITY_EN field.
	LP_UART_CONF0_SYNC_PARITY_EN_Pos = 0x1
	// Bit mask of PARITY_EN field.
	LP_UART_CONF0_SYNC_PARITY_EN_Msk = 0x2
	// Bit PARITY_EN.
	LP_UART_CONF0_SYNC_PARITY_EN = 0x2
	// Position of BIT_NUM field.
	LP_UART_CONF0_SYNC_BIT_NUM_Pos = 0x2
	// Bit mask of BIT_NUM field.
	LP_UART_CONF0_SYNC_BIT_NUM_Msk = 0xc
	// Position of STOP_BIT_NUM field.
	LP_UART_CONF0_SYNC_STOP_BIT_NUM_Pos = 0x4
	// Bit mask of STOP_BIT_NUM field.
	LP_UART_CONF0_SYNC_STOP_BIT_NUM_Msk = 0x30
	// Position of TXD_BRK field.
	LP_UART_CONF0_SYNC_TXD_BRK_Pos = 0x6
	// Bit mask of TXD_BRK field.
	LP_UART_CONF0_SYNC_TXD_BRK_Msk = 0x40
	// Bit TXD_BRK.
	LP_UART_CONF0_SYNC_TXD_BRK = 0x40
	// Position of LOOPBACK field.
	LP_UART_CONF0_SYNC_LOOPBACK_Pos = 0xc
	// Bit mask of LOOPBACK field.
	LP_UART_CONF0_SYNC_LOOPBACK_Msk = 0x1000
	// Bit LOOPBACK.
	LP_UART_CONF0_SYNC_LOOPBACK = 0x1000
	// Position of TX_FLOW_EN field.
	LP_UART_CONF0_SYNC_TX_FLOW_EN_Pos = 0xd
	// Bit mask of TX_FLOW_EN field.
	LP_UART_CONF0_SYNC_TX_FLOW_EN_Msk = 0x2000
	// Bit TX_FLOW_EN.
	LP_UART_CONF0_SYNC_TX_FLOW_EN = 0x2000
	// Position of RXD_INV field.
	LP_UART_CONF0_SYNC_RXD_INV_Pos = 0xf
	// Bit mask of RXD_INV field.
	LP_UART_CONF0_SYNC_RXD_INV_Msk = 0x8000
	// Bit RXD_INV.
	LP_UART_CONF0_SYNC_RXD_INV = 0x8000
	// Position of TXD_INV field.
	LP_UART_CONF0_SYNC_TXD_INV_Pos = 0x10
	// Bit mask of TXD_INV field.
	LP_UART_CONF0_SYNC_TXD_INV_Msk = 0x10000
	// Bit TXD_INV.
	LP_UART_CONF0_SYNC_TXD_INV = 0x10000
	// Position of DIS_RX_DAT_OVF field.
	LP_UART_CONF0_SYNC_DIS_RX_DAT_OVF_Pos = 0x11
	// Bit mask of DIS_RX_DAT_OVF field.
	LP_UART_CONF0_SYNC_DIS_RX_DAT_OVF_Msk = 0x20000
	// Bit DIS_RX_DAT_OVF.
	LP_UART_CONF0_SYNC_DIS_RX_DAT_OVF = 0x20000
	// Position of ERR_WR_MASK field.
	LP_UART_CONF0_SYNC_ERR_WR_MASK_Pos = 0x12
	// Bit mask of ERR_WR_MASK field.
	LP_UART_CONF0_SYNC_ERR_WR_MASK_Msk = 0x40000
	// Bit ERR_WR_MASK.
	LP_UART_CONF0_SYNC_ERR_WR_MASK = 0x40000
	// Position of MEM_CLK_EN field.
	LP_UART_CONF0_SYNC_MEM_CLK_EN_Pos = 0x14
	// Bit mask of MEM_CLK_EN field.
	LP_UART_CONF0_SYNC_MEM_CLK_EN_Msk = 0x100000
	// Bit MEM_CLK_EN.
	LP_UART_CONF0_SYNC_MEM_CLK_EN = 0x100000
	// Position of SW_RTS field.
	LP_UART_CONF0_SYNC_SW_RTS_Pos = 0x15
	// Bit mask of SW_RTS field.
	LP_UART_CONF0_SYNC_SW_RTS_Msk = 0x200000
	// Bit SW_RTS.
	LP_UART_CONF0_SYNC_SW_RTS = 0x200000
	// Position of RXFIFO_RST field.
	LP_UART_CONF0_SYNC_RXFIFO_RST_Pos = 0x16
	// Bit mask of RXFIFO_RST field.
	LP_UART_CONF0_SYNC_RXFIFO_RST_Msk = 0x400000
	// Bit RXFIFO_RST.
	LP_UART_CONF0_SYNC_RXFIFO_RST = 0x400000
	// Position of TXFIFO_RST field.
	LP_UART_CONF0_SYNC_TXFIFO_RST_Pos = 0x17
	// Bit mask of TXFIFO_RST field.
	LP_UART_CONF0_SYNC_TXFIFO_RST_Msk = 0x800000
	// Bit TXFIFO_RST.
	LP_UART_CONF0_SYNC_TXFIFO_RST = 0x800000

	// CONF1: Configuration register 1
	// Position of RXFIFO_FULL_THRHD field.
	LP_UART_CONF1_RXFIFO_FULL_THRHD_Pos = 0x3
	// Bit mask of RXFIFO_FULL_THRHD field.
	LP_UART_CONF1_RXFIFO_FULL_THRHD_Msk = 0xf8
	// Position of TXFIFO_EMPTY_THRHD field.
	LP_UART_CONF1_TXFIFO_EMPTY_THRHD_Pos = 0xb
	// Bit mask of TXFIFO_EMPTY_THRHD field.
	LP_UART_CONF1_TXFIFO_EMPTY_THRHD_Msk = 0xf800
	// Position of CTS_INV field.
	LP_UART_CONF1_CTS_INV_Pos = 0x10
	// Bit mask of CTS_INV field.
	LP_UART_CONF1_CTS_INV_Msk = 0x10000
	// Bit CTS_INV.
	LP_UART_CONF1_CTS_INV = 0x10000
	// Position of DSR_INV field.
	LP_UART_CONF1_DSR_INV_Pos = 0x11
	// Bit mask of DSR_INV field.
	LP_UART_CONF1_DSR_INV_Msk = 0x20000
	// Bit DSR_INV.
	LP_UART_CONF1_DSR_INV = 0x20000
	// Position of RTS_INV field.
	LP_UART_CONF1_RTS_INV_Pos = 0x12
	// Bit mask of RTS_INV field.
	LP_UART_CONF1_RTS_INV_Msk = 0x40000
	// Bit RTS_INV.
	LP_UART_CONF1_RTS_INV = 0x40000
	// Position of DTR_INV field.
	LP_UART_CONF1_DTR_INV_Pos = 0x13
	// Bit mask of DTR_INV field.
	LP_UART_CONF1_DTR_INV_Msk = 0x80000
	// Bit DTR_INV.
	LP_UART_CONF1_DTR_INV = 0x80000
	// Position of SW_DTR field.
	LP_UART_CONF1_SW_DTR_Pos = 0x14
	// Bit mask of SW_DTR field.
	LP_UART_CONF1_SW_DTR_Msk = 0x100000
	// Bit SW_DTR.
	LP_UART_CONF1_SW_DTR = 0x100000
	// Position of CLK_EN field.
	LP_UART_CONF1_CLK_EN_Pos = 0x15
	// Bit mask of CLK_EN field.
	LP_UART_CONF1_CLK_EN_Msk = 0x200000
	// Bit CLK_EN.
	LP_UART_CONF1_CLK_EN = 0x200000

	// HWFC_CONF_SYNC: Hardware flow-control configuration
	// Position of RX_FLOW_THRHD field.
	LP_UART_HWFC_CONF_SYNC_RX_FLOW_THRHD_Pos = 0x3
	// Bit mask of RX_FLOW_THRHD field.
	LP_UART_HWFC_CONF_SYNC_RX_FLOW_THRHD_Msk = 0xf8
	// Position of RX_FLOW_EN field.
	LP_UART_HWFC_CONF_SYNC_RX_FLOW_EN_Pos = 0x8
	// Bit mask of RX_FLOW_EN field.
	LP_UART_HWFC_CONF_SYNC_RX_FLOW_EN_Msk = 0x100
	// Bit RX_FLOW_EN.
	LP_UART_HWFC_CONF_SYNC_RX_FLOW_EN = 0x100

	// SLEEP_CONF0: UART sleep configure register 0
	// Position of WK_CHAR1 field.
	LP_UART_SLEEP_CONF0_WK_CHAR1_Pos = 0x0
	// Bit mask of WK_CHAR1 field.
	LP_UART_SLEEP_CONF0_WK_CHAR1_Msk = 0xff
	// Position of WK_CHAR2 field.
	LP_UART_SLEEP_CONF0_WK_CHAR2_Pos = 0x8
	// Bit mask of WK_CHAR2 field.
	LP_UART_SLEEP_CONF0_WK_CHAR2_Msk = 0xff00
	// Position of WK_CHAR3 field.
	LP_UART_SLEEP_CONF0_WK_CHAR3_Pos = 0x10
	// Bit mask of WK_CHAR3 field.
	LP_UART_SLEEP_CONF0_WK_CHAR3_Msk = 0xff0000
	// Position of WK_CHAR4 field.
	LP_UART_SLEEP_CONF0_WK_CHAR4_Pos = 0x18
	// Bit mask of WK_CHAR4 field.
	LP_UART_SLEEP_CONF0_WK_CHAR4_Msk = 0xff000000

	// SLEEP_CONF1: UART sleep configure register 1
	// Position of WK_CHAR0 field.
	LP_UART_SLEEP_CONF1_WK_CHAR0_Pos = 0x0
	// Bit mask of WK_CHAR0 field.
	LP_UART_SLEEP_CONF1_WK_CHAR0_Msk = 0xff

	// SLEEP_CONF2: UART sleep configure register 2
	// Position of ACTIVE_THRESHOLD field.
	LP_UART_SLEEP_CONF2_ACTIVE_THRESHOLD_Pos = 0x0
	// Bit mask of ACTIVE_THRESHOLD field.
	LP_UART_SLEEP_CONF2_ACTIVE_THRESHOLD_Msk = 0x3ff
	// Position of RX_WAKE_UP_THRHD field.
	LP_UART_SLEEP_CONF2_RX_WAKE_UP_THRHD_Pos = 0xd
	// Bit mask of RX_WAKE_UP_THRHD field.
	LP_UART_SLEEP_CONF2_RX_WAKE_UP_THRHD_Msk = 0x3e000
	// Position of WK_CHAR_NUM field.
	LP_UART_SLEEP_CONF2_WK_CHAR_NUM_Pos = 0x12
	// Bit mask of WK_CHAR_NUM field.
	LP_UART_SLEEP_CONF2_WK_CHAR_NUM_Msk = 0x1c0000
	// Position of WK_CHAR_MASK field.
	LP_UART_SLEEP_CONF2_WK_CHAR_MASK_Pos = 0x15
	// Bit mask of WK_CHAR_MASK field.
	LP_UART_SLEEP_CONF2_WK_CHAR_MASK_Msk = 0x3e00000
	// Position of WK_MODE_SEL field.
	LP_UART_SLEEP_CONF2_WK_MODE_SEL_Pos = 0x1a
	// Bit mask of WK_MODE_SEL field.
	LP_UART_SLEEP_CONF2_WK_MODE_SEL_Msk = 0xc000000

	// SWFC_CONF0_SYNC: Software flow-control character configuration
	// Position of XON_CHAR field.
	LP_UART_SWFC_CONF0_SYNC_XON_CHAR_Pos = 0x0
	// Bit mask of XON_CHAR field.
	LP_UART_SWFC_CONF0_SYNC_XON_CHAR_Msk = 0xff
	// Position of XOFF_CHAR field.
	LP_UART_SWFC_CONF0_SYNC_XOFF_CHAR_Pos = 0x8
	// Bit mask of XOFF_CHAR field.
	LP_UART_SWFC_CONF0_SYNC_XOFF_CHAR_Msk = 0xff00
	// Position of XON_XOFF_STILL_SEND field.
	LP_UART_SWFC_CONF0_SYNC_XON_XOFF_STILL_SEND_Pos = 0x10
	// Bit mask of XON_XOFF_STILL_SEND field.
	LP_UART_SWFC_CONF0_SYNC_XON_XOFF_STILL_SEND_Msk = 0x10000
	// Bit XON_XOFF_STILL_SEND.
	LP_UART_SWFC_CONF0_SYNC_XON_XOFF_STILL_SEND = 0x10000
	// Position of SW_FLOW_CON_EN field.
	LP_UART_SWFC_CONF0_SYNC_SW_FLOW_CON_EN_Pos = 0x11
	// Bit mask of SW_FLOW_CON_EN field.
	LP_UART_SWFC_CONF0_SYNC_SW_FLOW_CON_EN_Msk = 0x20000
	// Bit SW_FLOW_CON_EN.
	LP_UART_SWFC_CONF0_SYNC_SW_FLOW_CON_EN = 0x20000
	// Position of XONOFF_DEL field.
	LP_UART_SWFC_CONF0_SYNC_XONOFF_DEL_Pos = 0x12
	// Bit mask of XONOFF_DEL field.
	LP_UART_SWFC_CONF0_SYNC_XONOFF_DEL_Msk = 0x40000
	// Bit XONOFF_DEL.
	LP_UART_SWFC_CONF0_SYNC_XONOFF_DEL = 0x40000
	// Position of FORCE_XON field.
	LP_UART_SWFC_CONF0_SYNC_FORCE_XON_Pos = 0x13
	// Bit mask of FORCE_XON field.
	LP_UART_SWFC_CONF0_SYNC_FORCE_XON_Msk = 0x80000
	// Bit FORCE_XON.
	LP_UART_SWFC_CONF0_SYNC_FORCE_XON = 0x80000
	// Position of FORCE_XOFF field.
	LP_UART_SWFC_CONF0_SYNC_FORCE_XOFF_Pos = 0x14
	// Bit mask of FORCE_XOFF field.
	LP_UART_SWFC_CONF0_SYNC_FORCE_XOFF_Msk = 0x100000
	// Bit FORCE_XOFF.
	LP_UART_SWFC_CONF0_SYNC_FORCE_XOFF = 0x100000
	// Position of SEND_XON field.
	LP_UART_SWFC_CONF0_SYNC_SEND_XON_Pos = 0x15
	// Bit mask of SEND_XON field.
	LP_UART_SWFC_CONF0_SYNC_SEND_XON_Msk = 0x200000
	// Bit SEND_XON.
	LP_UART_SWFC_CONF0_SYNC_SEND_XON = 0x200000
	// Position of SEND_XOFF field.
	LP_UART_SWFC_CONF0_SYNC_SEND_XOFF_Pos = 0x16
	// Bit mask of SEND_XOFF field.
	LP_UART_SWFC_CONF0_SYNC_SEND_XOFF_Msk = 0x400000
	// Bit SEND_XOFF.
	LP_UART_SWFC_CONF0_SYNC_SEND_XOFF = 0x400000

	// SWFC_CONF1: Software flow-control character configuration
	// Position of XON_THRESHOLD field.
	LP_UART_SWFC_CONF1_XON_THRESHOLD_Pos = 0x3
	// Bit mask of XON_THRESHOLD field.
	LP_UART_SWFC_CONF1_XON_THRESHOLD_Msk = 0xf8
	// Position of XOFF_THRESHOLD field.
	LP_UART_SWFC_CONF1_XOFF_THRESHOLD_Pos = 0xb
	// Bit mask of XOFF_THRESHOLD field.
	LP_UART_SWFC_CONF1_XOFF_THRESHOLD_Msk = 0xf800

	// TXBRK_CONF_SYNC: Tx Break character configuration
	// Position of TX_BRK_NUM field.
	LP_UART_TXBRK_CONF_SYNC_TX_BRK_NUM_Pos = 0x0
	// Bit mask of TX_BRK_NUM field.
	LP_UART_TXBRK_CONF_SYNC_TX_BRK_NUM_Msk = 0xff

	// IDLE_CONF_SYNC: Frame-end idle configuration
	// Position of RX_IDLE_THRHD field.
	LP_UART_IDLE_CONF_SYNC_RX_IDLE_THRHD_Pos = 0x0
	// Bit mask of RX_IDLE_THRHD field.
	LP_UART_IDLE_CONF_SYNC_RX_IDLE_THRHD_Msk = 0x3ff
	// Position of TX_IDLE_NUM field.
	LP_UART_IDLE_CONF_SYNC_TX_IDLE_NUM_Pos = 0xa
	// Bit mask of TX_IDLE_NUM field.
	LP_UART_IDLE_CONF_SYNC_TX_IDLE_NUM_Msk = 0xffc00

	// RS485_CONF_SYNC: RS485 mode configuration
	// Position of DL0_EN field.
	LP_UART_RS485_CONF_SYNC_DL0_EN_Pos = 0x1
	// Bit mask of DL0_EN field.
	LP_UART_RS485_CONF_SYNC_DL0_EN_Msk = 0x2
	// Bit DL0_EN.
	LP_UART_RS485_CONF_SYNC_DL0_EN = 0x2
	// Position of DL1_EN field.
	LP_UART_RS485_CONF_SYNC_DL1_EN_Pos = 0x2
	// Bit mask of DL1_EN field.
	LP_UART_RS485_CONF_SYNC_DL1_EN_Msk = 0x4
	// Bit DL1_EN.
	LP_UART_RS485_CONF_SYNC_DL1_EN = 0x4

	// AT_CMD_PRECNT_SYNC: Pre-sequence timing configuration
	// Position of PRE_IDLE_NUM field.
	LP_UART_AT_CMD_PRECNT_SYNC_PRE_IDLE_NUM_Pos = 0x0
	// Bit mask of PRE_IDLE_NUM field.
	LP_UART_AT_CMD_PRECNT_SYNC_PRE_IDLE_NUM_Msk = 0xffff

	// AT_CMD_POSTCNT_SYNC: Post-sequence timing configuration
	// Position of POST_IDLE_NUM field.
	LP_UART_AT_CMD_POSTCNT_SYNC_POST_IDLE_NUM_Pos = 0x0
	// Bit mask of POST_IDLE_NUM field.
	LP_UART_AT_CMD_POSTCNT_SYNC_POST_IDLE_NUM_Msk = 0xffff

	// AT_CMD_GAPTOUT_SYNC: Timeout configuration
	// Position of RX_GAP_TOUT field.
	LP_UART_AT_CMD_GAPTOUT_SYNC_RX_GAP_TOUT_Pos = 0x0
	// Bit mask of RX_GAP_TOUT field.
	LP_UART_AT_CMD_GAPTOUT_SYNC_RX_GAP_TOUT_Msk = 0xffff

	// AT_CMD_CHAR_SYNC: AT escape sequence detection configuration
	// Position of AT_CMD_CHAR field.
	LP_UART_AT_CMD_CHAR_SYNC_AT_CMD_CHAR_Pos = 0x0
	// Bit mask of AT_CMD_CHAR field.
	LP_UART_AT_CMD_CHAR_SYNC_AT_CMD_CHAR_Msk = 0xff
	// Position of CHAR_NUM field.
	LP_UART_AT_CMD_CHAR_SYNC_CHAR_NUM_Pos = 0x8
	// Bit mask of CHAR_NUM field.
	LP_UART_AT_CMD_CHAR_SYNC_CHAR_NUM_Msk = 0xff00

	// MEM_CONF: UART memory power configuration
	// Position of MEM_FORCE_PD field.
	LP_UART_MEM_CONF_MEM_FORCE_PD_Pos = 0x19
	// Bit mask of MEM_FORCE_PD field.
	LP_UART_MEM_CONF_MEM_FORCE_PD_Msk = 0x2000000
	// Bit MEM_FORCE_PD.
	LP_UART_MEM_CONF_MEM_FORCE_PD = 0x2000000
	// Position of MEM_FORCE_PU field.
	LP_UART_MEM_CONF_MEM_FORCE_PU_Pos = 0x1a
	// Bit mask of MEM_FORCE_PU field.
	LP_UART_MEM_CONF_MEM_FORCE_PU_Msk = 0x4000000
	// Bit MEM_FORCE_PU.
	LP_UART_MEM_CONF_MEM_FORCE_PU = 0x4000000

	// TOUT_CONF_SYNC: UART threshold and allocation configuration
	// Position of RX_TOUT_EN field.
	LP_UART_TOUT_CONF_SYNC_RX_TOUT_EN_Pos = 0x0
	// Bit mask of RX_TOUT_EN field.
	LP_UART_TOUT_CONF_SYNC_RX_TOUT_EN_Msk = 0x1
	// Bit RX_TOUT_EN.
	LP_UART_TOUT_CONF_SYNC_RX_TOUT_EN = 0x1
	// Position of RX_TOUT_FLOW_DIS field.
	LP_UART_TOUT_CONF_SYNC_RX_TOUT_FLOW_DIS_Pos = 0x1
	// Bit mask of RX_TOUT_FLOW_DIS field.
	LP_UART_TOUT_CONF_SYNC_RX_TOUT_FLOW_DIS_Msk = 0x2
	// Bit RX_TOUT_FLOW_DIS.
	LP_UART_TOUT_CONF_SYNC_RX_TOUT_FLOW_DIS = 0x2
	// Position of RX_TOUT_THRHD field.
	LP_UART_TOUT_CONF_SYNC_RX_TOUT_THRHD_Pos = 0x2
	// Bit mask of RX_TOUT_THRHD field.
	LP_UART_TOUT_CONF_SYNC_RX_TOUT_THRHD_Msk = 0xffc

	// MEM_TX_STATUS: Tx-SRAM write and read offset address.
	// Position of TX_SRAM_WADDR field.
	LP_UART_MEM_TX_STATUS_TX_SRAM_WADDR_Pos = 0x3
	// Bit mask of TX_SRAM_WADDR field.
	LP_UART_MEM_TX_STATUS_TX_SRAM_WADDR_Msk = 0xf8
	// Position of TX_SRAM_RADDR field.
	LP_UART_MEM_TX_STATUS_TX_SRAM_RADDR_Pos = 0xc
	// Bit mask of TX_SRAM_RADDR field.
	LP_UART_MEM_TX_STATUS_TX_SRAM_RADDR_Msk = 0x1f000

	// MEM_RX_STATUS: Rx-SRAM write and read offset address.
	// Position of RX_SRAM_RADDR field.
	LP_UART_MEM_RX_STATUS_RX_SRAM_RADDR_Pos = 0x3
	// Bit mask of RX_SRAM_RADDR field.
	LP_UART_MEM_RX_STATUS_RX_SRAM_RADDR_Msk = 0xf8
	// Position of RX_SRAM_WADDR field.
	LP_UART_MEM_RX_STATUS_RX_SRAM_WADDR_Pos = 0xc
	// Bit mask of RX_SRAM_WADDR field.
	LP_UART_MEM_RX_STATUS_RX_SRAM_WADDR_Msk = 0x1f000

	// FSM_STATUS: UART transmit and receive status.
	// Position of ST_URX_OUT field.
	LP_UART_FSM_STATUS_ST_URX_OUT_Pos = 0x0
	// Bit mask of ST_URX_OUT field.
	LP_UART_FSM_STATUS_ST_URX_OUT_Msk = 0xf
	// Position of ST_UTX_OUT field.
	LP_UART_FSM_STATUS_ST_UTX_OUT_Pos = 0x4
	// Bit mask of ST_UTX_OUT field.
	LP_UART_FSM_STATUS_ST_UTX_OUT_Msk = 0xf0

	// CLK_CONF: UART core clock configuration
	// Position of SCLK_DIV_B field.
	LP_UART_CLK_CONF_SCLK_DIV_B_Pos = 0x0
	// Bit mask of SCLK_DIV_B field.
	LP_UART_CLK_CONF_SCLK_DIV_B_Msk = 0x3f
	// Position of SCLK_DIV_A field.
	LP_UART_CLK_CONF_SCLK_DIV_A_Pos = 0x6
	// Bit mask of SCLK_DIV_A field.
	LP_UART_CLK_CONF_SCLK_DIV_A_Msk = 0xfc0
	// Position of SCLK_DIV_NUM field.
	LP_UART_CLK_CONF_SCLK_DIV_NUM_Pos = 0xc
	// Bit mask of SCLK_DIV_NUM field.
	LP_UART_CLK_CONF_SCLK_DIV_NUM_Msk = 0xff000
	// Position of SCLK_SEL field.
	LP_UART_CLK_CONF_SCLK_SEL_Pos = 0x14
	// Bit mask of SCLK_SEL field.
	LP_UART_CLK_CONF_SCLK_SEL_Msk = 0x300000
	// Position of SCLK_EN field.
	LP_UART_CLK_CONF_SCLK_EN_Pos = 0x16
	// Bit mask of SCLK_EN field.
	LP_UART_CLK_CONF_SCLK_EN_Msk = 0x400000
	// Bit SCLK_EN.
	LP_UART_CLK_CONF_SCLK_EN = 0x400000
	// Position of RST_CORE field.
	LP_UART_CLK_CONF_RST_CORE_Pos = 0x17
	// Bit mask of RST_CORE field.
	LP_UART_CLK_CONF_RST_CORE_Msk = 0x800000
	// Bit RST_CORE.
	LP_UART_CLK_CONF_RST_CORE = 0x800000
	// Position of TX_SCLK_EN field.
	LP_UART_CLK_CONF_TX_SCLK_EN_Pos = 0x18
	// Bit mask of TX_SCLK_EN field.
	LP_UART_CLK_CONF_TX_SCLK_EN_Msk = 0x1000000
	// Bit TX_SCLK_EN.
	LP_UART_CLK_CONF_TX_SCLK_EN = 0x1000000
	// Position of RX_SCLK_EN field.
	LP_UART_CLK_CONF_RX_SCLK_EN_Pos = 0x19
	// Bit mask of RX_SCLK_EN field.
	LP_UART_CLK_CONF_RX_SCLK_EN_Msk = 0x2000000
	// Bit RX_SCLK_EN.
	LP_UART_CLK_CONF_RX_SCLK_EN = 0x2000000
	// Position of TX_RST_CORE field.
	LP_UART_CLK_CONF_TX_RST_CORE_Pos = 0x1a
	// Bit mask of TX_RST_CORE field.
	LP_UART_CLK_CONF_TX_RST_CORE_Msk = 0x4000000
	// Bit TX_RST_CORE.
	LP_UART_CLK_CONF_TX_RST_CORE = 0x4000000
	// Position of RX_RST_CORE field.
	LP_UART_CLK_CONF_RX_RST_CORE_Pos = 0x1b
	// Bit mask of RX_RST_CORE field.
	LP_UART_CLK_CONF_RX_RST_CORE_Msk = 0x8000000
	// Bit RX_RST_CORE.
	LP_UART_CLK_CONF_RX_RST_CORE = 0x8000000

	// DATE: UART Version register
	// Position of DATE field.
	LP_UART_DATE_DATE_Pos = 0x0
	// Bit mask of DATE field.
	LP_UART_DATE_DATE_Msk = 0xffffffff

	// AFIFO_STATUS: UART AFIFO Status
	// Position of TX_AFIFO_FULL field.
	LP_UART_AFIFO_STATUS_TX_AFIFO_FULL_Pos = 0x0
	// Bit mask of TX_AFIFO_FULL field.
	LP_UART_AFIFO_STATUS_TX_AFIFO_FULL_Msk = 0x1
	// Bit TX_AFIFO_FULL.
	LP_UART_AFIFO_STATUS_TX_AFIFO_FULL = 0x1
	// Position of TX_AFIFO_EMPTY field.
	LP_UART_AFIFO_STATUS_TX_AFIFO_EMPTY_Pos = 0x1
	// Bit mask of TX_AFIFO_EMPTY field.
	LP_UART_AFIFO_STATUS_TX_AFIFO_EMPTY_Msk = 0x2
	// Bit TX_AFIFO_EMPTY.
	LP_UART_AFIFO_STATUS_TX_AFIFO_EMPTY = 0x2
	// Position of RX_AFIFO_FULL field.
	LP_UART_AFIFO_STATUS_RX_AFIFO_FULL_Pos = 0x2
	// Bit mask of RX_AFIFO_FULL field.
	LP_UART_AFIFO_STATUS_RX_AFIFO_FULL_Msk = 0x4
	// Bit RX_AFIFO_FULL.
	LP_UART_AFIFO_STATUS_RX_AFIFO_FULL = 0x4
	// Position of RX_AFIFO_EMPTY field.
	LP_UART_AFIFO_STATUS_RX_AFIFO_EMPTY_Pos = 0x3
	// Bit mask of RX_AFIFO_EMPTY field.
	LP_UART_AFIFO_STATUS_RX_AFIFO_EMPTY_Msk = 0x8
	// Bit RX_AFIFO_EMPTY.
	LP_UART_AFIFO_STATUS_RX_AFIFO_EMPTY = 0x8

	// REG_UPDATE: UART Registers Configuration Update register
	// Position of REG_UPDATE field.
	LP_UART_REG_UPDATE_REG_UPDATE_Pos = 0x0
	// Bit mask of REG_UPDATE field.
	LP_UART_REG_UPDATE_REG_UPDATE_Msk = 0x1
	// Bit REG_UPDATE.
	LP_UART_REG_UPDATE_REG_UPDATE = 0x1

	// ID: UART ID register
	// Position of ID field.
	LP_UART_ID_ID_Pos = 0x0
	// Bit mask of ID field.
	LP_UART_ID_ID_Msk = 0xffffffff
)

// Constants for LP_WDT: Low-power Watchdog Timer
const (
	// CONFIG0: need_des
	// Position of WDT_CHIP_RESET_WIDTH field.
	LP_WDT_CONFIG0_WDT_CHIP_RESET_WIDTH_Pos = 0x0
	// Bit mask of WDT_CHIP_RESET_WIDTH field.
	LP_WDT_CONFIG0_WDT_CHIP_RESET_WIDTH_Msk = 0xff
	// Position of WDT_CHIP_RESET_EN field.
	LP_WDT_CONFIG0_WDT_CHIP_RESET_EN_Pos = 0x8
	// Bit mask of WDT_CHIP_RESET_EN field.
	LP_WDT_CONFIG0_WDT_CHIP_RESET_EN_Msk = 0x100
	// Bit WDT_CHIP_RESET_EN.
	LP_WDT_CONFIG0_WDT_CHIP_RESET_EN = 0x100
	// Position of WDT_PAUSE_IN_SLP field.
	LP_WDT_CONFIG0_WDT_PAUSE_IN_SLP_Pos = 0x9
	// Bit mask of WDT_PAUSE_IN_SLP field.
	LP_WDT_CONFIG0_WDT_PAUSE_IN_SLP_Msk = 0x200
	// Bit WDT_PAUSE_IN_SLP.
	LP_WDT_CONFIG0_WDT_PAUSE_IN_SLP = 0x200
	// Position of WDT_APPCPU_RESET_EN field.
	LP_WDT_CONFIG0_WDT_APPCPU_RESET_EN_Pos = 0xa
	// Bit mask of WDT_APPCPU_RESET_EN field.
	LP_WDT_CONFIG0_WDT_APPCPU_RESET_EN_Msk = 0x400
	// Bit WDT_APPCPU_RESET_EN.
	LP_WDT_CONFIG0_WDT_APPCPU_RESET_EN = 0x400
	// Position of WDT_PROCPU_RESET_EN field.
	LP_WDT_CONFIG0_WDT_PROCPU_RESET_EN_Pos = 0xb
	// Bit mask of WDT_PROCPU_RESET_EN field.
	LP_WDT_CONFIG0_WDT_PROCPU_RESET_EN_Msk = 0x800
	// Bit WDT_PROCPU_RESET_EN.
	LP_WDT_CONFIG0_WDT_PROCPU_RESET_EN = 0x800
	// Position of WDT_FLASHBOOT_MOD_EN field.
	LP_WDT_CONFIG0_WDT_FLASHBOOT_MOD_EN_Pos = 0xc
	// Bit mask of WDT_FLASHBOOT_MOD_EN field.
	LP_WDT_CONFIG0_WDT_FLASHBOOT_MOD_EN_Msk = 0x1000
	// Bit WDT_FLASHBOOT_MOD_EN.
	LP_WDT_CONFIG0_WDT_FLASHBOOT_MOD_EN = 0x1000
	// Position of WDT_SYS_RESET_LENGTH field.
	LP_WDT_CONFIG0_WDT_SYS_RESET_LENGTH_Pos = 0xd
	// Bit mask of WDT_SYS_RESET_LENGTH field.
	LP_WDT_CONFIG0_WDT_SYS_RESET_LENGTH_Msk = 0xe000
	// Position of WDT_CPU_RESET_LENGTH field.
	LP_WDT_CONFIG0_WDT_CPU_RESET_LENGTH_Pos = 0x10
	// Bit mask of WDT_CPU_RESET_LENGTH field.
	LP_WDT_CONFIG0_WDT_CPU_RESET_LENGTH_Msk = 0x70000
	// Position of WDT_STG3 field.
	LP_WDT_CONFIG0_WDT_STG3_Pos = 0x13
	// Bit mask of WDT_STG3 field.
	LP_WDT_CONFIG0_WDT_STG3_Msk = 0x380000
	// Position of WDT_STG2 field.
	LP_WDT_CONFIG0_WDT_STG2_Pos = 0x16
	// Bit mask of WDT_STG2 field.
	LP_WDT_CONFIG0_WDT_STG2_Msk = 0x1c00000
	// Position of WDT_STG1 field.
	LP_WDT_CONFIG0_WDT_STG1_Pos = 0x19
	// Bit mask of WDT_STG1 field.
	LP_WDT_CONFIG0_WDT_STG1_Msk = 0xe000000
	// Position of WDT_STG0 field.
	LP_WDT_CONFIG0_WDT_STG0_Pos = 0x1c
	// Bit mask of WDT_STG0 field.
	LP_WDT_CONFIG0_WDT_STG0_Msk = 0x70000000
	// Position of WDT_EN field.
	LP_WDT_CONFIG0_WDT_EN_Pos = 0x1f
	// Bit mask of WDT_EN field.
	LP_WDT_CONFIG0_WDT_EN_Msk = 0x80000000
	// Bit WDT_EN.
	LP_WDT_CONFIG0_WDT_EN = 0x80000000

	// CONFIG1: need_des
	// Position of WDT_STG0_HOLD field.
	LP_WDT_CONFIG1_WDT_STG0_HOLD_Pos = 0x0
	// Bit mask of WDT_STG0_HOLD field.
	LP_WDT_CONFIG1_WDT_STG0_HOLD_Msk = 0xffffffff

	// CONFIG2: need_des
	// Position of WDT_STG1_HOLD field.
	LP_WDT_CONFIG2_WDT_STG1_HOLD_Pos = 0x0
	// Bit mask of WDT_STG1_HOLD field.
	LP_WDT_CONFIG2_WDT_STG1_HOLD_Msk = 0xffffffff

	// CONFIG3: need_des
	// Position of WDT_STG2_HOLD field.
	LP_WDT_CONFIG3_WDT_STG2_HOLD_Pos = 0x0
	// Bit mask of WDT_STG2_HOLD field.
	LP_WDT_CONFIG3_WDT_STG2_HOLD_Msk = 0xffffffff

	// CONFIG4: need_des
	// Position of WDT_STG3_HOLD field.
	LP_WDT_CONFIG4_WDT_STG3_HOLD_Pos = 0x0
	// Bit mask of WDT_STG3_HOLD field.
	LP_WDT_CONFIG4_WDT_STG3_HOLD_Msk = 0xffffffff

	// FEED: need_des
	// Position of RTC_WDT_FEED field.
	LP_WDT_FEED_RTC_WDT_FEED_Pos = 0x1f
	// Bit mask of RTC_WDT_FEED field.
	LP_WDT_FEED_RTC_WDT_FEED_Msk = 0x80000000
	// Bit RTC_WDT_FEED.
	LP_WDT_FEED_RTC_WDT_FEED = 0x80000000

	// WPROTECT: need_des
	// Position of WDT_WKEY field.
	LP_WDT_WPROTECT_WDT_WKEY_Pos = 0x0
	// Bit mask of WDT_WKEY field.
	LP_WDT_WPROTECT_WDT_WKEY_Msk = 0xffffffff

	// SWD_CONFIG: need_des
	// Position of SWD_RESET_FLAG field.
	LP_WDT_SWD_CONFIG_SWD_RESET_FLAG_Pos = 0x0
	// Bit mask of SWD_RESET_FLAG field.
	LP_WDT_SWD_CONFIG_SWD_RESET_FLAG_Msk = 0x1
	// Bit SWD_RESET_FLAG.
	LP_WDT_SWD_CONFIG_SWD_RESET_FLAG = 0x1
	// Position of SWD_AUTO_FEED_EN field.
	LP_WDT_SWD_CONFIG_SWD_AUTO_FEED_EN_Pos = 0x12
	// Bit mask of SWD_AUTO_FEED_EN field.
	LP_WDT_SWD_CONFIG_SWD_AUTO_FEED_EN_Msk = 0x40000
	// Bit SWD_AUTO_FEED_EN.
	LP_WDT_SWD_CONFIG_SWD_AUTO_FEED_EN = 0x40000
	// Position of SWD_RST_FLAG_CLR field.
	LP_WDT_SWD_CONFIG_SWD_RST_FLAG_CLR_Pos = 0x13
	// Bit mask of SWD_RST_FLAG_CLR field.
	LP_WDT_SWD_CONFIG_SWD_RST_FLAG_CLR_Msk = 0x80000
	// Bit SWD_RST_FLAG_CLR.
	LP_WDT_SWD_CONFIG_SWD_RST_FLAG_CLR = 0x80000
	// Position of SWD_SIGNAL_WIDTH field.
	LP_WDT_SWD_CONFIG_SWD_SIGNAL_WIDTH_Pos = 0x14
	// Bit mask of SWD_SIGNAL_WIDTH field.
	LP_WDT_SWD_CONFIG_SWD_SIGNAL_WIDTH_Msk = 0x3ff00000
	// Position of SWD_DISABLE field.
	LP_WDT_SWD_CONFIG_SWD_DISABLE_Pos = 0x1e
	// Bit mask of SWD_DISABLE field.
	LP_WDT_SWD_CONFIG_SWD_DISABLE_Msk = 0x40000000
	// Bit SWD_DISABLE.
	LP_WDT_SWD_CONFIG_SWD_DISABLE = 0x40000000
	// Position of SWD_FEED field.
	LP_WDT_SWD_CONFIG_SWD_FEED_Pos = 0x1f
	// Bit mask of SWD_FEED field.
	LP_WDT_SWD_CONFIG_SWD_FEED_Msk = 0x80000000
	// Bit SWD_FEED.
	LP_WDT_SWD_CONFIG_SWD_FEED = 0x80000000

	// SWD_WPROTECT: need_des
	// Position of SWD_WKEY field.
	LP_WDT_SWD_WPROTECT_SWD_WKEY_Pos = 0x0
	// Bit mask of SWD_WKEY field.
	LP_WDT_SWD_WPROTECT_SWD_WKEY_Msk = 0xffffffff

	// INT_RAW: need_des
	// Position of SUPER_WDT_INT_RAW field.
	LP_WDT_INT_RAW_SUPER_WDT_INT_RAW_Pos = 0x1e
	// Bit mask of SUPER_WDT_INT_RAW field.
	LP_WDT_INT_RAW_SUPER_WDT_INT_RAW_Msk = 0x40000000
	// Bit SUPER_WDT_INT_RAW.
	LP_WDT_INT_RAW_SUPER_WDT_INT_RAW = 0x40000000
	// Position of LP_WDT_INT_RAW field.
	LP_WDT_INT_RAW_LP_WDT_INT_RAW_Pos = 0x1f
	// Bit mask of LP_WDT_INT_RAW field.
	LP_WDT_INT_RAW_LP_WDT_INT_RAW_Msk = 0x80000000
	// Bit LP_WDT_INT_RAW.
	LP_WDT_INT_RAW_LP_WDT_INT_RAW = 0x80000000

	// INT_ST: need_des
	// Position of SUPER_WDT_INT_ST field.
	LP_WDT_INT_ST_SUPER_WDT_INT_ST_Pos = 0x1e
	// Bit mask of SUPER_WDT_INT_ST field.
	LP_WDT_INT_ST_SUPER_WDT_INT_ST_Msk = 0x40000000
	// Bit SUPER_WDT_INT_ST.
	LP_WDT_INT_ST_SUPER_WDT_INT_ST = 0x40000000
	// Position of LP_WDT_INT_ST field.
	LP_WDT_INT_ST_LP_WDT_INT_ST_Pos = 0x1f
	// Bit mask of LP_WDT_INT_ST field.
	LP_WDT_INT_ST_LP_WDT_INT_ST_Msk = 0x80000000
	// Bit LP_WDT_INT_ST.
	LP_WDT_INT_ST_LP_WDT_INT_ST = 0x80000000

	// INT_ENA: need_des
	// Position of SUPER_WDT_INT_ENA field.
	LP_WDT_INT_ENA_SUPER_WDT_INT_ENA_Pos = 0x1e
	// Bit mask of SUPER_WDT_INT_ENA field.
	LP_WDT_INT_ENA_SUPER_WDT_INT_ENA_Msk = 0x40000000
	// Bit SUPER_WDT_INT_ENA.
	LP_WDT_INT_ENA_SUPER_WDT_INT_ENA = 0x40000000
	// Position of LP_WDT_INT_ENA field.
	LP_WDT_INT_ENA_LP_WDT_INT_ENA_Pos = 0x1f
	// Bit mask of LP_WDT_INT_ENA field.
	LP_WDT_INT_ENA_LP_WDT_INT_ENA_Msk = 0x80000000
	// Bit LP_WDT_INT_ENA.
	LP_WDT_INT_ENA_LP_WDT_INT_ENA = 0x80000000

	// INT_CLR: need_des
	// Position of SUPER_WDT_INT_CLR field.
	LP_WDT_INT_CLR_SUPER_WDT_INT_CLR_Pos = 0x1e
	// Bit mask of SUPER_WDT_INT_CLR field.
	LP_WDT_INT_CLR_SUPER_WDT_INT_CLR_Msk = 0x40000000
	// Bit SUPER_WDT_INT_CLR.
	LP_WDT_INT_CLR_SUPER_WDT_INT_CLR = 0x40000000
	// Position of LP_WDT_INT_CLR field.
	LP_WDT_INT_CLR_LP_WDT_INT_CLR_Pos = 0x1f
	// Bit mask of LP_WDT_INT_CLR field.
	LP_WDT_INT_CLR_LP_WDT_INT_CLR_Msk = 0x80000000
	// Bit LP_WDT_INT_CLR.
	LP_WDT_INT_CLR_LP_WDT_INT_CLR = 0x80000000

	// DATE: need_des
	// Position of LP_WDT_DATE field.
	LP_WDT_DATE_LP_WDT_DATE_Pos = 0x0
	// Bit mask of LP_WDT_DATE field.
	LP_WDT_DATE_LP_WDT_DATE_Msk = 0x7fffffff
	// Position of CLK_EN field.
	LP_WDT_DATE_CLK_EN_Pos = 0x1f
	// Bit mask of CLK_EN field.
	LP_WDT_DATE_CLK_EN_Msk = 0x80000000
	// Bit CLK_EN.
	LP_WDT_DATE_CLK_EN = 0x80000000
)
