/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI;

import com.zeroc.Ice.LocalException;
import com.zeroc.IceGridGUI.Coordinator;
import com.zeroc.IceGridGUI.Utils;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Main
extends JFrame {
    private Coordinator _coordinator;

    public static void main(String[] args) {
        try {
            if (System.getProperty("os.name").startsWith("Mac OS")) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "IceGrid GUI");
                System.setProperty("apple.eawt.quitStrategy", "CLOSE_ALL_WINDOWS");
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else if (System.getProperty("os.name").startsWith("Windows")) {
                UIManager.setLookAndFeel("com.jgoodies.looks.windows.WindowsLookAndFeel");
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
            JOptionPane.showMessageDialog(null, e.toString(), "Initialization failed", 0);
            System.exit(1);
        }
        SwingUtilities.invokeLater(() -> {
            try {
                new Main(args);
            }
            catch (LocalException e) {
                JOptionPane.showMessageDialog(null, e.toString(), "Initialization failed", 0);
                System.exit(1);
            }
        });
    }

    Main(String[] args) {
        super("IceGrid GUI");
        ImageIcon icon = Utils.getIcon("/icons/16x16/grid.png");
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (Main.this._coordinator != null) {
                    if (Main.this._coordinator.needsSaving()) {
                        if (JOptionPane.showOptionDialog(Main.this, "The application has unsaved changes, if you exit all unsaved changes will be lost.\nExit and discard changes?", "Save application", 0, 0, null, null, null) == 0) {
                            Main.this._coordinator.exit(0);
                        }
                    } else {
                        Main.this._coordinator.exit(0);
                    }
                }
            }
        });
        this._coordinator = new Coordinator(this, args, Preferences.userRoot().node("IceGridGUI"));
        this._coordinator.tryMigrateDataDirectory();
        this._coordinator.showMainFrame();
    }
}

