//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `IceBox.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceBox;

/**
 * Administers a set of {@link Service} instances.
 *
 * @see Service
 **/
public interface ServiceManagerPrx extends com.zeroc.Ice.ObjectPrx
{
    /**
     * Returns the checksums for the IceBox Slice definitions.
     * @return A dictionary mapping Slice type ids to their checksums.
     **/
    default java.util.Map<java.lang.String, java.lang.String> getSliceChecksums()
    {
        return getSliceChecksums(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     **/
    default java.util.Map<java.lang.String, java.lang.String> getSliceChecksums(java.util.Map<String, String> context)
    {
        return _iceI_getSliceChecksumsAsync(context, true).waitForResponse();
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * @return A dictionary mapping Slice type ids to their checksums.
     **/
    default java.util.concurrent.CompletableFuture<java.util.Map<java.lang.String, java.lang.String>> getSliceChecksumsAsync()
    {
        return _iceI_getSliceChecksumsAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     **/
    default java.util.concurrent.CompletableFuture<java.util.Map<java.lang.String, java.lang.String>> getSliceChecksumsAsync(java.util.Map<String, String> context)
    {
        return _iceI_getSliceChecksumsAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.util.Map<java.lang.String, java.lang.String>> _iceI_getSliceChecksumsAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.util.Map<java.lang.String, java.lang.String>> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getSliceChecksums", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     java.util.Map<java.lang.String, java.lang.String> ret;
                     ret = com.zeroc.Ice.SliceChecksumDictHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    /**
     * Start an individual service.
     * @param service The service name.
     * @throws AlreadyStartedException If the service is already running.
     * @throws NoSuchServiceException If no service could be found with the given name.
     **/
    default void startService(String service)
        throws AlreadyStartedException,
               NoSuchServiceException
    {
        startService(service, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Start an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @throws AlreadyStartedException If the service is already running.
     * @throws NoSuchServiceException If no service could be found with the given name.
     **/
    default void startService(String service, java.util.Map<String, String> context)
        throws AlreadyStartedException,
               NoSuchServiceException
    {
        try
        {
            _iceI_startServiceAsync(service, context, true).waitForResponseOrUserEx();
        }
        catch(AlreadyStartedException ex)
        {
            throw ex;
        }
        catch(NoSuchServiceException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Start an individual service.
     * @param service The service name.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> startServiceAsync(String service)
    {
        return _iceI_startServiceAsync(service, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Start an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> startServiceAsync(String service, java.util.Map<String, String> context)
    {
        return _iceI_startServiceAsync(service, context, false);
    }

    /**
     * @hidden
     * @param iceP_service -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_startServiceAsync(String iceP_service, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "startService", null, sync, _iceE_startService);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_service);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_startService =
    {
        AlreadyStartedException.class,
        NoSuchServiceException.class
    };

    /**
     * Stop an individual service.
     * @param service The service name.
     * @throws AlreadyStoppedException If the service is already stopped.
     * @throws NoSuchServiceException If no service could be found with the given name.
     **/
    default void stopService(String service)
        throws AlreadyStoppedException,
               NoSuchServiceException
    {
        stopService(service, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Stop an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @throws AlreadyStoppedException If the service is already stopped.
     * @throws NoSuchServiceException If no service could be found with the given name.
     **/
    default void stopService(String service, java.util.Map<String, String> context)
        throws AlreadyStoppedException,
               NoSuchServiceException
    {
        try
        {
            _iceI_stopServiceAsync(service, context, true).waitForResponseOrUserEx();
        }
        catch(AlreadyStoppedException ex)
        {
            throw ex;
        }
        catch(NoSuchServiceException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Stop an individual service.
     * @param service The service name.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> stopServiceAsync(String service)
    {
        return _iceI_stopServiceAsync(service, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Stop an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> stopServiceAsync(String service, java.util.Map<String, String> context)
    {
        return _iceI_stopServiceAsync(service, context, false);
    }

    /**
     * @hidden
     * @param iceP_service -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_stopServiceAsync(String iceP_service, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "stopService", null, sync, _iceE_stopService);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_service);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_stopService =
    {
        AlreadyStoppedException.class,
        NoSuchServiceException.class
    };

    /**
     * Registers a new observer with the ServiceManager.
     * @param observer The new observer
     **/
    default void addObserver(ServiceObserverPrx observer)
    {
        addObserver(observer, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Registers a new observer with the ServiceManager.
     * @param observer The new observer
     * @param context The Context map to send with the invocation.
     **/
    default void addObserver(ServiceObserverPrx observer, java.util.Map<String, String> context)
    {
        _iceI_addObserverAsync(observer, context, true).waitForResponse();
    }

    /**
     * Registers a new observer with the ServiceManager.
     * @param observer The new observer
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> addObserverAsync(ServiceObserverPrx observer)
    {
        return _iceI_addObserverAsync(observer, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Registers a new observer with the ServiceManager.
     * @param observer The new observer
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> addObserverAsync(ServiceObserverPrx observer, java.util.Map<String, String> context)
    {
        return _iceI_addObserverAsync(observer, context, false);
    }

    /**
     * @hidden
     * @param iceP_observer -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_addObserverAsync(ServiceObserverPrx iceP_observer, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "addObserver", null, sync, null);
        f.invoke(false, context, null, ostr -> {
                     ostr.writeProxy(iceP_observer);
                 }, null);
        return f;
    }

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     **/
    default void shutdown()
    {
        shutdown(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     * @param context The Context map to send with the invocation.
     **/
    default void shutdown(java.util.Map<String, String> context)
    {
        _iceI_shutdownAsync(context, true).waitForResponse();
    }

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> shutdownAsync()
    {
        return _iceI_shutdownAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> shutdownAsync(java.util.Map<String, String> context)
    {
        return _iceI_shutdownAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_shutdownAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "shutdown", null, sync, null);
        f.invoke(false, context, null, null, null);
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static ServiceManagerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), ServiceManagerPrx.class, _ServiceManagerPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static ServiceManagerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), ServiceManagerPrx.class, _ServiceManagerPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static ServiceManagerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), ServiceManagerPrx.class, _ServiceManagerPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static ServiceManagerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), ServiceManagerPrx.class, _ServiceManagerPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static ServiceManagerPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, ServiceManagerPrx.class, _ServiceManagerPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static ServiceManagerPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, ServiceManagerPrx.class, _ServiceManagerPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default ServiceManagerPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (ServiceManagerPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default ServiceManagerPrx ice_adapterId(String newAdapterId)
    {
        return (ServiceManagerPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default ServiceManagerPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (ServiceManagerPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default ServiceManagerPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (ServiceManagerPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default ServiceManagerPrx ice_invocationTimeout(int newTimeout)
    {
        return (ServiceManagerPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default ServiceManagerPrx ice_connectionCached(boolean newCache)
    {
        return (ServiceManagerPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default ServiceManagerPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (ServiceManagerPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default ServiceManagerPrx ice_secure(boolean b)
    {
        return (ServiceManagerPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default ServiceManagerPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (ServiceManagerPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default ServiceManagerPrx ice_preferSecure(boolean b)
    {
        return (ServiceManagerPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default ServiceManagerPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (ServiceManagerPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default ServiceManagerPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (ServiceManagerPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default ServiceManagerPrx ice_collocationOptimized(boolean b)
    {
        return (ServiceManagerPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default ServiceManagerPrx ice_twoway()
    {
        return (ServiceManagerPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default ServiceManagerPrx ice_oneway()
    {
        return (ServiceManagerPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default ServiceManagerPrx ice_batchOneway()
    {
        return (ServiceManagerPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default ServiceManagerPrx ice_datagram()
    {
        return (ServiceManagerPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default ServiceManagerPrx ice_batchDatagram()
    {
        return (ServiceManagerPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default ServiceManagerPrx ice_compress(boolean co)
    {
        return (ServiceManagerPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default ServiceManagerPrx ice_timeout(int t)
    {
        return (ServiceManagerPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default ServiceManagerPrx ice_connectionId(String connectionId)
    {
        return (ServiceManagerPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default ServiceManagerPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (ServiceManagerPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::IceBox::ServiceManager";
    }
}
